/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.nd4j.linalg.util.ArrayUtil;

public class Im2col
extends DynamicCustomOp {
    protected Conv2DConfig conv2DConfig;

    public Im2col(SameDiff sameDiff, SDVariable[] inputFunctions, INDArray[] inputArrays, INDArray[] outputs, Conv2DConfig conv2DConfig) {
        super(null, inputArrays, outputs);
        if (sameDiff != null) {
            this.sameDiff = sameDiff;
        }
        this.conv2DConfig = conv2DConfig;
        this.addArgs();
    }

    public Im2col(SameDiff sd, SDVariable input, Conv2DConfig config) {
        super(null, sd, new SDVariable[]{input});
        this.conv2DConfig = config;
        this.addArgs();
    }

    public Im2col() {
    }

    protected void addArgs() {
        this.addIArgument(this.conv2DConfig.getKH());
        this.addIArgument(this.conv2DConfig.getKW());
        this.addIArgument(this.conv2DConfig.getSH());
        this.addIArgument(this.conv2DConfig.getSW());
        this.addIArgument(this.conv2DConfig.getPH());
        this.addIArgument(this.conv2DConfig.getPW());
        this.addIArgument(this.conv2DConfig.getDH());
        this.addIArgument(this.conv2DConfig.getDW());
        this.addIArgument(ArrayUtil.fromBoolean((boolean)this.conv2DConfig.isSameMode()));
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        return this.conv2DConfig.toProperties();
    }

    @Override
    public String opName() {
        return "im2col";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        return Collections.singletonList(this.f().im2ColBp(this.arg(), grad.get(0), this.conv2DConfig));
    }

    public static Im2colBuilder builder() {
        return new Im2colBuilder();
    }

    public static class Im2colBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private INDArray[] inputArrays;
        private INDArray[] outputs;
        private Conv2DConfig conv2DConfig;

        Im2colBuilder() {
        }

        public Im2colBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public Im2colBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public Im2colBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public Im2colBuilder outputs(INDArray[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public Im2colBuilder conv2DConfig(Conv2DConfig conv2DConfig) {
            this.conv2DConfig = conv2DConfig;
            return this;
        }

        public Im2col build() {
            return new Im2col(this.sameDiff, this.inputFunctions, this.inputArrays, this.outputs, this.conv2DConfig);
        }

        public String toString() {
            return "Im2col.Im2colBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputs=" + Arrays.deepToString(this.outputs) + ", conv2DConfig=" + this.conv2DConfig + ")";
        }
    }
}

