/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.indexaccum;

import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseIndexAccumulation;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.conditions.Condition;

public class FirstIndex
extends BaseIndexAccumulation {
    protected Condition condition;
    protected double compare;
    protected double eps;
    protected int mode;

    public FirstIndex(SameDiff sameDiff, SDVariable i_v, Condition condition, boolean keepDims, int ... dimensions) {
        super(sameDiff, i_v, keepDims, dimensions);
        this.condition = condition;
        this.compare = condition.getValue();
        this.mode = condition.condtionNum();
        this.eps = this.eps;
        this.extraArgs = new Object[]{this.compare, this.eps, (double)this.mode};
    }

    public FirstIndex() {
    }

    public FirstIndex(INDArray x, @NonNull Condition condition) {
        this(x, condition, Nd4j.EPS_THRESHOLD);
        if (condition == null) {
            throw new NullPointerException("condition is marked @NonNull but is null");
        }
    }

    public FirstIndex(INDArray x, @NonNull Condition condition, double eps) {
        super(x);
        if (condition == null) {
            throw new NullPointerException("condition is marked @NonNull but is null");
        }
        this.condition = condition;
        this.compare = condition.getValue();
        this.mode = condition.condtionNum();
        this.eps = eps;
        this.extraArgs = new Object[]{this.compare, eps, (double)this.mode};
    }

    @Override
    public int opNum() {
        return 4;
    }

    @Override
    public String opName() {
        return "first_index";
    }

    @Override
    public float zeroFloat() {
        return 0.0f;
    }

    @Override
    public float zeroHalf() {
        return this.zeroFloat();
    }

    @Override
    public double zeroDouble() {
        return 0.0;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Collections.singletonList(this.sameDiff.zerosLike(this.arg()));
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }
}

