/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Moments
extends DynamicCustomOp {
    private int[] axes;

    public Moments(SameDiff sameDiff, SDVariable input) {
        this(sameDiff, input, null);
    }

    public Moments(SameDiff sameDiff, SDVariable input, int[] axes) {
        super(null, sameDiff, new SDVariable[]{input}, false);
        this.axes = axes;
        this.addArgs();
    }

    public Moments(INDArray in, INDArray outMean, INDArray outStd, int ... axes) {
        super(null, new INDArray[]{in}, new INDArray[]{outMean, outStd}, null, axes);
    }

    private void addArgs() {
        if (this.axes != null) {
            for (int axis : this.axes) {
                this.addIArgument(axis);
            }
        }
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.getInstance().initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.addArgs();
    }

    @Override
    public String opName() {
        return "moments";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "moments";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        SDVariable dLdMean = grad.get(0);
        SDVariable dLdVar = grad.get(1);
        SDVariable meanBp = this.f().meanBp(this.arg(), dLdMean, false, this.axes);
        SDVariable varBp = this.f().varianceBp(this.arg(), dLdVar, false, false, this.axes);
        return Collections.singletonList(meanBp.add(varBp));
    }

    public Moments() {
    }
}

