/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseIndexAccumulation
extends BaseOp
implements IndexAccumulation {
    private static final Logger log = LoggerFactory.getLogger(BaseIndexAccumulation.class);
    protected int finalResult;
    protected boolean keepDims = false;
    protected boolean newFormat = false;

    public BaseIndexAccumulation(SameDiff sameDiff, SDVariable i_v, boolean keepDims, int[] dimensions) {
        super(sameDiff, new Object[]{dimensions});
        if (i_v != null) {
            this.dimensions = dimensions;
            this.f().validateDifferentialFunctionsameDiff(i_v);
            sameDiff.addArgsFor(new SDVariable[]{i_v}, (DifferentialFunction)this);
            if (Shape.isPlaceholderShape(i_v.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v.getVarName());
            }
        } else {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.xVertexId = i_v.getVarName();
        this.keepDims = keepDims;
        this.newFormat = true;
    }

    public BaseIndexAccumulation(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, boolean keepDims, int[] dimensions) {
        super(sameDiff, new Object[]{dimensions});
        if (i_v != null) {
            this.dimensions = dimensions;
            this.f().validateDifferentialFunctionsameDiff(i_v);
            this.f().validateDifferentialFunctionsameDiff(i_v2);
            this.xVertexId = i_v.getVarName();
            this.yVertexId = i_v2.getVarName();
            sameDiff.addArgsFor(new SDVariable[]{i_v, i_v2}, (DifferentialFunction)this);
            if (Shape.isPlaceholderShape(i_v.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v.getVarName());
            }
            if (Shape.isPlaceholderShape(i_v2.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v2.getVarName());
            }
        } else {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.keepDims = keepDims;
        this.newFormat = true;
    }

    public BaseIndexAccumulation() {
    }

    public BaseIndexAccumulation(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
        this.init(x, y, z, n);
    }

    public BaseIndexAccumulation(INDArray x, INDArray y, long n) {
        this(x, y, x, n);
    }

    public BaseIndexAccumulation(INDArray x) {
        this(x, null, x, x.lengthLong());
    }

    public BaseIndexAccumulation(INDArray x, INDArray y) {
        this(x, y, x, x.lengthLong());
    }

    @Override
    public double zeroDouble() {
        return 0.0;
    }

    @Override
    public float zeroFloat() {
        return 0.0f;
    }

    @Override
    public Pair<Double, Integer> zeroPair() {
        return new Pair((Object)this.zeroDouble(), (Object)-1);
    }

    private void init() {
        this.init(this.x, this.y, this.x, this.x.lengthLong());
    }

    @Override
    public void init(INDArray x, INDArray y, INDArray z, long n) {
        super.init(x, y, z, n);
        if (Nd4j.dataType() == DataBuffer.Type.DOUBLE) {
            this.extraArgs = new Object[]{this.zeroDouble()};
        } else if (Nd4j.dataType() == DataBuffer.Type.FLOAT) {
            this.extraArgs = new Object[]{Float.valueOf(this.zeroFloat())};
        } else if (Nd4j.dataType() == DataBuffer.Type.HALF) {
            this.extraArgs = new Object[]{Float.valueOf(this.zeroHalf())};
        }
    }

    @Override
    public List<long[]> calculateOutputShape() {
        if (this.arg().getShape() == null) {
            return Collections.emptyList();
        }
        ArrayList<long[]> ret = new ArrayList<long[]>(1);
        long[] reducedShape = Shape.getReducedShape(this.arg().getShape(), this.dimensions, this.keepDims, this.newFormat);
        ret.add(reducedShape);
        return ret;
    }

    @Override
    public void setFinalResult(int idx) {
        this.finalResult = idx;
    }

    @Override
    public int getFinalResult() {
        return this.finalResult;
    }

    public boolean isKeepDims() {
        return this.keepDims;
    }

    public boolean isNewFormat() {
        return this.newFormat;
    }

    public void setKeepDims(boolean keepDims) {
        this.keepDims = keepDims;
    }

    public void setNewFormat(boolean newFormat) {
        this.newFormat = newFormat;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseIndexAccumulation)) {
            return false;
        }
        BaseIndexAccumulation other = (BaseIndexAccumulation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getFinalResult() != other.getFinalResult()) {
            return false;
        }
        if (this.isKeepDims() != other.isKeepDims()) {
            return false;
        }
        return this.isNewFormat() == other.isNewFormat();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseIndexAccumulation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFinalResult();
        result = result * 59 + (this.isKeepDims() ? 79 : 97);
        result = result * 59 + (this.isNewFormat() ? 79 : 97);
        return result;
    }

    @Override
    public String toString() {
        return "BaseIndexAccumulation(finalResult=" + this.getFinalResult() + ", keepDims=" + this.isKeepDims() + ", newFormat=" + this.isNewFormat() + ")";
    }
}

