/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas.impl;

import org.nd4j.linalg.api.blas.Lapack;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.exception.ND4JArraySizeException;
import org.nd4j.linalg.factory.Nd4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseLapack
implements Lapack {
    private static final Logger log = LoggerFactory.getLogger(BaseLapack.class);

    @Override
    public INDArray getrf(INDArray A) {
        if (A.rows() > Integer.MAX_VALUE || A.columns() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        int m = A.rows();
        int n = A.columns();
        INDArray INFO = Nd4j.createArrayFromShapeBuffer(Nd4j.getDataBufferFactory().createInt(1L), (DataBuffer)Nd4j.getShapeInfoProvider().createShapeInformation(new int[]{1, 1}).getFirst());
        int mn = Math.min(m, n);
        INDArray IPIV = Nd4j.createArrayFromShapeBuffer(Nd4j.getDataBufferFactory().createInt((long)mn), (DataBuffer)Nd4j.getShapeInfoProvider().createShapeInformation(new int[]{1, mn}).getFirst());
        if (A.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.dgetrf(m, n, A, IPIV, INFO);
        } else if (A.data().dataType() == DataBuffer.Type.FLOAT) {
            this.sgetrf(m, n, A, IPIV, INFO);
        } else {
            throw new UnsupportedOperationException();
        }
        if (INFO.getInt(0) < 0) {
            throw new Error("Parameter #" + INFO.getInt(0) + " to getrf() was not valid");
        }
        if (INFO.getInt(0) > 0) {
            log.warn("The matrix is singular - cannot be used for inverse op. Check L matrix at row " + INFO.getInt(0));
        }
        return IPIV;
    }

    public abstract void sgetrf(int var1, int var2, INDArray var3, INDArray var4, INDArray var5);

    public abstract void dgetrf(int var1, int var2, INDArray var3, INDArray var4, INDArray var5);

    @Override
    public void potrf(INDArray A, boolean lower) {
        if (A.columns() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        byte uplo = (byte)(lower ? 76 : 85);
        int n = A.columns();
        INDArray INFO = Nd4j.createArrayFromShapeBuffer(Nd4j.getDataBufferFactory().createInt(1L), (DataBuffer)Nd4j.getShapeInfoProvider().createShapeInformation(new int[]{1, 1}).getFirst());
        if (A.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.dpotrf(uplo, n, A, INFO);
        } else if (A.data().dataType() == DataBuffer.Type.FLOAT) {
            this.spotrf(uplo, n, A, INFO);
        } else {
            throw new UnsupportedOperationException();
        }
        if (INFO.getInt(0) < 0) {
            throw new Error("Parameter #" + INFO.getInt(0) + " to potrf() was not valid");
        }
        if (INFO.getInt(0) > 0) {
            throw new Error("The matrix is not positive definite! (potrf fails @ order " + INFO.getInt(0) + ")");
        }
    }

    public abstract void spotrf(byte var1, int var2, INDArray var3, INDArray var4);

    public abstract void dpotrf(byte var1, int var2, INDArray var3, INDArray var4);

    @Override
    public void geqrf(INDArray A, INDArray R) {
        if (A.rows() > Integer.MAX_VALUE || A.columns() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        int m = A.rows();
        int n = A.columns();
        INDArray INFO = Nd4j.createArrayFromShapeBuffer(Nd4j.getDataBufferFactory().createInt(1L), (DataBuffer)Nd4j.getShapeInfoProvider().createShapeInformation(new int[]{1, 1}).getFirst());
        if (R.rows() != A.columns() || R.columns() != A.columns()) {
            throw new Error("geqrf: R must be N x N (n = columns in A)");
        }
        if (A.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.dgeqrf(m, n, A, R, INFO);
        } else if (A.data().dataType() == DataBuffer.Type.FLOAT) {
            this.sgeqrf(m, n, A, R, INFO);
        } else {
            throw new UnsupportedOperationException();
        }
        if (INFO.getInt(0) < 0) {
            throw new Error("Parameter #" + INFO.getInt(0) + " to getrf() was not valid");
        }
    }

    public abstract void sgeqrf(int var1, int var2, INDArray var3, INDArray var4, INDArray var5);

    public abstract void dgeqrf(int var1, int var2, INDArray var3, INDArray var4, INDArray var5);

    @Override
    public int syev(char jobz, char uplo, INDArray A, INDArray V) {
        if (A.rows() != A.columns()) {
            throw new Error("syev: A must be square.");
        }
        if ((long)A.rows() != V.length()) {
            throw new Error("syev: V must be the length of the matrix dimension.");
        }
        if (A.rows() > Integer.MAX_VALUE || A.columns() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        int status = -1;
        if (A.data().dataType() == DataBuffer.Type.DOUBLE) {
            status = this.dsyev(jobz, uplo, A.rows(), A, V);
        } else if (A.data().dataType() == DataBuffer.Type.FLOAT) {
            status = this.ssyev(jobz, uplo, A.rows(), A, V);
        } else {
            throw new UnsupportedOperationException();
        }
        return status;
    }

    public abstract int ssyev(char var1, char var2, int var3, INDArray var4, INDArray var5);

    public abstract int dsyev(char var1, char var2, int var3, INDArray var4, INDArray var5);

    @Override
    public void gesvd(INDArray A, INDArray S, INDArray U, INDArray VT) {
        if (A.rows() > Integer.MAX_VALUE || A.columns() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        int m = A.rows();
        int n = A.columns();
        byte jobu = (byte)(U == null ? 78 : 65);
        byte jobvt = (byte)(VT == null ? 78 : 65);
        INDArray INFO = Nd4j.createArrayFromShapeBuffer(Nd4j.getDataBufferFactory().createInt(1L), (DataBuffer)Nd4j.getShapeInfoProvider().createShapeInformation(new int[]{1, 1}).getFirst());
        if (A.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.dgesvd(jobu, jobvt, m, n, A, S, U, VT, INFO);
        } else if (A.data().dataType() == DataBuffer.Type.FLOAT) {
            this.sgesvd(jobu, jobvt, m, n, A, S, U, VT, INFO);
        } else {
            throw new UnsupportedOperationException();
        }
        if (INFO.getInt(0) < 0) {
            throw new Error("Parameter #" + INFO.getInt(0) + " to gesvd() was not valid");
        }
        if (INFO.getInt(0) > 0) {
            log.warn("The matrix contains singular elements. Check S matrix at row " + INFO.getInt(0));
        }
    }

    public abstract void sgesvd(byte var1, byte var2, int var3, int var4, INDArray var5, INDArray var6, INDArray var7, INDArray var8, INDArray var9);

    public abstract void dgesvd(byte var1, byte var2, int var3, int var4, INDArray var5, INDArray var6, INDArray var7, INDArray var8, INDArray var9);

    @Override
    public INDArray getPFactor(int M, INDArray ipiv) {
        INDArray P = Nd4j.eye(M);
        int i = 0;
        while ((long)i < ipiv.length()) {
            int pivot = ipiv.getInt(i) - 1;
            if (pivot > i) {
                INDArray v1 = P.getColumn(i).dup();
                INDArray v2 = P.getColumn(pivot);
                P.putColumn(i, v2);
                P.putColumn(pivot, v1);
            }
            ++i;
        }
        return P;
    }

    @Override
    public INDArray getLFactor(INDArray A) {
        if (A.rows() > Integer.MAX_VALUE || A.columns() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        int m = A.rows();
        int n = A.columns();
        INDArray L = Nd4j.create(m, n);
        for (int r = 0; r < m; ++r) {
            for (int c = 0; c < n; ++c) {
                if (r > c && r < m && c < n) {
                    L.putScalar(r, c, A.getFloat(r, c));
                    continue;
                }
                if (r < c) {
                    L.putScalar(r, c, 0.0);
                    continue;
                }
                L.putScalar(r, c, 1.0);
            }
        }
        return L;
    }

    @Override
    public INDArray getUFactor(INDArray A) {
        if (A.rows() > Integer.MAX_VALUE || A.columns() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        int m = A.rows();
        int n = A.columns();
        INDArray U = Nd4j.create(n, n);
        for (int r = 0; r < n; ++r) {
            for (int c = 0; c < n; ++c) {
                if (r <= c && r < m && c < n) {
                    U.putScalar(r, c, A.getFloat(r, c));
                    continue;
                }
                U.putScalar(r, c, 0.0);
            }
        }
        return U;
    }
}

