/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class XavierUniformInitScheme
extends BaseWeightInitScheme {
    private double fanIn;
    private double fanOut;

    public XavierUniformInitScheme(char order, double fanIn, double fanOut) {
        super(order);
        this.fanIn = fanIn;
        this.fanOut = fanOut;
    }

    @Override
    public INDArray doCreate(int[] shape, INDArray paramsView) {
        double s = Math.sqrt(6.0) / Math.sqrt(this.fanIn + this.fanOut);
        return Nd4j.rand(shape, Nd4j.getDistributions().createUniform(-s, s));
    }

    @Override
    public WeightInit type() {
        return WeightInit.XAVIER_UNIFORM;
    }

    public static XavierUniformInitSchemeBuilder builder() {
        return new XavierUniformInitSchemeBuilder();
    }

    public static class XavierUniformInitSchemeBuilder {
        private char order;
        private double fanIn;
        private double fanOut;

        XavierUniformInitSchemeBuilder() {
        }

        public XavierUniformInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public XavierUniformInitSchemeBuilder fanIn(double fanIn) {
            this.fanIn = fanIn;
            return this;
        }

        public XavierUniformInitSchemeBuilder fanOut(double fanOut) {
            this.fanOut = fanOut;
            return this;
        }

        public XavierUniformInitScheme build() {
            return new XavierUniformInitScheme(this.order, this.fanIn, this.fanOut);
        }

        public String toString() {
            return "XavierUniformInitScheme.XavierUniformInitSchemeBuilder(order=" + this.order + ", fanIn=" + this.fanIn + ", fanOut=" + this.fanOut + ")";
        }
    }
}

