/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.versioncheck;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Properties;

public class VersionInfo {
    private static final int SUFFIX_LENGTH = "-git.properties".length();
    private String groupId;
    private String artifactId;
    private String tags;
    private String branch;
    private String dirty;
    private String remoteOriginUrl;
    private String commitId;
    private String commitIdAbbrev;
    private String describe;
    private String describeShort;
    private String commitUserName;
    private String commitUserEmail;
    private String commitMessageFull;
    private String commitMessageShort;
    private String commitTime;
    private String closestTagName;
    private String closestTagCommitCount;
    private String buildUserName;
    private String buildUserEmail;
    private String buildTime;
    private String buildHost;
    private String buildVersion;

    public VersionInfo(String groupId, String artifactId, String buildVersion) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.buildVersion = buildVersion;
    }

    public VersionInfo(String propertiesFilePath) throws IOException {
        this(new File(propertiesFilePath).toURI());
    }

    public VersionInfo(URI uri) throws IOException {
        String path = uri.toString();
        int idxOf = path.lastIndexOf(47);
        idxOf = Math.max(idxOf, path.lastIndexOf(92));
        String filename = idxOf <= 0 ? path : path.substring(idxOf + 1);
        idxOf = filename.indexOf(45);
        this.groupId = filename.substring(0, idxOf);
        this.artifactId = filename.substring(idxOf + 1, filename.length() - SUFFIX_LENGTH);
        Properties properties = new Properties();
        try (InputStream is = uri.toURL().openStream();){
            properties.load(is);
        }
        this.tags = String.valueOf(properties.get("git.tags"));
        this.branch = String.valueOf(properties.get("git.branch"));
        this.dirty = String.valueOf(properties.get("git.dirty"));
        this.remoteOriginUrl = String.valueOf(properties.get("git.remote.origin.url"));
        this.commitId = String.valueOf(properties.get("git.commit.id.full"));
        this.commitIdAbbrev = String.valueOf(properties.get("git.commit.id.abbrev"));
        this.describe = String.valueOf(properties.get("git.commit.id.describe"));
        this.describeShort = String.valueOf(properties.get("git.commit.id.describe-short"));
        this.commitUserName = String.valueOf(properties.get("git.commit.user.name"));
        this.commitUserEmail = String.valueOf(properties.get("git.commit.user.email"));
        this.commitMessageFull = String.valueOf(properties.get("git.commit.message.full"));
        this.commitMessageShort = String.valueOf(properties.get("git.commit.message.short"));
        this.commitTime = String.valueOf(properties.get("git.commit.time"));
        this.closestTagName = String.valueOf(properties.get("git.closest.tag.name"));
        this.closestTagCommitCount = String.valueOf(properties.get("git.closest.tag.commit.count"));
        this.buildUserName = String.valueOf(properties.get("git.build.user.name"));
        this.buildUserEmail = String.valueOf(properties.get("git.build.user.email"));
        this.buildTime = String.valueOf(properties.get("git.build.time"));
        this.buildHost = String.valueOf(properties.get("git.build.host"));
        this.buildVersion = String.valueOf(properties.get("git.build.version"));
    }

    public static VersionInfoBuilder builder() {
        return new VersionInfoBuilder();
    }

    public VersionInfo(String groupId, String artifactId, String tags, String branch, String dirty, String remoteOriginUrl, String commitId, String commitIdAbbrev, String describe, String describeShort, String commitUserName, String commitUserEmail, String commitMessageFull, String commitMessageShort, String commitTime, String closestTagName, String closestTagCommitCount, String buildUserName, String buildUserEmail, String buildTime, String buildHost, String buildVersion) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.tags = tags;
        this.branch = branch;
        this.dirty = dirty;
        this.remoteOriginUrl = remoteOriginUrl;
        this.commitId = commitId;
        this.commitIdAbbrev = commitIdAbbrev;
        this.describe = describe;
        this.describeShort = describeShort;
        this.commitUserName = commitUserName;
        this.commitUserEmail = commitUserEmail;
        this.commitMessageFull = commitMessageFull;
        this.commitMessageShort = commitMessageShort;
        this.commitTime = commitTime;
        this.closestTagName = closestTagName;
        this.closestTagCommitCount = closestTagCommitCount;
        this.buildUserName = buildUserName;
        this.buildUserEmail = buildUserEmail;
        this.buildTime = buildTime;
        this.buildHost = buildHost;
        this.buildVersion = buildVersion;
    }

    public VersionInfo() {
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getTags() {
        return this.tags;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getDirty() {
        return this.dirty;
    }

    public String getRemoteOriginUrl() {
        return this.remoteOriginUrl;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public String getCommitIdAbbrev() {
        return this.commitIdAbbrev;
    }

    public String getDescribe() {
        return this.describe;
    }

    public String getDescribeShort() {
        return this.describeShort;
    }

    public String getCommitUserName() {
        return this.commitUserName;
    }

    public String getCommitUserEmail() {
        return this.commitUserEmail;
    }

    public String getCommitMessageFull() {
        return this.commitMessageFull;
    }

    public String getCommitMessageShort() {
        return this.commitMessageShort;
    }

    public String getCommitTime() {
        return this.commitTime;
    }

    public String getClosestTagName() {
        return this.closestTagName;
    }

    public String getClosestTagCommitCount() {
        return this.closestTagCommitCount;
    }

    public String getBuildUserName() {
        return this.buildUserName;
    }

    public String getBuildUserEmail() {
        return this.buildUserEmail;
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    public String getBuildHost() {
        return this.buildHost;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public void setBranch(String branch) {
        this.branch = branch;
    }

    public void setDirty(String dirty) {
        this.dirty = dirty;
    }

    public void setRemoteOriginUrl(String remoteOriginUrl) {
        this.remoteOriginUrl = remoteOriginUrl;
    }

    public void setCommitId(String commitId) {
        this.commitId = commitId;
    }

    public void setCommitIdAbbrev(String commitIdAbbrev) {
        this.commitIdAbbrev = commitIdAbbrev;
    }

    public void setDescribe(String describe) {
        this.describe = describe;
    }

    public void setDescribeShort(String describeShort) {
        this.describeShort = describeShort;
    }

    public void setCommitUserName(String commitUserName) {
        this.commitUserName = commitUserName;
    }

    public void setCommitUserEmail(String commitUserEmail) {
        this.commitUserEmail = commitUserEmail;
    }

    public void setCommitMessageFull(String commitMessageFull) {
        this.commitMessageFull = commitMessageFull;
    }

    public void setCommitMessageShort(String commitMessageShort) {
        this.commitMessageShort = commitMessageShort;
    }

    public void setCommitTime(String commitTime) {
        this.commitTime = commitTime;
    }

    public void setClosestTagName(String closestTagName) {
        this.closestTagName = closestTagName;
    }

    public void setClosestTagCommitCount(String closestTagCommitCount) {
        this.closestTagCommitCount = closestTagCommitCount;
    }

    public void setBuildUserName(String buildUserName) {
        this.buildUserName = buildUserName;
    }

    public void setBuildUserEmail(String buildUserEmail) {
        this.buildUserEmail = buildUserEmail;
    }

    public void setBuildTime(String buildTime) {
        this.buildTime = buildTime;
    }

    public void setBuildHost(String buildHost) {
        this.buildHost = buildHost;
    }

    public void setBuildVersion(String buildVersion) {
        this.buildVersion = buildVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VersionInfo)) {
            return false;
        }
        VersionInfo other = (VersionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$tags = this.getTags();
        String other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !this$tags.equals(other$tags)) {
            return false;
        }
        String this$branch = this.getBranch();
        String other$branch = other.getBranch();
        if (this$branch == null ? other$branch != null : !this$branch.equals(other$branch)) {
            return false;
        }
        String this$dirty = this.getDirty();
        String other$dirty = other.getDirty();
        if (this$dirty == null ? other$dirty != null : !this$dirty.equals(other$dirty)) {
            return false;
        }
        String this$remoteOriginUrl = this.getRemoteOriginUrl();
        String other$remoteOriginUrl = other.getRemoteOriginUrl();
        if (this$remoteOriginUrl == null ? other$remoteOriginUrl != null : !this$remoteOriginUrl.equals(other$remoteOriginUrl)) {
            return false;
        }
        String this$commitId = this.getCommitId();
        String other$commitId = other.getCommitId();
        if (this$commitId == null ? other$commitId != null : !this$commitId.equals(other$commitId)) {
            return false;
        }
        String this$commitIdAbbrev = this.getCommitIdAbbrev();
        String other$commitIdAbbrev = other.getCommitIdAbbrev();
        if (this$commitIdAbbrev == null ? other$commitIdAbbrev != null : !this$commitIdAbbrev.equals(other$commitIdAbbrev)) {
            return false;
        }
        String this$describe = this.getDescribe();
        String other$describe = other.getDescribe();
        if (this$describe == null ? other$describe != null : !this$describe.equals(other$describe)) {
            return false;
        }
        String this$describeShort = this.getDescribeShort();
        String other$describeShort = other.getDescribeShort();
        if (this$describeShort == null ? other$describeShort != null : !this$describeShort.equals(other$describeShort)) {
            return false;
        }
        String this$commitUserName = this.getCommitUserName();
        String other$commitUserName = other.getCommitUserName();
        if (this$commitUserName == null ? other$commitUserName != null : !this$commitUserName.equals(other$commitUserName)) {
            return false;
        }
        String this$commitUserEmail = this.getCommitUserEmail();
        String other$commitUserEmail = other.getCommitUserEmail();
        if (this$commitUserEmail == null ? other$commitUserEmail != null : !this$commitUserEmail.equals(other$commitUserEmail)) {
            return false;
        }
        String this$commitMessageFull = this.getCommitMessageFull();
        String other$commitMessageFull = other.getCommitMessageFull();
        if (this$commitMessageFull == null ? other$commitMessageFull != null : !this$commitMessageFull.equals(other$commitMessageFull)) {
            return false;
        }
        String this$commitMessageShort = this.getCommitMessageShort();
        String other$commitMessageShort = other.getCommitMessageShort();
        if (this$commitMessageShort == null ? other$commitMessageShort != null : !this$commitMessageShort.equals(other$commitMessageShort)) {
            return false;
        }
        String this$commitTime = this.getCommitTime();
        String other$commitTime = other.getCommitTime();
        if (this$commitTime == null ? other$commitTime != null : !this$commitTime.equals(other$commitTime)) {
            return false;
        }
        String this$closestTagName = this.getClosestTagName();
        String other$closestTagName = other.getClosestTagName();
        if (this$closestTagName == null ? other$closestTagName != null : !this$closestTagName.equals(other$closestTagName)) {
            return false;
        }
        String this$closestTagCommitCount = this.getClosestTagCommitCount();
        String other$closestTagCommitCount = other.getClosestTagCommitCount();
        if (this$closestTagCommitCount == null ? other$closestTagCommitCount != null : !this$closestTagCommitCount.equals(other$closestTagCommitCount)) {
            return false;
        }
        String this$buildUserName = this.getBuildUserName();
        String other$buildUserName = other.getBuildUserName();
        if (this$buildUserName == null ? other$buildUserName != null : !this$buildUserName.equals(other$buildUserName)) {
            return false;
        }
        String this$buildUserEmail = this.getBuildUserEmail();
        String other$buildUserEmail = other.getBuildUserEmail();
        if (this$buildUserEmail == null ? other$buildUserEmail != null : !this$buildUserEmail.equals(other$buildUserEmail)) {
            return false;
        }
        String this$buildTime = this.getBuildTime();
        String other$buildTime = other.getBuildTime();
        if (this$buildTime == null ? other$buildTime != null : !this$buildTime.equals(other$buildTime)) {
            return false;
        }
        String this$buildHost = this.getBuildHost();
        String other$buildHost = other.getBuildHost();
        if (this$buildHost == null ? other$buildHost != null : !this$buildHost.equals(other$buildHost)) {
            return false;
        }
        String this$buildVersion = this.getBuildVersion();
        String other$buildVersion = other.getBuildVersion();
        return !(this$buildVersion == null ? other$buildVersion != null : !this$buildVersion.equals(other$buildVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VersionInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : $tags.hashCode());
        String $branch = this.getBranch();
        result = result * 59 + ($branch == null ? 43 : $branch.hashCode());
        String $dirty = this.getDirty();
        result = result * 59 + ($dirty == null ? 43 : $dirty.hashCode());
        String $remoteOriginUrl = this.getRemoteOriginUrl();
        result = result * 59 + ($remoteOriginUrl == null ? 43 : $remoteOriginUrl.hashCode());
        String $commitId = this.getCommitId();
        result = result * 59 + ($commitId == null ? 43 : $commitId.hashCode());
        String $commitIdAbbrev = this.getCommitIdAbbrev();
        result = result * 59 + ($commitIdAbbrev == null ? 43 : $commitIdAbbrev.hashCode());
        String $describe = this.getDescribe();
        result = result * 59 + ($describe == null ? 43 : $describe.hashCode());
        String $describeShort = this.getDescribeShort();
        result = result * 59 + ($describeShort == null ? 43 : $describeShort.hashCode());
        String $commitUserName = this.getCommitUserName();
        result = result * 59 + ($commitUserName == null ? 43 : $commitUserName.hashCode());
        String $commitUserEmail = this.getCommitUserEmail();
        result = result * 59 + ($commitUserEmail == null ? 43 : $commitUserEmail.hashCode());
        String $commitMessageFull = this.getCommitMessageFull();
        result = result * 59 + ($commitMessageFull == null ? 43 : $commitMessageFull.hashCode());
        String $commitMessageShort = this.getCommitMessageShort();
        result = result * 59 + ($commitMessageShort == null ? 43 : $commitMessageShort.hashCode());
        String $commitTime = this.getCommitTime();
        result = result * 59 + ($commitTime == null ? 43 : $commitTime.hashCode());
        String $closestTagName = this.getClosestTagName();
        result = result * 59 + ($closestTagName == null ? 43 : $closestTagName.hashCode());
        String $closestTagCommitCount = this.getClosestTagCommitCount();
        result = result * 59 + ($closestTagCommitCount == null ? 43 : $closestTagCommitCount.hashCode());
        String $buildUserName = this.getBuildUserName();
        result = result * 59 + ($buildUserName == null ? 43 : $buildUserName.hashCode());
        String $buildUserEmail = this.getBuildUserEmail();
        result = result * 59 + ($buildUserEmail == null ? 43 : $buildUserEmail.hashCode());
        String $buildTime = this.getBuildTime();
        result = result * 59 + ($buildTime == null ? 43 : $buildTime.hashCode());
        String $buildHost = this.getBuildHost();
        result = result * 59 + ($buildHost == null ? 43 : $buildHost.hashCode());
        String $buildVersion = this.getBuildVersion();
        result = result * 59 + ($buildVersion == null ? 43 : $buildVersion.hashCode());
        return result;
    }

    public String toString() {
        return "VersionInfo(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", tags=" + this.getTags() + ", branch=" + this.getBranch() + ", dirty=" + this.getDirty() + ", remoteOriginUrl=" + this.getRemoteOriginUrl() + ", commitId=" + this.getCommitId() + ", commitIdAbbrev=" + this.getCommitIdAbbrev() + ", describe=" + this.getDescribe() + ", describeShort=" + this.getDescribeShort() + ", commitUserName=" + this.getCommitUserName() + ", commitUserEmail=" + this.getCommitUserEmail() + ", commitMessageFull=" + this.getCommitMessageFull() + ", commitMessageShort=" + this.getCommitMessageShort() + ", commitTime=" + this.getCommitTime() + ", closestTagName=" + this.getClosestTagName() + ", closestTagCommitCount=" + this.getClosestTagCommitCount() + ", buildUserName=" + this.getBuildUserName() + ", buildUserEmail=" + this.getBuildUserEmail() + ", buildTime=" + this.getBuildTime() + ", buildHost=" + this.getBuildHost() + ", buildVersion=" + this.getBuildVersion() + ")";
    }

    public static class VersionInfoBuilder {
        private String groupId;
        private String artifactId;
        private String tags;
        private String branch;
        private String dirty;
        private String remoteOriginUrl;
        private String commitId;
        private String commitIdAbbrev;
        private String describe;
        private String describeShort;
        private String commitUserName;
        private String commitUserEmail;
        private String commitMessageFull;
        private String commitMessageShort;
        private String commitTime;
        private String closestTagName;
        private String closestTagCommitCount;
        private String buildUserName;
        private String buildUserEmail;
        private String buildTime;
        private String buildHost;
        private String buildVersion;

        VersionInfoBuilder() {
        }

        public VersionInfoBuilder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public VersionInfoBuilder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public VersionInfoBuilder tags(String tags) {
            this.tags = tags;
            return this;
        }

        public VersionInfoBuilder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public VersionInfoBuilder dirty(String dirty) {
            this.dirty = dirty;
            return this;
        }

        public VersionInfoBuilder remoteOriginUrl(String remoteOriginUrl) {
            this.remoteOriginUrl = remoteOriginUrl;
            return this;
        }

        public VersionInfoBuilder commitId(String commitId) {
            this.commitId = commitId;
            return this;
        }

        public VersionInfoBuilder commitIdAbbrev(String commitIdAbbrev) {
            this.commitIdAbbrev = commitIdAbbrev;
            return this;
        }

        public VersionInfoBuilder describe(String describe) {
            this.describe = describe;
            return this;
        }

        public VersionInfoBuilder describeShort(String describeShort) {
            this.describeShort = describeShort;
            return this;
        }

        public VersionInfoBuilder commitUserName(String commitUserName) {
            this.commitUserName = commitUserName;
            return this;
        }

        public VersionInfoBuilder commitUserEmail(String commitUserEmail) {
            this.commitUserEmail = commitUserEmail;
            return this;
        }

        public VersionInfoBuilder commitMessageFull(String commitMessageFull) {
            this.commitMessageFull = commitMessageFull;
            return this;
        }

        public VersionInfoBuilder commitMessageShort(String commitMessageShort) {
            this.commitMessageShort = commitMessageShort;
            return this;
        }

        public VersionInfoBuilder commitTime(String commitTime) {
            this.commitTime = commitTime;
            return this;
        }

        public VersionInfoBuilder closestTagName(String closestTagName) {
            this.closestTagName = closestTagName;
            return this;
        }

        public VersionInfoBuilder closestTagCommitCount(String closestTagCommitCount) {
            this.closestTagCommitCount = closestTagCommitCount;
            return this;
        }

        public VersionInfoBuilder buildUserName(String buildUserName) {
            this.buildUserName = buildUserName;
            return this;
        }

        public VersionInfoBuilder buildUserEmail(String buildUserEmail) {
            this.buildUserEmail = buildUserEmail;
            return this;
        }

        public VersionInfoBuilder buildTime(String buildTime) {
            this.buildTime = buildTime;
            return this;
        }

        public VersionInfoBuilder buildHost(String buildHost) {
            this.buildHost = buildHost;
            return this;
        }

        public VersionInfoBuilder buildVersion(String buildVersion) {
            this.buildVersion = buildVersion;
            return this;
        }

        public VersionInfo build() {
            return new VersionInfo(this.groupId, this.artifactId, this.tags, this.branch, this.dirty, this.remoteOriginUrl, this.commitId, this.commitIdAbbrev, this.describe, this.describeShort, this.commitUserName, this.commitUserEmail, this.commitMessageFull, this.commitMessageShort, this.commitTime, this.closestTagName, this.closestTagCommitCount, this.buildUserName, this.buildUserEmail, this.buildTime, this.buildHost, this.buildVersion);
        }

        public String toString() {
            return "VersionInfo.VersionInfoBuilder(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", tags=" + this.tags + ", branch=" + this.branch + ", dirty=" + this.dirty + ", remoteOriginUrl=" + this.remoteOriginUrl + ", commitId=" + this.commitId + ", commitIdAbbrev=" + this.commitIdAbbrev + ", describe=" + this.describe + ", describeShort=" + this.describeShort + ", commitUserName=" + this.commitUserName + ", commitUserEmail=" + this.commitUserEmail + ", commitMessageFull=" + this.commitMessageFull + ", commitMessageShort=" + this.commitMessageShort + ", commitTime=" + this.commitTime + ", closestTagName=" + this.closestTagName + ", closestTagCommitCount=" + this.closestTagCommitCount + ", buildUserName=" + this.buildUserName + ", buildUserEmail=" + this.buildUserEmail + ", buildTime=" + this.buildTime + ", buildHost=" + this.buildHost + ", buildVersion=" + this.buildVersion + ")";
        }
    }
}

