/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor;

import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;
import org.nd4j.linalg.dataset.api.preprocessor.MultiDataNormalization;
import org.nd4j.linalg.dataset.api.preprocessor.serializer.NormalizerType;

public class ImageMultiPreProcessingScaler
implements MultiDataNormalization {
    private double minRange;
    private double maxRange;
    private double maxPixelVal;
    private int[] featureIndices;

    public ImageMultiPreProcessingScaler(int ... featureIndices) {
        this(0.0, 1.0, 8, featureIndices);
    }

    public ImageMultiPreProcessingScaler(double a, double b, int[] featureIndices) {
        this(a, b, 8, featureIndices);
    }

    public ImageMultiPreProcessingScaler(double a, double b, int maxBits, int[] featureIndices) {
        if (featureIndices == null || featureIndices.length == 0) {
            throw new IllegalArgumentException("Invalid feature indices: the indices of the features arrays to apply the normalizer to must be specified. MultiDataSet/MultiDataSetIterators with only a single feature array, this should be set to 0. Otherwise specify the indexes of all the feature arrays to apply the normalizer to.");
        }
        this.maxPixelVal = Math.pow(2.0, maxBits) - 1.0;
        this.minRange = a;
        this.maxRange = b;
        this.featureIndices = featureIndices;
    }

    @Override
    public void fit(MultiDataSetIterator iterator) {
    }

    @Override
    public void preProcess(MultiDataSet multiDataSet) {
        for (int i = 0; i < this.featureIndices.length; ++i) {
            INDArray f = multiDataSet.getFeatures(this.featureIndices[i]);
            f.divi(this.maxPixelVal);
            if (this.maxRange - this.minRange != 1.0) {
                f.muli(this.maxRange - this.minRange);
            }
            if (this.minRange == 0.0) continue;
            f.addi(this.minRange);
        }
    }

    @Override
    public void revertFeatures(INDArray[] features, INDArray[] featuresMask) {
        this.revertFeatures(features);
    }

    @Override
    public void revertFeatures(INDArray[] features) {
        for (int i = 0; i < this.featureIndices.length; ++i) {
            INDArray f = features[this.featureIndices[i]];
            if (this.minRange != 0.0) {
                f.subi(this.minRange);
            }
            if (this.maxRange - this.minRange != 1.0) {
                f.divi(this.maxRange - this.minRange);
            }
            f.muli(this.maxPixelVal);
        }
    }

    @Override
    public void revertLabels(INDArray[] labels, INDArray[] labelsMask) {
    }

    @Override
    public void revertLabels(INDArray[] labels) {
    }

    @Override
    public void fit(MultiDataSet dataSet) {
    }

    @Override
    public void transform(MultiDataSet toPreProcess) {
        this.preProcess(toPreProcess);
    }

    @Override
    public void revert(MultiDataSet toRevert) {
        this.revertFeatures(toRevert.getFeatures(), toRevert.getFeaturesMaskArrays());
    }

    @Override
    public NormalizerType getType() {
        return NormalizerType.IMAGE_MIN_MAX;
    }
}

