/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.impl;

import java.util.List;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.BaseRandomOp;

public class Choice
extends BaseRandomOp {
    public Choice() {
    }

    public Choice(@NonNull INDArray source, @NonNull INDArray probabilities, @NonNull INDArray z) {
        if (source == null) {
            throw new NullPointerException("source");
        }
        if (probabilities == null) {
            throw new NullPointerException("probabilities");
        }
        if (z == null) {
            throw new NullPointerException("z");
        }
        if (source.lengthLong() != probabilities.lengthLong()) {
            throw new IllegalStateException("From & probabilities length mismatch: " + source.lengthLong() + "/" + probabilities.lengthLong());
        }
        if (probabilities.elementWiseStride() < 1 || source.elementWiseStride() < 1) {
            throw new IllegalStateException("Source and probabilities should have element-wise stride >= 1");
        }
        this.init(source, probabilities, z, z.lengthLong());
        this.extraArgs = new Object[]{0.0};
    }

    @Override
    public boolean isExecSpecial() {
        return true;
    }

    @Override
    public int opNum() {
        return 5;
    }

    @Override
    public String opName() {
        return "choice";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return null;
    }
}

