/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Pooling3DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling3DConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pooling3D
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Pooling3D.class);
    protected Pooling3DConfig config;

    public Pooling3D() {
    }

    public Pooling3D(SameDiff sameDiff, SDVariable[] inputs, INDArray[] inputArrays, INDArray[] outputs, boolean inPlace, Pooling3DConfig pooling3DConfig, Pooling3DType type) {
        super(null, sameDiff, inputs, inPlace);
        pooling3DConfig.setType(type);
        this.config = pooling3DConfig;
        this.sameDiff = sameDiff;
        if (inputArrays != null) {
            this.addInputArgument(inputArrays);
        }
        if (outputs != null) {
            this.addOutputArgument(outputs);
        }
        this.addArgs();
    }

    @Override
    public void setValueFor(Field target, Object value) {
        this.config.setValueFor(target, value);
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        return this.config.toProperties();
    }

    private void addArgs() {
        this.addIArgument(this.config.getKT());
        this.addIArgument(this.config.getKW());
        this.addIArgument(this.config.getKH());
        this.addIArgument(this.config.getST());
        this.addIArgument(this.config.getSW());
        this.addIArgument(this.config.getSH());
        this.addIArgument(this.config.getPT());
        this.addIArgument(this.config.getPW());
        this.addIArgument(this.config.getPH());
        this.addIArgument(this.config.getDilationT());
        this.addIArgument(this.config.getDilationW());
        this.addIArgument(this.config.getDilationH());
    }

    @Override
    public String opName() {
        return this.getPoolingPrefix() + "pool3dnew";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.addAll(Arrays.asList(this.args()));
        inputs.add(f1.get(0));
        Pooling3DDerivative pooling3DDerivative = Pooling3DDerivative.derivativeBuilder().inPlace(this.inPlace).sameDiff(this.sameDiff).inputs(inputs.toArray(new SDVariable[inputs.size()])).pooling3DConfig(this.config).build();
        ret.addAll(Arrays.asList(pooling3DDerivative.outputVariables()));
        return ret;
    }

    public String getPoolingPrefix() {
        if (this.config == null) {
            return "pooling3d";
        }
        switch (this.config.getType()) {
            case AVG: {
                return "avg";
            }
            case MAX: {
                return "max";
            }
        }
        throw new IllegalStateException("No pooling type found.");
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for op " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No op opName found for op " + this.opName());
    }

    public static Pooling3DBuilder builder() {
        return new Pooling3DBuilder();
    }

    public static class Pooling3DBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputs;
        private INDArray[] inputArrays;
        private INDArray[] outputs;
        private boolean inPlace;
        private Pooling3DConfig pooling3DConfig;
        private Pooling3DType type;

        Pooling3DBuilder() {
        }

        public Pooling3DBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public Pooling3DBuilder inputs(SDVariable[] inputs) {
            this.inputs = inputs;
            return this;
        }

        public Pooling3DBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public Pooling3DBuilder outputs(INDArray[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public Pooling3DBuilder inPlace(boolean inPlace) {
            this.inPlace = inPlace;
            return this;
        }

        public Pooling3DBuilder pooling3DConfig(Pooling3DConfig pooling3DConfig) {
            this.pooling3DConfig = pooling3DConfig;
            return this;
        }

        public Pooling3DBuilder type(Pooling3DType type) {
            this.type = type;
            return this;
        }

        public Pooling3D build() {
            return new Pooling3D(this.sameDiff, this.inputs, this.inputArrays, this.outputs, this.inPlace, this.pooling3DConfig, this.type);
        }

        public String toString() {
            return "Pooling3D.Pooling3DBuilder(sameDiff=" + this.sameDiff + ", inputs=" + Arrays.deepToString(this.inputs) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputs=" + Arrays.deepToString(this.outputs) + ", inPlace=" + this.inPlace + ", pooling3DConfig=" + this.pooling3DConfig + ", type=" + (Object)((Object)this.type) + ")";
        }
    }

    public static enum Pooling3DType {
        MAX,
        AVG,
        PNORM;

    }
}

