/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum.distances;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;

public class JaccardDistance
extends BaseAccumulation {
    public JaccardDistance(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int ... dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
        this.extraArgs = new Object[2];
        this.extraArgs[0] = Float.valueOf(0.0f);
        this.extraArgs[1] = Float.valueOf(0.0f);
    }

    public JaccardDistance() {
        this.passThrough = false;
    }

    public JaccardDistance(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
        this.passThrough = Nd4j.getExecutioner().executionMode() == OpExecutioner.ExecutionMode.JAVA;
        this.extraArgs = new Object[2];
        this.extraArgs[0] = Float.valueOf(0.0f);
        this.extraArgs[1] = Float.valueOf(0.0f);
    }

    public JaccardDistance(INDArray x, INDArray y, long n) {
        super(x, y, n);
        this.passThrough = Nd4j.getExecutioner().executionMode() == OpExecutioner.ExecutionMode.JAVA;
        this.extraArgs = new Object[2];
        this.extraArgs[0] = Float.valueOf(0.0f);
        this.extraArgs[1] = Float.valueOf(0.0f);
    }

    public JaccardDistance(INDArray x) {
        super(x);
        this.passThrough = Nd4j.getExecutioner().executionMode() == OpExecutioner.ExecutionMode.JAVA;
        this.extraArgs = new Object[2];
        this.extraArgs[0] = Float.valueOf(0.0f);
        this.extraArgs[1] = Float.valueOf(0.0f);
    }

    public JaccardDistance(INDArray x, INDArray y) {
        super(x, y);
        this.passThrough = Nd4j.getExecutioner().executionMode() == OpExecutioner.ExecutionMode.JAVA;
        this.extraArgs = new Object[2];
        this.extraArgs[0] = Float.valueOf(0.0f);
        this.extraArgs[1] = Float.valueOf(0.0f);
    }

    public JaccardDistance(INDArray x, INDArray y, INDArray z, boolean allDistances) {
        this(x, y, z, x.lengthLong());
        this.isComplex = allDistances;
    }

    public JaccardDistance(INDArray x, INDArray y, boolean allDistances) {
        this(x, y);
        this.isComplex = allDistances;
    }

    @Override
    public Op.Type opType() {
        return Op.Type.REDUCE3;
    }

    @Override
    public Op.Type getOpType() {
        return this.opType();
    }

    @Override
    public int opNum() {
        return 6;
    }

    @Override
    public String opName() {
        return "jaccarddistance";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        int rank = Shape.rankFromShape(this.larg().getShape());
        SDVariable jSim = this.outputVariables()[0].rsub(1.0);
        SDVariable min = this.f().min(this.larg(), this.rarg());
        SDVariable max = this.f().max(this.larg(), this.rarg());
        SDVariable sumMax = this.f().sum(max, this.dimensions);
        SDVariable broadcastableSumMax = this.f().reductionBroadcastableWithOrigShape(rank, this.dimensions, sumMax);
        SDVariable broadcastableJSim = this.f().reductionBroadcastableWithOrigShape(rank, this.dimensions, jSim);
        SDVariable xIsMin = this.f().eq(min, this.larg());
        SDVariable xIsMax = this.f().eq(max, this.larg());
        SDVariable yIsMin = this.f().eq(min, this.rarg());
        SDVariable yIsMax = this.f().eq(max, this.rarg());
        SDVariable dldx = xIsMax.mul(broadcastableJSim).sub(xIsMin).div(broadcastableSumMax);
        SDVariable dldy = yIsMax.mul(broadcastableJSim).sub(yIsMin).div(broadcastableSumMax);
        return Arrays.asList(dldx.mul(f1.get(0)), dldy.mul(f1.get(0)));
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }
}

