/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.accum;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.ops.transforms.Transforms;

public class Norm1
extends BaseAccumulation {
    public Norm1(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public Norm1(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public Norm1() {
    }

    public Norm1(INDArray x, INDArray y, INDArray z, long n) {
        super(x, y, z, n);
    }

    public Norm1(INDArray x, INDArray y, long n) {
        super(x, y, n);
    }

    public Norm1(INDArray x) {
        super(x);
    }

    public Norm1(INDArray x, INDArray y) {
        super(x, y);
    }

    @Override
    public INDArray noOp() {
        return Transforms.abs(this.x());
    }

    @Override
    public int opNum() {
        return 5;
    }

    @Override
    public String opName() {
        return "norm1";
    }

    @Override
    public String onnxName() {
        return "Norm";
    }

    @Override
    public String tensorflowName() {
        return "norm";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v1) {
        SDVariable signum = this.sameDiff.sign(this.arg());
        int origRank = Shape.rankFromShape(this.arg().getShape());
        SDVariable bcGrad = this.sameDiff.f().reductionBroadcastableWithOrigShape(origRank, this.dimensions, i_v1.get(0));
        return Arrays.asList(signum.mul(bcGrad));
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.REDUCE;
    }
}

