/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas.impl;

import org.nd4j.linalg.api.blas.Level2;
import org.nd4j.linalg.api.blas.impl.BaseLevel;
import org.nd4j.linalg.api.blas.params.GemvParameters;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexFloat;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.executioner.DefaultOpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpExecutionerUtil;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.profiler.OpProfiler;

public abstract class BaseLevel2
extends BaseLevel
implements Level2 {
    @Override
    public void gemv(char order, char transA, double alpha, INDArray A, INDArray X, double beta, INDArray Y) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X, Y);
        }
        if (A.isSparse() && !X.isSparse()) {
            Nd4j.getSparseBlasWrapper().level2().gemv(order, transA, alpha, A, X, beta, Y);
            return;
        }
        GemvParameters parameters = new GemvParameters(A, X, Y);
        if (A.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, parameters.getA(), parameters.getX(), parameters.getY());
            this.dgemv(order, parameters.getAOrdering(), parameters.getM(), parameters.getN(), alpha, parameters.getA(), parameters.getLda(), parameters.getX(), parameters.getIncx(), beta, parameters.getY(), parameters.getIncy());
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, parameters.getA(), parameters.getX(), parameters.getY());
            this.sgemv(order, parameters.getAOrdering(), parameters.getM(), parameters.getN(), (float)alpha, parameters.getA(), parameters.getLda(), parameters.getX(), parameters.getIncx(), (float)beta, parameters.getY(), parameters.getIncy());
        }
        OpExecutionerUtil.checkForAny(Y);
    }

    @Override
    public void gemv(char order, char transA, IComplexNumber alpha, IComplexNDArray A, IComplexNDArray X, IComplexNumber beta, IComplexNDArray Y) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X, Y);
        }
        GemvParameters parameters = new GemvParameters(A, X, Y);
        if (A.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.zgemv(order, transA, parameters.getM(), parameters.getN(), alpha.asDouble(), A, parameters.getLda(), X, parameters.getIncx(), beta.asDouble(), Y, parameters.getIncy());
        } else {
            this.cgemv(order, transA, parameters.getM(), parameters.getN(), alpha.asFloat(), A, parameters.getLda(), X, parameters.getIncx(), beta.asFloat(), Y, parameters.getIncy());
        }
    }

    @Override
    public void gbmv(char order, char TransA, int KL, int KU, double alpha, INDArray A, INDArray X, double beta, INDArray Y) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X, Y);
        }
        if (A.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, A, X, Y);
            this.dgbmv(order, TransA, A.rows(), A.columns(), KL, KU, alpha, A, A.size(0), X, X.majorStride(), beta, Y, Y.majorStride());
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, A, X, Y);
            this.sgbmv(order, TransA, A.rows(), A.columns(), KL, KU, (float)alpha, A, A.size(0), X, X.majorStride(), (float)beta, Y, Y.majorStride());
        }
        OpExecutionerUtil.checkForAny(Y);
    }

    @Override
    public void gbmv(char order, char TransA, int KL, int KU, IComplexNumber alpha, IComplexNDArray A, IComplexNDArray X, IComplexNumber beta, IComplexNDArray Y) {
        if (A.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.zgbmv(order, TransA, A.rows(), A.columns(), KL, KU, alpha.asDouble(), A, A.size(0), X, X.majorStride() / 2, beta.asDouble(), Y, Y.majorStride() / 2);
        } else {
            this.cgbmv(order, TransA, A.rows(), A.columns(), KL, KU, alpha.asFloat(), A, A.size(0), X, X.majorStride() / 2, beta.asFloat(), Y, Y.majorStride() / 2);
        }
    }

    @Override
    public void ger(char order, double alpha, INDArray X, INDArray Y, INDArray A) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X, Y);
        }
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, A, X, Y);
            this.dger(order, A.rows(), A.columns(), alpha, X, X.majorStride(), Y, Y.majorStride(), A, A.size(0));
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, A, X, Y);
            this.sger(order, A.rows(), A.columns(), (float)alpha, X, X.majorStride(), Y, Y.majorStride(), A, A.size(0));
        }
        OpExecutionerUtil.checkForAny(A);
    }

    @Override
    public void geru(char order, IComplexNumber alpha, IComplexNDArray X, IComplexNDArray Y, IComplexNDArray A) {
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.zgeru(order, A.rows(), A.columns(), alpha.asDouble(), X, X.majorStride() / 2, Y, Y.majorStride() / 2, A, A.size(0));
        } else {
            this.cgeru(order, A.rows(), A.columns(), alpha.asFloat(), X, X.majorStride() / 2, Y, Y.majorStride() / 2, A, A.size(0));
        }
    }

    @Override
    public void hbmv(char order, char Uplo, IComplexNumber alpha, IComplexNDArray A, IComplexNDArray X, IComplexNumber beta, IComplexNDArray Y) {
        if (A.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.zhbmv(order, Uplo, X.length(), A.columns(), alpha.asDouble(), A, A.size(0), X, X.majorStride() / 2, beta.asDouble(), Y, Y.majorStride() / 2);
        } else {
            this.chbmv(order, Uplo, X.length(), A.columns(), alpha.asFloat(), A, A.size(0), X, X.majorStride() / 2, beta.asFloat(), Y, Y.majorStride() / 2);
        }
    }

    @Override
    public void hemv(char order, char Uplo, IComplexNumber alpha, IComplexNDArray A, IComplexNDArray X, IComplexNumber beta, IComplexNDArray Y) {
        if (A.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.zhemv(order, Uplo, A.rows(), alpha.asDouble(), A, A.size(0), X, X.majorStride() / 2, beta.asDouble(), Y, Y.majorStride() / 2);
        } else {
            this.chemv(order, Uplo, A.rows(), alpha.asFloat(), A, A.size(0), X, X.majorStride() / 2, beta.asFloat(), Y, Y.majorStride() / 2);
        }
    }

    @Override
    public void her2(char order, char Uplo, IComplexNumber alpha, IComplexNDArray X, IComplexNDArray Y, IComplexNDArray A) {
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.zher2(order, Uplo, A.rows(), alpha.asDouble(), X, X.majorStride() / 2, Y, Y.majorStride() / 2, A, A.size(0));
        } else {
            this.cher2(order, Uplo, A.rows(), alpha.asFloat(), X, X.majorStride() / 2, Y, Y.majorStride() / 2, A, A.size(0));
        }
    }

    @Override
    public void hpmv(char order, char Uplo, int N, IComplexNumber alpha, IComplexNDArray Ap, IComplexNDArray X, IComplexNumber beta, IComplexNDArray Y) {
        if (Ap.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.zhpmv(order, Uplo, Ap.rows(), alpha.asDouble(), Ap, X, X.majorStride() / 2, beta.asDouble(), Y, Y.majorStride() / 2);
        } else {
            this.chpmv(order, Uplo, Ap.rows(), alpha.asFloat(), Ap, X, X.majorStride() / 2, beta.asFloat(), Y, Y.majorStride() / 2);
        }
    }

    @Override
    public void hpr2(char order, char Uplo, IComplexNumber alpha, IComplexNDArray X, IComplexNDArray Y, IComplexNDArray Ap) {
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            this.zhpr2(order, Uplo, Ap.rows(), alpha.asDouble(), X, X.majorStride() / 2, Y, Y.majorStride() / 2, Ap);
        } else {
            this.chpr2(order, Uplo, Ap.rows(), alpha.asFloat(), X, X.majorStride() / 2, Y, Y.majorStride() / 2, Ap);
        }
    }

    @Override
    public void sbmv(char order, char Uplo, double alpha, INDArray A, INDArray X, double beta, INDArray Y) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X, Y);
        }
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, A, X, Y);
            this.dsbmv(order, Uplo, X.length(), A.columns(), alpha, A, A.size(0), X, X.majorStride(), beta, Y, Y.majorStride());
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, A, X, Y);
            this.ssbmv(order, Uplo, X.length(), A.columns(), (float)alpha, A, A.size(0), X, X.majorStride(), (float)beta, Y, Y.majorStride());
        }
        OpExecutionerUtil.checkForAny(Y);
    }

    @Override
    public void spmv(char order, char Uplo, double alpha, INDArray Ap, INDArray X, double beta, INDArray Y) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, Ap, X, Y);
        }
        if (Ap.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, X, Y);
            this.dspmv(order, Uplo, X.length(), alpha, Ap, X, Ap.majorStride(), beta, Y, Y.majorStride());
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, X, Y);
            this.sspmv(order, Uplo, X.length(), (float)alpha, Ap, X, Ap.majorStride(), (float)beta, Y, Y.majorStride());
        }
        OpExecutionerUtil.checkForAny(Y);
    }

    @Override
    public void spr(char order, char Uplo, double alpha, INDArray X, INDArray Ap) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, Ap, X);
        }
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, X);
            this.dspr(order, Uplo, X.length(), alpha, X, X.majorStride(), Ap);
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, X);
            this.sspr(order, Uplo, X.length(), (float)alpha, X, X.majorStride(), Ap);
        }
        OpExecutionerUtil.checkForAny(Ap);
    }

    @Override
    public void spr2(char order, char Uplo, double alpha, INDArray X, INDArray Y, INDArray A) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X, Y);
        }
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, A, X, Y);
            this.dspr2(order, Uplo, X.length(), alpha, X, X.majorStride(), Y, Y.majorStride(), A);
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, A, X, Y);
            this.sspr2(order, Uplo, X.length(), (float)alpha, X, X.majorStride(), Y, Y.majorStride(), A);
        }
        OpExecutionerUtil.checkForAny(A);
    }

    @Override
    public void symv(char order, char Uplo, double alpha, INDArray A, INDArray X, double beta, INDArray Y) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X, Y);
        }
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, A, X, Y);
            this.dsymv(order, Uplo, X.length(), alpha, A, A.size(0), X, X.majorStride(), beta, Y, Y.majorStride());
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, A, X, Y);
            this.ssymv(order, Uplo, X.length(), (float)alpha, A, A.size(0), X, X.majorStride(), (float)beta, Y, Y.majorStride());
        }
        OpExecutionerUtil.checkForAny(Y);
    }

    @Override
    public void syr(char order, char Uplo, int N, double alpha, INDArray X, INDArray A) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X);
        }
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, A, X);
            this.dsyr(order, Uplo, X.length(), alpha, X, X.majorStride(), A, A.size(0));
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, A, X);
            this.ssyr(order, Uplo, X.length(), (float)alpha, X, X.majorStride(), A, A.size(0));
        }
        OpExecutionerUtil.checkForAny(A);
    }

    @Override
    public void syr2(char order, char Uplo, double alpha, INDArray X, INDArray Y, INDArray A) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X, Y);
        }
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, A, X, Y);
            this.dsyr2(order, Uplo, X.length(), alpha, X, X.majorStride(), Y, Y.majorStride(), A, A.size(0));
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, A, X, Y);
            this.ssyr2(order, Uplo, X.length(), (float)alpha, X, X.majorStride(), Y, Y.majorStride(), A, A.size(0));
        }
        OpExecutionerUtil.checkForAny(A);
    }

    @Override
    public void tbmv(char order, char Uplo, char TransA, char Diag2, INDArray A, INDArray X) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X);
        }
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, A, X);
            this.dtbmv(order, Uplo, TransA, Diag2, X.length(), A.columns(), A, A.size(0), X, X.majorStride());
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, A, X);
            this.stbmv(order, Uplo, TransA, Diag2, X.length(), A.columns(), A, A.size(0), X, X.majorStride());
        }
    }

    @Override
    public void tbsv(char order, char Uplo, char TransA, char Diag2, INDArray A, INDArray X) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X);
        }
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, A, X);
            this.dtbsv(order, Uplo, TransA, Diag2, X.length(), A.columns(), A, A.size(0), X, X.majorStride());
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, A, X);
            this.stbsv(order, Uplo, TransA, Diag2, X.length(), A.columns(), A, A.size(0), X, X.majorStride());
        }
    }

    @Override
    public void tpmv(char order, char Uplo, char TransA, char Diag2, INDArray Ap, INDArray X) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, Ap, X);
        }
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, X);
            this.dtpmv(order, Uplo, TransA, Diag2, Ap.length(), Ap, X, X.majorStride());
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, X);
            this.stpmv(order, Uplo, TransA, Diag2, Ap.length(), Ap, X, X.majorStride());
        }
        OpExecutionerUtil.checkForAny(X);
    }

    @Override
    public void tpsv(char order, char Uplo, char TransA, char Diag2, INDArray Ap, INDArray X) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, Ap, X);
        }
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, X, Ap);
            this.dtpsv(order, Uplo, TransA, Diag2, X.length(), Ap, X, X.majorStride());
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, Ap, X);
            this.stpsv(order, Uplo, TransA, Diag2, X.length(), Ap, X, X.majorStride());
        }
        OpExecutionerUtil.checkForAny(X);
    }

    @Override
    public void trmv(char order, char Uplo, char TransA, char Diag2, INDArray A, INDArray X) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X);
        }
        if (A.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, A, X);
            this.dtrmv(order, Uplo, TransA, Diag2, X.length(), A, A.size(0), X, X.majorStride());
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, A, X);
            this.strmv(order, Uplo, TransA, Diag2, X.length(), A, A.size(0), X, X.majorStride());
        }
        OpExecutionerUtil.checkForAny(X);
    }

    @Override
    public void trsv(char order, char Uplo, char TransA, char Diag2, INDArray A, INDArray X) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X);
        }
        if (X.data().dataType() == DataBuffer.Type.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.DOUBLE, A, X);
            this.dtrsv(order, Uplo, TransA, Diag2, A.length(), A, A.size(0), X, X.majorStride());
        } else {
            DefaultOpExecutioner.validateDataType(DataBuffer.Type.FLOAT, A, X);
            this.strsv(order, Uplo, TransA, Diag2, A.length(), A, A.size(0), X, X.majorStride());
        }
        OpExecutionerUtil.checkForAny(X);
    }

    protected abstract void sgemv(char var1, char var2, int var3, int var4, float var5, INDArray var6, int var7, INDArray var8, int var9, float var10, INDArray var11, int var12);

    protected abstract void sgbmv(char var1, char var2, int var3, int var4, int var5, int var6, float var7, INDArray var8, int var9, INDArray var10, int var11, float var12, INDArray var13, int var14);

    protected abstract void strmv(char var1, char var2, char var3, char var4, int var5, INDArray var6, int var7, INDArray var8, int var9);

    protected abstract void stbmv(char var1, char var2, char var3, char var4, int var5, int var6, INDArray var7, int var8, INDArray var9, int var10);

    protected abstract void stpmv(char var1, char var2, char var3, char var4, int var5, INDArray var6, INDArray var7, int var8);

    protected abstract void strsv(char var1, char var2, char var3, char var4, int var5, INDArray var6, int var7, INDArray var8, int var9);

    protected abstract void stbsv(char var1, char var2, char var3, char var4, int var5, int var6, INDArray var7, int var8, INDArray var9, int var10);

    protected abstract void stpsv(char var1, char var2, char var3, char var4, int var5, INDArray var6, INDArray var7, int var8);

    protected abstract void dgemv(char var1, char var2, int var3, int var4, double var5, INDArray var7, int var8, INDArray var9, int var10, double var11, INDArray var13, int var14);

    protected abstract void dgbmv(char var1, char var2, int var3, int var4, int var5, int var6, double var7, INDArray var9, int var10, INDArray var11, int var12, double var13, INDArray var15, int var16);

    protected abstract void dtrmv(char var1, char var2, char var3, char var4, int var5, INDArray var6, int var7, INDArray var8, int var9);

    protected abstract void dtbmv(char var1, char var2, char var3, char var4, int var5, int var6, INDArray var7, int var8, INDArray var9, int var10);

    protected abstract void dtpmv(char var1, char var2, char var3, char var4, int var5, INDArray var6, INDArray var7, int var8);

    protected abstract void dtrsv(char var1, char var2, char var3, char var4, int var5, INDArray var6, int var7, INDArray var8, int var9);

    protected abstract void dtbsv(char var1, char var2, char var3, char var4, int var5, int var6, INDArray var7, int var8, INDArray var9, int var10);

    protected abstract void dtpsv(char var1, char var2, char var3, char var4, int var5, INDArray var6, INDArray var7, int var8);

    protected abstract void cgemv(char var1, char var2, int var3, int var4, IComplexFloat var5, IComplexNDArray var6, int var7, IComplexNDArray var8, int var9, IComplexFloat var10, IComplexNDArray var11, int var12);

    protected abstract void cgbmv(char var1, char var2, int var3, int var4, int var5, int var6, IComplexFloat var7, IComplexNDArray var8, int var9, IComplexNDArray var10, int var11, IComplexFloat var12, IComplexNDArray var13, int var14);

    protected abstract void ctrmv(char var1, char var2, char var3, char var4, int var5, IComplexNDArray var6, int var7, IComplexNDArray var8, int var9);

    protected abstract void ctbmv(char var1, char var2, char var3, char var4, int var5, int var6, IComplexNDArray var7, int var8, IComplexNDArray var9, int var10);

    protected abstract void ctpmv(char var1, char var2, char var3, char var4, int var5, IComplexNDArray var6, IComplexNDArray var7, int var8);

    protected abstract void ctrsv(char var1, char var2, char var3, char var4, int var5, IComplexNDArray var6, int var7, IComplexNDArray var8, int var9);

    protected abstract void ctbsv(char var1, char var2, char var3, char var4, int var5, int var6, IComplexNDArray var7, int var8, IComplexNDArray var9, int var10);

    protected abstract void ctpsv(char var1, char var2, char var3, char var4, int var5, IComplexNDArray var6, IComplexNDArray var7, int var8);

    protected abstract void zgemv(char var1, char var2, int var3, int var4, IComplexDouble var5, IComplexNDArray var6, int var7, IComplexNDArray var8, int var9, IComplexDouble var10, IComplexNDArray var11, int var12);

    protected abstract void zgbmv(char var1, char var2, int var3, int var4, int var5, int var6, IComplexDouble var7, IComplexNDArray var8, int var9, IComplexNDArray var10, int var11, IComplexDouble var12, IComplexNDArray var13, int var14);

    protected abstract void ztrmv(char var1, char var2, char var3, char var4, int var5, IComplexNDArray var6, int var7, IComplexNDArray var8, int var9);

    protected abstract void ztbmv(char var1, char var2, char var3, char var4, int var5, int var6, IComplexNDArray var7, int var8, IComplexNDArray var9, int var10);

    protected abstract void ztpmv(char var1, char var2, char var3, char var4, int var5, IComplexNDArray var6, IComplexNDArray var7, int var8);

    protected abstract void ztrsv(char var1, char var2, char var3, char var4, int var5, IComplexNDArray var6, int var7, IComplexNDArray var8, int var9);

    protected abstract void ztbsv(char var1, char var2, char var3, char var4, int var5, int var6, IComplexNDArray var7, int var8, IComplexNDArray var9, int var10);

    protected abstract void ztpsv(char var1, char var2, char var3, char var4, int var5, IComplexNDArray var6, IComplexNDArray var7, int var8);

    protected abstract void ssymv(char var1, char var2, int var3, float var4, INDArray var5, int var6, INDArray var7, int var8, float var9, INDArray var10, int var11);

    protected abstract void ssbmv(char var1, char var2, int var3, int var4, float var5, INDArray var6, int var7, INDArray var8, int var9, float var10, INDArray var11, int var12);

    protected abstract void sspmv(char var1, char var2, int var3, float var4, INDArray var5, INDArray var6, int var7, float var8, INDArray var9, int var10);

    protected abstract void sger(char var1, int var2, int var3, float var4, INDArray var5, int var6, INDArray var7, int var8, INDArray var9, int var10);

    protected abstract void ssyr(char var1, char var2, int var3, float var4, INDArray var5, int var6, INDArray var7, int var8);

    protected abstract void sspr(char var1, char var2, int var3, float var4, INDArray var5, int var6, INDArray var7);

    protected abstract void ssyr2(char var1, char var2, int var3, float var4, INDArray var5, int var6, INDArray var7, int var8, INDArray var9, int var10);

    protected abstract void sspr2(char var1, char var2, int var3, float var4, INDArray var5, int var6, INDArray var7, int var8, INDArray var9);

    protected abstract void dsymv(char var1, char var2, int var3, double var4, INDArray var6, int var7, INDArray var8, int var9, double var10, INDArray var12, int var13);

    protected abstract void dsbmv(char var1, char var2, int var3, int var4, double var5, INDArray var7, int var8, INDArray var9, int var10, double var11, INDArray var13, int var14);

    protected abstract void dspmv(char var1, char var2, int var3, double var4, INDArray var6, INDArray var7, int var8, double var9, INDArray var11, int var12);

    protected abstract void dger(char var1, int var2, int var3, double var4, INDArray var6, int var7, INDArray var8, int var9, INDArray var10, int var11);

    protected abstract void dsyr(char var1, char var2, int var3, double var4, INDArray var6, int var7, INDArray var8, int var9);

    protected abstract void dspr(char var1, char var2, int var3, double var4, INDArray var6, int var7, INDArray var8);

    protected abstract void dsyr2(char var1, char var2, int var3, double var4, INDArray var6, int var7, INDArray var8, int var9, INDArray var10, int var11);

    protected abstract void dspr2(char var1, char var2, int var3, double var4, INDArray var6, int var7, INDArray var8, int var9, INDArray var10);

    protected abstract void chemv(char var1, char var2, int var3, IComplexFloat var4, IComplexNDArray var5, int var6, IComplexNDArray var7, int var8, IComplexFloat var9, IComplexNDArray var10, int var11);

    protected abstract void chbmv(char var1, char var2, int var3, int var4, IComplexFloat var5, IComplexNDArray var6, int var7, IComplexNDArray var8, int var9, IComplexFloat var10, IComplexNDArray var11, int var12);

    protected abstract void chpmv(char var1, char var2, int var3, IComplexFloat var4, IComplexNDArray var5, IComplexNDArray var6, int var7, IComplexFloat var8, IComplexNDArray var9, int var10);

    protected abstract void cgeru(char var1, int var2, int var3, IComplexFloat var4, IComplexNDArray var5, int var6, IComplexNDArray var7, int var8, IComplexNDArray var9, int var10);

    protected abstract void cgerc(char var1, int var2, int var3, IComplexFloat var4, IComplexNDArray var5, int var6, IComplexNDArray var7, int var8, IComplexNDArray var9, int var10);

    protected abstract void cher(char var1, char var2, int var3, float var4, IComplexNDArray var5, int var6, IComplexNDArray var7, int var8);

    protected abstract void chpr(char var1, char var2, int var3, INDArray var4, IComplexNDArray var5, int var6, IComplexNDArray var7);

    protected abstract void cher2(char var1, char var2, int var3, IComplexFloat var4, IComplexNDArray var5, int var6, IComplexNDArray var7, int var8, IComplexNDArray var9, int var10);

    protected abstract void chpr2(char var1, char var2, int var3, IComplexFloat var4, IComplexNDArray var5, int var6, IComplexNDArray var7, int var8, IComplexNDArray var9);

    protected abstract void zhemv(char var1, char var2, int var3, IComplexDouble var4, IComplexNDArray var5, int var6, IComplexNDArray var7, int var8, IComplexDouble var9, IComplexNDArray var10, int var11);

    protected abstract void zhbmv(char var1, char var2, int var3, int var4, IComplexDouble var5, IComplexNDArray var6, int var7, IComplexNDArray var8, int var9, IComplexDouble var10, IComplexNDArray var11, int var12);

    protected abstract void zhpmv(char var1, char var2, int var3, IComplexDouble var4, IComplexNDArray var5, IComplexNDArray var6, int var7, IComplexDouble var8, IComplexNDArray var9, int var10);

    protected abstract void zgeru(char var1, int var2, int var3, IComplexDouble var4, IComplexNDArray var5, int var6, IComplexNDArray var7, int var8, IComplexNDArray var9, int var10);

    protected abstract void zgerc(char var1, int var2, int var3, IComplexDouble var4, IComplexNDArray var5, int var6, IComplexNDArray var7, int var8, IComplexNDArray var9, int var10);

    protected abstract void zher(char var1, char var2, int var3, double var4, IComplexNDArray var6, int var7, IComplexNDArray var8, int var9);

    protected abstract void zhpr(char var1, char var2, int var3, INDArray var4, IComplexNDArray var5, int var6, IComplexNDArray var7);

    protected abstract void zher2(char var1, char var2, int var3, IComplexDouble var4, IComplexNDArray var5, int var6, IComplexNDArray var7, int var8, IComplexNDArray var9, int var10);

    protected abstract void zhpr2(char var1, char var2, int var3, IComplexDouble var4, IComplexNDArray var5, int var6, IComplexNDArray var7, int var8, IComplexNDArray var9);
}

