/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.CustomOpDescriptor;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Fill
extends DynamicCustomOp {
    private double value;

    public Fill() {
    }

    public Fill(SameDiff sameDiff, SDVariable shape, double value) {
        super(null, sameDiff, new SDVariable[]{shape}, false);
        this.value = value;
        INDArray shp = shape.getArr();
        this.addArgs();
    }

    protected void addArgs() {
        this.addTArgument(this.value);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        if (nodeDef.getInputCount() == 2) {
            NodeDef targetNode = TFGraphMapper.getInstance().getNodeWithNameFromGraph(graph, nodeDef.getInput(1));
            TFGraphMapper mapper = TFGraphMapper.getInstance();
            INDArray secondInputAsScalar = mapper.getNDArrayFromTensor("value", targetNode, graph);
            if (secondInputAsScalar.length() == 1) {
                this.addTArgument(secondInputAsScalar.getDouble(0));
            } else {
                throw new ND4JIllegalStateException("Second input to node " + nodeDef + " should be scalar!");
            }
        }
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        super.initFromOnnx(node, initWith, attributesForNode, graph);
    }

    @Override
    public void assertValidForExecution() {
        CustomOpDescriptor descriptor = this.getDescriptor();
        if (descriptor.getNumInputs() > 0 && this.numInputArguments() > 2 || this.numInputArguments() < 1) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of inputs is invalid for execution. Specified " + this.numInputArguments() + " but should be " + descriptor.getNumInputs());
        }
        if (descriptor.getNumOutputs() > 0 && this.numOutputArguments() != descriptor.getNumOutputs()) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of outputs is invalid for execution. Specified " + this.numOutputArguments() + " but should be " + descriptor.getNumInputs());
        }
        if (descriptor.getNumIArgs() >= 0 && this.numIArguments() != descriptor.getNumIArgs()) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of integer arguments is invalid for execution. Specified " + this.numIArguments() + " but should be " + descriptor.getNumIArgs());
        }
        if (descriptor.getNumTArgs() >= 0 && this.numTArguments() < 1) {
            throw new ND4JIllegalStateException("Op failure for " + this.opName() + " Number of inputs is invalid for execution. Specified " + this.numTArguments() + " but should be " + descriptor.getNumTArgs());
        }
    }

    @Override
    public List<int[]> calculateOutputShape() {
        int numArgs = this.args().length;
        if (numArgs < 1) {
            return Collections.emptyList();
        }
        INDArray shape = this.args()[0].getArr();
        if (shape == null) {
            return Collections.emptyList();
        }
        if (shape.length() == 1) {
            if (shape.getDouble(0) < 1.0) {
                return Arrays.asList(new int[][]{{1, 1}});
            }
            return Arrays.asList(new int[][]{{1, shape.getInt(0)}});
        }
        return Arrays.asList(new int[][]{shape.data().asInt()});
    }

    @Override
    public String opName() {
        return "fill";
    }

    @Override
    public String onnxName() {
        return "ConstantFill";
    }

    @Override
    public String tensorflowName() {
        return "Fill";
    }

    @Override
    public Op.Type opType() {
        return Op.Type.CUSTOM;
    }
}

