/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.onnx.OnnxGraphMapper;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.util.ArrayUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;
import org.tensorflow.framework.TensorShapeProto;

public class Reshape
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Reshape.class);
    private int[] shape;
    private String arrName;

    public Reshape(SameDiff sameDiff, SDVariable i_v, int[] shape) {
        super(null, sameDiff, new SDVariable[]{i_v});
        this.shape = shape;
        this.addIArgument(99);
        this.addIArgument(shape);
    }

    public Reshape() {
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        if (!nodeDef.containsAttr("TShape") && nodeDef.getInputCount() == 1) {
            this.shape = new int[0];
            return;
        }
        if (nodeDef.getInputCount() > 1) {
            String shapeNode = nodeDef.getInput(1);
            NodeDef shapeNodeInGraph = null;
            for (int i = 0; i < graph.getNodeCount(); ++i) {
                if (!graph.getNode(i).getName().equals(shapeNode)) continue;
                shapeNodeInGraph = graph.getNode(i);
            }
            INDArray arr = TFGraphMapper.getInstance().getNDArrayFromTensor("value", shapeNodeInGraph, graph);
            if (arr != null) {
                this.shape = arr.data().asInt();
                this.addIArgument(99);
                if (!ArrayUtil.containsAnyNegative((int[])this.shape)) {
                    this.addIArgument(this.shape);
                } else {
                    this.arrName = nodeDef.getName();
                }
            }
        } else {
            AttrValue shape = nodeDef.getAttrOrThrow("Tshape");
            if (!shape.hasShape()) {
                int[] shapeRet = new int[]{1, shape.getValueCase().getNumber()};
                this.shape = shapeRet;
            } else {
                List<TensorShapeProto.Dim> shapeVals = shape.getShape().getDimList();
                if (shapeVals.size() > 1) {
                    this.shape = new int[shapeVals.size()];
                    for (int i = 0; i < shapeVals.size(); ++i) {
                        this.shape[i] = (int)shapeVals.get(i).getSize();
                    }
                } else {
                    this.shape = new int[2];
                    this.shape[0] = 1;
                    this.shape[1] = (int)shapeVals.get(0).getSize();
                }
            }
            if (this.shape != null) {
                this.addIArgument(99);
                this.addIArgument(this.shape);
            }
        }
    }

    @Override
    public void resolvePropertiesFromSameDiffBeforeExecution() {
        super.resolvePropertiesFromSameDiffBeforeExecution();
        if (this.arrName != null) {
            SDVariable[] args = this.args();
            int[] firstInputShape = args[0].getShape();
            int[] shapeInput = args[1].getArr().data().asInt();
            for (int i = 0; i < shapeInput.length; ++i) {
                if (shapeInput[i] >= 0) continue;
                shapeInput[i] = firstInputShape[i];
            }
            this.shape = shapeInput;
            this.addIArgument(shapeInput);
        }
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        ret.put("shape", this.shape);
        return ret;
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
        int[] shape = new OnnxGraphMapper().getShape(node);
        this.shape = shape;
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping shapeMapping = PropertyMapping.builder().onnxAttrName("shape").tfInputPosition(-1).propertyNames(new String[]{"shape"}).build();
        map.put("shape", shapeMapping);
        ret.put(this.tensorflowName(), map);
        ret.put(this.onnxName(), map);
        return ret;
    }

    @Override
    public List<int[]> calculateOutputShape() {
        return Arrays.asList(new int[][]{this.shape});
    }

    @Override
    public String opName() {
        return "reshape";
    }

    @Override
    public String onnxName() {
        return "Reshape";
    }

    @Override
    public String tensorflowName() {
        return "Reshape";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        int[] origShape = this.arg().getShape();
        if (origShape == null) {
            throw new ND4JIllegalStateException("Cannot reshape: original array input shape is null");
        }
        SDVariable ret = this.f().reshape(i_v.get(0), origShape);
        return Arrays.asList(ret);
    }
}

