/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.UpsamplingDerivative;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Upsampling
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Upsampling.class);
    protected int scaleFactor;

    public Upsampling(SameDiff sameDiff, SDVariable[] inputs, INDArray[] inputArrays, INDArray[] outputs, boolean inPlace, int scaleFactor) {
        super(null, sameDiff, inputs, inPlace);
        this.scaleFactor = scaleFactor;
        if (inputArrays != null) {
            this.addInputArgument(inputArrays);
        }
        if (outputs != null) {
            this.addOutputArgument(outputs);
        }
        this.addIArgument(scaleFactor);
    }

    public Upsampling() {
    }

    @Override
    public String opName() {
        return "upsampling2d";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow op opName found for " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>();
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>();
        inputs.addAll(Arrays.asList(this.args()));
        inputs.add(f1.get(0));
        UpsamplingDerivative conv2DDerivative = UpsamplingDerivative.derivativeBuilder().scaleFactor(this.scaleFactor).inputs(inputs.toArray(new SDVariable[inputs.size()])).build();
        ret.addAll(Arrays.asList(conv2DDerivative.outputVariables()));
        return ret;
    }

    public static UpsamplingBuilder sameDiffBuilder() {
        return new UpsamplingBuilder();
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public static class UpsamplingBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputs;
        private INDArray[] inputArrays;
        private INDArray[] outputs;
        private boolean inPlace;
        private int scaleFactor;

        UpsamplingBuilder() {
        }

        public UpsamplingBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public UpsamplingBuilder inputs(SDVariable[] inputs) {
            this.inputs = inputs;
            return this;
        }

        public UpsamplingBuilder inputArrays(INDArray[] inputArrays) {
            this.inputArrays = inputArrays;
            return this;
        }

        public UpsamplingBuilder outputs(INDArray[] outputs) {
            this.outputs = outputs;
            return this;
        }

        public UpsamplingBuilder inPlace(boolean inPlace) {
            this.inPlace = inPlace;
            return this;
        }

        public UpsamplingBuilder scaleFactor(int scaleFactor) {
            this.scaleFactor = scaleFactor;
            return this;
        }

        public Upsampling build() {
            return new Upsampling(this.sameDiff, this.inputs, this.inputArrays, this.outputs, this.inPlace, this.scaleFactor);
        }

        public String toString() {
            return "Upsampling.UpsamplingBuilder(sameDiff=" + this.sameDiff + ", inputs=" + Arrays.deepToString(this.inputs) + ", inputArrays=" + Arrays.deepToString(this.inputArrays) + ", outputs=" + Arrays.deepToString(this.outputs) + ", inPlace=" + this.inPlace + ", scaleFactor=" + this.scaleFactor + ")";
        }
    }
}

