/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import onnx.OnnxProto3;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.shape.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public abstract class BaseBroadcastOp
extends BaseOp
implements BroadcastOp {
    private static final Logger log = LoggerFactory.getLogger(BaseBroadcastOp.class);
    protected int[] dimension;

    public BaseBroadcastOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, int[] dimension) {
        this(sameDiff, i_v1, i_v2, false, dimension);
    }

    public BaseBroadcastOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, boolean inPlace, int[] dimension) {
        super(sameDiff, inPlace, new Object[]{i_v2});
        if (i_v1 != null && i_v2 != null) {
            this.f().validateDifferentialFunctionsameDiff(i_v1);
            this.f().validateDifferentialFunctionsameDiff(i_v2);
            this.sameDiff = sameDiff;
            this.inPlace = inPlace;
            this.dimension = dimension;
            if (Shape.isPlaceholderShape(i_v1.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v1.getVarName());
            }
            if (Shape.isPlaceholderShape(i_v2.getShape())) {
                sameDiff.addPropertyToResolve(this, i_v2.getVarName());
            }
        } else {
            throw new IllegalArgumentException("Input not null variables.");
        }
        sameDiff.addArgsFor(new SDVariable[]{i_v1, i_v2}, (DifferentialFunction)this);
    }

    public BaseBroadcastOp(SameDiff sameDiff) {
        this.sameDiff = sameDiff;
    }

    public BaseBroadcastOp(SameDiff sameDiff, SDVariable i_v1, SDVariable i_v2, int[] dimension, Object[] extraArgs) {
        super(sameDiff, extraArgs);
        this.dimension = dimension;
        if (i_v1 == null || i_v2 == null) {
            throw new IllegalArgumentException("Input not null variables.");
        }
        this.f().validateDifferentialFunctionsameDiff(i_v1);
        this.f().validateDifferentialFunctionsameDiff(i_v2);
        this.sameDiff = sameDiff;
        sameDiff.addArgsFor(new SDVariable[]{i_v1, i_v2}, (DifferentialFunction)this);
    }

    public BaseBroadcastOp(SameDiff sameDiff, SDVariable i_v, int[] dimension, boolean inPlace) {
        this(sameDiff, i_v, i_v.getShape(), inPlace, dimension, null);
    }

    public BaseBroadcastOp(SameDiff sameDiff, SDVariable i_v, int[] shape, boolean inPlace, int[] dimension, Object[] extraArgs) {
        super(sameDiff, inPlace, extraArgs);
        this.dimension = dimension;
        if (i_v == null) {
            throw new IllegalArgumentException("Input not null variable.");
        }
        this.f().validateDifferentialFunctionsameDiff(i_v);
        sameDiff.addArgsFor(new SDVariable[]{i_v}, (DifferentialFunction)this);
    }

    public BaseBroadcastOp(SameDiff sameDiff, SDVariable i_v, int[] dimension, Object[] extraArgs) {
        this(sameDiff, i_v, i_v.getShape(), false, dimension, extraArgs);
    }

    public BaseBroadcastOp(INDArray x, INDArray y, INDArray z, int ... dimension) {
        super(x, y, z, x.lengthLong());
        this.dimension = dimension;
        for (int i = 0; i < dimension.length; ++i) {
            if (dimension[i] >= 0) continue;
            int n = i;
            dimension[n] = dimension[n] + x.rank();
        }
    }

    @Override
    public Op.Type opType() {
        return Op.Type.BROADCAST;
    }

    @Override
    public List<int[]> calculateOutputShape() {
        ArrayList<int[]> ret = new ArrayList<int[]>();
        if (this.larg().getShape() != null && this.rarg().getShape() != null) {
            ret.add(Shape.broadcastOutputShape(this.larg().getShape(), this.rarg().getShape()));
        } else if (this.larg().getShape() != null) {
            ret.add(this.larg().getShape());
        }
        return ret;
    }

    @Override
    public int[] getDimension() {
        if (this.dimension == null) {
            this.dimension = Shape.getBroadcastDimensions(this.larg().getShape(), this.rarg().getShape());
        }
        return this.dimension;
    }

    @Override
    public void setDimension(int ... dimension) {
        this.dimension = dimension;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
    }

    @Override
    public void initFromOnnx(OnnxProto3.NodeProto node, SameDiff initWith, Map<String, OnnxProto3.AttributeProto> attributesForNode, OnnxProto3.GraphProto graph) {
    }

    public BaseBroadcastOp() {
    }
}

