/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.complex;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.blas.BlasBufferUtil;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.complex.IComplexDouble;
import org.nd4j.linalg.api.complex.IComplexNDArray;
import org.nd4j.linalg.api.complex.IComplexNumber;
import org.nd4j.linalg.api.ndarray.BaseNDArray;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.conditions.Condition;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.linalg.util.LinAlgExceptions;

public abstract class BaseComplexNDArray
extends BaseNDArray
implements IComplexNDArray {
    public BaseComplexNDArray() {
    }

    public BaseComplexNDArray(DataBuffer data, int[] shape, int[] stride) {
        this(data, shape, stride, 0L, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(float[] data) {
        super(data);
    }

    public BaseComplexNDArray(DataBuffer buffer, int[] shape, int[] stride, long offset, char ordering) {
        super(buffer, shape, stride, offset, ordering);
    }

    public BaseComplexNDArray(float[] data, int[] shape, char ordering) {
        this(data, shape, Nd4j.getComplexStrides(shape, ordering), 0L, Character.valueOf(ordering));
    }

    public BaseComplexNDArray(int[] shape, long offset, char ordering) {
        this(Nd4j.createBuffer(ArrayUtil.prodLong((int[])shape) * 2L), shape, Nd4j.getComplexStrides(shape, ordering), offset, ordering);
    }

    public BaseComplexNDArray(int[] shape) {
        this(Nd4j.createBuffer(ArrayUtil.prodLong((int[])shape) * 2L), shape, Nd4j.getComplexStrides(shape));
    }

    public BaseComplexNDArray(float[] data, int[] shape, int[] stride, char ordering) {
        this(data, shape, stride, 0L, Character.valueOf(ordering));
    }

    public BaseComplexNDArray(int[] shape, char ordering) {
        this(Nd4j.createBuffer(ArrayUtil.prodLong((int[])shape) * 2L), shape, Nd4j.getComplexStrides(shape, ordering), 0L, ordering);
    }

    public BaseComplexNDArray(INDArray m, int[] stride, char ordering) {
        this(m.shape(), stride, ordering);
        this.copyFromReal(m);
    }

    public BaseComplexNDArray(INDArray m, char ordering) {
        this(m.shape(), ordering);
        this.copyFromReal(m);
    }

    public BaseComplexNDArray(INDArray m) {
        this(m, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(INDArray m, int[] stride) {
        this(m, stride, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(List<IComplexNDArray> slices, int[] shape, int[] stride) {
        this(slices, shape, stride, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(List<IComplexNDArray> slices, int[] shape, int[] stride, char ordering) {
        this(new float[ArrayUtil.prod((int[])shape) * 2]);
        ArrayList<IComplexNumber> list = new ArrayList<IComplexNumber>();
        for (int i = 0; i < slices.size(); ++i) {
            IComplexNDArray flattened = slices.get(i).ravel();
            for (int j = 0; j < flattened.length(); ++j) {
                list.add(flattened.getComplex(j));
            }
        }
        throw new UnsupportedOperationException();
    }

    public BaseComplexNDArray(List<IComplexNDArray> slices, int[] shape, char ordering) {
        this(slices, shape, Nd4j.getComplexStrides(shape, ordering), ordering);
    }

    public BaseComplexNDArray(float[] data, int[] shape, int[] stride, long offset, Character order) {
        this.data = Nd4j.createBuffer(data);
        throw new UnsupportedOperationException();
    }

    public BaseComplexNDArray(DataBuffer data) {
        super(data);
    }

    public BaseComplexNDArray(DataBuffer data, int[] shape, int[] stride, long offset) {
        this.data = data;
        throw new UnsupportedOperationException();
    }

    public BaseComplexNDArray(IComplexNumber[] data, int[] shape, int[] stride, long offset, char ordering) {
        this(shape, stride, offset, ordering);
        assert (data.length <= this.length());
        for (int i = 0; i < data.length; ++i) {
            this.putScalar(i, data[i]);
        }
    }

    public BaseComplexNDArray(DataBuffer data, int[] shape) {
        this(shape);
        this.data = data;
    }

    public BaseComplexNDArray(IComplexNumber[] data, int[] shape, int[] stride, long offset) {
        this(data, shape, stride, offset, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(IComplexNumber[] data, int[] shape, long offset, char ordering) {
        this(data, shape, Nd4j.getComplexStrides(shape), offset, ordering);
    }

    public BaseComplexNDArray(DataBuffer buffer, int[] shape, long offset, char ordering) {
        this(buffer, shape, Nd4j.getComplexStrides(shape), offset, ordering);
    }

    public BaseComplexNDArray(DataBuffer buffer, int[] shape, long offset) {
        this(buffer, shape, Nd4j.getComplexStrides(shape), offset, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(float[] data, Character order) {
        this(data, new int[]{1, data.length / 2}, order.charValue());
    }

    public BaseComplexNDArray(List<IComplexNDArray> slices, int[] shape) {
        this(slices, shape, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(IComplexNumber[] newData, int[] shape) {
        super(new float[ArrayUtil.prod((int[])shape) * 2]);
        throw new UnsupportedOperationException();
    }

    public BaseComplexNDArray(IComplexNumber[] newData, int[] shape, int[] stride) {
        super(new float[ArrayUtil.prod((int[])shape) * 2]);
        throw new UnsupportedOperationException();
    }

    public BaseComplexNDArray(IComplexNumber[] newData, int[] shape, char ordering) {
        super(new float[ArrayUtil.prod((int[])shape) * 2]);
        throw new UnsupportedOperationException();
    }

    public BaseComplexNDArray(float[] data, int[] shape, int[] stride) {
        this(data, shape, stride, 0L, Nd4j.order());
    }

    public BaseComplexNDArray(float[] data, int[] shape) {
        this(data, shape, 0L);
    }

    public BaseComplexNDArray(float[] data, int[] shape, long offset, char ordering) {
        this(data, shape, ordering == 'c' ? ArrayUtil.calcStrides((int[])shape, (int)2) : ArrayUtil.calcStridesFortran((int[])shape, (int)2), offset, Character.valueOf(ordering));
    }

    public BaseComplexNDArray(float[] data, int[] shape, long offset) {
        this(data, shape, offset, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(int[] shape, int[] stride, long offset) {
        this(new float[ArrayUtil.prod((int[])shape) * 2], shape, stride, offset);
    }

    public BaseComplexNDArray(int[] shape, int[] stride, long offset, char ordering) {
        this(new float[ArrayUtil.prod((int[])shape) * 2], shape, stride, offset);
        this.shapeInformation = Shape.createShapeInformation(shape, stride, offset, stride[stride.length - 1], ordering);
    }

    public BaseComplexNDArray(int[] shape, int[] stride, char ordering) {
        this(shape, stride, 0L, ordering);
    }

    public BaseComplexNDArray(int[] shape, int[] stride) {
        this(shape, stride, 0L);
    }

    public BaseComplexNDArray(int[] shape, long offset) {
        this(shape, offset, Nd4j.order().charValue());
    }

    public BaseComplexNDArray(int newRows, int newColumns) {
        this(new int[]{newRows, newColumns});
    }

    public BaseComplexNDArray(int newRows, int newColumns, char ordering) {
        this(new int[]{newRows, newColumns}, ordering);
    }

    public BaseComplexNDArray(float[] data, int[] shape, int[] stride, long offset) {
        this(data, shape, stride, offset, Nd4j.order());
    }

    protected void copyFromReal(INDArray real) {
        if (!Shape.shapeEquals(this.shape(), real.shape())) {
            throw new IllegalStateException("Unable to copy array. Not the same shape");
        }
        INDArray linear = real.linearView();
        IComplexNDArray thisLinear = this.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            thisLinear.putScalar(i, Nd4j.createComplexNumber(linear.getDouble(i), 0.0));
        }
    }

    @Override
    protected IComplexNDArray create(DataBuffer data, int[] shape, int[] strides) {
        return Nd4j.createComplex(data, shape, strides, this.offset(), this.ordering());
    }

    protected void copyRealTo(INDArray arr) {
        INDArray linear = arr.linearView();
        IComplexNDArray thisLinear = this.linearView();
        if (arr.isScalar()) {
            arr.putScalar(0, this.getReal(0));
        } else {
            for (int i = 0; i < linear.length(); ++i) {
                arr.putScalar(i, thisLinear.getReal(i));
            }
        }
    }

    protected void copyImagTo(INDArray arr) {
        INDArray linear = arr.linearView();
        IComplexNDArray thisLinear = this.linearView();
        if (arr.isScalar()) {
            arr.putScalar(0, this.getReal(0));
        } else {
            for (int i = 0; i < linear.length(); ++i) {
                arr.putScalar(i, thisLinear.getImag(i));
            }
        }
    }

    @Override
    public int blasOffset() {
        return (int)this.offset();
    }

    @Override
    public IComplexNDArray linearViewColumnOrder() {
        if (this.length() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Length can not be >= Integer.MAX_VALUE");
        }
        return Nd4j.createComplex(this.data, new int[]{this.length(), 1}, this.offset());
    }

    @Override
    public IComplexNDArray linearView() {
        if (this.isVector() || this.isScalar() || this.length() == 1 || this.length() == this.size(0)) {
            return this;
        }
        return this;
    }

    @Override
    public void resetLinearView() {
    }

    @Override
    public IComplexNumber getComplex(int i, IComplexNumber result) {
        if (!this.isVector() || i >= this.length()) {
            throw new IllegalArgumentException("Given index >= length " + this.length());
        }
        IComplexNumber d = this.getComplex(i);
        return result.set(d.realComponent(), d.imaginaryComponent());
    }

    @Override
    public IComplexNumber getComplex(int i, int j, IComplexNumber result) {
        IComplexNumber d = this.getComplex(i, j);
        return result.set(d.realComponent(), d.imaginaryComponent());
    }

    @Override
    public IComplexNDArray putScalar(int j, int i, IComplexNumber conji) {
        return this.putScalar(new int[]{j, i}, conji);
    }

    @Override
    public IComplexNDArray eps(Number other) {
        return this.dup().epsi(other);
    }

    @Override
    public IComplexNDArray eps(IComplexNumber other) {
        return this.dup().epsi(other);
    }

    @Override
    public IComplexNDArray epsi(IComplexNumber other) {
        IComplexNDArray linear = this.linearView();
        double otherVal = other.realComponent().doubleValue();
        for (int i = 0; i < this.linearView().length(); ++i) {
            IComplexNumber n = linear.getComplex(i);
            double real = n.realComponent().doubleValue();
            double diff = Math.abs(real - otherVal);
            if (diff <= Nd4j.EPS_THRESHOLD) {
                linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(1.0, 0.0));
                continue;
            }
            linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(0.0, 0.0));
        }
        return this;
    }

    @Override
    public IComplexNDArray epsi(Number other) {
        IComplexNDArray linear = this.linearView();
        double otherVal = other.doubleValue();
        for (int i = 0; i < this.linearView().length(); ++i) {
            IComplexNumber n = linear.getComplex(i);
            double real = n.realComponent().doubleValue();
            double diff = Math.abs(real - otherVal);
            if (diff <= Nd4j.EPS_THRESHOLD) {
                linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(1.0, 0.0));
                continue;
            }
            linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(0.0, 0.0));
        }
        return this;
    }

    @Override
    public IComplexNDArray eps(INDArray other) {
        return this.dup().epsi(other);
    }

    @Override
    public IComplexNDArray epsi(INDArray other) {
        IComplexNDArray linear = this.linearView();
        if (other instanceof IComplexNDArray) {
            IComplexNDArray otherComplex = (IComplexNDArray)other;
            IComplexNDArray otherComplexLinear = otherComplex.linearView();
            for (int i = 0; i < this.linearView().length(); ++i) {
                double otherAbs;
                IComplexNumber n = linear.getComplex(i);
                IComplexNumber otherComplexNumber = otherComplexLinear.getComplex(i);
                double real = n.absoluteValue().doubleValue();
                double diff = Math.abs(real - (otherAbs = otherComplexNumber.absoluteValue().doubleValue()));
                if (diff <= Nd4j.EPS_THRESHOLD) {
                    linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(1.0, 0.0));
                    continue;
                }
                linear.putScalar(i, (IComplexNumber)Nd4j.createDouble(0.0, 0.0));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray lt(Number other) {
        return this.dup().lti(other);
    }

    @Override
    public IComplexNDArray lti(Number other) {
        IComplexNDArray linear = this.linearView();
        double val = other.doubleValue();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() < val ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
        }
        return this;
    }

    @Override
    public IComplexNDArray eq(Number other) {
        return this.dup().eqi(other);
    }

    @Override
    public IComplexNDArray eqi(Number other) {
        IComplexNDArray linear = this.linearView();
        double val = other.doubleValue();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() == val ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
        }
        return this;
    }

    @Override
    public IComplexNDArray gt(Number other) {
        return this.dup().gti(other);
    }

    @Override
    public IComplexNDArray gti(Number other) {
        IComplexNDArray linear = this.linearView();
        double val = other.doubleValue();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() > val ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
        }
        return this;
    }

    @Override
    public IComplexNDArray lt(INDArray other) {
        return this.dup().lti(other);
    }

    @Override
    public IComplexNDArray lti(INDArray other) {
        if (other instanceof IComplexNDArray) {
            IComplexNDArray linear = this.linearView();
            IComplexNDArray otherLinear = (IComplexNDArray)other.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() < otherLinear.getComplex(i).absoluteValue().doubleValue() ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
            }
        } else {
            IComplexNDArray linear = this.linearView();
            INDArray otherLinear = other.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() < otherLinear.getDouble(i) ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray eq(INDArray other) {
        return this.dup().eqi(other);
    }

    @Override
    public IComplexNDArray eqi(INDArray other) {
        if (other instanceof IComplexNDArray) {
            IComplexNDArray linear = this.linearView();
            IComplexNDArray otherLinear = (IComplexNDArray)other.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() == otherLinear.getComplex(i).absoluteValue().doubleValue() ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
            }
        } else {
            IComplexNDArray linear = this.linearView();
            INDArray otherLinear = other.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() == otherLinear.getDouble(i) ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray neq(INDArray other) {
        return this.dup().neqi(other);
    }

    @Override
    public IComplexNDArray neq(Number other) {
        return this.dup().neqi(other);
    }

    @Override
    public IComplexNDArray neqi(Number other) {
        IComplexNDArray linear = this.linearView();
        double otherVal = other.doubleValue();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() != otherVal ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
        }
        return this;
    }

    @Override
    public IComplexNDArray neqi(INDArray other) {
        if (other instanceof IComplexNDArray) {
            IComplexNDArray linear = this.linearView();
            IComplexNDArray otherLinear = (IComplexNDArray)other.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() != otherLinear.getComplex(i).absoluteValue().doubleValue() ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
            }
        } else {
            IComplexNDArray linear = this.linearView();
            INDArray otherLinear = other.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() != otherLinear.getDouble(i) ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray gt(INDArray other) {
        return this.dup().gti(other);
    }

    @Override
    public IComplexNDArray gti(INDArray other) {
        if (other instanceof IComplexNDArray) {
            IComplexNDArray linear = this.linearView();
            IComplexNDArray otherLinear = (IComplexNDArray)other.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() > otherLinear.getComplex(i).absoluteValue().doubleValue() ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
            }
        } else {
            IComplexNDArray linear = this.linearView();
            INDArray otherLinear = other.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, linear.getComplex(i).absoluteValue().doubleValue() > otherLinear.getDouble(i) ? Nd4j.createComplexNumber(1, 0) : Nd4j.createComplexNumber(0, 0));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray rdiv(Number n, INDArray result) {
        return this.dup().rdivi(n, result);
    }

    @Override
    public IComplexNDArray rdivi(Number n, INDArray result) {
        return this.rdivi((IComplexNumber)Nd4j.createDouble(n.doubleValue(), 0.0), result);
    }

    @Override
    public IComplexNDArray rsub(Number n, INDArray result) {
        return this.dup().rsubi(n, result);
    }

    @Override
    public IComplexNDArray rsubi(Number n, INDArray result) {
        return this.rsubi((IComplexNumber)Nd4j.createDouble(n.doubleValue(), 0.0), result);
    }

    @Override
    public IComplexNDArray div(Number n, INDArray result) {
        return this.dup().divi(n, result);
    }

    @Override
    public IComplexNDArray divi(Number n, INDArray result) {
        return this.divi((IComplexNumber)Nd4j.createDouble(n.doubleValue(), 0.0), result);
    }

    @Override
    public IComplexNDArray mul(Number n, INDArray result) {
        return this.dup().muli(n, result);
    }

    @Override
    public IComplexNDArray muli(Number n, INDArray result) {
        return this.muli((IComplexNumber)Nd4j.createDouble(n.doubleValue(), 0.0), result);
    }

    @Override
    public IComplexNDArray sub(Number n, INDArray result) {
        return this.dup().subi(n, result);
    }

    @Override
    public IComplexNDArray subi(Number n, INDArray result) {
        return this.subi((IComplexNumber)Nd4j.createDouble(n.doubleValue(), 0.0), result);
    }

    @Override
    public IComplexNDArray add(Number n, INDArray result) {
        return this.dup().addi(n, result);
    }

    @Override
    public IComplexNDArray addi(Number n, INDArray result) {
        return this.addi((IComplexNumber)Nd4j.createDouble(n.doubleValue(), 0.0), result);
    }

    @Override
    public IComplexNDArray dup() {
        return (IComplexNDArray)Shape.toOffsetZeroCopy(this);
    }

    @Override
    public IComplexNDArray rsubRowVector(INDArray rowVector) {
        return this.dup().rsubiRowVector(rowVector);
    }

    @Override
    public IComplexNDArray rsubiRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 't');
    }

    @Override
    public IComplexNDArray rsubColumnVector(INDArray columnVector) {
        return this.dup().rsubiColumnVector(columnVector);
    }

    @Override
    public IComplexNDArray rsubiColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 'h');
    }

    @Override
    public IComplexNDArray rdivRowVector(INDArray rowVector) {
        return this.dup().rdiviRowVector(rowVector);
    }

    @Override
    public IComplexNDArray rdiviRowVector(INDArray rowVector) {
        return this.doRowWise(rowVector, 't');
    }

    @Override
    public IComplexNDArray rdivColumnVector(INDArray columnVector) {
        return this.dup().rdiviColumnVector(columnVector);
    }

    @Override
    public IComplexNDArray rdiviColumnVector(INDArray columnVector) {
        return this.doColumnWise(columnVector, 't');
    }

    @Override
    protected IComplexNDArray doRowWise(INDArray rowVector, char operation) {
        return (IComplexNDArray)super.doRowWise(rowVector, operation);
    }

    @Override
    protected IComplexNDArray doColumnWise(INDArray columnVector, char operation) {
        return (IComplexNDArray)super.doColumnWise(columnVector, operation);
    }

    @Override
    public double squaredDistance(INDArray other) {
        double sd = 0.0;
        if (other instanceof IComplexNDArray) {
            IComplexNDArray n = (IComplexNDArray)other;
            IComplexNDArray nLinear = n.linearView();
            for (int i = 0; i < this.length(); ++i) {
                IComplexNumber diff = this.linearView().getComplex(i).sub(nLinear.getComplex(i));
                double d = diff.absoluteValue().doubleValue();
                sd += d * d;
            }
            return sd;
        }
        for (int i = 0; i < this.length(); ++i) {
            INDArray linear = other.linearView();
            IComplexNumber diff = this.linearView().getComplex(i).sub((Number)linear.getDouble(i));
            double d = diff.absoluteValue().doubleValue();
            sd += d * d;
        }
        return sd;
    }

    @Override
    public double distance2(INDArray other) {
        return Math.sqrt(this.squaredDistance(other));
    }

    @Override
    public double distance1(INDArray other) {
        float d = 0.0f;
        if (other instanceof IComplexNDArray) {
            IComplexNDArray n2 = (IComplexNDArray)other;
            IComplexNDArray n2Linear = n2.linearView();
            for (int i = 0; i < this.length(); ++i) {
                IComplexNumber n = this.getComplex(i).sub(n2Linear.getComplex(i));
                d = (float)((double)d + n.absoluteValue().doubleValue());
            }
            return d;
        }
        INDArray linear = other.linearView();
        for (int i = 0; i < this.length(); ++i) {
            IComplexNumber n = this.linearView().getComplex(i).sub((Number)linear.getDouble(i));
            d = (float)((double)d + n.absoluteValue().doubleValue());
        }
        return d;
    }

    @Override
    public IComplexNDArray put(INDArrayIndex[] indices, INDArray element) {
        super.put(indices, element);
        return this;
    }

    @Override
    public IComplexNDArray normmax(int ... dimension) {
        return Nd4j.createComplex(super.normmax(dimension));
    }

    @Override
    public Number normmaxNumber() {
        return this.normmaxComplex().absoluteValue();
    }

    @Override
    public IComplexNumber normmaxComplex() {
        return this.normmax(Integer.MAX_VALUE).getComplex(0);
    }

    @Override
    public IComplexNDArray prod(int ... dimension) {
        return Nd4j.createComplex(super.prod(dimension));
    }

    @Override
    public Number prodNumber() {
        return this.prodComplex().absoluteValue();
    }

    @Override
    public IComplexNumber prodComplex() {
        return this.prod(Integer.MAX_VALUE).getComplex(0);
    }

    @Override
    public IComplexNDArray mean(int ... dimension) {
        return Nd4j.createComplex(super.mean(dimension));
    }

    @Override
    public Number meanNumber() {
        return this.meanComplex().absoluteValue();
    }

    @Override
    public IComplexNumber meanComplex() {
        return this.mean(Integer.MAX_VALUE).getComplex(0);
    }

    @Override
    public IComplexNDArray var(int ... dimension) {
        return Nd4j.createComplex(super.var(dimension));
    }

    @Override
    public Number varNumber() {
        return this.varComplex().absoluteValue();
    }

    @Override
    public IComplexNumber varComplex() {
        return this.var(Integer.MAX_VALUE).getComplex(0);
    }

    @Override
    public IComplexNDArray max(int ... dimension) {
        return Nd4j.createComplex(super.max(dimension));
    }

    @Override
    public Number maxNumber() {
        return this.maxComplex().absoluteValue();
    }

    @Override
    public IComplexNumber maxComplex() {
        return this.max(Integer.MAX_VALUE).getComplex(0);
    }

    @Override
    public IComplexNDArray sum(int ... dimension) {
        return Nd4j.createComplex(super.sum(dimension));
    }

    @Override
    public Number sumNumber() {
        return this.sumComplex().absoluteValue();
    }

    @Override
    public IComplexNumber sumComplex() {
        return this.sum(Integer.MAX_VALUE).getComplex(0);
    }

    @Override
    public IComplexNDArray min(int ... dimension) {
        return Nd4j.createComplex(super.min(dimension));
    }

    @Override
    public Number minNumber() {
        return this.minComplex().absoluteValue();
    }

    @Override
    public IComplexNumber minComplex() {
        return this.min(Integer.MAX_VALUE).getComplex(0);
    }

    @Override
    public IComplexNDArray norm1(int ... dimension) {
        return Nd4j.createComplex(super.norm1(dimension));
    }

    @Override
    public Number norm1Number() {
        return this.norm1Complex().absoluteValue();
    }

    @Override
    public IComplexNumber norm1Complex() {
        return this.norm1(Integer.MAX_VALUE).getComplex(0);
    }

    @Override
    public IComplexNDArray std(int ... dimension) {
        return Nd4j.createComplex(super.std(dimension));
    }

    @Override
    public Number stdNumber() {
        return this.stdComplex().absoluteValue();
    }

    @Override
    public IComplexNumber stdComplex() {
        return this.std(Integer.MAX_VALUE).getComplex(0);
    }

    @Override
    public IComplexNDArray norm2(int ... dimension) {
        return Nd4j.createComplex(super.norm2(dimension));
    }

    @Override
    public Number norm2Number() {
        return this.norm2Complex().absoluteValue();
    }

    @Override
    public IComplexNumber norm2Complex() {
        return this.norm2(Integer.MAX_VALUE).getComplex(0);
    }

    @Override
    public IComplexNDArray put(int i, int j, Number element) {
        return (IComplexNDArray)super.put(i, j, Nd4j.scalar(element));
    }

    @Override
    public IComplexNDArray put(int[] indexes, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNDArray put(int i, int j, IComplexNumber complex) {
        return this.putScalar(new int[]{i, j}, complex);
    }

    @Override
    public IComplexNDArray putSlice(int slice, IComplexNDArray put) {
        if (this.isScalar()) {
            assert (put.isScalar()) : "Invalid dimension. Can only insert a scalar in to another scalar";
            this.put(0, put.getScalar(0));
            return this;
        }
        if (this.isVector()) {
            assert (put.isScalar() || put.isVector() && put.length() == this.length()) : "Invalid dimension on insertion. Can only insert scalars input vectors";
            if (put.isScalar()) {
                this.putScalar(slice, put.getComplex(0));
            } else {
                for (int i = 0; i < this.length(); ++i) {
                    this.putScalar(i, put.getComplex(i));
                }
            }
            return this;
        }
        this.assertSlice(put, slice);
        IComplexNDArray view = this.slice(slice);
        if (put.length() == 1) {
            this.putScalar(slice, put.getComplex(0));
        } else if (put.isVector()) {
            for (int i = 0; i < put.length(); ++i) {
                view.putScalar(i, put.getComplex(i));
            }
        } else {
            assert (Shape.shapeEquals(view.shape(), put.shape()));
            IComplexNDArray linear = view.linearView();
            IComplexNDArray putLinearView = put.linearView();
            for (int i = 0; i < linear.length(); ++i) {
                linear.putScalar(i, putLinearView.getComplex(i));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray swapAxes(int dimension, int with) {
        return (IComplexNDArray)super.swapAxes(dimension, with);
    }

    @Override
    public IComplexNDArray conji() {
        IComplexNDArray reshaped = this.linearView();
        IComplexDouble c = Nd4j.createDouble(0.0, 0.0);
        for (int i = 0; i < this.length(); ++i) {
            IComplexNumber conj = reshaped.getComplex(i, (IComplexNumber)c).conj();
            reshaped.putScalar(i, conj);
        }
        return this;
    }

    @Override
    public IComplexNDArray hermitian() {
        IComplexNDArray result = Nd4j.createComplex(this.shape());
        IComplexDouble c = Nd4j.createDouble(0.0, 0.0);
        for (int i = 0; i < this.slices(); ++i) {
            for (int j = 0; j < this.columns(); ++j) {
                result.putScalar(j, i, this.getComplex(i, j, (IComplexNumber)c).conji());
            }
        }
        return result;
    }

    @Override
    public IComplexNDArray conj() {
        return this.dup().conji();
    }

    @Override
    public INDArray getReal() {
        INDArray result = Nd4j.create(this.shape());
        IComplexNDArray linearView = this.linearView();
        INDArray linearRet = result.linearView();
        for (int i = 0; i < linearView.length(); ++i) {
            linearRet.putScalar(i, linearView.getReal(i));
        }
        return result;
    }

    @Override
    public double getImag(int i) {
        return this.getComplex(i).imaginaryComponent().doubleValue();
    }

    @Override
    public double getReal(int i) {
        return this.getComplex(i).realComponent().doubleValue();
    }

    @Override
    public IComplexNDArray putReal(int rowIndex, int columnIndex, double value) {
        this.data.put((long)(2 * this.index(rowIndex, columnIndex)) + this.offset(), value);
        return this;
    }

    @Override
    public IComplexNDArray putImag(int rowIndex, int columnIndex, double value) {
        this.data.put((long)(this.index(rowIndex, columnIndex) + 1) + this.offset(), value);
        return this;
    }

    @Override
    public IComplexNDArray putReal(int i, float v) {
        super.putScalar(i, v);
        return this;
    }

    @Override
    public IComplexNDArray putImag(int i, float v) {
        return this;
    }

    @Override
    public IComplexNumber getComplex(int i) {
        if (i >= this.length()) {
            throw new IllegalArgumentException("Index " + i + " >= " + this.length());
        }
        int[] dimensions = Shape.ind2sub(this, (long)i);
        return this.getComplex(dimensions);
    }

    @Override
    public IComplexNumber getComplex(int i, int j) {
        return this.getComplex(new int[]{i, j});
    }

    @Override
    public IComplexNumber getComplex(int ... indices) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray real() {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray imag() {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNDArray put(int i, IComplexNDArray element) {
        if (element == null) {
            throw new IllegalArgumentException("Unable to insert null element");
        }
        assert (element.isScalar()) : "Unable to insert non scalar element";
        int idx = this.linearIndex(i);
        IComplexNumber n = element.getComplex(0);
        this.data.put((long)idx, n.realComponent().doubleValue());
        this.data.put((long)(idx + 1), n.imaginaryComponent().doubleValue());
        return this;
    }

    @Override
    public IComplexNDArray getScalar(int ... indexes) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkDimensions(INDArray other) {
    }

    @Override
    public IComplexNDArray putSlice(int slice, INDArray put) {
        return this.putSlice(slice, Nd4j.createComplex(put));
    }

    @Override
    public IComplexNDArray subArray(long[] offsets, int[] shape, int[] stride) {
        return (IComplexNDArray)super.subArray(offsets, shape, stride);
    }

    @Override
    public IComplexNDArray put(int[] indices, INDArray element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNDArray put(int i, int j, INDArray element) {
        return this.put(new int[]{i, j}, element);
    }

    protected IComplexNDArray create(BaseNDArray baseNDArray) {
        return Nd4j.createComplex(baseNDArray);
    }

    @Override
    protected IComplexNDArray createScalar(double d) {
        return Nd4j.createComplex(Nd4j.scalar(d));
    }

    @Override
    protected INDArray createScalarForIndex(int i, boolean applyOffset) {
        return Nd4j.createComplex(this.data(), new int[]{1, 1}, new int[]{1, 1}, applyOffset ? this.offset() + (long)i : (long)i);
    }

    @Override
    public IComplexNDArray slice(int slice) {
        return (IComplexNDArray)super.slice(slice);
    }

    @Override
    public int elementStride() {
        return 2;
    }

    @Override
    protected IComplexNDArray create(int[] shape) {
        return Nd4j.createComplex(shape, Nd4j.getComplexStrides(shape, this.ordering()), 0L);
    }

    @Override
    protected IComplexNDArray create(int[] shape, int[] strides, long offset) {
        return Nd4j.createComplex(shape, strides, offset);
    }

    @Override
    protected int[] getStrides(int[] shape, char ordering) {
        return Nd4j.getComplexStrides(shape, ordering);
    }

    @Override
    protected IComplexNDArray create(DataBuffer data, int[] newShape, int[] newStrides, long offset, char ordering) {
        return Nd4j.createComplex(data, newShape, newStrides, offset, ordering);
    }

    @Override
    public IComplexNDArray slice(int slice, int dimension) {
        return (IComplexNDArray)super.slice(slice, dimension);
    }

    @Override
    protected IComplexNDArray newShape(int[] newShape, char ordering) {
        return Nd4j.createComplex(super.newShape(newShape, ordering));
    }

    @Override
    protected IComplexNDArray create(DataBuffer data, int[] newShape, int[] newStrides, long offset) {
        return Nd4j.createComplex(data, newShape, newStrides, offset);
    }

    @Override
    public IComplexNDArray repmat(int[] shape) {
        return (IComplexNDArray)super.repmat(shape);
    }

    @Override
    public IComplexNDArray assign(IComplexNDArray arr) {
        if (!arr.isScalar()) {
            LinAlgExceptions.assertSameLength(this, arr);
        }
        IComplexNDArray linear = this.linearView();
        IComplexNDArray otherLinear = arr.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, otherLinear.getComplex(i));
        }
        return this;
    }

    @Override
    public void assign(IComplexNumber aDouble) {
        IComplexNDArray linear = this.linearView();
        for (int i = 0; i < linear.length(); ++i) {
            linear.putScalar(i, aDouble);
        }
    }

    @Override
    public IComplexNDArray getRows(int[] rindices) {
        INDArray rows = Nd4j.create(rindices.length, this.columns());
        for (int i = 0; i < rindices.length; ++i) {
            rows.putRow(i, this.getRow(rindices[i]));
        }
        return (IComplexNDArray)rows;
    }

    @Override
    public IComplexNDArray put(INDArrayIndex[] indices, IComplexNumber element) {
        return this.put(indices, Nd4j.scalar(element));
    }

    @Override
    public IComplexNDArray put(INDArrayIndex[] indices, IComplexNDArray element) {
        super.put(indices, (INDArray)element);
        return this;
    }

    @Override
    protected INDArray create(int[] shape, char ordering) {
        return Nd4j.createComplex(shape, ordering);
    }

    @Override
    public IComplexNDArray put(INDArrayIndex[] indices, Number element) {
        return this.put(indices, Nd4j.scalar(element));
    }

    @Override
    public IComplexNDArray putScalar(int i, IComplexNumber value) {
        int[] dimensions = Shape.ind2sub(this, (long)i);
        return this.putScalar(dimensions, value);
    }

    @Override
    protected IComplexNDArray create(DataBuffer buffer) {
        return Nd4j.createComplex(buffer, new int[]{1, (int)buffer.length()});
    }

    @Override
    protected IComplexNDArray create(int rows, int length) {
        return this.create(new int[]{rows, this.length()});
    }

    @Override
    protected IComplexNDArray create(DataBuffer data, int[] shape, long offset) {
        return Nd4j.createComplex(data, shape, offset);
    }

    protected IComplexNDArray create(INDArray baseNDArray) {
        return Nd4j.createComplex(baseNDArray);
    }

    @Override
    public IComplexNDArray vectorAlongDimension(int index, int dimension) {
        return (IComplexNDArray)super.vectorAlongDimension(index, dimension);
    }

    @Override
    public IComplexNDArray cumsumi(int dimension) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNDArray dimShuffle(Object[] rearrange, int[] newOrder, boolean[] broadCastable) {
        return (IComplexNDArray)super.dimShuffle(rearrange, newOrder, broadCastable);
    }

    @Override
    public IComplexNDArray cumsum(int dimension) {
        return this.dup().cumsumi(dimension);
    }

    @Override
    public INDArray assign(INDArray arr) {
        return this.assign((IComplexNDArray)arr);
    }

    @Override
    public IComplexNDArray putScalar(int i, double value) {
        return this.put(i, Nd4j.scalar(value));
    }

    @Override
    public INDArray putScalar(int[] i, double value) {
        super.putScalar(i, value);
        return this.putScalar(i, Nd4j.createComplexNumber(value, 0));
    }

    @Override
    public IComplexNDArray putScalar(int[] indexes, IComplexNumber complexNumber) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNDArray neg() {
        return this.dup().negi();
    }

    @Override
    public IComplexNDArray negi() {
        return (IComplexNDArray)Transforms.neg(this);
    }

    @Override
    public IComplexNDArray rdiv(Number n) {
        return this.rdiv(n, (INDArray)this);
    }

    @Override
    public IComplexNDArray rdivi(Number n) {
        return this.rdivi(n, (INDArray)this);
    }

    @Override
    public IComplexNDArray rsub(Number n) {
        return this.rsub(n, (INDArray)this);
    }

    @Override
    public IComplexNDArray rsubi(Number n) {
        return this.rsubi(n, (INDArray)this);
    }

    @Override
    public IComplexNDArray div(Number n) {
        return this.dup().divi(n);
    }

    @Override
    public IComplexNDArray divi(Number n) {
        return this.divi(Nd4j.complexScalar(n));
    }

    @Override
    public IComplexNDArray mul(Number n) {
        return this.dup().muli(n);
    }

    @Override
    public IComplexNDArray muli(Number n) {
        return this.muli(Nd4j.complexScalar(n));
    }

    @Override
    public IComplexNDArray sub(Number n) {
        return this.dup().subi(n);
    }

    @Override
    public IComplexNDArray subi(Number n) {
        return this.subi(Nd4j.complexScalar(n));
    }

    @Override
    public IComplexNDArray add(Number n) {
        return this.dup().addi(n);
    }

    @Override
    public IComplexNDArray addi(Number n) {
        return this.addi(Nd4j.complexScalar(n));
    }

    @Override
    public IComplexNDArray get(INDArrayIndex ... indexes) {
        return (IComplexNDArray)super.get(indexes);
    }

    @Override
    public IComplexNDArray cond(Condition condition) {
        return this.dup().condi(condition);
    }

    @Override
    public IComplexNDArray condi(Condition condition) {
        IComplexNDArray linear = this.linearView();
        for (int i = 0; i < this.length(); ++i) {
            boolean met = condition.apply(linear.getComplex(i));
            IComplexNumber put = Nd4j.createComplexNumber(met ? 1 : 0, 0);
            linear.putScalar(i, put);
        }
        return this;
    }

    @Override
    public IComplexNDArray getColumns(int[] cindices) {
        return (IComplexNDArray)super.getColumns(cindices);
    }

    @Override
    public IComplexNDArray putRow(int row, INDArray toPut) {
        return (IComplexNDArray)super.putRow(row, toPut);
    }

    @Override
    public IComplexNDArray putColumn(int column, INDArray toPut) {
        assert (toPut.isVector() && toPut.length() == this.rows()) : "Illegal length for row " + toPut.length() + " should have been " + this.columns();
        IComplexNDArray r = this.getColumn(column);
        if (toPut instanceof IComplexNDArray) {
            IComplexNDArray putComplex = (IComplexNDArray)toPut;
            for (int i = 0; i < r.length(); ++i) {
                IComplexNumber n = putComplex.getComplex(i);
                r.putScalar(i, n);
            }
        } else {
            for (int i = 0; i < r.length(); ++i) {
                r.putScalar(i, (IComplexNumber)Nd4j.createDouble(toPut.getDouble(i), 0.0));
            }
        }
        return this;
    }

    @Override
    public IComplexNDArray getScalar(int row, int column) {
        return this.getScalar(new int[]{row, column});
    }

    @Override
    public IComplexNDArray getScalar(int i) {
        return Nd4j.scalar(this.getComplex(i));
    }

    @Override
    public IComplexNDArray put(int i, INDArray element) {
        if (element == null) {
            throw new IllegalArgumentException("Unable to insert null element");
        }
        assert (element.isScalar()) : "Unable to insert non scalar element";
        if (element instanceof IComplexNDArray) {
            IComplexNDArray n1 = (IComplexNDArray)element;
            IComplexNumber n = n1.getComplex(0);
            this.put(i, n);
        } else {
            this.putScalar(i, (IComplexNumber)Nd4j.createDouble(element.getDouble(0), 0.0));
        }
        return this;
    }

    public void put(int i, IComplexNumber element) {
        int idx = this.linearIndex(i);
        this.data.put((long)idx, element.realComponent().doubleValue());
        this.data.put((long)(idx + 1), element.imaginaryComponent().doubleValue());
    }

    @Override
    public IComplexNDArray diviColumnVector(INDArray columnVector) {
        for (int i = 0; i < this.columns(); ++i) {
            this.getColumn(i).divi(columnVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray divColumnVector(INDArray columnVector) {
        return this.dup().diviColumnVector(columnVector);
    }

    @Override
    public IComplexNDArray diviRowVector(INDArray rowVector) {
        for (int i = 0; i < this.rows(); ++i) {
            this.getRow(i).divi(rowVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray divRowVector(INDArray rowVector) {
        return this.dup().diviRowVector(rowVector);
    }

    @Override
    public IComplexNDArray muliColumnVector(INDArray columnVector) {
        for (int i = 0; i < this.columns(); ++i) {
            this.getColumn(i).muli(columnVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray mulColumnVector(INDArray columnVector) {
        return this.dup().muliColumnVector(columnVector);
    }

    @Override
    public IComplexNDArray muliRowVector(INDArray rowVector) {
        for (int i = 0; i < this.rows(); ++i) {
            this.getRow(i).muli(rowVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray mulRowVector(INDArray rowVector) {
        return this.dup().muliRowVector(rowVector);
    }

    @Override
    public IComplexNDArray subiColumnVector(INDArray columnVector) {
        for (int i = 0; i < this.columns(); ++i) {
            this.getColumn(i).subi(columnVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray subColumnVector(INDArray columnVector) {
        return this.dup().subiColumnVector(columnVector);
    }

    @Override
    public IComplexNDArray subiRowVector(INDArray rowVector) {
        for (int i = 0; i < this.rows(); ++i) {
            this.getRow(i).subi(rowVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray subRowVector(INDArray rowVector) {
        return this.dup().subiRowVector(rowVector);
    }

    @Override
    public IComplexNDArray addiColumnVector(INDArray columnVector) {
        for (int i = 0; i < this.columns(); ++i) {
            this.getColumn(i).addi(columnVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray addColumnVector(INDArray columnVector) {
        return this.dup().addiColumnVector(columnVector);
    }

    @Override
    public IComplexNDArray addiRowVector(INDArray rowVector) {
        for (int i = 0; i < this.rows(); ++i) {
            this.getRow(i).addi(rowVector.getScalar(i));
        }
        return this;
    }

    @Override
    public IComplexNDArray addRowVector(INDArray rowVector) {
        return this.dup().addiRowVector(rowVector);
    }

    @Override
    public IComplexNDArray mmul(INDArray other) {
        return (IComplexNDArray)super.mmul(other);
    }

    @Override
    public IComplexNDArray mmul(INDArray other, INDArray result) {
        return this.dup().mmuli(other, result);
    }

    @Override
    public IComplexNDArray div(INDArray other) {
        return this.dup().divi(other);
    }

    @Override
    public IComplexNDArray div(INDArray other, INDArray result) {
        return this.dup().divi(other, result);
    }

    @Override
    public IComplexNDArray mul(INDArray other) {
        return this.dup().muli(other);
    }

    @Override
    public IComplexNDArray mul(INDArray other, INDArray result) {
        return this.dup().muli(other, result);
    }

    @Override
    public IComplexNDArray sub(INDArray other) {
        return this.dup().subi(other);
    }

    @Override
    public IComplexNDArray sub(INDArray other, INDArray result) {
        return this.dup().subi(other, result);
    }

    @Override
    public IComplexNDArray add(INDArray other) {
        return this.dup().addi(other);
    }

    @Override
    public IComplexNDArray add(INDArray other, INDArray result) {
        return this.dup().addi(other, result);
    }

    @Override
    public IComplexNDArray mmuli(INDArray other) {
        return this.mmuli(other, this);
    }

    @Override
    public IComplexNDArray mmuli(INDArray other, INDArray result) {
        IComplexNDArray otherArray = (IComplexNDArray)other;
        IComplexNDArray resultArray = (IComplexNDArray)result;
        if (other.shape().length > 2) {
            for (int i = 0; i < other.slices(); ++i) {
                resultArray.putSlice(i, this.slice(i).mmul(otherArray.slice(i)));
            }
            return resultArray;
        }
        LinAlgExceptions.assertMultiplies(this, other);
        if (other.isScalar()) {
            return this.muli(otherArray.getComplex(0), resultArray);
        }
        if (this.isScalar()) {
            return otherArray.muli(this.getComplex(0), resultArray);
        }
        if (result == this || result == other) {
            IComplexNDArray temp = Nd4j.createComplex(resultArray.shape());
            if (otherArray.columns() == 1) {
                Nd4j.getBlasWrapper().level2().gemv(BlasBufferUtil.getCharForTranspose(temp), BlasBufferUtil.getCharForTranspose(this), Nd4j.UNIT, this, otherArray, Nd4j.ZERO, temp);
            } else {
                Nd4j.getBlasWrapper().level3().gemm(BlasBufferUtil.getCharForTranspose(temp), BlasBufferUtil.getCharForTranspose(this), BlasBufferUtil.getCharForTranspose(other), Nd4j.UNIT, this, otherArray, Nd4j.ZERO, temp);
            }
            Nd4j.getBlasWrapper().copy(temp, resultArray);
        } else if (otherArray.columns() == 1) {
            Nd4j.getBlasWrapper().level2().gemv(BlasBufferUtil.getCharForTranspose(resultArray), BlasBufferUtil.getCharForTranspose(this), Nd4j.UNIT, this, otherArray, Nd4j.ZERO, resultArray);
        } else {
            Nd4j.getBlasWrapper().level3().gemm(BlasBufferUtil.getCharForTranspose(resultArray), BlasBufferUtil.getCharForTranspose(this), BlasBufferUtil.getCharForTranspose(other), Nd4j.UNIT, this, otherArray, Nd4j.ZERO, resultArray);
        }
        return resultArray;
    }

    @Override
    public int secondaryStride() {
        return super.secondaryStride() / 2;
    }

    @Override
    public IComplexNDArray divi(INDArray other) {
        return this.divi(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray divi(INDArray other, INDArray result) {
        IComplexNDArray cOther = (IComplexNDArray)other;
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cOtherLinear = cOther.linearView();
        IComplexNDArray cResultLinear = cResult.linearView();
        if (other.isScalar()) {
            return this.divi(cOther.getComplex(0), result);
        }
        IComplexNumber c = Nd4j.createComplexNumber(0, 0);
        IComplexNumber d = Nd4j.createComplexNumber(0, 0);
        for (int i = 0; i < this.length(); ++i) {
            cResultLinear.putScalar(i, linear.getComplex(i, c).divi(cOtherLinear.getComplex(i, d)));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray muli(INDArray other) {
        return this.muli(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray muli(INDArray other, INDArray result) {
        IComplexNDArray cOther = (IComplexNDArray)other;
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cOtherLinear = cOther.linearView();
        IComplexNDArray cResultLinear = cResult.linearView();
        if (other.isScalar()) {
            return this.muli(cOther.getComplex(0), result);
        }
        IComplexNumber c = Nd4j.createComplexNumber(0, 0);
        IComplexNumber d = Nd4j.createComplexNumber(0, 0);
        for (int i = 0; i < this.length(); ++i) {
            cResultLinear.putScalar(i, linear.getComplex(i, c).muli(cOtherLinear.getComplex(i, d)));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray subi(INDArray other) {
        return this.subi(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray subi(INDArray other, INDArray result) {
        IComplexNDArray cOther = (IComplexNDArray)other;
        IComplexNDArray cResult = (IComplexNDArray)result;
        if (other.isScalar()) {
            return this.subi(cOther.getComplex(0), result);
        }
        if (result == this) {
            Nd4j.getBlasWrapper().axpy(Nd4j.NEG_UNIT, cOther, cResult);
        } else if (result == other) {
            if (this.data.dataType() == DataBuffer.Type.DOUBLE) {
                Nd4j.getBlasWrapper().scal(Nd4j.NEG_UNIT.asDouble(), cResult);
                Nd4j.getBlasWrapper().axpy(Nd4j.UNIT, this, cResult);
            } else {
                Nd4j.getBlasWrapper().scal(Nd4j.NEG_UNIT.asFloat(), cResult);
                Nd4j.getBlasWrapper().axpy(Nd4j.UNIT, this, cResult);
            }
        } else {
            Nd4j.getBlasWrapper().copy((INDArray)this, result);
            Nd4j.getBlasWrapper().axpy(Nd4j.NEG_UNIT, cOther, cResult);
        }
        return cResult;
    }

    @Override
    public IComplexNDArray addi(INDArray other) {
        return this.addi(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray addi(INDArray other, INDArray result) {
        IComplexNDArray cOther = (IComplexNDArray)other;
        IComplexNDArray cResult = (IComplexNDArray)result;
        if (cOther.isScalar()) {
            return cResult.addi(cOther.getComplex(0), result);
        }
        if (this.isScalar()) {
            return cOther.addi(this.getComplex(0), result);
        }
        if (result == this) {
            Nd4j.getBlasWrapper().axpy(Nd4j.UNIT, cOther, cResult);
        } else if (result == other) {
            Nd4j.getBlasWrapper().axpy(Nd4j.UNIT, this, cResult);
        } else {
            INDArray resultLinear = result.linearView();
            INDArray otherLinear = other.linearView();
            IComplexNDArray linear = this.linearView();
            for (int i = 0; i < resultLinear.length(); ++i) {
                resultLinear.putScalar(i, otherLinear.getDouble(i) + linear.getDouble(i));
            }
        }
        return (IComplexNDArray)result;
    }

    @Override
    public IComplexNDArray rdiv(IComplexNumber n, INDArray result) {
        return this.dup().rdivi(n, result);
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n, INDArray result) {
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray cResultLinear = cResult.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResultLinear.putScalar(i, n.div(this.getComplex(i)));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray rsub(IComplexNumber n, INDArray result) {
        return this.dup().rsubi(n, result);
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n, INDArray result) {
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray cResultLinear = cResult.linearView();
        IComplexNDArray thiLinear = this.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResultLinear.putScalar(i, n.sub(thiLinear.getComplex(i)));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray div(IComplexNumber n, INDArray result) {
        return this.dup().divi(n, result);
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n, INDArray result) {
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray cResultLinear = cResult.linearView();
        IComplexNDArray thisLinear = this.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResultLinear.putScalar(i, thisLinear.getComplex(i).div(n));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray mul(IComplexNumber n, INDArray result) {
        return this.dup().muli(n, result);
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n, INDArray result) {
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray cResultLinear = cResult.linearView();
        IComplexNDArray thiLinear = this.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResultLinear.putScalar(i, thiLinear.getComplex(i).mul(n));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray sub(IComplexNumber n, INDArray result) {
        return this.dup().subi(n, result);
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n, INDArray result) {
        IComplexNDArray cResult = (IComplexNDArray)result;
        IComplexNDArray cResultLinear = cResult.linearView();
        IComplexNDArray linear = this.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResultLinear.putScalar(i, linear.getComplex(i).sub(n));
        }
        return cResult;
    }

    @Override
    public IComplexNDArray add(IComplexNumber n, INDArray result) {
        return this.dup().addi(n, result);
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n, INDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = (IComplexNDArray)result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, linear.getComplex(i).add(n));
        }
        return (IComplexNDArray)result;
    }

    @Override
    public IComplexNDArray rdiv(IComplexNumber n) {
        return this.dup().rdivi(n, this);
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n) {
        return this.rdivi(n, this);
    }

    @Override
    public IComplexNDArray rsub(IComplexNumber n) {
        return this.rsub(n, this);
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n) {
        return this.rsubi(n, this);
    }

    @Override
    public IComplexNDArray div(IComplexNumber n) {
        return this.div(n, this);
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n) {
        return this.divi(n, this);
    }

    @Override
    public IComplexNDArray mul(IComplexNumber n) {
        return this.dup().muli(n);
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n) {
        return this.muli(n, this);
    }

    @Override
    public IComplexNDArray sub(IComplexNumber n) {
        return this.dup().subi(n);
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n) {
        return this.subi(n, this);
    }

    @Override
    public IComplexNDArray add(IComplexNumber n) {
        return this.dup().addi(n);
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n) {
        return this.addi(n, this);
    }

    @Override
    public IComplexNDArray putReal(int rowIndex, int columnIndex, float value) {
        return this.putReal(new int[]{rowIndex, columnIndex}, value);
    }

    @Override
    public IComplexNDArray putReal(int[] indices, float value) {
        return this.putReal(indices, (double)value);
    }

    @Override
    public IComplexNDArray putImag(int[] indices, float value) {
        return this.putImag(indices, (double)value);
    }

    @Override
    public IComplexNDArray putReal(int[] indices, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNDArray putImag(int[] indices, double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IComplexNDArray putImag(int rowIndex, int columnIndex, float value) {
        return this.putReal(new int[]{rowIndex, columnIndex}, value);
    }

    @Override
    public IComplexNDArray put(int[] indexes, float value) {
        return this.put(indexes, (double)value);
    }

    @Override
    public IComplexNDArray neqi(IComplexNumber other) {
        IComplexNDArray ret = this.linearView();
        for (int i = 0; i < this.length(); ++i) {
            IComplexNumber num = ret.getComplex(i);
            ret.putScalar(i, num.neqc(other));
        }
        return this;
    }

    @Override
    public IComplexNDArray neq(IComplexNumber other) {
        return this.dup().neqi(other);
    }

    @Override
    public IComplexNDArray lt(IComplexNumber other) {
        return this.dup().lti(other);
    }

    @Override
    public IComplexNDArray lti(IComplexNumber other) {
        IComplexNDArray ret = this.linearView();
        for (int i = 0; i < this.length(); ++i) {
            IComplexNumber num = ret.getComplex(i);
            ret.putScalar(i, num.lt(other));
        }
        return this;
    }

    @Override
    public IComplexNDArray eq(IComplexNumber other) {
        return this.dup().eqi(other);
    }

    @Override
    public IComplexNDArray eqi(IComplexNumber other) {
        return this.dup().eqi(other);
    }

    @Override
    public IComplexNDArray gt(IComplexNumber other) {
        return this.dup().gti(other);
    }

    @Override
    public IComplexNDArray gti(IComplexNumber other) {
        IComplexNDArray ret = this.linearView();
        for (int i = 0; i < this.length(); ++i) {
            IComplexNumber num = ret.getComplex(i);
            ret.putScalar(i, num.gt(other));
        }
        return this;
    }

    @Override
    public IComplexNDArray transposei() {
        return Nd4j.createComplex(super.transposei());
    }

    @Override
    public IComplexNDArray transpose() {
        return this.transposei();
    }

    @Override
    public IComplexNDArray addi(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, linear.getComplex(i).addi(n));
        }
        return result;
    }

    @Override
    public IComplexNDArray subi(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, linear.getComplex(i).subi(n));
        }
        return result;
    }

    @Override
    public IComplexNDArray muli(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            IComplexNumber n3 = linear.getComplex(i);
            cResult.putScalar(i, n3.mul(n));
        }
        return result;
    }

    @Override
    public IComplexNDArray divi(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, linear.getComplex(i).div(n));
        }
        return result;
    }

    @Override
    public IComplexNDArray rsubi(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, n.sub(linear.getComplex(i)));
        }
        return result;
    }

    @Override
    public IComplexNDArray rdivi(IComplexNumber n, IComplexNDArray result) {
        IComplexNDArray linear = this.linearView();
        IComplexNDArray cResult = result.linearView();
        for (int i = 0; i < this.length(); ++i) {
            cResult.putScalar(i, n.div(linear.getComplex(i)));
        }
        return result;
    }

    @Override
    public IComplexNDArray reshape(int ... shape) {
        return (IComplexNDArray)super.reshape(shape);
    }

    @Override
    public IComplexNDArray reshape(char order, int ... newShape) {
        return (IComplexNDArray)super.reshape(order, newShape);
    }

    @Override
    public IComplexNDArray reshape(char order, int rows, int columns) {
        return (IComplexNDArray)super.reshape(order, rows, columns);
    }

    @Override
    public IComplexNDArray assign(Number value) {
        IComplexNDArray one = this.linearView();
        for (int i = 0; i < one.length(); ++i) {
            one.putScalar(i, (IComplexNumber)Nd4j.createDouble(value.doubleValue(), 0.0));
        }
        return this;
    }

    @Override
    public IComplexNDArray rdiv(INDArray other) {
        return this.dup().rdivi(other);
    }

    @Override
    public IComplexNDArray rdivi(INDArray other) {
        return this.rdivi(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray rdiv(INDArray other, INDArray result) {
        return this.dup().rdivi(other, result);
    }

    @Override
    public IComplexNDArray rdivi(INDArray other, INDArray result) {
        return (IComplexNDArray)other.divi(this, result);
    }

    @Override
    public IComplexNDArray rsub(INDArray other, INDArray result) {
        return this.dup().rsubi(other, result);
    }

    @Override
    public IComplexNDArray rsub(INDArray other) {
        return this.dup().rsubi(other);
    }

    @Override
    public IComplexNDArray rsubi(INDArray other) {
        return this.rsubi(other, (INDArray)this);
    }

    @Override
    public IComplexNDArray rsubi(INDArray other, INDArray result) {
        return (IComplexNDArray)other.subi(this, result);
    }

    public IComplexNumber max() {
        IComplexNDArray reshape = this.ravel();
        IComplexNumber max = reshape.getComplex(0);
        for (int i = 1; i < reshape.length(); ++i) {
            IComplexNumber curr = reshape.getComplex(i);
            double val = curr.realComponent().doubleValue();
            if (!(val > curr.realComponent().doubleValue())) continue;
            max = curr;
        }
        return max;
    }

    public IComplexNumber min() {
        IComplexNDArray reshape = this.ravel();
        IComplexNumber min = reshape.getComplex(0);
        for (int i = 1; i < reshape.length(); ++i) {
            IComplexNumber curr = reshape.getComplex(i);
            double val = curr.realComponent().doubleValue();
            if (!(val < curr.realComponent().doubleValue())) continue;
            min = curr;
        }
        return min;
    }

    @Override
    public IComplexNDArray reshape(int newRows, int newColumns) {
        return this.reshape(new int[]{newRows, newColumns});
    }

    @Override
    public IComplexNDArray getColumn(int c) {
        return (IComplexNDArray)super.getColumn(c);
    }

    @Override
    public IComplexNDArray getRow(int r) {
        return (IComplexNDArray)super.getRow(r);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof IComplexNDArray)) {
            return false;
        }
        IComplexNDArray n = (IComplexNDArray)o;
        if (this.isScalar() && n.isScalar()) {
            IComplexNumber c = n.getComplex(0);
            return FastMath.abs((double)this.getComplex(0).sub(c).realComponent().doubleValue()) < Nd4j.EPS_THRESHOLD;
        }
        if (this.isVector() && n.isVector()) {
            for (int i = 0; i < this.length(); ++i) {
                IComplexNumber thisComplex;
                IComplexNumber nComplex = n.getComplex(i);
                if (nComplex.equals(thisComplex = this.getComplex(i))) continue;
                return false;
            }
            return true;
        }
        if (!Shape.shapeEquals(this.shape(), n.shape())) {
            return false;
        }
        if (this.isScalar()) {
            IComplexNumber c = n.getComplex(0);
            return this.getComplex(0).sub(c).absoluteValue().doubleValue() < Nd4j.EPS_THRESHOLD;
        }
        if (this.isVector()) {
            for (int i = 0; i < this.length(); ++i) {
                IComplexNumber comp;
                IComplexNumber curr = this.getComplex(i);
                if (curr.equals(comp = n.getComplex(i))) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < this.slices(); ++i) {
            IComplexNDArray nSliceI;
            IComplexNDArray sliceI = this.slice(i);
            if (sliceI.equals(nSliceI = n.slice(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public IComplexNDArray broadcast(int[] shape) {
        return (IComplexNDArray)super.broadcast(shape);
    }

    @Override
    public Object element() {
        if (!this.isScalar()) {
            throw new IllegalStateException("Unable to getScalar the element of a non scalar");
        }
        int idx = this.linearIndex(0);
        return Nd4j.createDouble(this.data.getDouble((long)idx), this.data.getDouble((long)(idx + 1)));
    }

    @Override
    public IComplexNDArray permute(int[] rearrange) {
        return (IComplexNDArray)super.permute(rearrange);
    }

    @Override
    public IComplexNDArray ravel() {
        if (this.length() >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("length() can not be >= Integer.MAX_VALUE");
        }
        IComplexNDArray ret = Nd4j.createComplex(this.length(), this.ordering());
        IComplexNDArray linear = this.linearView();
        for (int i = 0; i < this.length(); ++i) {
            ret.putScalar(i, linear.getComplex(i));
        }
        return ret;
    }

    @Override
    public String toString() {
        if (this.isScalar()) {
            return this.element().toString();
        }
        if (this.isVector()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            if (this.length() >= Integer.MAX_VALUE) {
                throw new IllegalArgumentException("length() can not be >= Integer.MAX_VALUE");
            }
            long numElementsToPrint = Nd4j.MAX_ELEMENTS_PER_SLICE < 0 ? (long)this.length() : (long)Nd4j.MAX_ELEMENTS_PER_SLICE;
            for (int i = 0; i < this.length(); ++i) {
                long numElementsLeft;
                sb.append(this.getComplex(i));
                if (i < this.length() - 1) {
                    sb.append(" ,");
                }
                if ((long)i < numElementsToPrint || (numElementsLeft = (long)(this.length() - i)) <= numElementsToPrint) continue;
                i = (int)((long)i + (numElementsLeft - numElementsToPrint - 1L));
                sb.append(" ,... ,");
            }
            sb.append("]\n");
            return sb.toString();
        }
        throw new UnsupportedOperationException();
    }
}

