/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.primitives.Ints;
import com.google.flatbuffers.FlatBufferBuilder;
import com.rits.cloning.Cloner;
import com.rits.cloning.IFastCloner;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.autodiff.execution.conf.ExecutionMode;
import org.nd4j.autodiff.execution.conf.ExecutorConfiguration;
import org.nd4j.autodiff.execution.conf.OutputMode;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.functions.DifferentialFunctionFactory;
import org.nd4j.autodiff.functions.FunctionProperties;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.flow.FlowPath;
import org.nd4j.autodiff.util.cloner.DataBufferFastCloner;
import org.nd4j.autodiff.util.cloner.INDArrayFastCloner;
import org.nd4j.graph.FlatGraph;
import org.nd4j.graph.FlatNode;
import org.nd4j.graph.FlatVariable;
import org.nd4j.graph.IntPair;
import org.nd4j.linalg.api.blas.params.MMulTranspose;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.factory.DataBufferFactory;
import org.nd4j.linalg.api.buffer.util.DataTypeUtil;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.memory.conf.WorkspaceConfiguration;
import org.nd4j.linalg.api.memory.enums.AllocationPolicy;
import org.nd4j.linalg.api.memory.enums.LearningPolicy;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.Accumulation;
import org.nd4j.linalg.api.ops.BaseOp;
import org.nd4j.linalg.api.ops.BroadcastOp;
import org.nd4j.linalg.api.ops.CustomOp;
import org.nd4j.linalg.api.ops.CustomOpDescriptor;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.GradientOp;
import org.nd4j.linalg.api.ops.IndexAccumulation;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.TransformOp;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.impl.controlflow.If;
import org.nd4j.linalg.api.ops.impl.controlflow.While;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Enter;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Exit;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.LoopCond;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Merge;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.NextIteration;
import org.nd4j.linalg.api.ops.impl.controlflow.compat.Switch;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv1DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv3DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.DeConv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.LocalResponseNormalizationConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Pooling3DConfig;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.GRUCell;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.LSTMCell;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.SRU;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.SRUCell;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.GRUCellConfiguration;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.LSTMCellConfiguration;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.SRUCellConfiguration;
import org.nd4j.linalg.api.ops.impl.layers.recurrent.config.SRUConfiguration;
import org.nd4j.linalg.api.ops.impl.transforms.gradient.GradientBackwardsMarker;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.collection.IntArrayKeyMap;
import org.nd4j.linalg.compression.CompressedDataBuffer;
import org.nd4j.linalg.exception.ND4JIllegalArgumentException;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.lossfunctions.impl.LossBinaryXENT;
import org.nd4j.linalg.lossfunctions.impl.LossCosineProximity;
import org.nd4j.linalg.lossfunctions.impl.LossHinge;
import org.nd4j.linalg.lossfunctions.impl.LossKLD;
import org.nd4j.linalg.lossfunctions.impl.LossL1;
import org.nd4j.linalg.lossfunctions.impl.LossL2;
import org.nd4j.linalg.lossfunctions.impl.LossMAE;
import org.nd4j.linalg.lossfunctions.impl.LossMCXENT;
import org.nd4j.linalg.lossfunctions.impl.LossMSE;
import org.nd4j.linalg.lossfunctions.impl.LossMSLE;
import org.nd4j.linalg.lossfunctions.impl.LossNegativeLogLikelihood;
import org.nd4j.linalg.lossfunctions.impl.LossPoisson;
import org.nd4j.linalg.lossfunctions.impl.LossSquaredHinge;
import org.nd4j.linalg.primitives.AtomicBoolean;
import org.nd4j.linalg.primitives.Pair;
import org.nd4j.linalg.util.ArrayUtil;
import org.nd4j.weightinit.WeightInitScheme;
import org.nd4j.weightinit.impl.ConstantInitScheme;
import org.nd4j.weightinit.impl.NDArraySupplierInitScheme;
import org.nd4j.weightinit.impl.ZeroInitScheme;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SameDiff {
    private static final Logger log;
    private Map<String[], DifferentialFunction> incomingArgs;
    private Map<String[], DifferentialFunction> outgoingArgs;
    private Map<String, String[]> incomingArgsReverse;
    private Map<String, String[]> outgoingArgsReverse;
    private Map<String, int[]> permuteOrder;
    private boolean shouldBootStrap = true;
    private Set<String> importedVarName;
    private Map<String, String> baseNameForFunctionInstanceId;
    private DifferentialFunctionFactory functionFactory;
    private Map<String, SDVariable> variableMap;
    private Map<String, int[]> variableNameToShape;
    private Map<String, SDVariable> gradients;
    private Map<String, SDVariable> forwardVarForGrad;
    private Map<String, INDArray> variableNameToArr;
    private Map<String, List<DifferentialFunction>> functionsArgsFor;
    private Map<String, List<DifferentialFunction>> functionOutputFor;
    private ThreadLocal<FlowPath> localFlowPath = new ThreadLocal();
    private Map<String, List<String>> propertiesToResolve;
    private Map<String, Map<String, Object>> propertiesForFunction;
    private Map<String, List<String[]>> placeHolderMap;
    private Map<String, int[]> placeHolderOriginalShapes;
    private Set<String> placeHolderVarNames;
    private IdentityHashMap<INDArray, SDVariable> reverseArrayLookup;
    private MemoryWorkspace workspace;
    private Map<String, SameDiffFunctionDefinition> sameDiffFunctionDefinitionMap;
    private Map<String, SameDiff> sameDiffFunctionInstances;
    private Set<String> placeHolderFunctions;
    private static Cloner cloner;
    private static Map<String, Method> opMethods;
    private Map<String, DifferentialFunction> functionInstancesById;
    private Table<String, String, String> fieldVariableResolutionMapping;
    private transient AtomicBoolean wasRegistered = new AtomicBoolean(false);
    private boolean debugMode;
    private Map<int[], Op> opsForResult;
    private boolean resolvedVariables = false;
    boolean logExecution = true;

    public static Cloner newCloner() {
        Cloner cloner = new Cloner();
        INDArrayFastCloner fc = new INDArrayFastCloner();
        cloner.registerFastCloner(Nd4j.getBackend().getNDArrayClass(), (IFastCloner)fc);
        cloner.registerFastCloner(Nd4j.getBackend().getComplexNDArrayClass(), (IFastCloner)fc);
        DataBufferFastCloner fc2 = new DataBufferFastCloner();
        DataBufferFactory d = Nd4j.getDataBufferFactory();
        SameDiff.doReg(cloner, fc2, d.intBufferClass());
        SameDiff.doReg(cloner, fc2, d.longBufferClass());
        SameDiff.doReg(cloner, fc2, d.halfBufferClass());
        SameDiff.doReg(cloner, fc2, d.floatBufferClass());
        SameDiff.doReg(cloner, fc2, d.doubleBufferClass());
        SameDiff.doReg(cloner, fc2, CompressedDataBuffer.class);
        return cloner;
    }

    private static void doReg(Cloner cl, IFastCloner fc, Class<?> c) {
        if (c != null) {
            cl.registerFastCloner(c, fc);
        }
    }

    public void updateVariableName(String varName, String withName) {
        BaseOp baseOp;
        List<DifferentialFunction> funcs;
        int i;
        SDVariable oldVarNameRef = this.getVariable(varName);
        this.variableMap.remove(oldVarNameRef.getVarName());
        String oldVarName = varName;
        oldVarNameRef.setVarName(withName);
        this.variableMap.put(withName, oldVarNameRef);
        for (Map.Entry<String, String[]> reverseValues : this.outgoingArgsReverse.entrySet()) {
            for (i = 0; i < reverseValues.getValue().length; ++i) {
                if (!reverseValues.getValue()[i].equals(oldVarName)) continue;
                reverseValues.getValue()[i] = withName;
            }
        }
        for (Map.Entry<String, String[]> reverseValues : this.incomingArgsReverse.entrySet()) {
            for (i = 0; i < reverseValues.getValue().length; ++i) {
                if (!reverseValues.getValue()[i].equals(oldVarName)) continue;
                reverseValues.getValue()[i] = withName;
            }
        }
        if (this.variableNameToArr.containsKey(oldVarName)) {
            INDArray arr = this.variableNameToArr.remove(oldVarName);
            this.variableNameToArr.put(withName, arr);
        }
        if (this.variableNameToShape.containsKey(oldVarName)) {
            int[] shape = this.variableNameToShape.remove(oldVarName);
            this.variableNameToShape.put(withName, shape);
        }
        if (this.gradients.containsKey(oldVarName)) {
            SDVariable grad = this.gradients.remove(oldVarName);
            this.gradients.put(withName, grad);
        }
        if (this.forwardVarForGrad.containsKey(oldVarName)) {
            SDVariable forwardGrad = this.forwardVarForGrad.remove(oldVarName);
            this.forwardVarForGrad.put(withName, forwardGrad);
        }
        if (this.placeHolderMap.containsKey(oldVarName)) {
            List<String[]> placeholders = this.placeHolderMap.remove(oldVarName);
            this.placeHolderMap.put(withName, placeholders);
        }
        if (this.functionsArgsFor.containsKey(oldVarName)) {
            funcs = this.functionsArgsFor.remove(oldVarName);
            for (DifferentialFunction func : funcs) {
                if (!(func instanceof BaseOp)) continue;
                baseOp = (BaseOp)func;
                if (baseOp.getXVertexId() != null && baseOp.getXVertexId().equals(oldVarName)) {
                    baseOp.setXVertexId(withName);
                }
                if (baseOp.getYVertexId() != null && baseOp.getYVertexId().equals(oldVarName)) {
                    baseOp.setYVertexId(withName);
                }
                if (baseOp.getZVertexId() == null || !baseOp.getZVertexId().equals(oldVarName)) continue;
                baseOp.setZVertexId(withName);
            }
            this.functionsArgsFor.put(withName, funcs);
        }
        if (this.functionOutputFor.containsKey(oldVarName)) {
            funcs = this.functionOutputFor.remove(oldVarName);
            for (DifferentialFunction func : funcs) {
                if (!(func instanceof BaseOp)) continue;
                baseOp = (BaseOp)func;
                if (baseOp.getXVertexId() != null && baseOp.getXVertexId().equals(oldVarName)) {
                    baseOp.setXVertexId(withName);
                }
                if (baseOp.getYVertexId() != null && baseOp.getYVertexId().equals(oldVarName)) {
                    baseOp.setYVertexId(withName);
                }
                if (baseOp.getZVertexId() == null || !baseOp.getZVertexId().equals(oldVarName)) continue;
                baseOp.setZVertexId(withName);
            }
            this.functionOutputFor.put(withName, funcs);
        }
        this.variableMap.remove(oldVarName);
    }

    public SameDiff disableDebugging() {
        this.debugMode = false;
        return this;
    }

    public SameDiff enableDebugMode() {
        this.debugMode = true;
        return this;
    }

    public DifferentialFunctionFactory f() {
        return this.functionFactory;
    }

    public SDVariable invokeGraphOn(SameDiff sameDiff) {
        HashMap<Integer, Integer> thisVertexIdToNew = new HashMap<Integer, Integer>();
        int idx = 1;
        for (SDVariable var : this.variables()) {
            SDVariable sDVariable = (SDVariable)cloner.deepCloneDontCloneInstances((Object)var, new Object[]{var.getSameDiff()});
            SDVariable newVar = sameDiff.var(sDVariable);
            if (var.getArr() != null) {
                sameDiff.associateArrayWithVariable(var.getArr(), newVar);
            }
            thisVertexIdToNew.put(idx, idx);
            sDVariable.setSameDiff(sameDiff);
            ++idx;
        }
        LinkedHashMap<String, DifferentialFunction> newFunctions = new LinkedHashMap<String, DifferentialFunction>();
        for (DifferentialFunction differentialFunction : this.functionInstancesById.values()) {
            if (differentialFunction instanceof SDVariable) continue;
            DifferentialFunction clone = (DifferentialFunction)cloner.deepCloneDontCloneInstances((Object)differentialFunction, new Object[]{differentialFunction.getSameDiff()});
            clone.setSameDiff(sameDiff);
            clone.setOwnName(differentialFunction.getOwnName());
            if (sameDiff.functionExists(differentialFunction.getOwnName())) {
                sameDiff.putFunctionForId(differentialFunction.getOwnName(), differentialFunction);
            }
            newFunctions.put(differentialFunction.getOwnName(), clone);
            SDVariable[] argsForFunction = differentialFunction.args();
            SDVariable[] outputsForFunction = differentialFunction.outputVariables();
            sameDiff.addArgsFor(argsForFunction, clone);
            sameDiff.addOutgoingFor(outputsForFunction, differentialFunction);
            for (SDVariable arg : clone.args()) {
                arg.setSameDiff(sameDiff);
            }
            for (SDVariable output : clone.outputVariables()) {
                output.setSameDiff(sameDiff);
            }
            sameDiff.functionInstancesById.put(differentialFunction.getOwnName(), differentialFunction);
        }
        for (Map.Entry entry : this.reverseArrayLookup.entrySet()) {
            sameDiff.reverseArrayLookup.put((INDArray)entry.getKey(), sameDiff.getVariable(((SDVariable)entry.getValue()).getVarName()));
        }
        return sameDiff.variables().get(sameDiff.variables().size() - 1);
    }

    public boolean functionExists(String id) {
        return this.functionInstancesById.containsKey(id);
    }

    public DifferentialFunction getFunctionById(String id) {
        if (!this.functionInstancesById.containsKey(id)) {
            throw new ND4JIllegalStateException("No function with id " + id + " found!");
        }
        return this.functionInstancesById.get(id);
    }

    public void putFunctionForId(String id, DifferentialFunction function) {
        if (this.functionInstancesById.containsKey(id)) {
            throw new ND4JIllegalStateException("Function by id already exists!");
        }
        if (function instanceof SDVariable) {
            throw new ND4JIllegalStateException("Function must not be a variable!");
        }
        this.functionInstancesById.put(id, function);
    }

    public String[] getInputsForFunction(DifferentialFunction function) {
        if (!this.incomingArgsReverse.containsKey(function.getOwnName())) {
            throw new ND4JIllegalStateException("Illegal function instance id found " + function.getOwnName());
        }
        return this.incomingArgsReverse.get(function.getOwnName());
    }

    public String[] getOutputsForFunction(DifferentialFunction function) {
        return this.outgoingArgsReverse.get(function.getOwnName());
    }

    public SDVariable[] getOutputVariablesForFunction(DifferentialFunction function) {
        String[] inputs = this.getOutputsForFunction(function);
        if (inputs == null) {
            throw new ND4JIllegalStateException("No inputs found for function " + function);
        }
        SDVariable[] vars = new SDVariable[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            vars[i] = this.getVariable(inputs[i]);
        }
        return vars;
    }

    public SDVariable[] getInputVariablesForFunction(DifferentialFunction function) {
        String[] inputs = this.getInputsForFunction(function);
        if (inputs == null) {
            throw new ND4JIllegalStateException("No inputs found for function " + function);
        }
        SDVariable[] vars = new SDVariable[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            vars[i] = this.getVariable(inputs[i]);
            if (vars[i] != null) continue;
            throw new ND4JIllegalStateException("Found null variable at index " + i);
        }
        return vars;
    }

    public void updateArrayForVarName(String varName, INDArray arr) {
        if (!this.variableNameToArr.containsKey(varName)) {
            throw new ND4JIllegalStateException("Array for " + varName + " does not exist. Please use putArrayForVertexId instead.");
        }
        this.variableNameToArr.put(varName, arr);
        this.reverseArrayLookup.put(arr, this.getVariable(varName));
    }

    public void putArrayForVarName(String varName, INDArray arr) {
        if (varName == null) {
            throw new ND4JIllegalStateException("No null names allowed!");
        }
        if (this.variableNameToArr.containsKey(varName)) {
            throw new ND4JIllegalStateException("Array for " + varName + " already exists!");
        }
        this.variableNameToArr.put(varName, arr);
    }

    public int[] getShapeForVarName(String varName) {
        if (this.variableNameToArr.containsKey(varName)) {
            return this.variableNameToArr.get(varName).shape();
        }
        return this.variableNameToShape.get(varName);
    }

    public void updateShapeForVarName(String varName, int[] shape) {
        if (shape == null) {
            throw new ND4JIllegalStateException("Null shapes not allowed!");
        }
        if (this.variableNameToArr.containsKey(varName) && !Arrays.equals(this.variableNameToArr.get(varName).shape(), shape)) {
            throw new ND4JIllegalStateException("Already found an existing array!");
        }
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] >= 1) continue;
            this.addAsPlaceHolder(varName);
            this.placeHolderOriginalShapes.put(varName, shape);
            return;
        }
        this.variableNameToShape.put(varName, shape);
    }

    public void putShapeForVarName(String varName, int[] shape) {
        if (shape == null) {
            throw new ND4JIllegalStateException("Shape must not be null!");
        }
        if (this.variableNameToShape.containsKey(varName)) {
            throw new ND4JIllegalStateException("Shape for " + varName + " already exists!");
        }
        for (int i = 0; i < shape.length; ++i) {
            if (shape[i] >= 1) continue;
            this.addAsPlaceHolder(varName);
            this.placeHolderOriginalShapes.put(varName, shape);
            return;
        }
        this.variableNameToShape.put(varName, shape);
    }

    public boolean shapeAlreadyExistsForVarName(String varName) {
        return this.variableNameToShape.containsKey(varName) || this.arrayAlreadyExistsForVarName(varName);
    }

    public boolean arrayAlreadyExistsForVarName(String varName) {
        return this.variableNameToArr.containsKey(varName);
    }

    public INDArray getArrForVarName(String varName) {
        return this.variableNameToArr.get(varName);
    }

    public void associateArrayWithVariable(INDArray arr, SDVariable variable) {
        if (variable == null) {
            throw new ND4JIllegalArgumentException("Variable must not be null!");
        }
        if (arr == null) {
            throw new ND4JIllegalArgumentException("Array must not be null");
        }
        this.reverseArrayLookup.put(arr, variable);
        this.variableNameToArr.put(variable.getVarName(), arr);
        if (!this.shapeAlreadyExistsForVarName(variable.getVarName())) {
            this.putShapeForVarName(variable.getVarName(), arr.shape());
        } else {
            this.updateShapeForVarName(variable.getVarName(), arr.shape());
        }
    }

    public void putSubFunction(String name, SameDiff nameSpace) {
        if (this.sameDiffFunctionInstances.containsKey(name) && this.sameDiffFunctionInstances.get(name) != nameSpace) {
            throw new ND4JIllegalStateException("Unable to replace samediff namespace. Please choose another opName");
        }
        this.sameDiffFunctionInstances.put(name, nameSpace);
    }

    public Map<String, SDVariable> variableMap() {
        return this.variableMap;
    }

    public SDVariable invoke(Op op, SDVariable x, SDVariable y) {
        if (!opMethods.containsKey(op.opName())) {
            throw new ND4JIllegalStateException("Illegal method opName " + op.opName());
        }
        if (x != null && y != null) {
            try {
                return (SDVariable)opMethods.get(op.opName()).invoke((Object)this, x, y);
            }
            catch (Exception exception) {
            }
        } else {
            try {
                return (SDVariable)opMethods.get(op.opName()).invoke((Object)this, x);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ND4JIllegalStateException("Illegal method opName " + op.opName());
    }

    public SDVariable getVariableForArray(INDArray arr) {
        return this.reverseArrayLookup.get(arr);
    }

    public Collection<String> definedFunctionNames() {
        return this.sameDiffFunctionInstances.keySet();
    }

    public long memoryForGraph() {
        return this.numElements() * (long)DataTypeUtil.lengthForDtype((DataBuffer.Type)Nd4j.dataType());
    }

    public SDVariable invoke(Op op, SDVariable x) {
        return this.invoke(op, x, null);
    }

    private SameDiff() {
        this.functionFactory = new DifferentialFunctionFactory(this);
        this.variableMap = new LinkedHashMap<String, SDVariable>();
        this.sameDiffFunctionDefinitionMap = new LinkedHashMap<String, SameDiffFunctionDefinition>();
        this.sameDiffFunctionInstances = new LinkedHashMap<String, SameDiff>();
        this.gradients = new LinkedHashMap<String, SDVariable>();
        this.forwardVarForGrad = new LinkedHashMap<String, SDVariable>();
        this.opsForResult = new IntArrayKeyMap();
        this.reverseArrayLookup = new IdentityHashMap();
        this.variableNameToArr = new LinkedHashMap<String, INDArray>();
        this.variableNameToShape = new LinkedHashMap<String, int[]>();
        this.placeHolderMap = new LinkedHashMap<String, List<String[]>>();
        this.placeHolderVarNames = new LinkedHashSet<String>();
        this.placeHolderOriginalShapes = new LinkedHashMap<String, int[]>();
        this.incomingArgs = new LinkedHashMap<String[], DifferentialFunction>();
        this.outgoingArgs = new LinkedHashMap<String[], DifferentialFunction>();
        this.incomingArgsReverse = new LinkedHashMap<String, String[]>();
        this.outgoingArgsReverse = new LinkedHashMap<String, String[]>();
        this.functionInstancesById = new LinkedHashMap<String, DifferentialFunction>();
        this.placeHolderFunctions = new LinkedHashSet<String>();
        this.functionsArgsFor = new LinkedHashMap<String, List<DifferentialFunction>>();
        this.functionOutputFor = new LinkedHashMap<String, List<DifferentialFunction>>();
        this.baseNameForFunctionInstanceId = new LinkedHashMap<String, String>();
        this.importedVarName = new LinkedHashSet<String>();
        this.permuteOrder = new LinkedHashMap<String, int[]>();
        this.propertiesToResolve = new LinkedHashMap<String, List<String>>();
        this.propertiesForFunction = new LinkedHashMap<String, Map<String, Object>>();
        this.fieldVariableResolutionMapping = HashBasedTable.create();
    }

    public void addPropertyToResolve(DifferentialFunction forFunction, String arrayName) {
        if (!this.propertiesToResolve.containsKey(forFunction.getOwnName())) {
            ArrayList<String> newVal = new ArrayList<String>();
            newVal.add(arrayName);
            this.propertiesToResolve.put(forFunction.getOwnName(), newVal);
        } else {
            List<String> newVal = this.propertiesToResolve.get(forFunction.getOwnName());
            newVal.add(arrayName);
        }
    }

    public List<String> propertiesToResolveForFunction(DifferentialFunction function) {
        if (!this.propertiesToResolve.containsKey(function.getOwnName())) {
            return Collections.emptyList();
        }
        return this.propertiesToResolve.get(function.getOwnName());
    }

    public boolean hasPropertiesToResolve(DifferentialFunction function) {
        return this.propertiesToResolve.containsKey(function.getOwnName());
    }

    public <T> T getPropertyForFunction(DifferentialFunction functionInstance, String propertyName) {
        if (!this.propertiesForFunction.containsKey(functionInstance.getOwnName())) {
            return null;
        }
        Map<String, Object> map = this.propertiesForFunction.get(functionInstance.getOwnName());
        return (T)map.get(propertyName);
    }

    public void addPropertyForFunction(DifferentialFunction functionFor, String propertyName, INDArray property) {
        this.addPropertyForFunction(functionFor, propertyName, (Object)property);
    }

    public void addPropertyForFunction(DifferentialFunction functionFor, String propertyName, long property) {
        this.addPropertyForFunction(functionFor, propertyName, (Object)property);
    }

    private void addPropertyForFunction(DifferentialFunction functionFor, String propertyName, Object propertyValue) {
        if (!this.propertiesForFunction.containsKey(functionFor.getOwnName())) {
            LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
            fields.put(propertyName, propertyValue);
            this.propertiesForFunction.put(functionFor.getOwnName(), fields);
        } else {
            Map<String, Object> fieldMap = this.propertiesForFunction.get(functionFor.getOwnName());
            if (fieldMap.containsKey(propertyName)) {
                throw new ND4JIllegalStateException("Attempting to override property " + propertyName);
            }
            fieldMap.put(propertyName, propertyValue);
        }
    }

    public void addVariableMappingForField(DifferentialFunction function, String fieldName, String varName) {
        this.fieldVariableResolutionMapping.put((Object)function.getOwnName(), (Object)fieldName, (Object)varName);
    }

    public String getVarNameForFieldAndFunction(DifferentialFunction function, String fieldName) {
        return (String)this.fieldVariableResolutionMapping.get((Object)function.getOwnName(), (Object)fieldName);
    }

    public boolean isImportVariable(String variableName) {
        return this.importedVarName.contains(variableName);
    }

    public void addVarNameForImport(String varName) {
        this.importedVarName.add(varName);
    }

    public void setBaseNameForFunctionInstanceId(String baseName, DifferentialFunction function) {
        this.baseNameForFunctionInstanceId.put(function.getOwnName(), baseName);
    }

    public String getBaseNameForFunction(DifferentialFunction function) {
        return this.baseNameForFunctionInstanceId.get(function.getOwnName());
    }

    public <X extends SDVariable> X setupFunction(X function) {
        Preconditions.checkNotNull(function, (Object)"Passed in function must not be null!");
        if (function instanceof SDVariable) {
            if (function.getSameDiff() != this) {
                function.setSameDiff(this);
            }
            return function;
        }
        return function;
    }

    public void addOutgoingFor(SDVariable[] variables, DifferentialFunction function) {
        String[] varNames = new String[variables.length];
        for (int i = 0; i < varNames.length; ++i) {
            varNames[i] = variables[i].getVarName();
        }
        this.addOutgoingFor(varNames, function);
    }

    public void addOutgoingFor(String[] varNames, DifferentialFunction function) {
        if (function.getOwnName() == null) {
            throw new ND4JIllegalStateException("Instance id can not be null. Function not initialized properly");
        }
        if (this.outgoingArgsReverse.containsKey(function.getOwnName())) {
            throw new ND4JIllegalStateException("Outgoing arguments already declared for " + function);
        }
        if (varNames == null) {
            throw new ND4JIllegalStateException("Var names can not be null!");
        }
        for (int i = 0; i < varNames.length; ++i) {
            if (varNames[i] != null) continue;
            throw new ND4JIllegalStateException("Variable name elements can not be null!");
        }
        this.outgoingArgsReverse.put(function.getOwnName(), varNames);
        this.outgoingArgs.put(varNames, function);
        for (String resultName : varNames) {
            List<DifferentialFunction> funcs = this.functionOutputFor.get(resultName);
            if (funcs == null) {
                funcs = new ArrayList<DifferentialFunction>();
                this.functionOutputFor.put(resultName, funcs);
            }
            funcs.add(function);
        }
    }

    public void addArgsFor(String[] variables, DifferentialFunction function) {
        if (function.getOwnName() == null) {
            throw new ND4JIllegalStateException("Instance id can not be null. Function not initialized properly");
        }
        for (String varName : variables) {
            if (!this.isPlaceHolder(varName)) continue;
            this.placeHolderFunctions.add(function.getOwnName());
        }
        this.incomingArgs.put(variables, function);
        this.incomingArgsReverse.put(function.getOwnName(), variables);
        for (String variableName : variables) {
            List<DifferentialFunction> funcs = this.functionsArgsFor.get(variableName);
            if (funcs == null) {
                funcs = new ArrayList<DifferentialFunction>();
                this.functionsArgsFor.put(variableName, funcs);
            }
            funcs.add(function);
        }
    }

    public void addArgsFor(SDVariable[] variables, DifferentialFunction function) {
        String[] varNames = new String[variables.length];
        for (int i = 0; i < varNames.length; ++i) {
            if (variables[i] == null) {
                throw new ND4JIllegalStateException("Found null variable at index " + i);
            }
            varNames[i] = variables[i].getVarName();
        }
        this.addArgsFor(varNames, function);
    }

    public boolean hasArgs(int[] function) {
        return this.incomingArgs.containsKey(function);
    }

    public boolean hasArgs(DifferentialFunction function) {
        DifferentialFunction args;
        String[] vertexIdArgs = this.incomingArgsReverse.get(function.getOwnName());
        return vertexIdArgs != null && (args = this.incomingArgs.get(vertexIdArgs)) != null;
    }

    public DifferentialFunction[] functions() {
        Collection<DifferentialFunction> ret = this.functionInstancesById.values();
        return ret.toArray(new DifferentialFunction[ret.size()]);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.variableMap != null ? this.variableMap.hashCode() : 0);
        return result;
    }

    public static SameDiff create(SameDiff originalSameDiff) {
        DifferentialFunctionFactory differentialFunctionFactory;
        SameDiff ret = SameDiff.builder().variableMap(originalSameDiff.variableMap).sameDiffFunctionInstances(originalSameDiff.sameDiffFunctionInstances).build();
        ret.functionFactory = differentialFunctionFactory = new DifferentialFunctionFactory(ret);
        return ret;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SameDiff sameDiff = (SameDiff)o;
        if (this.variableMap != null ? !this.variableMap.equals(sameDiff.variableMap) : sameDiff.variableMap != null) {
            return false;
        }
        if (this.sameDiffFunctionDefinitionMap != null ? !this.sameDiffFunctionDefinitionMap.equals(sameDiff.sameDiffFunctionDefinitionMap) : sameDiff.sameDiffFunctionDefinitionMap != null) {
            return false;
        }
        return this.sameDiffFunctionInstances != null ? this.sameDiffFunctionInstances.equals(sameDiff.sameDiffFunctionInstances) : sameDiff.sameDiffFunctionInstances == null;
    }

    public static SameDiff create() {
        return new SameDiff();
    }

    public INDArray[] eval(Map<String, INDArray> inputs) {
        SameDiff execPipeline = this.dup();
        List opExecAction = (List)execPipeline.exec().getRight();
        if (opExecAction.isEmpty()) {
            throw new IllegalStateException("No ops found to execute.");
        }
        INDArray[] ret = new INDArray[opExecAction.size()];
        for (int i = 0; i < ret.length; ++i) {
            String varName = ((DifferentialFunction)opExecAction.get(i)).outputVariables()[0].getVarName();
            ret[i] = execPipeline.getArrForVarName(varName);
        }
        return ret;
    }

    public SameDiff dup() {
        Cloner cloner = SameDiff.newCloner();
        return (SameDiff)cloner.deepClone((Object)this);
    }

    public long numElements() {
        long ret = 0L;
        for (SDVariable variable : this.variables()) {
            ret += (long)ArrayUtil.prod((int[])variable.getShape());
        }
        return ret;
    }

    private void initWorkspace() {
        this.workspace = Nd4j.getWorkspaceManager().createNewWorkspace(WorkspaceConfiguration.builder().initialSize(this.memoryForGraph()).policyAllocation(AllocationPolicy.OVERALLOCATE).policyLearning(LearningPolicy.FIRST_LOOP).build());
        Nd4j.getWorkspaceManager().setWorkspaceForCurrentThread(this.workspace);
    }

    public List<SDVariable> variables() {
        return new ArrayList<SDVariable>(this.variableMap.values());
    }

    public SDVariable one(String name, int[] shape) {
        return this.var(name, shape, new ConstantInitScheme('f', 1.0));
    }

    public SDVariable onesLike(SDVariable input) {
        return this.onesLike(null, input);
    }

    public SDVariable onesLike(String name, SDVariable input) {
        return this.f().onesLike(name, input);
    }

    public SDVariable zero(String name, int[] shape) {
        return this.var(name, shape, new ZeroInitScheme());
    }

    public SDVariable zerosLike(SDVariable input) {
        return this.zerosLike(null, input);
    }

    public SDVariable zerosLike(String name, SDVariable input) {
        return this.f().zerosLike(name, input);
    }

    public SDVariable var(String name, int[] shape, WeightInitScheme weightInitScheme) {
        if (this.variableMap.containsKey(name) && this.variableMap.get(name).getArr() != null) {
            return this.variableMap.get(name);
        }
        if (name == null || name.length() < 1) {
            throw new IllegalArgumentException("Name for variable must be defined");
        }
        if (this.workspace == null) {
            this.initWorkspace();
        }
        SDVariable ret = SDVariable.builder().sameDiff(this).shape(shape).weightInitScheme(weightInitScheme).varName(name).build();
        this.addVariable(ret);
        this.variableMap.put(name, ret);
        return ret;
    }

    public SDVariable var(String name, int[] shape) {
        return this.var(name, shape, new ZeroInitScheme());
    }

    public SDVariable var(final SDVariable arr) {
        if (this.variableMap.containsKey(arr.getVarName()) && this.variableMap.get(arr.getVarName()).getArr() != null) {
            return this.variableMap.get(arr.getVarName());
        }
        if (arr.getVarName() == null || arr.getVarName().length() < 1) {
            throw new IllegalArgumentException("Name for variable must be defined");
        }
        if (arr == null) {
            throw new IllegalArgumentException("Array for " + arr.getVarName() + " must not be null");
        }
        if (this.workspace == null) {
            this.initWorkspace();
        }
        SDVariable ret = SDVariable.builder().sameDiff(this).shape(arr.getShape()).varName(arr.getVarName()).weightInitScheme(new NDArraySupplierInitScheme(new NDArraySupplierInitScheme.NDArraySupplier(){

            @Override
            public INDArray getArr() {
                if (arr.getArr() == null) {
                    INDArray retArr = arr.getWeightInitScheme().create(arr.getShape());
                    SameDiff.this.associateArrayWithVariable(retArr, arr);
                }
                return arr.getArr();
            }
        })).build();
        this.variableMap.put(arr.getVarName(), ret);
        return ret;
    }

    public void removeArgFromFunction(String varName, DifferentialFunction function) {
        SDVariable[] args = function.args();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].getVarName().equals(varName)) continue;
            String[] reverseArgs = this.incomingArgsReverse.get(function.getOwnName());
            this.incomingArgs.remove(reverseArgs);
            this.incomingArgsReverse.remove(function.getOwnName());
            ArrayList<String> newArgs = new ArrayList<String>(args.length - 1);
            for (int arg = 0; arg < args.length; ++arg) {
                if (reverseArgs[arg].equals(varName)) continue;
                newArgs.add(reverseArgs[arg]);
            }
            String[] newArgsArr = newArgs.toArray(new String[newArgs.size()]);
            this.incomingArgs.put(newArgsArr, function);
            this.incomingArgsReverse.put(function.getOwnName(), newArgsArr);
            break;
        }
    }

    public SDVariable var(String name, INDArray arr) {
        if (this.variableMap.containsKey(name) && this.variableMap.get(name).getArr() != null) {
            return this.variableMap.get(name);
        }
        if (name == null || name.length() < 1) {
            throw new IllegalArgumentException("Name for variable must be defined");
        }
        if (arr == null) {
            throw new IllegalArgumentException("Array for " + name + " must not be null");
        }
        if (this.workspace == null) {
            this.initWorkspace();
        }
        final INDArray arrRef = arr.migrate();
        SDVariable ret = SDVariable.builder().sameDiff(this).shape(arr.shape()).varName(name).weightInitScheme(new NDArraySupplierInitScheme(new NDArraySupplierInitScheme.NDArraySupplier(){

            @Override
            public INDArray getArr() {
                return arrRef;
            }
        })).build();
        this.associateArrayWithVariable(arr, ret);
        if (ArrayUtil.prod((int[])arr.shape()) == 1) {
            ret.setScalarValue(arr.getDouble(0));
        }
        this.addVariable(ret);
        if (this.getShapeForVarName(name) == null) {
            this.putShapeForVarName(name, arr.shape());
        }
        this.reverseArrayLookup.put(arr, ret);
        this.variableMap.put(name, ret);
        return ret;
    }

    public SDVariable getVariable(String name) {
        return this.variableMap.get(name);
    }

    public SDVariable getGradForVariable(String varName) {
        return this.gradients.get(varName);
    }

    public void setGradientForVariableName(String variableName, SDVariable variable) {
        if (variable == null) {
            throw new ND4JIllegalStateException("Unable to set null gradient for variable name " + variableName);
        }
        this.gradients.put(variableName, variable);
    }

    public SDVariable getForwardVariableForVertexId(int vertexId) {
        return this.forwardVarForGrad.get(vertexId);
    }

    public void setForwardVariableForVarName(String varName, SDVariable forwardVariable) {
        this.forwardVarForGrad.put(varName, forwardVariable);
    }

    public SDVariable grad(String varName) {
        if (!this.sameDiffFunctionInstances.containsKey("grad")) {
            throw new IllegalStateException("Unable to obtain gradient. Please run execBackwards() first.");
        }
        SameDiff grad = this.getFunction("grad");
        SDVariable var = grad.getVariable(varName);
        return this.getFunction("grad").getGradForVariable(var.getVarName());
    }

    public SDVariable avgPooling2d(SDVariable[] inputs, Pooling2DConfig pooling2DConfig) {
        return this.avgPooling2d(null, inputs, pooling2DConfig);
    }

    public SDVariable avgPooling2d(String name, SDVariable[] inputs, Pooling2DConfig pooling2DConfig) {
        SDVariable ret = this.f().avgPooling2d(inputs, pooling2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable maxPooling2d(SDVariable[] inputs, Pooling2DConfig pooling2DConfig) {
        return this.maxPooling2d(null, inputs, pooling2DConfig);
    }

    public SDVariable maxPooling2d(String name, SDVariable[] inputs, Pooling2DConfig pooling2DConfig) {
        SDVariable ret = this.f().maxPooling2d(inputs, pooling2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable avgPooling3d(SDVariable[] inputs, Pooling3DConfig pooling3DConfig) {
        return this.avgPooling3d(null, inputs, pooling3DConfig);
    }

    public SDVariable avgPooling3d(String name, SDVariable[] inputs, Pooling3DConfig pooling3DConfig) {
        SDVariable ret = this.f().avgPooling3d(inputs, pooling3DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable maxPooling3d(SDVariable[] inputs, Pooling3DConfig pooling3DConfig) {
        return this.maxPooling3d(null, inputs, pooling3DConfig);
    }

    public SDVariable maxPooling3d(String name, SDVariable[] inputs, Pooling3DConfig pooling3DConfig) {
        SDVariable ret = this.f().maxPooling3d(inputs, pooling3DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable conv1d(SDVariable[] inputs, Conv1DConfig conv1DConfig) {
        return this.conv1d(null, inputs, conv1DConfig);
    }

    public SDVariable conv1d(String name, SDVariable[] inputs, Conv1DConfig conv1DConfig) {
        SDVariable ret = this.f().conv1d(inputs, conv1DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable localResponseNormalization(SDVariable inputs, LocalResponseNormalizationConfig lrnConfig) {
        return this.localResponseNormalization(null, inputs, lrnConfig);
    }

    public SDVariable localResponseNormalization(String name, SDVariable inputs, LocalResponseNormalizationConfig lrnConfig) {
        SDVariable ret = this.f().localResponseNormalization(inputs, lrnConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable conv2d(SDVariable[] inputs, Conv2DConfig conv2DConfig) {
        return this.conv2d(null, inputs, conv2DConfig);
    }

    public SDVariable conv2d(String name, SDVariable[] inputs, Conv2DConfig conv2DConfig) {
        SDVariable ret = this.f().conv2d(inputs, conv2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable depthWiseConv2d(SDVariable[] inputs, Conv2DConfig depthConv2DConfig) {
        return this.depthWiseConv2d(null, inputs, depthConv2DConfig);
    }

    public SDVariable depthWiseConv2d(String name, SDVariable[] inputs, Conv2DConfig depthConv2DConfig) {
        SDVariable ret = this.f().depthWiseConv2d(inputs, depthConv2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable sconv2d(SDVariable[] inputs, Conv2DConfig conv2DConfig) {
        return this.sconv2d(null, inputs, conv2DConfig);
    }

    public SDVariable sconv2d(String name, SDVariable[] inputs, Conv2DConfig conv2DConfig) {
        SDVariable ret = this.f().sconv2d(inputs, conv2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable deconv2d(SDVariable[] inputs, DeConv2DConfig deconv2DConfig) {
        return this.deconv2d(null, inputs, deconv2DConfig);
    }

    public SDVariable deconv2d(String name, SDVariable[] inputs, DeConv2DConfig deconv2DConfig) {
        SDVariable ret = this.f().deconv2d(inputs, deconv2DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable conv3d(SDVariable[] inputs, Conv3DConfig conv3DConfig) {
        return this.conv3d(null, inputs, conv3DConfig);
    }

    public SDVariable conv3d(String name, SDVariable[] inputs, Conv3DConfig conv3DConfig) {
        SDVariable ret = this.f().conv3d(inputs, conv3DConfig);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable batchNorm(SDVariable input, SDVariable mean, SDVariable variance, SDVariable gamma, SDVariable beta, boolean applyGamma, boolean applyBeta, double epsilon) {
        return this.batchNorm(null, input, mean, variance, gamma, beta, applyGamma, applyBeta, epsilon);
    }

    public SDVariable batchNorm(String name, SDVariable input, SDVariable mean, SDVariable variance, SDVariable gamma, SDVariable beta, boolean applyGamma, boolean applyBeta, double epsilon) {
        SDVariable res = this.f().batchNorm(input, mean, variance, gamma, beta, applyGamma, applyBeta, epsilon);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable scalar(String name, double value) {
        return this.var(name, Nd4j.scalar(value));
    }

    public SDVariable gte(SDVariable iX, double iy) {
        return this.gte(null, iX, iy);
    }

    public SDVariable lte(SDVariable iX, double iy) {
        return this.lte(null, iX, iy);
    }

    public SDVariable gt(SDVariable iX, double iy) {
        return this.gt(null, iX, iy);
    }

    public SDVariable lt(SDVariable iX, double iy) {
        return this.lt(null, iX, iy);
    }

    public SDVariable neq(SDVariable iX, double iy) {
        return this.neq(null, iX, iy);
    }

    public SDVariable eq(SDVariable iX, double iy) {
        return this.eq(null, iX, iy);
    }

    public SDVariable gte(SDVariable iX, SDVariable iy) {
        return this.gte(null, iX, iy);
    }

    public SDVariable lte(SDVariable iX, SDVariable iy) {
        return this.lte(null, iX, iy);
    }

    public SDVariable gt(SDVariable iX, SDVariable iy) {
        return this.gt(null, iX, iy);
    }

    public SDVariable lt(SDVariable iX, SDVariable iy) {
        return this.lt(null, iX, iy);
    }

    public SDVariable neq(SDVariable iX, SDVariable iy) {
        return this.neq(null, iX, iy);
    }

    public SDVariable eq(SDVariable iX, SDVariable iy) {
        return this.eq(null, iX, iy);
    }

    public SDVariable or(SDVariable iX, SDVariable iy) {
        return this.or(null, iX, iy);
    }

    public SDVariable and(SDVariable iX, SDVariable iY) {
        return this.and(null, iX, iY);
    }

    public SDVariable and(String name, SDVariable ix, SDVariable iy) {
        SDVariable result = this.f().and(ix, iy);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable xor(SDVariable ix, SDVariable iy) {
        return this.xor(null, ix, iy);
    }

    public SDVariable xor(String name, SDVariable ix, SDVariable iy) {
        SDVariable result = this.f().xor(ix, iy);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable abs(SDVariable ix) {
        return this.abs(null, ix);
    }

    public SDVariable abs(String name, SDVariable ix) {
        SDVariable result = this.f().abs(ix);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable neg(SDVariable iX) {
        return this.neg(null, iX);
    }

    public SDVariable cos(SDVariable iX) {
        return this.cos(null, iX);
    }

    public SDVariable sin(SDVariable iX) {
        return this.sin(null, iX);
    }

    public SDVariable tan(SDVariable iX) {
        return this.tan(null, iX);
    }

    public SDVariable invertPermutation(SDVariable input) {
        return this.invertPermutation(null, input);
    }

    public SDVariable invertPermutation(String name, SDVariable input) {
        SDVariable ret = this.f().invertPermutation(input, false);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable acos(SDVariable iX) {
        return this.acos(null, iX);
    }

    public SDVariable asin(SDVariable iX) {
        return this.asin(null, iX);
    }

    public SDVariable atan(SDVariable iX) {
        return this.atan(null, iX);
    }

    public SDVariable atan2(SDVariable y, SDVariable x) {
        return this.atan2(null, y, x);
    }

    public SDVariable atan2(String name, SDVariable y, SDVariable x) {
        SDVariable ret = this.f().atan2(y, x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable cosh(SDVariable iX) {
        return this.cosh(null, iX);
    }

    public SDVariable sinh(SDVariable iX) {
        return this.sinh(null, iX);
    }

    public SDVariable tanh(SDVariable iX) {
        return this.tanh(null, iX);
    }

    public SDVariable acosh(SDVariable iX) {
        return this.acosh(null, iX);
    }

    public SDVariable asinh(SDVariable iX) {
        return this.asinh(null, iX);
    }

    public SDVariable atanh(SDVariable iX) {
        return this.atanh(null, iX);
    }

    public SDVariable exp(SDVariable iX) {
        return this.exp(null, iX);
    }

    public SDVariable rsqrt(SDVariable iX) {
        return this.rsqrt(null, iX);
    }

    public SDVariable expm1(SDVariable iX) {
        return this.expm1(null, iX);
    }

    public SDVariable log1p(SDVariable iX) {
        return this.log1p(null, iX);
    }

    public SDVariable isInfinite(SDVariable iX) {
        return this.isInfinite(null, iX);
    }

    public SDVariable isNaN(SDVariable iX) {
        return this.isNaN(null, iX);
    }

    public SDVariable round(SDVariable iX) {
        return this.round(null, iX);
    }

    public SDVariable isFinite(SDVariable iX) {
        return this.isFinite(null, iX);
    }

    public SDVariable log(SDVariable iX) {
        return this.log(null, iX);
    }

    public SDVariable cube(SDVariable iX) {
        return this.cube(null, iX);
    }

    public SDVariable pow(SDVariable iX, double value) {
        return this.pow(null, iX, value);
    }

    public SDVariable sqrt(SDVariable iX) {
        return this.sqrt(null, iX);
    }

    public SDVariable square(SDVariable iX) {
        return this.square(null, iX);
    }

    public SDVariable floor(SDVariable iX) {
        return this.floor(null, iX);
    }

    public SDVariable ceil(SDVariable x) {
        return this.ceil(null, x);
    }

    public SDVariable ceil(String name, SDVariable x) {
        SDVariable ret = this.f().ceil(x);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable clipByValue(SDVariable x, double clipValueMin, double clipValueMax) {
        return this.clipByValue(null, x, clipValueMin, clipValueMax);
    }

    public SDVariable clipByValue(String name, SDVariable x, double clipValueMin, double clipValueMax) {
        SDVariable ret = this.f().clipByValue(x, clipValueMin, clipValueMax);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable clipByNorm(SDVariable x, double clipValue) {
        return this.clipByNorm(null, x, clipValue);
    }

    public SDVariable clipByNorm(String name, SDVariable x, double clipValue) {
        SDVariable ret = this.f().clipByNorm(x, clipValue);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable relu(SDVariable iX, double cutoff) {
        return this.relu(null, iX, cutoff);
    }

    public SDVariable relu6(SDVariable iX, double cutoff) {
        return this.relu6(null, iX, cutoff);
    }

    public SDVariable softmax(SDVariable iX) {
        return this.softmax(null, iX);
    }

    public SDVariable logSoftmax(SDVariable iX) {
        return this.logSoftmax(null, iX);
    }

    public SDVariable logSoftmax(String name, SDVariable iX) {
        SDVariable ret = this.f().logSoftmax(iX);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable selu(SDVariable iX) {
        return this.selu(null, iX);
    }

    public SDVariable selu(String name, SDVariable iX) {
        SDVariable ret = this.f().selu(iX);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable mergeAdd(SDVariable ... iX) {
        return this.mergeAdd((String)null, iX);
    }

    public SDVariable mergeAdd(String name, SDVariable[] iX) {
        SDVariable ret = this.f().mergeadd(iX);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable batchToSpace(SDVariable iX, int[] blocks, int[][] crops) {
        return this.batchToSpace(null, iX, blocks, crops);
    }

    public SDVariable batchToSpace(String name, SDVariable iX, int[] blocks, int[][] crops) {
        SDVariable ret = this.f().batchToSpace(iX, blocks, crops);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable depthToSpace(SDVariable iX, int blockSize, String dataFormat) {
        return this.depthToSpace(null, iX, blockSize, dataFormat);
    }

    public SDVariable depthToSpace(String name, SDVariable iX, int blockSize, String dataFormat) {
        SDVariable ret = this.f().depthToSpace(iX, blockSize, dataFormat);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable spaceToBatch(SDVariable iX, int[] blocks, int[][] padding) {
        return this.spaceToBatch(null, iX, blocks, padding);
    }

    public SDVariable spaceToBatch(String name, SDVariable iX, int[] blocks, int[][] padding) {
        SDVariable ret = this.f().spaceToBatch(iX, blocks, padding);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable spaceToDepth(SDVariable iX, int blockSize, String dataFormat) {
        return this.spaceToDepth(null, iX, blockSize, dataFormat);
    }

    public SDVariable spaceToDepth(String name, SDVariable iX, int blockSize, String dataFormat) {
        SDVariable ret = this.f().spaceToDepth(iX, blockSize, dataFormat);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable[] dynamicPartition(SDVariable iX, SDVariable partitions, int numPartitions) {
        return this.dynamicPartition(null, iX, partitions, numPartitions);
    }

    public SDVariable[] dynamicPartition(String[] name, SDVariable iX, SDVariable partitions, int numPartitions) {
        SDVariable[] ret = this.f().dynamicPartition(iX, partitions, numPartitions);
        return this.updateVariableNamesAndReferences(ret, name);
    }

    public SDVariable dynamicStitch(SDVariable[] indices, SDVariable[] iX) {
        return this.dynamicStitch(null, indices, iX);
    }

    public SDVariable dynamicStitch(String name, SDVariable[] indices, SDVariable[] iX) {
        SDVariable ret = this.f().dynamicStitch(indices, iX);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable dilation2D(SDVariable df, SDVariable weights, int[] strides, int[] rates, boolean isSameMode) {
        return this.dilation2D(null, df, weights, strides, rates, isSameMode);
    }

    public SDVariable dilation2D(String name, SDVariable df, SDVariable weights, int[] strides, int[] rates, boolean isSameMode) {
        SDVariable ret = this.f().dilation2D(df, weights, strides, rates, isSameMode);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable shape(SDVariable df) {
        return this.shape(null, df);
    }

    public SDVariable shape(String name, SDVariable df) {
        SDVariable ret = this.f().shape(df);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable cross(SDVariable a, SDVariable b) {
        return this.cross(null, a, b);
    }

    public SDVariable cross(String name, SDVariable a, SDVariable b) {
        SDVariable ret = this.f().cross(a, b);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable gather(SDVariable df, int axis, int[] broadcast) {
        return this.gather(null, df, axis, broadcast);
    }

    public SDVariable gather(String name, SDVariable df, int axis, int[] broadcast) {
        SDVariable ret = this.f().gather(df, axis, broadcast);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable gatherNd(SDVariable df, SDVariable indices) {
        return this.gatherNd(null, df, indices);
    }

    public SDVariable gatherNd(String name, SDVariable df, SDVariable indices) {
        SDVariable ret = this.f().gatherNd(df, indices);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable repeat(SDVariable df, int axis) {
        return this.repeat(null, df, axis);
    }

    public SDVariable repeat(String name, SDVariable df, int axis) {
        SDVariable ret = this.f().repeat(df, axis);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable stack(SDVariable[] values, int axis) {
        return this.stack(null, values, axis);
    }

    public SDVariable stack(String name, SDVariable[] values, int axis) {
        SDVariable ret = this.f().stack(values, axis);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable parallel_stack(SDVariable[] values) {
        return this.parallel_stack(null, values);
    }

    public SDVariable parallel_stack(String name, SDVariable[] values) {
        SDVariable ret = this.f().parallel_stack(values);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable[] unstack(SDVariable value, int axis) {
        return this.unstack(null, value, axis);
    }

    public SDVariable[] unstack(String[] names, SDVariable value, int axis) {
        SDVariable[] ret = this.f().unstack(value, axis);
        return this.updateVariableNamesAndReferences(ret, names);
    }

    public SDVariable erf(SDVariable iX) {
        return this.erf(null, iX);
    }

    public SDVariable erf(String name, SDVariable iX) {
        SDVariable ret = this.f().erf(iX);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable erfc(SDVariable iX) {
        return this.erfc(null, iX);
    }

    public SDVariable erfc(String name, SDVariable iX) {
        SDVariable ret = this.f().erfc(iX);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable diag(SDVariable iX) {
        return this.diag(null, iX);
    }

    public SDVariable diag(String name, SDVariable iX) {
        SDVariable ret = this.f().diag(iX);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable diagPart(SDVariable iX) {
        return this.diagPart(null, iX);
    }

    public SDVariable diagPart(String name, SDVariable iX) {
        SDVariable ret = this.f().diagPart(iX);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable oneHot(SDVariable indices, int depth) {
        return this.oneHot(null, indices, depth, -1, 1.0, 0.0);
    }

    public SDVariable oneHot(SDVariable indices, int depth, int axis, double on, double off) {
        return this.oneHot(null, indices, depth, axis, on, off);
    }

    public SDVariable oneHot(String name, SDVariable indices, int depth) {
        return this.oneHot(name, indices, depth, -1, 1.0, 0.0);
    }

    public SDVariable oneHot(String name, SDVariable indices, int depth, int axis, double on, double off) {
        SDVariable ret = this.f().onehot(indices, depth, axis, on, off);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable reciprocal(SDVariable a) {
        return this.reciprocal(null, a);
    }

    public SDVariable reciprocal(String name, SDVariable a) {
        SDVariable ret = this.f().reciprocal(a);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable gradientBackwardsMarker(SDVariable iX) {
        return this.gradientBackwardsMarker(this.generateNewVarName(new GradientBackwardsMarker().opName(), 0), iX);
    }

    public SDVariable hardTanh(SDVariable iX) {
        return this.hardTanh(null, iX);
    }

    public SDVariable hardTanhDerivative(SDVariable iX) {
        return this.hardTanhDerivative(null, iX);
    }

    public SDVariable sigmoid(SDVariable iX) {
        return this.sigmoid(null, iX);
    }

    public SDVariable sigmoidDerivative(SDVariable iX, SDVariable wrt) {
        return this.sigmoidDerivative(null, iX, wrt);
    }

    public SDVariable logSigmoid(SDVariable iX) {
        return this.logSigmoid(null, iX);
    }

    public SDVariable logSigmoid(String name, SDVariable iX) {
        SDVariable ret = this.f().logSigmoid(iX);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable sign(SDVariable iX) {
        return this.sign(null, iX);
    }

    public SDVariable softsign(SDVariable iX) {
        return this.softsign(null, iX);
    }

    public SDVariable softsignDerivative(SDVariable iX) {
        return this.softsignDerivative(null, iX);
    }

    public SDVariable softplus(SDVariable iX) {
        return this.softplus(null, iX);
    }

    public SDVariable swish(SDVariable iX) {
        return this.swish(null, iX);
    }

    public SDVariable swish(String name, SDVariable iX) {
        SDVariable ret = this.f().swish(iX);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable elu(SDVariable iX) {
        return this.elu(null, iX);
    }

    public SDVariable eluDerivative(SDVariable iX) {
        return this.eluDerivative(null, iX);
    }

    public SDVariable leakyRelu(SDVariable iX, double cutoff) {
        return this.leakyRelu(null, iX, cutoff);
    }

    public SDVariable mean(SDVariable iX) {
        return this.mean(null, iX);
    }

    public SDVariable mean(SDVariable iX, int ... dimension) {
        return this.mean(null, iX, dimension);
    }

    public SDVariable standardDeviation(SDVariable iX, boolean biasCorrected, int ... dimensions) {
        return this.standardDeviation(null, iX, biasCorrected, dimensions);
    }

    public SDVariable variance(SDVariable iX, boolean biasCorrected, int ... dimensions) {
        return this.variance(null, iX, biasCorrected, dimensions);
    }

    public SDVariable sum(SDVariable iX, int ... dimensions) {
        return this.sum(null, iX, dimensions);
    }

    public SDVariable prod(SDVariable iX, int ... dimensions) {
        return this.prod(null, iX, dimensions);
    }

    public SDVariable max(SDVariable iX, int ... dimensions) {
        return this.max(null, iX, dimensions);
    }

    public SDVariable max(SDVariable first, SDVariable second) {
        return this.max(null, first, second);
    }

    public SDVariable max(String name, SDVariable first, SDVariable second) {
        SDVariable result = this.f().max(first, second);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable countZero(SDVariable input) {
        return this.countZero(null, input);
    }

    public SDVariable countZero(String name, SDVariable input) {
        SDVariable res = this.f().countZero(input);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable zeroFraction(SDVariable input) {
        return this.zeroFraction(null, input);
    }

    public SDVariable zeroFraction(String name, SDVariable input) {
        SDVariable res = this.f().zeroFraction(input);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable countNonZero(SDVariable input) {
        return this.countNonZero(null, input);
    }

    public SDVariable countNonZero(String name, SDVariable input) {
        SDVariable res = this.f().countNonZero(input);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable min(SDVariable iX, int ... dimensions) {
        return this.min(null, iX, dimensions);
    }

    public SDVariable min(SDVariable first, SDVariable second) {
        return this.min(null, first, second);
    }

    public SDVariable min(String name, SDVariable first, SDVariable second) {
        SDVariable result = this.f().min(first, second);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable argmax(SDVariable in, int ... dimensions) {
        return this.argmax(null, in, dimensions);
    }

    public SDVariable argmax(String name, SDVariable in, int ... dimensions) {
        SDVariable ret = this.f().argmax(in, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable argmin(SDVariable in, int ... dimensions) {
        return this.argmin(null, in, dimensions);
    }

    public SDVariable argmin(String name, SDVariable in, int ... dimensions) {
        SDVariable ret = this.f().argmin(in, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable cumsum(SDVariable in, boolean exclusive, boolean reverse, int ... dimensions) {
        return this.cumsum(null, in, exclusive, reverse, dimensions);
    }

    public SDVariable cumsum(String name, SDVariable in, boolean exclusive, boolean reverse, int ... dimensions) {
        SDVariable ret = this.f().cumsum(in, exclusive, reverse, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable cumprod(SDVariable in, boolean exclusive, boolean reverse, int ... dimensions) {
        return this.cumprod(null, in, exclusive, reverse, dimensions);
    }

    public SDVariable cumprod(String name, SDVariable in, boolean exclusive, boolean reverse, int ... dimensions) {
        SDVariable ret = this.f().cumprod(in, exclusive, reverse, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable biasAdd(SDVariable input, SDVariable bias) {
        return this.biasAdd(null, input, bias);
    }

    public SDVariable biasAdd(String name, SDVariable input, SDVariable bias) {
        SDVariable ret = this.f().biasAdd(input, bias);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable reshape(SDVariable iX, int ... shape) {
        return this.reshape(null, iX, shape);
    }

    public SDVariable reverse(SDVariable x, int ... dimensions) {
        return this.reverse(null, x, dimensions);
    }

    public SDVariable reverse(String name, SDVariable x, int ... dimensions) {
        SDVariable ret = this.f().reverse(x, dimensions);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable reverseSequence(String name, SDVariable x, SDVariable seq_lengths, int seqDim, int batchDim) {
        SDVariable ret = this.f().reverseSequence(x, seq_lengths, seqDim, batchDim);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable reverseSequence(String name, SDVariable x, SDVariable seq_lengths) {
        SDVariable ret = this.f().reverseSequence(x, seq_lengths);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable reverseSequence(SDVariable x, SDVariable seq_lengths, int seqDim, int batchDim) {
        return this.reverseSequence(null, x, seq_lengths, seqDim, batchDim);
    }

    public SDVariable reverseSequence(SDVariable x, SDVariable seq_lengths) {
        return this.reverseSequence(null, x, seq_lengths);
    }

    public SDVariable sequenceMask(String name, SDVariable lengths, SDVariable maxLen) {
        SDVariable ret = this.f().sequenceMask(lengths, maxLen);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable sequenceMask(SDVariable lengths, SDVariable maxLen) {
        return this.sequenceMask(null, lengths, maxLen);
    }

    public SDVariable sequenceMask(String name, SDVariable lengths, int maxLen) {
        SDVariable ret = this.f().sequenceMask(lengths, maxLen);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable sequenceMask(SDVariable lengths, int maxLen) {
        return this.sequenceMask(null, lengths, maxLen);
    }

    public SDVariable sequenceMask(String name, SDVariable lengths) {
        SDVariable ret = this.f().sequenceMask(lengths);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable sequenceMask(SDVariable lengths) {
        SDVariable ret = this.f().sequenceMask(lengths);
        return this.updateVariableNameAndReference(ret, null);
    }

    public SDVariable assign(SDVariable x, SDVariable y) {
        return this.assign(null, x, y);
    }

    public SDVariable assign(String name, SDVariable x, SDVariable y) {
        SDVariable ret = this.f().assign(x, y);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable transpose(SDVariable iX) {
        return this.transpose(null, iX);
    }

    public SDVariable permute(SDVariable iX, int ... dimensions) {
        return this.permute(null, iX, dimensions);
    }

    public SDVariable rollAxis(SDVariable x, int axis) {
        return this.rollAxis(null, x, axis);
    }

    public SDVariable concat(int dimension, SDVariable ... inputs) {
        return this.concat(null, dimension, inputs);
    }

    public SDVariable[] moments(SDVariable input, int ... axes) {
        return this.moments(null, input, axes);
    }

    public SDVariable[] moments(String[] name, SDVariable input, int ... axes) {
        SDVariable[] res = this.f().moments(input, axes);
        return this.updateVariableNamesAndReferences(res, name);
    }

    public SDVariable[] normalizeMoments(SDVariable counts, SDVariable means, SDVariable variances, double shift) {
        return this.normalizeMoments(null, counts, means, variances, shift);
    }

    public SDVariable[] normalizeMoments(String[] name, SDVariable counts, SDVariable means, SDVariable variances, double shift) {
        SDVariable[] res = this.f().normalizeMoments(counts, means, variances, shift);
        return this.updateVariableNamesAndReferences(res, name);
    }

    public SDVariable tile(SDVariable iX, int[] repeat) {
        return this.tile(null, iX, repeat);
    }

    public SDVariable fill(SDVariable shape, double value) {
        return this.fill(null, shape, value);
    }

    public SDVariable dropout(SDVariable input, double p) {
        return this.dropout(null, input, p);
    }

    public SDVariable dropout(String name, SDVariable input, double p) {
        SDVariable res = this.f().dropout(input, p);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable xwPlusB(SDVariable input, SDVariable weights, SDVariable bias) {
        return this.xwPlusB(null, input, weights, bias);
    }

    public SDVariable xwPlusB(String name, SDVariable input, SDVariable weights, SDVariable bias) {
        SDVariable res = this.f().xwPlusB(input, weights, bias);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable reluLayer(SDVariable input, SDVariable weights, SDVariable bias) {
        return this.reluLayer(null, input, weights, bias);
    }

    public SDVariable reluLayer(String name, SDVariable input, SDVariable weights, SDVariable bias) {
        SDVariable res = this.f().reluLayer(input, weights, bias);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable mmul(SDVariable x, SDVariable y, MMulTranspose transpose) {
        return this.mmul(null, x, y, transpose);
    }

    public SDVariable mmul(SDVariable x, SDVariable y) {
        return this.mmul(null, x, y);
    }

    public SDVariable tensorMmul(SDVariable x, SDVariable y, int[][] dimensions) {
        return this.tensorMmul(null, x, y, dimensions);
    }

    public SDVariable cosineSimilarity(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return this.cosineSimilarity(this.generateNewVarName("cosinesimilarity", 0), iX, i_y, dimensions);
    }

    public SDVariable euclideanDistance(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return this.euclideanDistance(this.generateNewVarName("euclidean", 0), iX, i_y, dimensions);
    }

    public SDVariable manhattanDistance(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return this.manhattanDistance(this.generateNewVarName("manhattan", 0), iX, i_y, dimensions);
    }

    public SDVariable cosineDistance(SDVariable ix, SDVariable iy, int ... dimensions) {
        return this.cosineDistance(null, ix, iy, dimensions);
    }

    public SDVariable cosineDistance(String name, SDVariable ix, SDVariable iy, int ... dimensions) {
        SDVariable result = this.functionFactory.cosineDistance(ix, iy, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable hammingDistance(SDVariable ix, SDVariable iy, int ... dimensions) {
        return this.hammingDistance(null, ix, iy, dimensions);
    }

    public SDVariable hammingDistance(String name, SDVariable ix, SDVariable iy, int ... dimensions) {
        SDVariable result = this.functionFactory.hammingDistance(ix, iy, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable jaccardDistance(SDVariable ix, SDVariable iy, int ... dimensions) {
        return this.jaccardDistance(null, ix, iy, dimensions);
    }

    public SDVariable jaccardDistance(String name, SDVariable ix, SDVariable iy, int ... dimensions) {
        SDVariable result = this.functionFactory.jaccardDistance(ix, iy, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossBinaryXENT(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return this.lossBinaryXENT(this.generateNewVarName(new LossBinaryXENT().opName(), 0), iX, i_y, dimensions);
    }

    public SDVariable lossCosineSimilarity(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return this.lossCosineSimilarity(this.generateNewVarName(new LossCosineProximity().opName(), 0), iX, i_y, dimensions);
    }

    public SDVariable lossHinge(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return this.lossHinge(this.generateNewVarName(new LossHinge().opName(), 0), iX, i_y, dimensions);
    }

    public SDVariable lossKLD(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return this.lossKLD(this.generateNewVarName(new LossKLD().opName(), 0), iX, i_y, dimensions);
    }

    public SDVariable lossL1(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return this.lossL1(this.generateNewVarName(new LossL1().opName(), 0), iX, i_y, dimensions);
    }

    public SDVariable lossL2(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return this.lossL2(this.generateNewVarName(new LossL2().opName(), 0), iX, i_y, dimensions);
    }

    public SDVariable lossMAE(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return this.lossMAE(this.generateNewVarName(new LossMAE().opName(), 0), iX, i_y, dimensions);
    }

    public SDVariable lossMSE(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return this.lossMSE(this.generateNewVarName(new LossMSE().opName(), 0), iX, i_y, dimensions);
    }

    public SDVariable lossMCXENT(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return this.lossMCXENT(this.generateNewVarName(new LossMCXENT().opName(), 0), iX, i_y, dimensions);
    }

    public SDVariable lossMSLE(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return this.lossMSLE(this.generateNewVarName(new LossMSLE().opName(), 0), iX, i_y, dimensions);
    }

    public SDVariable lossNegativeLogLikelihood(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return this.lossNegativeLogLikelihood(this.generateNewVarName(new LossNegativeLogLikelihood().opName(), 0), iX, i_y, dimensions);
    }

    public SDVariable lossPoisson(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return this.lossPoisson(this.generateNewVarName(new LossPoisson().opName(), 0), iX, i_y, dimensions);
    }

    public SDVariable lossSquaredHinge(SDVariable iX, SDVariable i_y, int ... dimensions) {
        return this.lossSquaredHinge(this.generateNewVarName(new LossSquaredHinge().opName(), 0), iX, i_y, dimensions);
    }

    public SDVariable gradientBackwardsMarker(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.gradientBackwardsMarker(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable neq(String name, SDVariable iX, double iy) {
        SDVariable result = this.functionFactory.neq(iX, iy);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable eq(String name, SDVariable iX, double iy) {
        SDVariable result = this.functionFactory.eq(iX, iy);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable gte(String name, SDVariable iX, double iy) {
        SDVariable result = this.functionFactory.gte(iX, iy);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lte(String name, SDVariable iX, double iy) {
        SDVariable result = this.functionFactory.lte(iX, iy);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable gt(String name, SDVariable iX, double iy) {
        SDVariable result = this.functionFactory.gt(iX, iy);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lt(String name, SDVariable iX, double iy) {
        SDVariable result = this.functionFactory.lt(iX, iy);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable neq(String name, SDVariable iX, SDVariable iy) {
        SDVariable result = this.functionFactory.neq(iX, iy);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable eq(String name, SDVariable iX, SDVariable iy) {
        SDVariable result = this.functionFactory.eq(iX, iy);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable gte(String name, SDVariable iX, SDVariable iy) {
        SDVariable result = this.functionFactory.gte(iX, iy);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lte(String name, SDVariable iX, SDVariable iy) {
        SDVariable result = this.functionFactory.lte(iX, iy);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable gt(String name, SDVariable iX, SDVariable iy) {
        SDVariable result = this.functionFactory.gt(iX, iy);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lt(String name, SDVariable iX, SDVariable iy) {
        SDVariable result = this.functionFactory.lt(iX, iy);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable or(String name, SDVariable iX, SDVariable iy) {
        SDVariable result = this.functionFactory.or(iX, iy);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable neg(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.neg(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable isNonDecreasing(SDVariable iX) {
        return this.isNonDecreasing(null, iX);
    }

    public SDVariable isNonDecreasing(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.isNonDecreasing(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable isStrictlyIncreasing(SDVariable iX) {
        return this.isStrictlyIncreasing(null, iX);
    }

    public SDVariable isStrictlyIncreasing(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.isStrictlyIncreasing(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable isNumericTensor(SDVariable iX) {
        return this.isNumericTensor(null, iX);
    }

    public SDVariable isNumericTensor(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.isNumericTensor(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable cos(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.cos(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sin(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.sin(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable tan(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.tan(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable acos(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.acos(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable asin(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.asin(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable atan(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.atan(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable cosh(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.cosh(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sinh(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.sinh(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable tanh(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.tanh(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable acosh(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.acosh(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable asinh(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.asinh(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable atanh(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.atanh(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable exp(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.exp(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable expm1(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.expm1(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable rsqrt(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.rsqrt(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable log(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.log(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable log1p(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.log1p(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable isFinite(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.isFinite(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable isInfinite(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.isInfinite(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable isNaN(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.isNaN(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable round(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.round(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable pow(String name, SDVariable iX, double value) {
        SDVariable result = this.functionFactory.pow(iX, value);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable cube(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.cube(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sqrt(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.sqrt(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable square(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.square(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable floor(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.floor(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable relu(String name, SDVariable iX, double cutoff) {
        SDVariable result = this.functionFactory.relu(iX, cutoff);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable relu6(String name, SDVariable iX, double cutoff) {
        SDVariable result = this.functionFactory.relu6(iX, cutoff);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable softmax(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.softmax(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable softmaxDerivative(String name, SDVariable iX, SDVariable wrt) {
        SDVariable result = this.functionFactory.softmaxDerivative(iX, wrt);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable hardTanh(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.hardTanh(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable hardTanhDerivative(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.hardTanhDerivative(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sigmoid(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.sigmoid(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sigmoidDerivative(String name, SDVariable iX, SDVariable wrt) {
        SDVariable result = this.functionFactory.sigmoidDerivative(iX, wrt);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sign(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.sign(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable softsign(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.softsign(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable softsignDerivative(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.softsignDerivative(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable softplus(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.softplus(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable elu(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.elu(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable eluDerivative(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.eluDerivative(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable leakyRelu(String name, SDVariable iX, double alpha) {
        SDVariable result = this.functionFactory.leakyRelu(iX, alpha);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable leakyReluDerivative(String name, SDVariable iX, double alpha) {
        SDVariable result = this.functionFactory.leakyReluDerivative(iX, alpha);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable mean(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.mean(iX, new int[0]);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable mean(String name, SDVariable iX, int ... dimension) {
        SDVariable result = this.functionFactory.mean(iX, dimension);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable standardDeviation(String name, SDVariable iX, boolean biasCorrected, int ... dimensions) {
        SDVariable result = this.functionFactory.std(iX, biasCorrected, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable variance(String name, SDVariable iX, boolean biasCorrected, int ... dimensions) {
        SDVariable result = this.functionFactory.variance(iX, biasCorrected, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sum(String name, SDVariable iX, int ... dimensions) {
        SDVariable result = this.functionFactory.sum(iX, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable prod(String name, SDVariable iX, int ... dimensions) {
        SDVariable result = this.functionFactory.prod(iX, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable max(String name, SDVariable iX, int ... dimensions) {
        SDVariable result = this.functionFactory.max(iX, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable min(String name, SDVariable iX, int ... dimensions) {
        SDVariable result = this.functionFactory.min(iX, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable norm1(String name, SDVariable ix, int ... dimensions) {
        SDVariable result = this.f().norm1(ix, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable norm2(String name, SDVariable ix, int ... dimensions) {
        SDVariable result = this.f().norm2(ix, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable normmax(String name, SDVariable ix, int ... dimensions) {
        SDVariable result = this.f().normmax(ix, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable reshape(String name, SDVariable iX, int ... shape) {
        SDVariable result = this.functionFactory.reshape(iX, shape);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable transpose(String name, SDVariable iX) {
        SDVariable result = this.functionFactory.transpose(iX);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable permute(String name, SDVariable iX, int ... dimensions) {
        SDVariable result = this.functionFactory.permute(iX, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable rollAxis(String name, SDVariable x, int axis) {
        SDVariable result = this.functionFactory.rollAxis(x, axis);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable fill(String name, SDVariable shape, double value) {
        SDVariable result = this.functionFactory.fill(shape, value);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable concat(String name, int dimension, SDVariable ... inputs) {
        SDVariable result = this.functionFactory.concat(dimension, inputs);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable tile(String name, SDVariable iX, int[] repeat) {
        SDVariable result = this.functionFactory.tile(iX, repeat);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable mmul(String name, SDVariable x, SDVariable y, MMulTranspose transpose) {
        SDVariable result = this.functionFactory.mmul(x, y, transpose);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable mmul(String name, SDVariable x, SDVariable y) {
        return this.mmul(name, x, y, MMulTranspose.allFalse());
    }

    public SDVariable tensorMmul(String name, SDVariable x, SDVariable y, int[][] dimensions) {
        SDVariable result = this.functionFactory.tensorMmul(x, y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable cosineSimilarity(String name, SDVariable iX, SDVariable i_y, int ... dimensions) {
        SDVariable cosim = this.functionFactory.cosineSimilarity(iX, i_y, dimensions);
        return this.updateVariableNameAndReference(cosim, name);
    }

    public SDVariable euclideanDistance(String name, SDVariable iX, SDVariable i_y, int ... dimensions) {
        SDVariable result = this.functionFactory.euclideanDistance(iX, i_y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable manhattanDistance(String name, SDVariable iX, SDVariable i_y, int ... dimensions) {
        SDVariable result = this.functionFactory.manhattanDistance(iX, i_y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable sigmoidCrossEntropyWithLogits(SDVariable logits, SDVariable weights, SDVariable labels, int reductionMode, double labelSmoothing) {
        return this.sigmoidCrossEntropyWithLogits(null, logits, weights, labels, reductionMode, labelSmoothing);
    }

    public SDVariable sigmoidCrossEntropyWithLogits(String name, SDVariable logits, SDVariable weights, SDVariable labels, int reductionMode, double labelSmoothing) {
        SDVariable res = this.f().sigmoidCrossEntropyWithLogits(logits, weights, labels, reductionMode, labelSmoothing);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable softmaxCrossEntropyWithLogits(SDVariable logits, SDVariable weights, SDVariable labels, int reductionMode, double labelSmoothing) {
        return this.softmaxCrossEntropyWithLogits(null, logits, weights, labels, reductionMode, labelSmoothing);
    }

    public SDVariable softmaxCrossEntropyWithLogits(String name, SDVariable logits, SDVariable weights, SDVariable labels, int reductionMode, double labelSmoothing) {
        SDVariable res = this.f().softmaxCrossEntropyWithLogits(logits, weights, labels, reductionMode, labelSmoothing);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable weightedCrossEntropyWithLogits(SDVariable targets, SDVariable inputs, SDVariable weights) {
        return this.weightedCrossEntropyWithLogits(null, targets, inputs, weights);
    }

    public SDVariable weightedCrossEntropyWithLogits(String name, SDVariable targets, SDVariable inputs, SDVariable weights) {
        SDVariable res = this.f().weightedCrossEntropyWithLogits(targets, inputs, weights);
        return this.updateVariableNameAndReference(res, name);
    }

    public SDVariable lossBinaryXENT(String name, SDVariable iX, SDVariable i_y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossBinaryXENT(iX, i_y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossCosineSimilarity(String name, SDVariable iX, SDVariable i_y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossCosineSimilarity(iX, i_y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossHinge(String name, SDVariable iX, SDVariable i_y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossHinge(iX, i_y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossKLD(String name, SDVariable iX, SDVariable i_y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossKLD(iX, i_y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossL1(String name, SDVariable iX, SDVariable i_y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossL1(iX, i_y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossL2(String name, SDVariable iX, SDVariable i_y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossL2(iX, i_y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossMAE(String name, SDVariable iX, SDVariable i_y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossMAE(iX, i_y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossMSE(String name, SDVariable iX, SDVariable i_y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossMSE(iX, i_y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossMCXENT(String name, SDVariable iX, SDVariable i_y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossMCXENT(iX, i_y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossMSLE(String name, SDVariable iX, SDVariable i_y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossMSLE(iX, i_y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossNegativeLogLikelihood(String name, SDVariable iX, SDVariable i_y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossNegativeLogLikelihood(iX, i_y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossPoisson(String name, SDVariable iX, SDVariable i_y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossPoisson(iX, i_y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable lossSquaredHinge(String name, SDVariable iX, SDVariable i_y, int ... dimensions) {
        SDVariable result = this.functionFactory.lossSquaredHinge(iX, i_y, dimensions);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable expandDims(SDVariable ix, int axis) {
        return this.expandDims(null, ix, axis);
    }

    public SDVariable expandDims(String name, SDVariable ix, int axis) {
        SDVariable result = this.f().expandDims(ix, axis);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable squeeze(SDVariable ix, int axis) {
        return this.squeeze(null, ix, axis);
    }

    public SDVariable squeeze(String name, SDVariable ix, int axis) {
        SDVariable result = this.f().squeeze(ix, axis);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable confusionMatrix(SDVariable labels, SDVariable predictions) {
        return this.confusionMatrix((String)null, labels, predictions);
    }

    public SDVariable confusionMatrix(String name, SDVariable labels, SDVariable pred) {
        SDVariable result = this.f().confusionMatrix(labels, pred);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable confusionMatrix(SDVariable labels, SDVariable pred, Integer numClasses) {
        return this.confusionMatrix(null, labels, pred, numClasses);
    }

    public SDVariable confusionMatrix(String name, SDVariable labels, SDVariable pred, Integer numClasses) {
        SDVariable result = this.f().confusionMatrix(labels, pred, numClasses);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable confusionMatrix(SDVariable labels, SDVariable pred, SDVariable weights) {
        return this.confusionMatrix(null, labels, pred, weights);
    }

    public SDVariable confusionMatrix(String name, SDVariable labels, SDVariable pred, SDVariable weights) {
        SDVariable result = this.f().confusionMatrix(labels, pred, weights);
        return this.updateVariableNameAndReference(result, name);
    }

    public SDVariable confusionMatrix(SDVariable labels, SDVariable pred, Integer numClasses, SDVariable weights) {
        return this.confusionMatrix(null, labels, pred, numClasses, weights);
    }

    public SDVariable confusionMatrix(String name, SDVariable labels, SDVariable pred, Integer numClasses, SDVariable weights) {
        SDVariable result = this.f().confusionMatrix(labels, pred, numClasses, weights);
        return this.updateVariableNameAndReference(result, name);
    }

    public void addVariable(SDVariable variable) {
        if (this.variableMap == null) {
            this.variableMap = new HashMap<String, SDVariable>();
        }
        Preconditions.checkState((variable.getSameDiff() == this ? 1 : 0) != 0, (Object)"Samediff instance must be the same.");
        if (this.variableMap.containsKey(variable.getVarName()) && !this.variableMap.get(variable.getVarName()).equals(variable)) {
            throw new IllegalArgumentException("Variable already found with variable opName " + variable.getVarName());
        }
        Preconditions.checkState((variable.getSameDiff() == this ? 1 : 0) != 0, (Object)"Same diff instance for variable must be the same!");
        this.variableMap.put(variable.getVarName(), variable);
    }

    public String generateNewVarName(String baseName, int argIndex) {
        if (this.getVariable(baseName) == null && argIndex == 0) {
            return baseName;
        }
        int count = 1;
        String name = baseName + "_" + count + (argIndex > 0 ? ":" + argIndex : "");
        while (this.getVariable(name) != null) {
            name = baseName + "_" + ++count + (argIndex > 0 ? ":" + argIndex : "");
        }
        if (this.getVariable(name) != null) {
            throw new ND4JIllegalStateException("Converged on already generated variable!");
        }
        return name;
    }

    public SDVariable lstm(String baseName, LSTMCellConfiguration configuration) {
        return new LSTMCell(this, configuration).outputVariables(baseName)[0];
    }

    public SDVariable sruCell(SRUCellConfiguration configuration) {
        return new SRUCell(this, configuration).outputVariables()[0];
    }

    public SDVariable sru(SRUConfiguration configuration) {
        return new SRU(this, configuration).outputVariables()[0];
    }

    public SDVariable gru(GRUCellConfiguration configuration) {
        return new GRUCell(this, configuration).outputVariables()[0];
    }

    public SDVariable sruCell(String baseName, SRUCellConfiguration configuration) {
        return new SRUCell(this, configuration).outputVariables(baseName)[0];
    }

    public SDVariable sru(String baseName, SRUConfiguration configuration) {
        return new SRU(this, configuration).outputVariables(baseName)[0];
    }

    public SDVariable gru(String baseName, GRUCellConfiguration configuration) {
        return new GRUCell(this, configuration).outputVariables(baseName)[0];
    }

    public SDVariable slice(SDVariable input, int[] begin, int[] size) {
        return this.slice(null, input, begin, size);
    }

    public SDVariable slice(String name, SDVariable input, int[] begin, int[] size) {
        SDVariable ret = this.f().slice(input, begin, size);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable stridedSlice(SDVariable input, int[] begin, int[] end, int[] strides) {
        return this.stridedSlice(null, input, begin, end, strides);
    }

    public SDVariable stridedSlice(String name, SDVariable input, int[] begin, int[] end, int[] strides) {
        return this.stridedSlice(name, input, begin, end, strides, 0, 0, 0, 0, 0);
    }

    public SDVariable stridedSlice(SDVariable in, int[] begin, int[] end, int[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        return this.stridedSlice(null, in, begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask);
    }

    public SDVariable stridedSlice(String name, SDVariable in, int[] begin, int[] end, int[] strides, int beginMask, int endMask, int ellipsisMask, int newAxisMask, int shrinkAxisMask) {
        SDVariable ret = this.f().stridedSlice(in, begin, end, strides, beginMask, endMask, ellipsisMask, newAxisMask, shrinkAxisMask);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterAdd(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDVariable ret = this.f().scatterAdd(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterMul(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDVariable ret = this.f().scatterMul(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterSub(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDVariable ret = this.f().scatterSub(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterDiv(String name, SDVariable ref, SDVariable indices, SDVariable updates) {
        SDVariable ret = this.f().scatterDiv(ref, indices, updates);
        return this.updateVariableNameAndReference(ret, name);
    }

    public SDVariable scatterAdd(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterAdd(null, ref, indices, updates);
    }

    public SDVariable scatterMul(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterMul(null, ref, indices, updates);
    }

    public SDVariable scatterSub(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterSub(null, ref, indices, updates);
    }

    public SDVariable scatterDiv(SDVariable ref, SDVariable indices, SDVariable updates) {
        return this.scatterDiv(null, ref, indices, updates);
    }

    public SDVariable[] generateOutputVariableForOp(DifferentialFunction function, String baseName) {
        List<int[]> outputShape;
        if (baseName == null || baseName.isEmpty() && this.getBaseNameForFunction(function) != null) {
            baseName = this.getBaseNameForFunction(function);
        }
        if (baseName == null) {
            baseName = function.opName();
        }
        if ((outputShape = function.calculateOutputShape()) == null || outputShape.isEmpty()) {
            if (function instanceof CustomOp) {
                CustomOp customOp = (CustomOp)((Object)function);
                CustomOpDescriptor descriptor = customOp.getDescriptor();
                if (descriptor == null || descriptor.getNumOutputs() <= 0) {
                    throw new ND4JIllegalStateException("No output variables found!");
                }
                char ordering = 'c';
                if (function.args()[0].getArr() != null) {
                    ordering = function.args()[0].getArr().ordering();
                }
                SDVariable[] ret = new SDVariable[descriptor.getNumOutputs()];
                for (int i = 0; i < ret.length; ++i) {
                    String newName;
                    SDVariable checkGet = this.getVariable(baseName);
                    if (checkGet == null) {
                        checkGet = this.var(this.generateNewVarName(baseName, i), null, new ZeroInitScheme(ordering));
                    } else if (i > 0 && !this.importedVarName.contains(baseName)) {
                        newName = this.generateNewVarName(baseName, i);
                        checkGet = this.getVariable(newName);
                    }
                    if (checkGet == null) {
                        newName = this.generateNewVarName(baseName, i);
                        checkGet = this.var(newName, null, new ZeroInitScheme(ordering));
                    }
                    ret[i] = checkGet;
                }
                return ret;
            }
            if (function instanceof BaseOp && outputShape.isEmpty()) {
                SDVariable[] ret = new SDVariable[1];
                SDVariable checkGet = this.getVariable(baseName);
                char ordering = 'c';
                if (function.args()[0].getArr() != null) {
                    ordering = function.args()[0].getArr().ordering();
                }
                if (checkGet == null) {
                    checkGet = this.var(baseName, null, new ZeroInitScheme(ordering));
                } else if (!this.importedVarName.contains(baseName)) {
                    String newName = this.generateNewVarName(baseName, 0);
                    checkGet = this.var(newName, null, new ZeroInitScheme(ordering));
                }
                if (checkGet == null) {
                    checkGet = this.var(baseName, null, new ZeroInitScheme(ordering));
                }
                ret[0] = checkGet;
                return ret;
            }
        }
        char ordering = 'c';
        if (function.args()[0].getArr() != null) {
            ordering = function.args()[0].getArr().ordering();
        }
        SDVariable[] ret = new SDVariable[outputShape.size()];
        String ownName = function.getOwnName();
        String rootName = baseName;
        for (int i = 0; i < ret.length; ++i) {
            int[] shape = outputShape.get(i);
            baseName = rootName + (i > 0 ? ":" + i : "");
            SDVariable checkGet = this.getVariable(baseName);
            if (checkGet == null) {
                checkGet = this.var(baseName, shape, new ZeroInitScheme(ordering));
            } else if (shape != null && !this.shapeAlreadyExistsForVarName(checkGet.getVarName())) {
                this.putShapeForVarName(checkGet.getVarName(), shape);
            } else if (!(shape != null && this.shapeAlreadyExistsForVarName(checkGet.getVarName()) || this.importedVarName.contains(baseName))) {
                int count = 1;
                String name = baseName + "_" + count + (i > 0 ? ":" + i : "");
                while (this.getVariable(name) != null) {
                    name = baseName + "_" + ++count + (i > 0 ? ":" + i : "");
                }
                if (this.getVariable(name) != null) {
                    throw new ND4JIllegalStateException("Converged on already generated variable!");
                }
                checkGet = this.var(name, shape, new ZeroInitScheme(ordering));
            }
            if (checkGet == null) {
                checkGet = this.var(baseName + (i > 0 ? ":" + i : ""), shape, new ZeroInitScheme(ordering));
            }
            ret[i] = checkGet;
        }
        return ret;
    }

    public SDVariable[] generateOutputVariableForOp(DifferentialFunction function) {
        return this.generateOutputVariableForOp(function, function.opName());
    }

    public SameDiff getFunction(String functionName) {
        return this.sameDiffFunctionInstances.get(functionName);
    }

    public INDArray execAndEndResult(List<DifferentialFunction> ops) {
        List<DifferentialFunction> exec = this.exec(ops);
        Op op = (Op)((Object)exec.get(exec.size() - 1));
        return op.z();
    }

    public INDArray execAndEndResult() {
        this.resolveVariablesWith(Collections.emptyMap());
        List exec = (List)this.exec().getRight();
        SDVariable output = ((DifferentialFunction)exec.get(exec.size() - 1)).outputVariables()[0];
        return output.getArr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INDArray yetAnotherExecMethod(@NonNull Map<String, INDArray> inputs) {
        if (inputs == null) {
            throw new NullPointerException("inputs");
        }
        if (!this.wasRegistered.get()) {
            SameDiff sameDiff = this;
            synchronized (sameDiff) {
                if (!this.wasRegistered.get()) {
                    ByteBuffer bb = this.asFlatBuffers();
                    BytePointer ptr = new BytePointer(bb);
                    Nd4j.getExecutioner().registerGraph(this.hashCode(), (Pointer)ptr);
                    this.wasRegistered.set(true);
                }
            }
        }
        LinkedHashMap<String, INDArray> newMap = new LinkedHashMap<String, INDArray>();
        Set<String> keySet = inputs.keySet();
        for (String key : keySet) {
            SDVariable vx = this.variableMap.get(key);
            newMap.put(vx.getVarName(), inputs.get(key));
        }
        Map<String, INDArray> result = Nd4j.getExecutioner().executeGraph(this.hashCode(), newMap);
        if (result.size() == 0) {
            throw new ND4JIllegalStateException("Execution failed");
        }
        ArrayList<INDArray> list = new ArrayList<INDArray>(result.values());
        return list.get(list.size() - 1);
    }

    public List<DifferentialFunction> exec(List<DifferentialFunction> ops) {
        for (int i = 0; i < ops.size(); ++i) {
            Op op = (Op)((Object)ops.get(i));
            Nd4j.getExecutioner().exec(op);
        }
        return ops;
    }

    public While whileStatement(SameDiffConditional sameDiffConditional, SameDiffFunctionDefinition conditionBody, SameDiffFunctionDefinition loopBody, SDVariable[] inputVars) {
        return While.builder().inputVars(inputVars).condition(conditionBody).predicate(sameDiffConditional).trueBody(loopBody).parent(this).blockName("while-" + UUID.randomUUID().toString()).build();
    }

    public If ifStatement(SameDiffConditional conditional, SameDiffFunctionDefinition conditionBody, SameDiffFunctionDefinition trueBody, SameDiffFunctionDefinition falseBody, SDVariable[] inputVars) {
        return If.builder().conditionBody(conditionBody).falseBody(falseBody).trueBody(trueBody).predicate(conditional).inputVars(inputVars).parent(this).blockName("if-" + UUID.randomUUID().toString()).build();
    }

    public SDVariable invokeFunctionOn(String functionName, SameDiff with) {
        SameDiff instance = this.sameDiffFunctionInstances.get(functionName);
        SDVariable ret = instance.invokeGraphOn(with);
        return ret;
    }

    public SameDiff defineFunction(String function, SameDiffFunctionDefinition functionDefinition, SDVariable[] variables) {
        if (!this.sameDiffFunctionInstances.containsKey(function)) {
            SameDiff sub = SameDiff.create();
            sub.workspace = this.workspace;
            SDVariable[] ret = new SDVariable[variables.length];
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = sub.var(variables[i]);
            }
            functionDefinition.define(sub, null, ret);
            this.sameDiffFunctionInstances.put(function, sub);
        }
        return this.sameDiffFunctionInstances.get(function);
    }

    public void defineFunction(String function, SameDiffFunctionDefinition functionDefinition) {
        this.defineFunction(function, functionDefinition, new LinkedHashMap<String, INDArray>());
    }

    public void defineFunction(String function, SameDiffFunctionDefinition functionDefinition, Map<String, INDArray> inputs) {
        if (!this.sameDiffFunctionInstances.containsKey(function)) {
            SameDiff sub = SameDiff.create();
            sub.workspace = this.workspace;
            functionDefinition.define(sub, inputs, null);
            this.sameDiffFunctionInstances.put(function, sub);
        }
    }

    public INDArray execAndEndResult(String functionName) {
        return this.sameDiffFunctionInstances.get(functionName).execAndEndResult();
    }

    public Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> exec(String functionName) {
        if (this.debugMode) {
            return this.sameDiffFunctionInstances.get(functionName).enableDebugMode().exec();
        }
        return this.sameDiffFunctionInstances.get(functionName).exec();
    }

    public List<DifferentialFunction> exec(String functionName, List<DifferentialFunction> cachedOps) {
        return this.sameDiffFunctionInstances.get(functionName).exec(cachedOps);
    }

    public Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> execBackwards() {
        final SameDiff outer = this;
        if (this.getFunction("grad") == null) {
            this.defineFunction("grad", new SameDiffFunctionDefinition(){

                @Override
                public SDVariable[] define(SameDiff sameDiff, Map<String, INDArray> inputs, SDVariable[] variableInputs) {
                    if (SameDiff.this.debugMode) {
                        sameDiff.enableDebugMode();
                    }
                    outer.invokeGraphOn(sameDiff);
                    ArrayList allFunctions = new ArrayList(sameDiff.functionInstancesById.values());
                    if (allFunctions.isEmpty()) {
                        throw new ND4JIllegalStateException("No ops found!");
                    }
                    for (DifferentialFunction func : allFunctions) {
                        SDVariable[] args;
                        if (func instanceof SDVariable) continue;
                        for (SDVariable arg : args = func.args()) {
                            arg.setSameDiff(sameDiff);
                        }
                        SDVariable[] outputs = func.outputVariables();
                        for (SDVariable output : outputs) {
                            output.setSameDiff(sameDiff);
                        }
                        func.setSameDiff(sameDiff);
                    }
                    SDVariable[] initialOuts = ((DifferentialFunction)allFunctions.get(allFunctions.size() - 1)).outputVariables();
                    SDVariable firstBackward = initialOuts[0];
                    SDVariable initialGrad = sameDiff.var("one-var", Nd4j.scalar(1.0));
                    sameDiff.forwardVarForGrad.put(firstBackward.getVarName(), initialGrad);
                    sameDiff.gradients.put(firstBackward.getVarName(), initialGrad);
                    SDVariable gradientBackwardsMarker = sameDiff.gradientBackwardsMarker(firstBackward);
                    allFunctions = new ArrayList(sameDiff.functionInstancesById.values());
                    Collections.reverse(allFunctions);
                    for (DifferentialFunction action : allFunctions) {
                        SDVariable[] args;
                        if (action instanceof GradientBackwardsMarker) {
                            log.warn("Action op state is null for " + action.opName());
                            continue;
                        }
                        DifferentialFunction currFunction = action;
                        Preconditions.checkState((currFunction.getSameDiff() == sameDiff ? 1 : 0) != 0, (Object)"Wrong samediff instance found!");
                        for (SDVariable arg : args = currFunction.outputVariables()) {
                            if (arg.getSameDiff() == sameDiff) continue;
                            arg.setSameDiff(sameDiff);
                        }
                        ArrayList<SDVariable> grads = new ArrayList<SDVariable>();
                        for (SDVariable varToGrad : args) {
                            SDVariable grad = varToGrad.gradient();
                            if (grad == null) {
                                throw new ND4JIllegalStateException("No gradient found for " + varToGrad.getVarName());
                            }
                            grads.add(grad);
                        }
                        List<SDVariable> object = currFunction.diff(grads);
                    }
                    if (sameDiff.isDebugMode()) {
                        for (SDVariable sdVariable : SameDiff.this.variables()) {
                            sdVariable.gradient();
                        }
                    }
                    return new SDVariable[]{sameDiff.var("grad", new int[]{1, 1})};
                }
            });
        }
        Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> forward = this.exec("grad");
        SameDiff grad = this.getFunction("grad");
        if (grad.isDebugMode()) {
            for (SDVariable sdVariable : grad.variables()) {
                sdVariable.gradient();
            }
        }
        return forward;
    }

    public INDArray execBackwardAndEndResult() {
        List backwards = (List)this.execBackwards().getRight();
        DifferentialFunction df = (DifferentialFunction)backwards.get(backwards.size() - 1);
        if (df instanceof Op) {
            return ((Op)((Object)df)).z();
        }
        if (df instanceof DynamicCustomOp) {
            return ((DynamicCustomOp)df).getOutputArgument(0);
        }
        return null;
    }

    public INDArray execWithPlaceHolderAndEndResult(Map<String, INDArray> inputs) {
        this.resolveVariablesWith(inputs);
        return this.execAndEndResult();
    }

    public void setOriginalPlaceHolderShape(String variableName, int[] shape) {
        if (!this.isPlaceHolder(variableName)) {
            throw new ND4JIllegalStateException("Vertex id " + variableName + " does not appear to be a place holder. Did you forget to call addPlaceHolder?");
        }
        if (shape == null) {
            throw new ND4JIllegalStateException("Null and 0 length shape arrays not allowed");
        }
        if (this.placeHolderOriginalShapes.containsKey(variableName) && !Arrays.equals(this.placeHolderOriginalShapes.get(variableName), shape)) {
            throw new ND4JIllegalStateException("Unable to add a new shape for vertex id " + variableName);
        }
        this.placeHolderOriginalShapes.put(variableName, shape);
    }

    public int[] getOriginalShapeForPlaceHolder(String varName) {
        return this.placeHolderOriginalShapes.get(varName);
    }

    public boolean isPlaceHolder(String varName) {
        return this.placeHolderVarNames.contains(varName);
    }

    public void addAsPlaceHolder(String varName) {
        this.placeHolderVarNames.add(varName);
        if (this.getVariable(varName) != null && this.getVariable(varName).getShape() != null) {
            this.placeHolderOriginalShapes.put(varName, this.getVariable(varName).getShape());
        }
    }

    public void resolveVariablesWith(Map<String, INDArray> arrays) {
        for (Map.Entry<String, INDArray> arrayEntry : arrays.entrySet()) {
            int[] originalShape;
            SDVariable varForName = this.getVariable(arrayEntry.getKey());
            if (varForName == null) {
                throw new ND4JIllegalStateException("No variable name found for " + arrayEntry.getKey());
            }
            if (!this.placeHolderOriginalShapes.containsKey(arrayEntry.getKey()) || (originalShape = this.placeHolderOriginalShapes.get(arrayEntry.getKey())).length != arrayEntry.getValue().rank()) continue;
            for (int i = 0; i < originalShape.length; ++i) {
                if (originalShape[i] == arrayEntry.getValue().shape()[i] || originalShape[i] < 1) continue;
                throw new ND4JIllegalStateException("Incompatible shape passed for variable. " + Arrays.toString(arrayEntry.getValue().shape()));
            }
        }
        for (Map.Entry<String, INDArray> entry : arrays.entrySet()) {
            if (!this.placeHolderVarNames.contains(entry.getKey())) {
                throw new ND4JIllegalStateException("Illegal variable " + entry.getKey() + " passed in. Variable found not to be a place holder variable");
            }
            int[] specifiedShape = this.getOriginalShapeForPlaceHolder(entry.getKey());
            if (!Shape.isPlaceholderShape(specifiedShape) && !Shape.shapeEquals(specifiedShape, entry.getValue().shape())) {
                throw new ND4JIllegalStateException("Place holder shape specified was " + Arrays.toString(specifiedShape) + " but array shape was " + Arrays.toString(entry.getValue().shape()));
            }
            this.updateShapeForVarName(entry.getKey(), entry.getValue().shape());
            this.associateArrayWithVariable(entry.getValue(), this.getVariable(entry.getKey()));
            this.updateArrayForVarName(entry.getKey(), entry.getValue());
        }
        for (String funcName : this.propertiesToResolve.keySet()) {
            DifferentialFunction func = this.functionInstancesById.get(funcName);
            if (!this.functionInstancesById.containsKey(funcName)) {
                throw new ND4JIllegalStateException("Unable to resolve function name " + funcName);
            }
            if (!(func instanceof CustomOp)) continue;
            CustomOp customOp = (CustomOp)((Object)func);
            customOp.populateInputsAndOutputsFromSameDiff();
        }
        this.resolvedVariables = true;
    }

    public boolean allPlaceHolderVariablesResolved() {
        for (String vertexId : this.placeHolderVarNames) {
            SDVariable var = this.getVariable(vertexId);
            if (var.getArr() != null) continue;
            return false;
        }
        return true;
    }

    public void putPlaceHolderForVariable(String varName, String ... placeHolderVariables) {
        for (String placeHolderVariable : placeHolderVariables) {
            if (this.variableMap.containsKey(placeHolderVariable)) continue;
            throw new ND4JIllegalStateException("No variable found for " + placeHolderVariable);
        }
        List<String[]> placeHolders = this.placeHolderMap.get(varName);
        if (placeHolders == null) {
            placeHolders = new ArrayList<String[]>();
            this.placeHolderMap.put(varName, placeHolders);
        }
        placeHolders.add(placeHolderVariables);
    }

    public boolean hasPlaceHolderVariables(String vertexId) {
        return this.placeHolderMap.containsKey(vertexId);
    }

    public List<String[]> getPlaceHoldersFor(String varName) {
        return this.placeHolderMap.get(varName);
    }

    public Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> execWithPlaceHolder(Map<String, INDArray> inputs) {
        this.resolveVariablesWith(inputs);
        return this.exec();
    }

    public List<SDVariable> getVariablesAssociatedWithFunctions(List<DifferentialFunction> functions) {
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>(functions.size());
        for (DifferentialFunction function : functions) {
            ret.addAll(Arrays.asList(function.outputVariables()));
        }
        return ret;
    }

    public SDVariable updateVariableNameAndReference(SDVariable varToUpdate, String newVarName) {
        if (varToUpdate == null) {
            throw new NullPointerException("Null input: No variable found for updating!");
        }
        if (newVarName == null && this.variableMap.containsKey(varToUpdate.getVarName())) {
            newVarName = this.generateNewVarName(varToUpdate.getVarName(), 0);
        }
        if (newVarName == null || varToUpdate.getVarName().equals(newVarName)) {
            return varToUpdate;
        }
        String oldVarName = varToUpdate.getVarName();
        varToUpdate.setVarName(newVarName);
        this.updateVariableName(oldVarName, newVarName);
        return varToUpdate;
    }

    public SDVariable[] updateVariableNamesAndReferences(SDVariable[] variablesToUpdate, String[] newVariableNames) {
        int numVariables = variablesToUpdate.length;
        SDVariable[] updatedVariables = new SDVariable[numVariables];
        for (int i = 0; i < numVariables; ++i) {
            SDVariable varToUpdate = variablesToUpdate[i];
            String name = newVariableNames == null ? null : newVariableNames[i];
            updatedVariables[i] = this.updateVariableNameAndReference(varToUpdate, name);
        }
        return updatedVariables;
    }

    public Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> exec() {
        if (!this.resolvedVariables) {
            this.resolveVariablesWith(new LinkedHashMap<String, INDArray>());
        }
        ArrayList<DifferentialFunction> ops = new ArrayList<DifferentialFunction>();
        this.localFlowPath.set(new FlowPath());
        FlowPath flowPath = this.localFlowPath.get();
        HashMap opMap = new HashMap();
        ArrayList<DifferentialFunction> funcs = new ArrayList<DifferentialFunction>(this.functionInstancesById.values());
        boolean onBackward = false;
        ArrayDeque<String> frames = new ArrayDeque<String>();
        boolean inFrame = false;
        boolean frameLeft = false;
        int exec_counter = 0;
        for (int i = 0; i < funcs.size(); ++i) {
            String frame_name;
            INDArray array;
            boolean shouldSkip;
            DifferentialFunction differentialFunction;
            block53: {
                String[] args;
                block52: {
                    ++exec_counter;
                    String opName = funcs.get(i).opName();
                    if (!onBackward && opName.equals(new GradientBackwardsMarker().opName())) {
                        onBackward = true;
                    }
                    if (opName.equals(new GradientBackwardsMarker().opName())) continue;
                    differentialFunction = funcs.get(i);
                    String ownName = differentialFunction.getOwnName();
                    flowPath.ensureNodeStateExists(differentialFunction.getOwnName());
                    if (differentialFunction instanceof SDVariable) continue;
                    args = this.getInputsForFunction(differentialFunction);
                    log.debug("Step: {}; Executing op {} for node [{}]", new Object[]{exec_counter, opName, ownName});
                    shouldSkip = false;
                    if (!(differentialFunction instanceof Merge)) break block52;
                    String string = args[0];
                    String arg1 = args[1];
                    if (flowPath.isActive(string) || flowPath.isActive(arg1)) break block53;
                    shouldSkip = true;
                    break block53;
                }
                if (!(differentialFunction instanceof Exit)) {
                    if (frameLeft) {
                        frameLeft = false;
                        String string = (String)frames.removeLast();
                        flowPath.activateFrame(string, false);
                        flowPath.forgetFrame(string);
                    }
                    for (String string : args) {
                        if (flowPath.isActive(string)) continue;
                        flowPath.markActive(differentialFunction.getOwnName(), false);
                        shouldSkip = true;
                        break;
                    }
                }
            }
            if (shouldSkip) continue;
            differentialFunction.resolvePropertiesFromSameDiffBeforeExecution();
            flowPath.markActive(differentialFunction.getOwnName(), true);
            if (differentialFunction instanceof LoopCond) {
                SDVariable[] sDVariableArray = this.getInputVariablesForFunction(differentialFunction);
                array = sDVariableArray[0].getArr();
                this.variableNameToArr.put(differentialFunction.getOwnName(), array.dup(array.ordering()));
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
                if ((int)array.getDouble(0) != 1) continue;
                String frameName = (String)frames.getLast();
                flowPath.incrementNumberOfCycles(frameName);
                continue;
            }
            if (differentialFunction instanceof Enter) {
                SDVariable[] sDVariableArray = this.getInputVariablesForFunction(differentialFunction);
                array = sDVariableArray[0].getArr();
                this.variableNameToArr.put(differentialFunction.getOwnName(), array.dup(array.ordering()));
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
                String frame_name3 = ((Enter)differentialFunction).getFrameName();
                if (flowPath.isRegisteredFrame(frame_name3)) continue;
                flowPath.registerFrame(frame_name3);
                frames.addLast(frame_name3);
                inFrame = true;
                continue;
            }
            if (differentialFunction instanceof Exit) {
                String string = (String)frames.getLast();
                ((Exit)differentialFunction).setFrameName(string);
                if (!flowPath.isFrameActive(string)) {
                    flowPath.markActive(differentialFunction.getOwnName(), false);
                    frameLeft = true;
                    continue;
                }
                if (flowPath.isRewindPlanned(string)) {
                    flowPath.planRewind(string, false);
                    int currentPosition = i;
                    i = flowPath.getRewindPosition(string);
                    int startPosition = i + 1;
                    flowPath.setRewindPosition(string, -1);
                    continue;
                }
                SDVariable[] inputs2 = this.getInputVariablesForFunction(differentialFunction);
                INDArray array2 = inputs2[0].getArr();
                this.variableNameToArr.put(differentialFunction.getOwnName(), array2.dup(array2.ordering()));
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
                frameLeft = true;
                continue;
            }
            if (differentialFunction instanceof NextIteration) {
                SDVariable[] sDVariableArray = this.getInputVariablesForFunction(differentialFunction);
                frame_name = (String)frames.getLast();
                INDArray array3 = sDVariableArray[0].getArr();
                this.variableNameToArr.put(differentialFunction.getOwnName(), array3.dup(array3.ordering()));
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
                if (flowPath.isRewindPlanned(frame_name)) continue;
                flowPath.planRewind(frame_name, true);
                continue;
            }
            if (differentialFunction instanceof Merge) {
                DifferentialFunction secondArg;
                SDVariable[] sDVariableArray = this.getInputVariablesForFunction(differentialFunction);
                String string = frame_name = frames.size() > 0 ? (String)frames.getLast() : null;
                if (frame_name != null) {
                    flowPath.activateFrame(frame_name, true);
                }
                if (frame_name != null) {
                    flowPath.setRewindPositionOnce(frame_name, i - 1);
                }
                if (sDVariableArray.length == 2 && (secondArg = this.functionInstancesById.get(sDVariableArray[1].getVarName())) != null && secondArg instanceof NextIteration) {
                    ((NextIteration)secondArg).setFrameName(frame_name);
                }
                if (flowPath.wasExecuted(sDVariableArray[1].getVarName())) {
                    INDArray array4 = sDVariableArray[1].getArr();
                    this.variableNameToArr.put(differentialFunction.getOwnName(), array4.dup(array4.ordering()));
                    flowPath.markExecuted(sDVariableArray[1].getVarName(), false);
                } else {
                    INDArray array2 = sDVariableArray[0].getArr();
                    this.variableNameToArr.put(differentialFunction.getOwnName(), array2.dup(array2.ordering()));
                }
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
                continue;
            }
            if (differentialFunction instanceof Switch) {
                ((CustomOp)((Object)differentialFunction)).populateInputsAndOutputsFromSameDiff();
                SDVariable[] sDVariableArray = this.getInputVariablesForFunction(differentialFunction);
                INDArray input = sDVariableArray[0].getArr();
                INDArray bool = sDVariableArray[1].getArr();
                if ((int)bool.getDouble(0) == 0) {
                    flowPath.setActiveBranch(differentialFunction.getOwnName(), 0);
                    flowPath.markActive(differentialFunction.getOwnName(), true);
                    flowPath.markActive(differentialFunction.getOwnName() + ":1", false);
                    this.variableNameToArr.put(differentialFunction.getOwnName(), input.dup(input.ordering()));
                } else {
                    flowPath.setActiveBranch(differentialFunction.getOwnName(), 1);
                    this.variableNameToArr.put(differentialFunction.getOwnName() + ":1", input.dup(input.ordering()));
                    flowPath.markActive(differentialFunction.getOwnName(), false);
                    flowPath.markActive(differentialFunction.getOwnName() + ":1", true);
                }
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
                continue;
            }
            if (differentialFunction instanceof If) {
                If if_ = (If)differentialFunction;
                if (!onBackward) {
                    if_.getPredicateExecution().exec();
                    if (if_.getTargetBoolean().getArr().sumNumber().doubleValue() > 0.0) {
                        if_.getLoopBodyExecution().exec();
                        if_.exectedTrueOrFalse(true);
                    } else {
                        if_.getFalseBodyExecution().exec();
                        if_.exectedTrueOrFalse(false);
                    }
                } else if (if_.getTrueBodyExecuted() != null) {
                    Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> execBackwards = null;
                    List<SDVariable> variablesForFunctions = null;
                    if (if_.getTrueBodyExecuted().booleanValue()) {
                        execBackwards = if_.getLoopBodyExecution().execBackwards();
                        variablesForFunctions = if_.getLoopBodyExecution().getVariablesAssociatedWithFunctions((List)execBackwards.getRight());
                    } else {
                        execBackwards = if_.getFalseBodyExecution().execBackwards();
                        variablesForFunctions = if_.getFalseBodyExecution().getVariablesAssociatedWithFunctions((List)execBackwards.getRight());
                    }
                    for (SDVariable variable : variablesForFunctions) {
                        SDVariable sDVariable = this.var(variable);
                    }
                } else {
                    throw new ND4JIllegalStateException("No body was run.");
                }
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
                ops.add(differentialFunction);
                continue;
            }
            if (differentialFunction instanceof While) {
                While while_ = (While)differentialFunction;
                if (!onBackward) {
                    SameDiff execBody = while_.getLoopBodyExecution();
                    while_.getPredicateExecution().exec();
                    while (while_.getTargetBoolean().getArr().sumNumber().doubleValue() > 0.0) {
                        execBody.exec();
                        while_.getPredicateExecution().exec();
                        while_.incrementLoopCounter();
                    }
                    ArrayList outputs = new ArrayList();
                    SDVariable[] sDVariableArray = new ArrayList<DifferentialFunction>(execBody.functionInstancesById.values()).get(execBody.functionInstancesById.values().size() - 1).outputVariables();
                    outputs.addAll(Arrays.asList(sDVariableArray));
                    while_.setOutputVars(outputs.toArray(new SDVariable[outputs.size()]));
                    ops.add(differentialFunction);
                } else {
                    Pair<Map<SDVariable, DifferentialFunction>, List<DifferentialFunction>> mapListPair = while_.getLoopBodyExecution().execBackwards();
                    for (SDVariable sDVariable : ((Map)mapListPair.getFirst()).keySet()) {
                        sDVariable.getArr().muli(while_.getNumLooped());
                    }
                }
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
                continue;
            }
            if (differentialFunction instanceof CustomOp) {
                DynamicCustomOp dynamicCustomOp = (DynamicCustomOp)differentialFunction;
                dynamicCustomOp.populateInputsAndOutputsFromSameDiff();
                dynamicCustomOp.assertValidForExecution();
                dynamicCustomOp.updateInputsFromSameDiff();
                Nd4j.getExecutioner().exec(dynamicCustomOp);
                flowPath.markExecuted(differentialFunction.getOwnName(), true);
                ops.add(dynamicCustomOp);
                continue;
            }
            if (!(differentialFunction instanceof Op)) continue;
            SDVariable[] sDVariableArray = this.getInputVariablesForFunction(differentialFunction);
            Op op = (Op)((Object)differentialFunction);
            op.setX(sDVariableArray[0].getArr());
            if (sDVariableArray.length == 2) {
                op.setY(sDVariableArray[1].getArr());
            }
            if (differentialFunction.getDimensions() == null) {
                Nd4j.getExecutioner().exec(op);
            } else if (op.isExecSpecial()) {
                op.exec();
            } else {
                int[] axes = differentialFunction.getDimensions();
                if (differentialFunction instanceof Accumulation) {
                    Accumulation accumulation = (Accumulation)((Object)differentialFunction);
                    Nd4j.getExecutioner().exec(accumulation, axes);
                    if (differentialFunction.outputVariables()[0].getArr() == null) {
                        SDVariable var = differentialFunction.outputVariables()[0];
                        this.updateArrayForVarName(var.getVarName(), accumulation.z());
                        this.updateShapeForVarName(var.getVarName(), accumulation.z().shape());
                    }
                } else if (differentialFunction instanceof BroadcastOp) {
                    BroadcastOp broadcastOp = (BroadcastOp)((Object)differentialFunction);
                    Nd4j.getExecutioner().exec(broadcastOp, axes);
                } else if (differentialFunction instanceof GradientOp) {
                    Nd4j.getExecutioner().exec(op);
                } else if (differentialFunction instanceof IndexAccumulation) {
                    IndexAccumulation indexAccumulation = (IndexAccumulation)((Object)differentialFunction);
                    Nd4j.getExecutioner().exec(indexAccumulation, axes);
                } else if (differentialFunction instanceof TransformOp) {
                    TransformOp transformOp = (TransformOp)((Object)differentialFunction);
                    Nd4j.getExecutioner().exec(transformOp, axes);
                }
            }
            flowPath.markExecuted(differentialFunction.getOwnName(), true);
            ops.add(differentialFunction);
        }
        return new Pair(opMap, ops);
    }

    public void printFunction(DifferentialFunction differentialFunction) {
        if (!this.logExecution) {
            return;
        }
        if (differentialFunction instanceof SDVariable) {
            return;
        }
        StringBuilder argShapes = new StringBuilder();
        for (SDVariable arg : differentialFunction.args()) {
            argShapes.append(" Variable " + arg.getVarName() + " Shape for " + Arrays.toString(arg.getShape()));
        }
        for (SDVariable func : differentialFunction.outputVariables()) {
            argShapes.append("  Output variable " + func.getVarName() + " is " + Arrays.toString(func.getShape()));
        }
        StringBuilder realShapes = new StringBuilder();
        for (SDVariable arg : differentialFunction.args()) {
            realShapes.append(" Input shape for " + arg.getVarName() + " is  " + Arrays.toString(this.getShapeForVarName(arg.getVarName())));
        }
        for (SDVariable arg : differentialFunction.outputVariables()) {
            realShapes.append(" Output shape for " + arg.getVarName() + " is  " + Arrays.toString(this.getShapeForVarName(arg.getVarName())));
        }
    }

    public static int[] permuteDataFormatForSameDiff(String dataFormat, boolean weights) {
        int i;
        String dl4jFormat = "NCHW";
        dataFormat = dataFormat.toUpperCase();
        int[] ret = new int[4];
        if (weights) {
            ret[0] = dataFormat.indexOf(87);
            ret[1] = dataFormat.indexOf(67);
            ret[2] = dataFormat.indexOf(78);
            ret[3] = dataFormat.indexOf(72);
            return ret;
        }
        for (i = 0; i < dataFormat.length(); ++i) {
            if ("NCHW".indexOf(dataFormat.charAt(i)) >= 0) continue;
            throw new ND4JIllegalStateException("Illegal convolution data format string passed in " + dataFormat + " must be some variant of NCHW");
        }
        for (i = 0; i < "NCHW".length(); ++i) {
            ret[i] = "NCHW".indexOf(dataFormat.charAt(i));
        }
        return ret;
    }

    public void updateVariable(String variableName, INDArray arr) {
        if (!this.variableNameToArr.containsKey(variableName)) {
            this.putArrayForVarName(variableName, arr);
        } else {
            this.updateArrayForVarName(variableName, arr);
        }
    }

    protected int asFlatNode(String name, @NonNull SameDiff scope, @NonNull FlatBufferBuilder bufferBuilder) {
        if (scope == null) {
            throw new NullPointerException("scope");
        }
        if (bufferBuilder == null) {
            throw new NullPointerException("bufferBuilder");
        }
        int scopeName = bufferBuilder.createString(name);
        int flatNode = FlatNode.createFlatNode(bufferBuilder, scopeName, scopeName, (byte)119, 10L, 0, 0, 0, (byte)0, 0, 0, 0, 0, -1, 0.0f, 0, 0);
        return flatNode;
    }

    public static Pair<String, Integer> parseVariable(@NonNull String varName) {
        if (varName == null) {
            throw new NullPointerException("varName");
        }
        if (!varName.contains(":")) {
            return Pair.pairOf((Object)varName, (Object)0);
        }
        String[] split = varName.split(":");
        Integer index = Integer.valueOf(split[split.length - 1]);
        if (split.length == 2) {
            return Pair.pairOf((Object)split[0], (Object)index);
        }
        StringBuilder builder = new StringBuilder();
        for (int e = 0; e < split.length - 1; ++e) {
            builder.append(split[e]);
            if (e >= split.length - 2) continue;
            builder.append(":");
        }
        return Pair.pairOf((Object)builder.toString(), (Object)index);
    }

    protected int asFlatNode(@NonNull DifferentialFunction node, @NonNull FlatBufferBuilder bufferBuilder, List<SDVariable> variables, Map<String, Integer> reverseMap, Map<String, Integer> forwardMap, Map<String, Integer> framesMap, AtomicInteger idCounter) {
        if (node == null) {
            throw new NullPointerException("node");
        }
        if (bufferBuilder == null) {
            throw new NullPointerException("bufferBuilder");
        }
        String opName = node.opName();
        long hash = SameDiff.getOpNum(node.opName(), node.opType());
        float[] extras = node.getExtraArgs() != null ? new float[node.getExtraArgs().length] : new float[]{};
        for (int e = 0; e < extras.length; ++e) {
            extras[e] = ((Number)node.getExtraArgs()[e]).floatValue();
        }
        int[] extraBits = null;
        if (node.opType() == Op.Type.CUSTOM) {
            DynamicCustomOp dynamicCustomOp = (DynamicCustomOp)node;
            extraBits = dynamicCustomOp.iArgs();
        } else if (node instanceof Enter) {
            String frameName = ((Enter)node).getFrameName();
            if (!framesMap.containsKey(frameName)) {
                framesMap.put(frameName, idCounter.incrementAndGet());
            }
            extraBits = new int[]{framesMap.get(frameName)};
        } else {
            extraBits = new int[]{};
        }
        ArrayList<Integer> inPaired = new ArrayList<Integer>();
        SDVariable[] outputVertexId = node.outputVariables();
        int[] outputIds = new int[outputVertexId.length];
        for (int i = 0; i < outputIds.length; ++i) {
            outputIds[i] = variables.indexOf(outputVertexId[i]);
        }
        SDVariable[] inputs = node.args();
        log.trace("");
        for (SDVariable input : inputs) {
            Pair<String, Integer> pair = SameDiff.parseVariable(input.getVarName());
            if (!reverseMap.containsKey(pair.getFirst())) {
                if (((String)pair.getFirst()).contains("NextIteration")) {
                    int fwdNodeId = idCounter.incrementAndGet();
                    forwardMap.put((String)pair.getFirst(), fwdNodeId);
                    reverseMap.put((String)pair.getFirst(), fwdNodeId);
                } else {
                    throw new ND4JIllegalStateException("Unknown variable used in input: [" + (String)pair.getFirst() + "]");
                }
            }
            int nodeId = reverseMap.get(pair.getFirst());
            int outputIndex = (Integer)pair.getSecond();
            inPaired.add(IntPair.createIntPair(bufferBuilder, nodeId, outputIndex));
        }
        log.debug("Own Name: {}", (Object)node.getOwnName());
        int ownId = forwardMap.containsKey(node.getOwnName()) ? forwardMap.get(node.getOwnName()).intValue() : idCounter.incrementAndGet();
        reverseMap.put(node.getOwnName(), ownId);
        ArrayList<FunctionProperties> props = new ArrayList<FunctionProperties>();
        int properties = FunctionProperties.asFlatProperties(bufferBuilder, props);
        int nodesIn = FlatNode.createInputVector(bufferBuilder, new int[0]);
        int nodesInPaired = FlatNode.createInputPairedVector(bufferBuilder, Ints.toArray(inPaired));
        int nodesOut = FlatNode.createOutputVector(bufferBuilder, outputIds);
        int extraz = FlatNode.createExtraParamsVector(bufferBuilder, extras);
        int integerArgs = FlatNode.createExtraIntegerVector(bufferBuilder, extraBits);
        int dimensions = FlatNode.createDimensionsVector(bufferBuilder, node.getDimensions() != null ? node.getDimensions() : new int[]{});
        int fname = bufferBuilder.createString(outputVertexId == null || outputVertexId.length < 1 || outputVertexId[0] == null ? "" : outputVertexId[0].getVarName());
        int scopeName = bufferBuilder.createString("");
        if (node.opType() == null) {
            log.warn("Null-op node: {}", (Object)node);
        }
        int flatNode = FlatNode.createFlatNode(bufferBuilder, ownId, fname, SameDiff.getFlatOpType(node.opType()), hash, properties, nodesIn, nodesInPaired, (byte)0, nodesOut, extraz, integerArgs, dimensions, -1, node.opType() == Op.Type.SCALAR && node.getScalarValue() != null ? node.getScalarValue().floatValue() : 0.0f, 0, scopeName);
        return flatNode;
    }

    public ByteBuffer asFlatBuffers(@NonNull ExecutorConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        Nd4j.getExecutioner().commit();
        FlatBufferBuilder bufferBuilder = new FlatBufferBuilder(1024);
        AtomicInteger idCounter = new AtomicInteger(0);
        ArrayList<Integer> flatVariables = new ArrayList<Integer>();
        ArrayList flatOffsets = new ArrayList();
        ArrayList<Integer> flatNodes = new ArrayList<Integer>();
        ArrayList<SDVariable> variableList = new ArrayList<SDVariable>(this.variables());
        LinkedHashMap<String, Integer> reverseMap = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> forwardMap = new LinkedHashMap<String, Integer>();
        LinkedHashMap<String, Integer> framesMap = new LinkedHashMap<String, Integer>();
        int idx = 0;
        for (SDVariable sDVariable : this.variables()) {
            log.debug("Exporting variable: [{}]", (Object)sDVariable.getVarName());
            if (sDVariable.getArr() == null || sDVariable.getShape() == null) continue;
            Pair<String, Integer> pair = SameDiff.parseVariable(sDVariable.getVarName());
            reverseMap.put((String)pair.getFirst(), idCounter.incrementAndGet());
            log.debug("Adding [{}] as [{}]", pair.getFirst(), (Object)idCounter.get());
            Iterator<DifferentialFunction> arr = sDVariable.getArr();
            int name = bufferBuilder.createString(sDVariable.getVarName());
            int array = arr.toFlatArray(bufferBuilder);
            int id = IntPair.createIntPair(bufferBuilder, idCounter.get(), 0);
            int flatVariable = FlatVariable.createFlatVariable(bufferBuilder, id, name, 0, array, -1);
            flatVariables.add(flatVariable);
        }
        for (DifferentialFunction differentialFunction : this.functionInstancesById.values()) {
            flatNodes.add(this.asFlatNode(differentialFunction, bufferBuilder, variableList, reverseMap, forwardMap, framesMap, idCounter));
        }
        for (Map.Entry entry : this.sameDiffFunctionInstances.entrySet()) {
            flatNodes.add(this.asFlatNode((String)entry.getKey(), (SameDiff)entry.getValue(), bufferBuilder));
            ArrayList<SDVariable> currVarList = new ArrayList<SDVariable>(((SameDiff)entry.getValue()).variables());
            for (SDVariable node : ((SameDiff)entry.getValue()).variables()) {
                INDArray arr = node.getArr();
                if (arr == null) continue;
                int name = bufferBuilder.createString(node.getVarName());
                int array = arr.toFlatArray(bufferBuilder);
                int id = IntPair.createIntPair(bufferBuilder, ++idx, 0);
                Pair<String, Integer> pair = SameDiff.parseVariable(node.getVarName());
                reverseMap.put((String)pair.getFirst(), idx);
                log.debug("Adding [{}] as [{}]", pair.getFirst(), (Object)idx);
                int flatVariable = FlatVariable.createFlatVariable(bufferBuilder, id, name, 0, array, -1);
                flatVariables.add(flatVariable);
            }
            for (DifferentialFunction func : ((SameDiff)entry.getValue()).functionInstancesById.values()) {
                flatNodes.add(this.asFlatNode(func, bufferBuilder, currVarList, reverseMap, forwardMap, framesMap, idCounter));
            }
        }
        int outputsOffset = FlatGraph.createVariablesVector(bufferBuilder, Ints.toArray(flatOffsets));
        int n = FlatGraph.createVariablesVector(bufferBuilder, Ints.toArray(flatVariables));
        int nodesOffset = FlatGraph.createNodesVector(bufferBuilder, Ints.toArray(flatNodes));
        int fg = FlatGraph.createFlatGraph(bufferBuilder, 119L, n, nodesOffset, outputsOffset, configuration.getFlatConfiguration(bufferBuilder));
        bufferBuilder.finish(fg);
        return bufferBuilder.dataBuffer();
    }

    public ByteBuffer asFlatBuffers() {
        ExecutorConfiguration configuration = ExecutorConfiguration.builder().outputMode(OutputMode.VARIABLE_SPACE).executionMode(ExecutionMode.SEQUENTIAL).profilingMode(OpExecutioner.ProfilingMode.DISABLED).gatherTimings(true).build();
        return this.asFlatBuffers(configuration);
    }

    public static ByteOrder getOrderFromByte(byte val) {
        if (val == 0) {
            return ByteOrder.LITTLE_ENDIAN;
        }
        return ByteOrder.BIG_ENDIAN;
    }

    public static byte getOrderAsByte() {
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            return 1;
        }
        return 0;
    }

    public void asFlatFile(@NonNull File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        ByteBuffer fb = this.asFlatBuffers();
        int offset = fb.position();
        byte[] array = fb.array();
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             DataOutputStream dos = new DataOutputStream(bos);){
            dos.write(array, offset, array.length - offset);
        }
    }

    public void asFlatFile(@NonNull File file, @NonNull ExecutorConfiguration configuration) throws IOException {
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration");
        }
        ByteBuffer fb = this.asFlatBuffers(configuration);
        int offset = fb.position();
        byte[] array = fb.array();
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             DataOutputStream dos = new DataOutputStream(bos);){
            dos.write(array, offset, array.length - offset);
        }
    }

    public String asFlatPrint() {
        StringBuilder sb = new StringBuilder();
        ByteBuffer fb = this.asFlatBuffers();
        FlatGraph graph = FlatGraph.getRootAsFlatGraph(fb);
        sb.append("\nExternal variables:\n\n");
        for (int e = 0; e < graph.variablesLength(); ++e) {
            FlatVariable var = graph.variables(e);
            INDArray ndarray = Nd4j.createFromFlatArray(var.ndarray());
            sb.append(var.id().first()).append(":<").append(var.name()).append("> ").append(Arrays.toString(ndarray.shapeInfoDataBuffer().asInt())).append("; Values: ").append(Arrays.toString(ndarray.data().asFloat())).append(";\n");
        }
        Map<String, CustomOpDescriptor> map = Nd4j.getExecutioner().getCustomOperations();
        sb.append("\nOps sequence:\n\n");
        for (int e = 0; e < graph.nodesLength(); ++e) {
            FlatNode node = graph.nodes(e);
            log.info("{}:<{}>", (Object)node.id(), (Object)node.name());
            sb.append(node.id()).append(":<").append(node.name()).append("> ").append((Object)SameDiff.getTypeFromByte(node.opType()));
            if (SameDiff.getTypeFromByte(node.opType()) != Op.Type.CUSTOM) {
                sb.append(": ").append(node.opNum());
            } else {
                Set<String> keys = map.keySet();
                String opName = null;
                for (String k : keys) {
                    CustomOpDescriptor d = map.get(k);
                    if (d.getHash() != node.opNum()) continue;
                    opName = k;
                }
                if (opName == null) {
                    opName = "unknown";
                }
                sb.append(": ").append(opName);
            }
            sb.append("; Inputs: {");
            for (int i = 0; i < node.inputPairedLength(); ++i) {
                IntPair pair = node.inputPaired(i);
                sb.append("[").append(pair.first()).append(":").append(pair.second()).append("]");
                if (i >= node.inputPairedLength() - 1) continue;
                sb.append(", ");
            }
            sb.append("};");
            sb.append(" OpNum: {").append(node.opNum()).append("};");
            sb.append("\n");
        }
        return sb.toString();
    }

    public static DataBuffer.Type getDataTypeFromByte(byte val) {
        if (val == 5) {
            return DataBuffer.Type.FLOAT;
        }
        if (val == 6) {
            return DataBuffer.Type.DOUBLE;
        }
        if (val == 3) {
            return DataBuffer.Type.HALF;
        }
        throw new UnsupportedOperationException("Unsupported DataType: [" + val + "]");
    }

    public static byte getDataTypeAsByte(DataBuffer.Type type) {
        switch (type) {
            case FLOAT: {
                return 5;
            }
            case DOUBLE: {
                return 6;
            }
            case HALF: {
                return 3;
            }
            case INT: {
                return 9;
            }
            case LONG: {
                return 10;
            }
        }
        throw new ND4JIllegalStateException("Unknown or unsupported DataType used: [" + type + "]");
    }

    public static long getOpNum(String name, Op.Type type) {
        if (type == Op.Type.LOOP) {
            return 0L;
        }
        if (type == Op.Type.RETURN) {
            return 40L;
        }
        if (type == Op.Type.IF) {
            return 30L;
        }
        if (type == Op.Type.CONDITIONAL) {
            return 10L;
        }
        if (type == Op.Type.MERGE) {
            return 60L;
        }
        if (type == Op.Type.LOOP_COND) {
            return 70L;
        }
        if (type == Op.Type.NEXT_ITERATION) {
            return 80L;
        }
        if (type == Op.Type.EXIT) {
            return 90L;
        }
        if (type == Op.Type.ENTER) {
            return 100L;
        }
        if (type == Op.Type.CUSTOM) {
            CustomOpDescriptor name2 = Nd4j.getExecutioner().getCustomOperations().get(name.toLowerCase());
            if (name2 == null) {
                return 0L;
            }
            return Nd4j.getExecutioner().getCustomOperations().get(name.toLowerCase()).getHash();
        }
        return Nd4j.getOpFactory().getOpNumByName(name);
    }

    public static Op.Type getTypeFromByte(byte type) {
        switch (type) {
            case 3: {
                return Op.Type.SCALAR;
            }
            case 4: {
                return Op.Type.BROADCAST;
            }
            case 0: {
                return Op.Type.TRANSFORM;
            }
            case 1: {
                return Op.Type.REDUCE;
            }
            case 6: {
                return Op.Type.REDUCE3;
            }
            case 2: {
                return Op.Type.INDEXREDUCE;
            }
            case 10: {
                return Op.Type.RANDOM;
            }
            case 119: {
                return Op.Type.META;
            }
            case 11: {
                return Op.Type.CUSTOM;
            }
            case 8: {
                return Op.Type.SHAPE;
            }
            case 5: {
                return Op.Type.PAIRWISE;
            }
            case 7: {
                return Op.Type.SUMMARYSTATS;
            }
        }
        throw new UnsupportedOperationException("Unknown op type passed in: " + type);
    }

    public static byte getFlatOpType(Op.Type type) {
        switch (type) {
            case SCALAR: {
                return 3;
            }
            case BROADCAST: {
                return 4;
            }
            case TRANSFORM: 
            case SPECIAL: {
                return 0;
            }
            case REDUCE: {
                return 1;
            }
            case REDUCE3: {
                return 6;
            }
            case INDEXREDUCE: {
                return 2;
            }
            case RANDOM: {
                return 10;
            }
            case MERGE: 
            case CONDITIONAL: 
            case LOOP: 
            case RETURN: 
            case ENTER: 
            case EXIT: 
            case NEXT_ITERATION: 
            case LOOP_COND: 
            case IF: {
                return 119;
            }
            case CUSTOM: {
                return 11;
            }
            case SHAPE: {
                return 8;
            }
            case PAIRWISE: {
                return 5;
            }
            case SUMMARYSTATS: {
                return 7;
            }
        }
        throw new UnsupportedOperationException("Unknown op type passed in: " + (Object)((Object)type));
    }

    public static SameDiffBuilder builder() {
        return new SameDiffBuilder();
    }

    public SameDiff(Map<String[], DifferentialFunction> incomingArgs, Map<String[], DifferentialFunction> outgoingArgs, Map<String, String[]> incomingArgsReverse, Map<String, String[]> outgoingArgsReverse, Map<String, int[]> permuteOrder, boolean shouldBootStrap, Set<String> importedVarName, Map<String, String> baseNameForFunctionInstanceId, DifferentialFunctionFactory functionFactory, Map<String, SDVariable> variableMap, Map<String, int[]> variableNameToShape, Map<String, SDVariable> gradients, Map<String, SDVariable> forwardVarForGrad, Map<String, INDArray> variableNameToArr, Map<String, List<DifferentialFunction>> functionsArgsFor, Map<String, List<DifferentialFunction>> functionOutputFor, ThreadLocal<FlowPath> localFlowPath, Map<String, List<String>> propertiesToResolve, Map<String, Map<String, Object>> propertiesForFunction, Map<String, List<String[]>> placeHolderMap, Map<String, int[]> placeHolderOriginalShapes, Set<String> placeHolderVarNames, IdentityHashMap<INDArray, SDVariable> reverseArrayLookup, MemoryWorkspace workspace, Map<String, SameDiffFunctionDefinition> sameDiffFunctionDefinitionMap, Map<String, SameDiff> sameDiffFunctionInstances, Set<String> placeHolderFunctions, Map<String, DifferentialFunction> functionInstancesById, Table<String, String, String> fieldVariableResolutionMapping, AtomicBoolean wasRegistered, boolean debugMode, Map<int[], Op> opsForResult, boolean resolvedVariables, boolean logExecution) {
        this.incomingArgs = incomingArgs;
        this.outgoingArgs = outgoingArgs;
        this.incomingArgsReverse = incomingArgsReverse;
        this.outgoingArgsReverse = outgoingArgsReverse;
        this.permuteOrder = permuteOrder;
        this.shouldBootStrap = shouldBootStrap;
        this.importedVarName = importedVarName;
        this.baseNameForFunctionInstanceId = baseNameForFunctionInstanceId;
        this.functionFactory = functionFactory;
        this.variableMap = variableMap;
        this.variableNameToShape = variableNameToShape;
        this.gradients = gradients;
        this.forwardVarForGrad = forwardVarForGrad;
        this.variableNameToArr = variableNameToArr;
        this.functionsArgsFor = functionsArgsFor;
        this.functionOutputFor = functionOutputFor;
        this.localFlowPath = localFlowPath;
        this.propertiesToResolve = propertiesToResolve;
        this.propertiesForFunction = propertiesForFunction;
        this.placeHolderMap = placeHolderMap;
        this.placeHolderOriginalShapes = placeHolderOriginalShapes;
        this.placeHolderVarNames = placeHolderVarNames;
        this.reverseArrayLookup = reverseArrayLookup;
        this.workspace = workspace;
        this.sameDiffFunctionDefinitionMap = sameDiffFunctionDefinitionMap;
        this.sameDiffFunctionInstances = sameDiffFunctionInstances;
        this.placeHolderFunctions = placeHolderFunctions;
        this.functionInstancesById = functionInstancesById;
        this.fieldVariableResolutionMapping = fieldVariableResolutionMapping;
        this.wasRegistered = wasRegistered;
        this.debugMode = debugMode;
        this.opsForResult = opsForResult;
        this.resolvedVariables = resolvedVariables;
        this.logExecution = logExecution;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public boolean isLogExecution() {
        return this.logExecution;
    }

    public void setLogExecution(boolean logExecution) {
        this.logExecution = logExecution;
    }

    static {
        Method[] methods;
        log = LoggerFactory.getLogger(SameDiff.class);
        cloner = SameDiff.newCloner();
        opMethods = new HashMap<String, Method>();
        for (Method method : methods = SameDiff.class.getDeclaredMethods()) {
            if (!method.getReturnType().equals(SDVariable.class)) continue;
            opMethods.put(method.getName(), method);
        }
    }

    public static class SameDiffBuilder {
        private Map<String[], DifferentialFunction> incomingArgs;
        private Map<String[], DifferentialFunction> outgoingArgs;
        private Map<String, String[]> incomingArgsReverse;
        private Map<String, String[]> outgoingArgsReverse;
        private Map<String, int[]> permuteOrder;
        private boolean shouldBootStrap;
        private Set<String> importedVarName;
        private Map<String, String> baseNameForFunctionInstanceId;
        private DifferentialFunctionFactory functionFactory;
        private Map<String, SDVariable> variableMap;
        private Map<String, int[]> variableNameToShape;
        private Map<String, SDVariable> gradients;
        private Map<String, SDVariable> forwardVarForGrad;
        private Map<String, INDArray> variableNameToArr;
        private Map<String, List<DifferentialFunction>> functionsArgsFor;
        private Map<String, List<DifferentialFunction>> functionOutputFor;
        private ThreadLocal<FlowPath> localFlowPath;
        private Map<String, List<String>> propertiesToResolve;
        private Map<String, Map<String, Object>> propertiesForFunction;
        private Map<String, List<String[]>> placeHolderMap;
        private Map<String, int[]> placeHolderOriginalShapes;
        private Set<String> placeHolderVarNames;
        private IdentityHashMap<INDArray, SDVariable> reverseArrayLookup;
        private MemoryWorkspace workspace;
        private Map<String, SameDiffFunctionDefinition> sameDiffFunctionDefinitionMap;
        private Map<String, SameDiff> sameDiffFunctionInstances;
        private Set<String> placeHolderFunctions;
        private Map<String, DifferentialFunction> functionInstancesById;
        private Table<String, String, String> fieldVariableResolutionMapping;
        private AtomicBoolean wasRegistered;
        private boolean debugMode;
        private Map<int[], Op> opsForResult;
        private boolean resolvedVariables;
        private boolean logExecution;

        SameDiffBuilder() {
        }

        public SameDiffBuilder incomingArgs(Map<String[], DifferentialFunction> incomingArgs) {
            this.incomingArgs = incomingArgs;
            return this;
        }

        public SameDiffBuilder outgoingArgs(Map<String[], DifferentialFunction> outgoingArgs) {
            this.outgoingArgs = outgoingArgs;
            return this;
        }

        public SameDiffBuilder incomingArgsReverse(Map<String, String[]> incomingArgsReverse) {
            this.incomingArgsReverse = incomingArgsReverse;
            return this;
        }

        public SameDiffBuilder outgoingArgsReverse(Map<String, String[]> outgoingArgsReverse) {
            this.outgoingArgsReverse = outgoingArgsReverse;
            return this;
        }

        public SameDiffBuilder permuteOrder(Map<String, int[]> permuteOrder) {
            this.permuteOrder = permuteOrder;
            return this;
        }

        public SameDiffBuilder shouldBootStrap(boolean shouldBootStrap) {
            this.shouldBootStrap = shouldBootStrap;
            return this;
        }

        public SameDiffBuilder importedVarName(Set<String> importedVarName) {
            this.importedVarName = importedVarName;
            return this;
        }

        public SameDiffBuilder baseNameForFunctionInstanceId(Map<String, String> baseNameForFunctionInstanceId) {
            this.baseNameForFunctionInstanceId = baseNameForFunctionInstanceId;
            return this;
        }

        public SameDiffBuilder functionFactory(DifferentialFunctionFactory functionFactory) {
            this.functionFactory = functionFactory;
            return this;
        }

        public SameDiffBuilder variableMap(Map<String, SDVariable> variableMap) {
            this.variableMap = variableMap;
            return this;
        }

        public SameDiffBuilder variableNameToShape(Map<String, int[]> variableNameToShape) {
            this.variableNameToShape = variableNameToShape;
            return this;
        }

        public SameDiffBuilder gradients(Map<String, SDVariable> gradients) {
            this.gradients = gradients;
            return this;
        }

        public SameDiffBuilder forwardVarForGrad(Map<String, SDVariable> forwardVarForGrad) {
            this.forwardVarForGrad = forwardVarForGrad;
            return this;
        }

        public SameDiffBuilder variableNameToArr(Map<String, INDArray> variableNameToArr) {
            this.variableNameToArr = variableNameToArr;
            return this;
        }

        public SameDiffBuilder functionsArgsFor(Map<String, List<DifferentialFunction>> functionsArgsFor) {
            this.functionsArgsFor = functionsArgsFor;
            return this;
        }

        public SameDiffBuilder functionOutputFor(Map<String, List<DifferentialFunction>> functionOutputFor) {
            this.functionOutputFor = functionOutputFor;
            return this;
        }

        public SameDiffBuilder localFlowPath(ThreadLocal<FlowPath> localFlowPath) {
            this.localFlowPath = localFlowPath;
            return this;
        }

        public SameDiffBuilder propertiesToResolve(Map<String, List<String>> propertiesToResolve) {
            this.propertiesToResolve = propertiesToResolve;
            return this;
        }

        public SameDiffBuilder propertiesForFunction(Map<String, Map<String, Object>> propertiesForFunction) {
            this.propertiesForFunction = propertiesForFunction;
            return this;
        }

        public SameDiffBuilder placeHolderMap(Map<String, List<String[]>> placeHolderMap) {
            this.placeHolderMap = placeHolderMap;
            return this;
        }

        public SameDiffBuilder placeHolderOriginalShapes(Map<String, int[]> placeHolderOriginalShapes) {
            this.placeHolderOriginalShapes = placeHolderOriginalShapes;
            return this;
        }

        public SameDiffBuilder placeHolderVarNames(Set<String> placeHolderVarNames) {
            this.placeHolderVarNames = placeHolderVarNames;
            return this;
        }

        public SameDiffBuilder reverseArrayLookup(IdentityHashMap<INDArray, SDVariable> reverseArrayLookup) {
            this.reverseArrayLookup = reverseArrayLookup;
            return this;
        }

        public SameDiffBuilder workspace(MemoryWorkspace workspace) {
            this.workspace = workspace;
            return this;
        }

        public SameDiffBuilder sameDiffFunctionDefinitionMap(Map<String, SameDiffFunctionDefinition> sameDiffFunctionDefinitionMap) {
            this.sameDiffFunctionDefinitionMap = sameDiffFunctionDefinitionMap;
            return this;
        }

        public SameDiffBuilder sameDiffFunctionInstances(Map<String, SameDiff> sameDiffFunctionInstances) {
            this.sameDiffFunctionInstances = sameDiffFunctionInstances;
            return this;
        }

        public SameDiffBuilder placeHolderFunctions(Set<String> placeHolderFunctions) {
            this.placeHolderFunctions = placeHolderFunctions;
            return this;
        }

        public SameDiffBuilder functionInstancesById(Map<String, DifferentialFunction> functionInstancesById) {
            this.functionInstancesById = functionInstancesById;
            return this;
        }

        public SameDiffBuilder fieldVariableResolutionMapping(Table<String, String, String> fieldVariableResolutionMapping) {
            this.fieldVariableResolutionMapping = fieldVariableResolutionMapping;
            return this;
        }

        public SameDiffBuilder wasRegistered(AtomicBoolean wasRegistered) {
            this.wasRegistered = wasRegistered;
            return this;
        }

        public SameDiffBuilder debugMode(boolean debugMode) {
            this.debugMode = debugMode;
            return this;
        }

        public SameDiffBuilder opsForResult(Map<int[], Op> opsForResult) {
            this.opsForResult = opsForResult;
            return this;
        }

        public SameDiffBuilder resolvedVariables(boolean resolvedVariables) {
            this.resolvedVariables = resolvedVariables;
            return this;
        }

        public SameDiffBuilder logExecution(boolean logExecution) {
            this.logExecution = logExecution;
            return this;
        }

        public SameDiff build() {
            return new SameDiff(this.incomingArgs, this.outgoingArgs, this.incomingArgsReverse, this.outgoingArgsReverse, this.permuteOrder, this.shouldBootStrap, this.importedVarName, this.baseNameForFunctionInstanceId, this.functionFactory, this.variableMap, this.variableNameToShape, this.gradients, this.forwardVarForGrad, this.variableNameToArr, this.functionsArgsFor, this.functionOutputFor, this.localFlowPath, this.propertiesToResolve, this.propertiesForFunction, this.placeHolderMap, this.placeHolderOriginalShapes, this.placeHolderVarNames, this.reverseArrayLookup, this.workspace, this.sameDiffFunctionDefinitionMap, this.sameDiffFunctionInstances, this.placeHolderFunctions, this.functionInstancesById, this.fieldVariableResolutionMapping, this.wasRegistered, this.debugMode, this.opsForResult, this.resolvedVariables, this.logExecution);
        }

        public String toString() {
            return "SameDiff.SameDiffBuilder(incomingArgs=" + this.incomingArgs + ", outgoingArgs=" + this.outgoingArgs + ", incomingArgsReverse=" + this.incomingArgsReverse + ", outgoingArgsReverse=" + this.outgoingArgsReverse + ", permuteOrder=" + this.permuteOrder + ", shouldBootStrap=" + this.shouldBootStrap + ", importedVarName=" + this.importedVarName + ", baseNameForFunctionInstanceId=" + this.baseNameForFunctionInstanceId + ", functionFactory=" + this.functionFactory + ", variableMap=" + this.variableMap + ", variableNameToShape=" + this.variableNameToShape + ", gradients=" + this.gradients + ", forwardVarForGrad=" + this.forwardVarForGrad + ", variableNameToArr=" + this.variableNameToArr + ", functionsArgsFor=" + this.functionsArgsFor + ", functionOutputFor=" + this.functionOutputFor + ", localFlowPath=" + this.localFlowPath + ", propertiesToResolve=" + this.propertiesToResolve + ", propertiesForFunction=" + this.propertiesForFunction + ", placeHolderMap=" + this.placeHolderMap + ", placeHolderOriginalShapes=" + this.placeHolderOriginalShapes + ", placeHolderVarNames=" + this.placeHolderVarNames + ", reverseArrayLookup=" + this.reverseArrayLookup + ", workspace=" + this.workspace + ", sameDiffFunctionDefinitionMap=" + this.sameDiffFunctionDefinitionMap + ", sameDiffFunctionInstances=" + this.sameDiffFunctionInstances + ", placeHolderFunctions=" + this.placeHolderFunctions + ", functionInstancesById=" + this.functionInstancesById + ", fieldVariableResolutionMapping=" + this.fieldVariableResolutionMapping + ", wasRegistered=" + this.wasRegistered + ", debugMode=" + this.debugMode + ", opsForResult=" + this.opsForResult + ", resolvedVariables=" + this.resolvedVariables + ", logExecution=" + this.logExecution + ")";
        }
    }

    public static interface SameDiffFunctionDefinition {
        public SDVariable[] define(SameDiff var1, Map<String, INDArray> var2, SDVariable[] var3);
    }

    public static class DefaultSameDiffConditional
    implements SameDiffConditional {
        @Override
        public SDVariable eval(SameDiff context, SameDiffFunctionDefinition body, SDVariable[] inputVars) {
            context.defineFunction("eval", body, inputVars);
            context.invokeFunctionOn("eval", context);
            return ((DifferentialFunction)new ArrayList(context.functionInstancesById.values()).get(context.functionInstancesById.size() - 1)).outputVariables()[0];
        }
    }

    public static interface SameDiffConditional {
        public SDVariable eval(SameDiff var1, SameDiffFunctionDefinition var2, SDVariable[] var3);
    }
}

