/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.nd4j.common.config.ND4JClassLoading;
import org.nd4j.common.io.Resource;
import org.nd4j.context.Nd4jContext;
import org.nd4j.linalg.factory.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Nd4jBackend {
    private static final Logger log = LoggerFactory.getLogger(Nd4jBackend.class);
    public static final int BACKEND_PRIORITY_CPU;
    public static final int BACKEND_PRIORITY_GPU;
    public static final int BACKEND_PRIORITY_AURORA;
    @Deprecated
    public static final String DYNAMIC_LOAD_CLASSPATH = "ND4J_DYNAMIC_LOAD_CLASSPATH";
    @Deprecated
    public static final String DYNAMIC_LOAD_CLASSPATH_PROPERTY = "org.nd4j.backend.dynamicbackend";
    private static boolean triedDynamicLoad;

    public abstract boolean allowsOrder();

    public abstract int getPriority();

    public abstract boolean isAvailable();

    public abstract boolean canRun();

    public abstract Resource getConfigurationResource();

    public abstract Class getNDArrayClass();

    public abstract Environment getEnvironment();

    public abstract String buildInfo();

    public static Nd4jBackend load() throws NoAvailableBackendException {
        String[] jarUris;
        String logInitProperty = System.getProperty("org.nd4j.log.initialization", "true");
        boolean logInit = Boolean.parseBoolean(logInitProperty);
        ArrayList<Nd4jBackend> backends = new ArrayList<Nd4jBackend>();
        ServiceLoader loader = ND4JClassLoading.loadService(Nd4jBackend.class);
        try {
            for (Nd4jBackend nd4jBackend : loader) {
                backends.add(nd4jBackend);
            }
        }
        catch (ServiceConfigurationError serviceError) {
            log.warn("failed to process available backends", (Throwable)serviceError);
            return null;
        }
        Collections.sort(backends, (o1, o2) -> o2.getPriority() - o1.getPriority());
        for (Nd4jBackend backend : backends) {
            boolean available = false;
            String error = null;
            try {
                available = backend.isAvailable();
            }
            catch (Exception e) {
                error = e.getMessage();
            }
            if (!available) {
                if (!logInit) continue;
                log.warn("Skipped [{}] backend (unavailable): {}", (Object)backend.getClass().getSimpleName(), (Object)error);
                continue;
            }
            try {
                Nd4jContext.getInstance().updateProperties(backend.getConfigurationResource().getInputStream());
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
            if (logInit) {
                log.info("Loaded [{}] backend", (Object)backend.getClass().getSimpleName());
            }
            return backend;
        }
        if (System.getProperties().containsKey(DYNAMIC_LOAD_CLASSPATH_PROPERTY) && !triedDynamicLoad) {
            jarUris = System.getProperties().getProperty(DYNAMIC_LOAD_CLASSPATH_PROPERTY).split(";");
        } else if (System.getenv(DYNAMIC_LOAD_CLASSPATH) != null && !triedDynamicLoad) {
            jarUris = System.getenv(DYNAMIC_LOAD_CLASSPATH).split(";");
        } else {
            throw new NoAvailableBackendException("Please ensure that you have an nd4j backend on your classpath. Please see: https://deeplearning4j.konduit.ai/nd4j/backend");
        }
        triedDynamicLoad = true;
        for (String uri : jarUris) {
            Nd4jBackend.loadLibrary(new File(uri));
        }
        return Nd4jBackend.load();
    }

    public static synchronized void loadLibrary(File jar) throws NoAvailableBackendException {
        try {
            URLClassLoader loader = (URLClassLoader)ND4JClassLoading.getNd4jClassloader();
            URL url = jar.toURI().toURL();
            for (URL it : Arrays.asList(loader.getURLs())) {
                if (!it.equals(url)) continue;
                return;
            }
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)loader, url);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | MalformedURLException e) {
            throw new NoAvailableBackendException(e);
        }
    }

    public Properties getProperties() throws IOException {
        return this.getContext().getConf();
    }

    public Nd4jContext getContext() throws IOException {
        return Nd4jContext.getInstance();
    }

    public String toString() {
        return this.getClass().getName();
    }

    public abstract void logBackendInit();

    static {
        triedDynamicLoad = false;
        int n = 0;
        String s = System.getenv("BACKEND_PRIORITY_CPU");
        if (s != null && s.length() > 0) {
            try {
                n = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(e);
            }
        }
        BACKEND_PRIORITY_CPU = n;
        n = 100;
        s = System.getenv("BACKEND_PRIORITY_GPU");
        if (s != null && s.length() > 0) {
            try {
                n = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(e);
            }
        }
        BACKEND_PRIORITY_GPU = n;
        n = 100;
        s = System.getenv("BACKEND_PRIORITY_AURORA");
        if (s != null && s.length() > 0) {
            try {
                n = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException(e);
            }
        }
        BACKEND_PRIORITY_AURORA = n;
    }

    public static class NoAvailableBackendException
    extends Exception {
        public NoAvailableBackendException(String s) {
            super(s);
        }

        public NoAvailableBackendException(Throwable cause) {
            super(cause);
        }
    }
}

