/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.iterator;

import java.io.File;
import java.util.List;
import java.util.NoSuchElementException;
import org.nd4j.linalg.dataset.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.dataset.api.iterator.fetcher.DataSetFetcher;

public class BaseDatasetIterator
implements DataSetIterator {
    private static final long serialVersionUID = -116636792426198949L;
    protected int batch;
    protected int numExamples;
    protected DataSetFetcher fetcher;
    protected DataSetPreProcessor preProcessor;
    protected File topLevelDir;

    public BaseDatasetIterator(int batch, int numExamples, DataSetFetcher fetcher) {
        this.batch = batch;
        if (numExamples < 0) {
            numExamples = fetcher.totalExamples();
        }
        this.numExamples = numExamples;
        this.fetcher = fetcher;
    }

    public void setTopLevelDir(File topLevelDir) {
        this.topLevelDir = topLevelDir;
        if (this.fetcher != null) {
            this.fetcher.setTopLevelDir(topLevelDir);
        }
    }

    public File topLevelDir() {
        return this.topLevelDir;
    }

    @Override
    public boolean hasNext() {
        return this.fetcher.hasMore() && this.fetcher.cursor() < this.numExamples;
    }

    @Override
    public DataSet next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element - hasNext() == false");
        }
        int next = Math.min(this.batch, this.numExamples - this.fetcher.cursor());
        this.fetcher.fetch(next);
        DataSet ds = this.fetcher.next();
        if (this.preProcessor != null) {
            this.preProcessor.preProcess(ds);
        }
        return ds;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int inputColumns() {
        return this.fetcher.inputColumns();
    }

    @Override
    public int totalOutcomes() {
        return this.fetcher.totalOutcomes();
    }

    @Override
    public boolean resetSupported() {
        return true;
    }

    @Override
    public boolean asyncSupported() {
        return true;
    }

    @Override
    public void reset() {
        this.fetcher.reset();
    }

    @Override
    public int batch() {
        return this.batch;
    }

    @Override
    public void setPreProcessor(DataSetPreProcessor preProcessor) {
        this.preProcessor = preProcessor;
    }

    @Override
    public DataSetPreProcessor getPreProcessor() {
        return this.preProcessor;
    }

    @Override
    public List<String> getLabels() {
        return null;
    }

    @Override
    public DataSet next(int num) {
        this.fetcher.fetch(num);
        DataSet next = this.fetcher.next();
        if (this.preProcessor != null) {
            this.preProcessor.preProcess(next);
        }
        return next;
    }
}

