/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.random.custom;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomBernoulli
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(RandomBernoulli.class);
    private double p = 0.0;

    public RandomBernoulli() {
    }

    public RandomBernoulli(SameDiff sd, SDVariable shape, double p) {
        super(null, sd, new SDVariable[]{shape});
        Preconditions.checkState((p >= 0.0 && p <= 1.0 ? 1 : 0) != 0, (String)"Probability must be between 0 and 1 - got %s", (double)p);
        this.p = p;
        this.addTArgument(p);
    }

    public RandomBernoulli(INDArray shape, INDArray out, double p) {
        super(null, new INDArray[]{shape}, new INDArray[]{out}, Collections.singletonList(p), (List<Integer>)null);
        Preconditions.checkState((p >= 0.0 && p <= 1.0 ? 1 : 0) != 0, (String)"Probability must be between 0 and 1 - got %s", (double)p);
    }

    @Override
    public String opName() {
        return "random_bernoulli";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradients) {
        return Collections.singletonList(this.sameDiff.zerosLike(this.arg()));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got %s", this.getClass(), inputDataTypes);
        return Collections.singletonList(DataType.FLOAT);
    }
}

