/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.transforms.custom.LayerNormBp;
import org.nd4j.shade.guava.primitives.Ints;

public class LayerNorm
extends DynamicCustomOp {
    private boolean noBias = false;
    private boolean channelsFirst;

    public LayerNorm(@NonNull SameDiff sameDiff, @NonNull SDVariable input, @NonNull SDVariable gain, SDVariable bias, boolean channelsFirst, int ... dimensions) {
        super(null, sameDiff, LayerNorm.wrapFilterNull(input, gain, bias), false);
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (gain == null) {
            throw new NullPointerException("gain is marked non-null but is null");
        }
        this.noBias = bias == null;
        this.channelsFirst = channelsFirst;
        this.setDimensions(dimensions);
    }

    public LayerNorm(SameDiff sameDiff, SDVariable input, SDVariable gain, boolean channelsFirst, int ... dimensions) {
        this(sameDiff, input, gain, null, channelsFirst, dimensions);
    }

    public LayerNorm(INDArray input, INDArray gain, INDArray bias, INDArray result, boolean channelsFirst, int ... dimensions) {
        super("layer_norm", LayerNorm.wrapFilterNull(input, gain, bias), LayerNorm.wrapOrNull(result));
        this.noBias = bias == null;
        this.channelsFirst = channelsFirst;
        this.setDimensions(dimensions);
    }

    public LayerNorm(@NonNull INDArray input, @NonNull INDArray gain, boolean channelsFirst, int ... dimensions) {
        this(input, gain, null, channelsFirst, dimensions);
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (gain == null) {
            throw new NullPointerException("gain is marked non-null but is null");
        }
    }

    public LayerNorm(INDArray input, INDArray gain, INDArray result, boolean channelsFirst, int ... dimensions) {
        this(input, gain, null, result, channelsFirst, dimensions);
    }

    @Override
    public void setDimensions(int[] dimensions) {
        Preconditions.checkArgument((dimensions != null ? 1 : 0) != 0, (String)"LayerNorm: You have to provide dimensions");
        Preconditions.checkArgument((dimensions.length > 0 ? 1 : 0) != 0, (String)"LayerNorm: You have to provide dimensions");
        this.dimensions = dimensions;
        this.iArguments.clear();
        this.addIArgument(dimensions);
        this.bArguments.clear();
        this.bArguments.add(this.channelsFirst);
    }

    @Override
    public void addBArgument(boolean ... arg) {
        super.addBArgument(arg);
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("noBias", this.noBias);
        ret.put("channelsFirst", this.channelsFirst);
        if (this.dimensions != null) {
            ret.put("dimensions", this.dimensions);
        }
        return ret;
    }

    @Override
    public void configureFromArguments() {
        if (!this.bArguments.isEmpty() && this.bArguments.size() > 1) {
            this.noBias = (Boolean)this.bArguments.get(1);
        }
        if (!this.bArguments.isEmpty()) {
            this.channelsFirst = (Boolean)this.bArguments.get(0);
        }
        if (!this.iArguments.isEmpty()) {
            this.dimensions = Ints.toArray((Collection)this.iArguments);
        }
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        Boolean channelsFirst;
        Boolean noBias = this.getBooleanFromProperty("noBias", properties);
        if (noBias != null) {
            this.noBias = noBias;
        }
        if ((channelsFirst = this.getBooleanFromProperty("channelsFirst", properties)) != null) {
            this.channelsFirst = channelsFirst;
        }
        if (properties.containsKey("dimensions") && properties.get("dimensions") instanceof Long) {
            Long dimension = (Long)properties.get("dimensions");
            this.dimensions = new int[]{dimension.intValue()};
        } else if (properties.containsKey("dimensions") && properties.get("dimensions") instanceof int[]) {
            int[] dimensions = (int[])properties.get("dimensions");
            this.dimensions = dimensions;
        }
    }

    @Override
    public String opName() {
        return "layer_norm";
    }

    @Override
    public String tensorflowName() {
        throw new NoOpNameFoundException("No tensorflow name found for shape " + this.opName());
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx name found for shape " + this.opName());
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradient) {
        if (this.noBias) {
            return new LayerNormBp(this.sameDiff, this.arg(0), this.arg(1), gradient.get(0), this.channelsFirst, this.dimensions).outputs();
        }
        return new LayerNormBp(this.sameDiff, this.arg(0), this.arg(1), this.arg(2), gradient.get(0), this.channelsFirst, this.dimensions).outputs();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() >= 2 && dataTypes.size() <= 3 ? 1 : 0) != 0, (String)"Expected exactly 2 or 3 input datatypes, got %s", dataTypes);
        DataType first = dataTypes.get(0);
        for (DataType dataType : dataTypes) {
            Preconditions.checkState((boolean)dataType.isFPType(), (String)"Input %s datatype must be a floating point type, got datypes %s", dataTypes);
            Preconditions.checkState((first == dataType ? 1 : 0) != 0, (String)"All datatypes must be same type, got input datatypes %s", dataTypes);
        }
        return Collections.singletonList(first);
    }

    @Override
    public int numOutputArguments() {
        return this.noBias ? 2 : 3;
    }

    public LayerNorm() {
    }
}

