/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.reduce.floating;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.BaseReduceFloatOp;
import org.nd4j.linalg.api.ops.Op;
import org.nd4j.linalg.api.ops.impl.reduce.bp.SumBp;

public class Entropy
extends BaseReduceFloatOp {
    public Entropy(SameDiff sameDiff, SDVariable i_v, int[] dimensions) {
        super(sameDiff, i_v, dimensions);
    }

    public Entropy(SameDiff sameDiff, SDVariable i_v, boolean keepDims, SDVariable dimensions) {
        super(sameDiff, i_v, keepDims, dimensions);
    }

    public Entropy(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, SDVariable dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public Entropy(SameDiff sameDiff, SDVariable input, SDVariable dimensions, boolean keepDims) {
        super(sameDiff, input, dimensions, keepDims);
    }

    public Entropy(SameDiff sameDiff, SDVariable input, SDVariable dimensions) {
        super(sameDiff, input, dimensions);
    }

    public Entropy(INDArray input, INDArray output, boolean keepDims, int ... dimensions) {
        super(input, output, keepDims, dimensions);
    }

    public Entropy(INDArray x, INDArray y, INDArray z, int ... dimensions) {
        super(x, y, z, dimensions);
    }

    public Entropy() {
    }

    public Entropy(INDArray x, INDArray z, int ... dimensions) {
        super(x, null, z, dimensions);
    }

    public Entropy(INDArray x, int ... dimensions) {
        super(x, dimensions);
    }

    public Entropy(INDArray in, boolean keepDims, int[] dimensions) {
        super(in, keepDims, dimensions);
    }

    public Entropy(INDArray x, INDArray y, INDArray z, boolean keepDims, int ... dimensions) {
        super(x, y, z, keepDims, dimensions);
    }

    public Entropy(SameDiff sameDiff, SDVariable i_v, boolean keepDims, int[] dimensions) {
        super(sameDiff, i_v, keepDims, dimensions);
    }

    public Entropy(SameDiff sameDiff, SDVariable i_v, SDVariable i_v2, int[] dimensions) {
        super(sameDiff, i_v, i_v2, dimensions);
    }

    public Entropy(SameDiff sameDiff, SDVariable input, int[] dimensions, boolean keepDims) {
        super(sameDiff, input, dimensions, keepDims);
    }

    public Entropy(INDArray in, int[] dimensions, boolean keepDims) {
        super(in, keepDims, dimensions);
    }

    @Override
    public int opNum() {
        return 8;
    }

    @Override
    public String opName() {
        return "entropy";
    }

    @Override
    public Op.Type getOpType() {
        return Op.Type.REDUCE_FLOAT;
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        return Entropy.grad(this.sameDiff, this.arg(), f1.get(0), this.dimensions);
    }

    public static List<SDVariable> grad(SameDiff sd, SDVariable arg, SDVariable grad, int[] dimensions) {
        SDVariable logx = sd.math.log(arg);
        SDVariable xLogX = arg.mul(logx);
        SDVariable sumBp = new SumBp(sd, xLogX, grad.neg(), false, dimensions).outputVariable();
        return Collections.singletonList(sumBp.mul(logx.add(1.0)));
    }
}

