/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.enums.DataFormat;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.SpaceToDepth;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class DepthToSpace
extends DynamicCustomOp {
    private DataFormat dataFormat = DataFormat.NHWC;
    private int blockSize;

    public DepthToSpace() {
    }

    public DepthToSpace(SameDiff sameDiff, SDVariable args, int blockSize, DataFormat dataFormat) {
        this(sameDiff, new SDVariable[]{args}, blockSize, dataFormat);
    }

    public DepthToSpace(SameDiff sameDiff, SDVariable[] args, int blockSize, DataFormat dataFormat) {
        super(null, sameDiff, args, false);
        this.blockSize = blockSize;
        this.dataFormat = dataFormat;
        boolean isNHWC = dataFormat.equals((Object)DataFormat.NHWC);
        this.addIArgument(blockSize, isNHWC ? 1 : 0);
    }

    public DepthToSpace(INDArray in, INDArray out, int blockSize, DataFormat dataFormat) {
        super(null, in, out, null, null);
        this.blockSize = blockSize;
        this.dataFormat = dataFormat;
        boolean isNHWC = dataFormat.equals((Object)DataFormat.NHWC);
        this.addIArgument(blockSize, isNHWC ? 1 : 0);
    }

    public DepthToSpace(INDArray in, int blockSize, DataFormat dataFormat) {
        this(in, null, blockSize, dataFormat);
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        SDVariable gradient = i_v.get(0);
        SDVariable ret = new SpaceToDepth(this.sameDiff, new SDVariable[]{gradient}, this.blockSize, this.dataFormat).outputVariable();
        return Arrays.asList(ret);
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        boolean isNHWC = this.dataFormat.equals((Object)DataFormat.NHWC);
        this.addIArgument(this.blockSize, isNHWC ? 1 : 0);
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        LinkedHashMap<String, PropertyMapping> attrs = new LinkedHashMap<String, PropertyMapping>();
        PropertyMapping blockSize = PropertyMapping.builder().tfAttrName("block_size").propertyNames(new String[]{"blockSize"}).build();
        attrs.put("blockSize", blockSize);
        PropertyMapping dataFormatMapping = PropertyMapping.builder().tfAttrName("data_format").propertyNames(new String[]{"dataFormat"}).build();
        attrs.put("dataFormat", dataFormatMapping);
        ret.put(this.tensorflowName(), attrs);
        return ret;
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        if (properties.containsKey("block_size")) {
            Long blockSize = (Long)properties.get("block_size");
            this.blockSize = blockSize.intValue();
        }
        if (properties.containsKey("isNHWC")) {
            Long isNHWC = (Long)properties.get("isNHWC");
            this.dataFormat = isNHWC > 0L ? DataFormat.NHWC : DataFormat.NCHW;
        }
    }

    @Override
    public String opName() {
        return "depth_to_space";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"DepthToSpace"};
    }

    @Override
    public String tensorflowName() {
        return "DepthToSpace";
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        return Collections.singletonList(dataTypes.get(0));
    }
}

