/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.custom;

import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.factory.Nd4j;

public class BarnesHutSymmetrize
extends DynamicCustomOp {
    private INDArray output;
    private INDArray outCols;

    public BarnesHutSymmetrize() {
    }

    public BarnesHutSymmetrize(INDArray rowP, INDArray colP, INDArray valP, long N, INDArray outRows) {
        INDArray rowCounts = Nd4j.create(N);
        int n = 0;
        while ((long)n < N) {
            int begin = rowP.getInt(n);
            int end = rowP.getInt(n + 1);
            for (int i = begin; i < end; ++i) {
                boolean present = false;
                for (int m = rowP.getInt(colP.getInt(i)); m < rowP.getInt(colP.getInt(i) + 1); ++m) {
                    if (colP.getInt(m) != n) continue;
                    present = true;
                }
                if (present) {
                    rowCounts.putScalar((long)n, rowCounts.getDouble((long)n) + 1.0);
                    continue;
                }
                rowCounts.putScalar((long)n, rowCounts.getDouble((long)n) + 1.0);
                rowCounts.putScalar((long)colP.getInt(i), rowCounts.getDouble((long)colP.getInt(i)) + 1.0);
            }
            ++n;
        }
        int outputCols = rowCounts.sum(Integer.MAX_VALUE).getInt(0);
        this.output = Nd4j.create(1, outputCols);
        this.outCols = Nd4j.create(new int[]{1, outputCols}, DataType.INT);
        this.inputArguments.add(rowP);
        this.inputArguments.add(colP);
        this.inputArguments.add(valP);
        this.outputArguments.add(outRows);
        this.outputArguments.add(this.outCols);
        this.outputArguments.add(this.output);
        this.iArguments.add(N);
    }

    public INDArray getSymmetrizedValues() {
        return this.output;
    }

    public INDArray getSymmetrizedCols() {
        return this.outCols;
    }

    @Override
    public String opName() {
        return "barnes_symmetrized";
    }
}

