/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class ReluUniformInitScheme
extends BaseWeightInitScheme {
    private double fanIn;

    public ReluUniformInitScheme(char order, double fanIn) {
        super(order);
        this.fanIn = fanIn;
    }

    @Override
    public INDArray doCreate(DataType dataType, long[] shape, INDArray paramsView) {
        double u = Math.sqrt(6.0 / this.fanIn);
        return Nd4j.rand(Nd4j.getDistributions().createUniform(-u, u), shape);
    }

    @Override
    public WeightInit type() {
        return WeightInit.RELU_UNIFORM;
    }

    public static ReluUniformInitSchemeBuilder builder() {
        return new ReluUniformInitSchemeBuilder();
    }

    public static class ReluUniformInitSchemeBuilder {
        private char order;
        private double fanIn;

        ReluUniformInitSchemeBuilder() {
        }

        public ReluUniformInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public ReluUniformInitSchemeBuilder fanIn(double fanIn) {
            this.fanIn = fanIn;
            return this;
        }

        public ReluUniformInitScheme build() {
            return new ReluUniformInitScheme(this.order, this.fanIn);
        }

        public String toString() {
            return "ReluUniformInitScheme.ReluUniformInitSchemeBuilder(order=" + this.order + ", fanIn=" + this.fanIn + ")";
        }
    }
}

