/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.schedule;

import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.linalg.schedule.ScheduleType;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class ExponentialSchedule
implements ISchedule {
    private final ScheduleType scheduleType;
    private final double initialValue;
    private final double gamma;

    public ExponentialSchedule(@JsonProperty(value="scheduleType") ScheduleType scheduleType, @JsonProperty(value="initialValue") double initialValue, @JsonProperty(value="gamma") double gamma) {
        this.scheduleType = scheduleType;
        this.initialValue = initialValue;
        this.gamma = gamma;
    }

    @Override
    public double valueAt(int iteration, int epoch) {
        int i = this.scheduleType == ScheduleType.ITERATION ? iteration : epoch;
        return this.initialValue * Math.pow(this.gamma, i);
    }

    @Override
    public ISchedule clone() {
        return new ExponentialSchedule(this.scheduleType, this.initialValue, this.gamma);
    }

    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public double getInitialValue() {
        return this.initialValue;
    }

    public double getGamma() {
        return this.gamma;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExponentialSchedule)) {
            return false;
        }
        ExponentialSchedule other = (ExponentialSchedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getInitialValue(), other.getInitialValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getGamma(), other.getGamma()) != 0) {
            return false;
        }
        ScheduleType this$scheduleType = this.getScheduleType();
        ScheduleType other$scheduleType = other.getScheduleType();
        return !(this$scheduleType == null ? other$scheduleType != null : !((Object)((Object)this$scheduleType)).equals((Object)other$scheduleType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExponentialSchedule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $initialValue = Double.doubleToLongBits(this.getInitialValue());
        result = result * 59 + (int)($initialValue >>> 32 ^ $initialValue);
        long $gamma = Double.doubleToLongBits(this.getGamma());
        result = result * 59 + (int)($gamma >>> 32 ^ $gamma);
        ScheduleType $scheduleType = this.getScheduleType();
        result = result * 59 + ($scheduleType == null ? 43 : ((Object)((Object)$scheduleType)).hashCode());
        return result;
    }

    public String toString() {
        return "ExponentialSchedule(scheduleType=" + this.getScheduleType() + ", initialValue=" + this.getInitialValue() + ", gamma=" + this.getGamma() + ")";
    }
}

