/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.indexing;

import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import net.ericaro.neoitertools.Generator;
import net.ericaro.neoitertools.Itertools;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.PointIndex;
import org.nd4j.linalg.util.LongUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecifiedIndex
implements INDArrayIndex {
    private static final Logger log = LoggerFactory.getLogger(SpecifiedIndex.class);
    private long[] indexes;
    private boolean initialized = false;

    public SpecifiedIndex(int ... indexes) {
        this.indexes = LongUtils.toLongs(indexes);
    }

    public SpecifiedIndex(long ... indexes) {
        this.indexes = indexes;
    }

    @Override
    public long end() {
        return this.indexes[this.indexes.length - 1];
    }

    @Override
    public long offset() {
        return this.indexes[0];
    }

    @Override
    public long length() {
        return this.indexes.length;
    }

    @Override
    public long stride() {
        return 1L;
    }

    @Override
    public void reverse() {
    }

    @Override
    public boolean isInterval() {
        return false;
    }

    @Override
    public void init(INDArray arr, long begin, int dimension) {
    }

    @Override
    public void init(INDArray arr, int dimension) {
        if (this.indexes != null) {
            for (int i = 0; i < this.indexes.length; ++i) {
                if (this.indexes[i] >= 0L) continue;
                int n = i;
                this.indexes[n] = this.indexes[n] + arr.size(dimension);
            }
            this.initialized = true;
        }
    }

    @Override
    public void init(long begin, long end, long max) {
    }

    @Override
    public void init(long begin, long end) {
    }

    @Override
    public boolean initialized() {
        boolean initialized;
        boolean bl = initialized = this.indexes != null;
        if (this.indexes != null) {
            for (int i = 0; i < this.indexes.length; ++i) {
                if (this.indexes[i] >= 0L) continue;
                return false;
            }
        }
        return this.initialized && initialized;
    }

    @Override
    public INDArrayIndex dup() {
        SpecifiedIndex specifiedIndex = new SpecifiedIndex(new int[0]);
        specifiedIndex.initialized = this.initialized;
        specifiedIndex.indexes = Arrays.copyOf(this.indexes, this.indexes.length);
        return this;
    }

    public static Generator<List<List<Long>>> iterate(INDArrayIndex ... indexes) {
        Generator gen = Itertools.product((Generator)new SpecifiedIndexesGenerator(indexes));
        return gen;
    }

    public static Generator<List<List<Long>>> iterateOverSparse(INDArrayIndex ... indexes) {
        Generator gen = Itertools.product((Generator)new SparseSpecifiedIndexesGenerator(indexes));
        return gen;
    }

    public Generator<List<Long>> generator() {
        return new SingleGenerator();
    }

    public Generator<List<Long>> sparseGenerator() {
        return new SparseSingleGenerator();
    }

    public long[] getIndexes() {
        return this.indexes;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setIndexes(long[] indexes) {
        this.indexes = indexes;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpecifiedIndex)) {
            return false;
        }
        SpecifiedIndex other = (SpecifiedIndex)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isInitialized() != other.isInitialized()) {
            return false;
        }
        return Arrays.equals(this.getIndexes(), other.getIndexes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpecifiedIndex;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isInitialized() ? 79 : 97);
        result = result * 59 + Arrays.hashCode(this.getIndexes());
        return result;
    }

    public String toString() {
        return "SpecifiedIndex(indexes=" + Arrays.toString(this.getIndexes()) + ", initialized=" + this.isInitialized() + ")";
    }

    public class SparseSingleGenerator
    implements Generator<List<Long>> {
        public List<Long> next() throws NoSuchElementException {
            throw new RuntimeException();
        }
    }

    public class SingleGenerator
    implements Generator<List<Long>> {
        public List<Long> next() throws NoSuchElementException {
            throw new RuntimeException();
        }
    }

    public static class SparseSpecifiedIndexesGenerator
    implements Generator<Generator<List<Long>>> {
        private int index = 0;
        private INDArrayIndex[] indexes;

        public SparseSpecifiedIndexesGenerator(INDArrayIndex[] indexes) {
            this.indexes = indexes;
        }

        public Generator<List<Long>> next() throws NoSuchElementException {
            if (this.index >= this.indexes.length) {
                throw new NoSuchElementException("Done");
            }
            SpecifiedIndex specifiedIndex = (SpecifiedIndex)this.indexes[this.index++];
            Generator<List<Long>> ret = specifiedIndex.sparseGenerator();
            return ret;
        }
    }

    public static class SpecifiedIndexesGenerator
    implements Generator<Generator<List<Long>>> {
        private int index = 0;
        private INDArrayIndex[] indexes;

        public SpecifiedIndexesGenerator(INDArrayIndex[] indexes) {
            this.indexes = indexes;
            for (int i = 0; i < indexes.length; ++i) {
                if (!(indexes[i] instanceof PointIndex)) continue;
                indexes[i] = new SpecifiedIndex(indexes[i].offset());
            }
        }

        public Generator<List<Long>> next() throws NoSuchElementException {
            if (this.index >= this.indexes.length) {
                throw new NoSuchElementException("Done");
            }
            SpecifiedIndex specifiedIndex = (SpecifiedIndex)this.indexes[this.index++];
            Generator<List<Long>> ret = specifiedIndex.generator();
            return ret;
        }
    }
}

