/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory.ops;

import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.custom.Eig;
import org.nd4j.linalg.api.ops.custom.LinearSolve;
import org.nd4j.linalg.api.ops.custom.Logdet;
import org.nd4j.linalg.api.ops.custom.Lstsq;
import org.nd4j.linalg.api.ops.custom.Lu;
import org.nd4j.linalg.api.ops.custom.MatrixBandPart;
import org.nd4j.linalg.api.ops.custom.Tri;
import org.nd4j.linalg.api.ops.custom.TriangularSolve;
import org.nd4j.linalg.api.ops.custom.Triu;
import org.nd4j.linalg.api.ops.impl.reduce.Mmul;
import org.nd4j.linalg.api.ops.impl.shape.Cross;
import org.nd4j.linalg.api.ops.impl.shape.Diag;
import org.nd4j.linalg.api.ops.impl.shape.DiagPart;
import org.nd4j.linalg.api.ops.impl.transforms.Cholesky;
import org.nd4j.linalg.api.ops.impl.transforms.custom.MatrixDeterminant;
import org.nd4j.linalg.api.ops.impl.transforms.custom.MatrixInverse;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Qr;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Svd;
import org.nd4j.linalg.factory.NDValidation;
import org.nd4j.linalg.factory.Nd4j;

public class NDLinalg {
    public INDArray cholesky(INDArray input) {
        NDValidation.validateNumerical("Cholesky", "input", input);
        return Nd4j.exec(new Cholesky(input))[0];
    }

    public INDArray lstsq(INDArray matrix, INDArray rhs, double l2_reguralizer, boolean fast) {
        NDValidation.validateNumerical("Lstsq", "matrix", matrix);
        NDValidation.validateNumerical("Lstsq", "rhs", rhs);
        return Nd4j.exec(new Lstsq(matrix, rhs, l2_reguralizer, fast))[0];
    }

    public INDArray lstsq(INDArray matrix, INDArray rhs, double l2_reguralizer) {
        NDValidation.validateNumerical("Lstsq", "matrix", matrix);
        NDValidation.validateNumerical("Lstsq", "rhs", rhs);
        return Nd4j.exec(new Lstsq(matrix, rhs, l2_reguralizer, true))[0];
    }

    public INDArray lu(INDArray input) {
        NDValidation.validateNumerical("Lu", "input", input);
        return Nd4j.exec(new Lu(input))[0];
    }

    public INDArray matmul(INDArray a, INDArray b) {
        NDValidation.validateNumerical("Matmul", "a", a);
        NDValidation.validateNumerical("Matmul", "b", b);
        return Nd4j.exec(new Mmul(a, b))[0];
    }

    public INDArray[] matrixBandPart(INDArray input, int minLower, int maxUpper) {
        NDValidation.validateNumerical("MatrixBandPart", "input", input);
        return Nd4j.exec(new MatrixBandPart(input, minLower, maxUpper));
    }

    public INDArray[] qr(INDArray input, boolean full) {
        NDValidation.validateNumerical("Qr", "input", input);
        return Nd4j.exec(new Qr(input, full));
    }

    public INDArray[] qr(INDArray input) {
        NDValidation.validateNumerical("Qr", "input", input);
        return Nd4j.exec(new Qr(input, false));
    }

    public INDArray solve(INDArray matrix, INDArray rhs, boolean adjoint) {
        NDValidation.validateNumerical("Solve", "matrix", matrix);
        NDValidation.validateNumerical("Solve", "rhs", rhs);
        return Nd4j.exec(new LinearSolve(matrix, rhs, adjoint))[0];
    }

    public INDArray solve(INDArray matrix, INDArray rhs) {
        NDValidation.validateNumerical("Solve", "matrix", matrix);
        NDValidation.validateNumerical("Solve", "rhs", rhs);
        return Nd4j.exec(new LinearSolve(matrix, rhs, false))[0];
    }

    public INDArray triangularSolve(INDArray matrix, INDArray rhs, boolean lower, boolean adjoint) {
        NDValidation.validateNumerical("TriangularSolve", "matrix", matrix);
        NDValidation.validateNumerical("TriangularSolve", "rhs", rhs);
        return Nd4j.exec(new TriangularSolve(matrix, rhs, lower, adjoint))[0];
    }

    public INDArray cross(INDArray a, INDArray b) {
        NDValidation.validateNumerical("cross", "a", a);
        NDValidation.validateNumerical("cross", "b", b);
        return Nd4j.exec(new Cross(a, b))[0];
    }

    public INDArray diag(INDArray input) {
        NDValidation.validateNumerical("diag", "input", input);
        return Nd4j.exec(new Diag(input))[0];
    }

    public INDArray diag_part(INDArray input) {
        NDValidation.validateNumerical("diag_part", "input", input);
        return Nd4j.exec(new DiagPart(input))[0];
    }

    public INDArray[] eig(INDArray input) {
        NDValidation.validateNumerical("eig", "input", input);
        return Nd4j.exec(new Eig(input));
    }

    public INDArray logdet(INDArray input) {
        NDValidation.validateNumerical("logdet", "input", input);
        return Nd4j.exec(new Logdet(input))[0];
    }

    public INDArray matrixDeterminant(INDArray input) {
        NDValidation.validateNumerical("matrixDeterminant", "input", input);
        return Nd4j.exec(new MatrixDeterminant(input))[0];
    }

    public INDArray matrixInverse(INDArray input) {
        NDValidation.validateNumerical("matrixInverse", "input", input);
        return Nd4j.exec(new MatrixInverse(input))[0];
    }

    public INDArray mmul(INDArray x, INDArray y, boolean transposeX, boolean transposeY, boolean transposeZ) {
        NDValidation.validateNumerical("mmul", "x", x);
        NDValidation.validateNumerical("mmul", "y", y);
        return Nd4j.exec(new Mmul(x, y, transposeX, transposeY, transposeZ))[0];
    }

    public INDArray mmul(INDArray x, INDArray y) {
        NDValidation.validateNumerical("mmul", "x", x);
        NDValidation.validateNumerical("mmul", "y", y);
        return Nd4j.exec(new Mmul(x, y, false, false, false))[0];
    }

    public INDArray svd(INDArray input, boolean fullUV, boolean computeUV, int switchNum) {
        NDValidation.validateNumerical("svd", "input", input);
        return Nd4j.exec(new Svd(input, fullUV, computeUV, switchNum))[0];
    }

    public INDArray svd(INDArray input, boolean fullUV, boolean computeUV) {
        NDValidation.validateNumerical("svd", "input", input);
        return Nd4j.exec(new Svd(input, fullUV, computeUV, 16))[0];
    }

    public INDArray tri(DataType dataType, int row, int column, int diagonal) {
        return Nd4j.exec(new Tri(dataType, row, column, diagonal))[0];
    }

    public INDArray tri(int row, int column) {
        return Nd4j.exec(new Tri(DataType.FLOAT, row, column, 0))[0];
    }

    public INDArray triu(INDArray input, int diag) {
        NDValidation.validateNumerical("triu", "input", input);
        return Nd4j.exec(new Triu(input, diag))[0];
    }

    public INDArray triu(INDArray input) {
        NDValidation.validateNumerical("triu", "input", input);
        return Nd4j.exec(new Triu(input, 0))[0];
    }
}

