/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import org.nd4j.linalg.api.blas.BlasBufferUtil;
import org.nd4j.linalg.api.blas.Lapack;
import org.nd4j.linalg.api.blas.Level1;
import org.nd4j.linalg.api.blas.Level2;
import org.nd4j.linalg.api.blas.Level3;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.BlasWrapper;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.util.LinAlgExceptions;

public abstract class BaseBlasWrapper
implements BlasWrapper {
    @Override
    public Lapack lapack() {
        return Nd4j.factory().lapack();
    }

    @Override
    public Level1 level1() {
        return Nd4j.factory().level1();
    }

    @Override
    public Level2 level2() {
        return Nd4j.factory().level2();
    }

    @Override
    public Level3 level3() {
        return Nd4j.factory().level3();
    }

    @Override
    public INDArray axpy(Number da, INDArray dx, INDArray dy) {
        LinAlgExceptions.assertSameLength(dx, dy);
        this.level1().axpy(dx.length(), da.doubleValue(), dx, dy);
        return dy;
    }

    @Override
    public INDArray gemv(Number alpha, INDArray a, INDArray x, double beta, INDArray y) {
        LinAlgExceptions.assertVector(x, y);
        LinAlgExceptions.assertMatrix(a);
        this.level2().gemv(BlasBufferUtil.getCharForTranspose(a), BlasBufferUtil.getCharForTranspose(x), alpha.doubleValue(), a, x, beta, y);
        return y;
    }

    @Override
    public INDArray ger(Number alpha, INDArray x, INDArray y, INDArray a) {
        this.level2().ger(BlasBufferUtil.getCharForTranspose(x), alpha.doubleValue(), x, y, a);
        return a;
    }

    @Override
    public int syevr(char jobz, char range, char uplo, INDArray a, float vl, float vu, int il, int iu, Number abstol, INDArray w, INDArray z, int[] isuppz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray swap(INDArray x, INDArray y) {
        this.level1().swap(x, y);
        return y;
    }

    @Override
    public INDArray scal(double alpha, INDArray x) {
        LinAlgExceptions.assertVector(x);
        if (x.data().dataType() == DataType.FLOAT) {
            return this.scal((float)alpha, x);
        }
        this.level1().scal(x.length(), alpha, x);
        return x;
    }

    @Override
    public INDArray scal(float alpha, INDArray x) {
        LinAlgExceptions.assertVector(x);
        if (x.data().dataType() == DataType.DOUBLE) {
            return this.scal((double)alpha, x);
        }
        this.level1().scal(x.length(), alpha, x);
        return x;
    }

    @Override
    public INDArray copy(INDArray x, INDArray y) {
        LinAlgExceptions.assertVector(x, y);
        this.level1().copy(x, y);
        return y;
    }

    @Override
    public INDArray axpy(double da, INDArray dx, INDArray dy) {
        LinAlgExceptions.assertVector(dx, dy);
        if (dx.data().dataType() == DataType.FLOAT) {
            return this.axpy((float)da, dx, dy);
        }
        this.level1().axpy(dx.length(), da, dx, dy);
        return dy;
    }

    @Override
    public INDArray axpy(float da, INDArray dx, INDArray dy) {
        LinAlgExceptions.assertVector(dx, dy);
        if (dx.data().dataType() == DataType.DOUBLE) {
            return this.axpy((double)da, dx, dy);
        }
        this.level1().axpy(dx.length(), da, dx, dy);
        return dy;
    }

    @Override
    public double dot(INDArray x, INDArray y) {
        return this.level1().dot(x.length(), 1.0, x, y);
    }

    @Override
    public double nrm2(INDArray x) {
        LinAlgExceptions.assertVector(x);
        return this.level1().nrm2(x);
    }

    @Override
    public double asum(INDArray x) {
        LinAlgExceptions.assertVector(x);
        return this.level1().asum(x);
    }

    @Override
    public int iamax(INDArray x) {
        return this.level1().iamax(x);
    }

    @Override
    public INDArray gemv(double alpha, INDArray a, INDArray x, double beta, INDArray y) {
        LinAlgExceptions.assertVector(x, y);
        LinAlgExceptions.assertMatrix(a);
        if (a.data().dataType() == DataType.FLOAT) {
            return this.gemv((float)alpha, a, x, (float)beta, y);
        }
        this.level2().gemv('N', 'N', alpha, a, x, beta, y);
        return y;
    }

    @Override
    public INDArray gemv(float alpha, INDArray a, INDArray x, float beta, INDArray y) {
        LinAlgExceptions.assertVector(x, y);
        LinAlgExceptions.assertMatrix(a);
        if (a.data().dataType() == DataType.DOUBLE) {
            return this.gemv((double)alpha, a, x, (double)beta, y);
        }
        this.level2().gemv('N', 'N', alpha, a, x, beta, y);
        return y;
    }

    @Override
    public INDArray ger(double alpha, INDArray x, INDArray y, INDArray a) {
        LinAlgExceptions.assertVector(x, y);
        LinAlgExceptions.assertMatrix(a);
        if (x.data().dataType() == DataType.FLOAT) {
            return this.ger((float)alpha, x, y, a);
        }
        this.level2().ger('N', alpha, x, y, a);
        return a;
    }

    @Override
    public INDArray ger(float alpha, INDArray x, INDArray y, INDArray a) {
        LinAlgExceptions.assertVector(x, y);
        LinAlgExceptions.assertMatrix(a);
        if (x.data().dataType() == DataType.DOUBLE) {
            return this.ger((double)alpha, x, y, a);
        }
        this.level2().ger('N', alpha, x, y, a);
        return a;
    }

    @Override
    public INDArray gesv(INDArray a, int[] ipiv, INDArray b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void checkInfo(String name, int info) {
    }

    @Override
    public INDArray sysv(char uplo, INDArray a, int[] ipiv, INDArray b) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int syev(char jobz, char uplo, INDArray a, INDArray w) {
        return this.lapack().syev(jobz, uplo, a, w);
    }

    @Override
    public int syevx(char jobz, char range, char uplo, INDArray a, double vl, double vu, int il, int iu, double abstol, INDArray w, INDArray z) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int syevx(char jobz, char range, char uplo, INDArray a, float vl, float vu, int il, int iu, float abstol, INDArray w, INDArray z) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int syevd(char jobz, char uplo, INDArray A, INDArray w) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int syevr(char jobz, char range, char uplo, INDArray a, double vl, double vu, int il, int iu, double abstol, INDArray w, INDArray z, int[] isuppz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int syevr(char jobz, char range, char uplo, INDArray a, float vl, float vu, int il, int iu, float abstol, INDArray w, INDArray z, int[] isuppz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void posv(char uplo, INDArray A, INDArray B) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int geev(char jobvl, char jobvr, INDArray A, INDArray WR, INDArray WI, INDArray VL, INDArray VR) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int sygvd(int itype, char jobz, char uplo, INDArray A, INDArray B, INDArray W) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void gelsd(INDArray A, INDArray B) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void geqrf(INDArray A, INDArray tau) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ormqr(char side, char trans, INDArray A, INDArray tau, INDArray C) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void saxpy(double alpha, INDArray x, INDArray y) {
        this.axpy(alpha, x, y);
    }

    @Override
    public void saxpy(float alpha, INDArray x, INDArray y) {
        this.axpy(alpha, x, y);
    }
}

