/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.shape;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class SplitV
extends DynamicCustomOp {
    private int numSplit;
    private int splitDim;

    public SplitV() {
    }

    public SplitV(SameDiff sd, SDVariable input, SDVariable sizes, int numSplit, int splitDim) {
        super(null, sd, new SDVariable[]{input, sizes}, false);
        this.splitDim = splitDim;
        this.numSplit = numSplit;
        this.addIArgument(splitDim, numSplit);
    }

    public SplitV(INDArray input, INDArray sizes, int numSplit, int splitDim) {
        super(null, new INDArray[]{input, sizes}, null);
        this.numSplit = numSplit;
        this.splitDim = splitDim;
        this.addIArgument(splitDim, numSplit);
    }

    @Override
    public String opName() {
        return "split_v";
    }

    @Override
    public String tensorflowName() {
        return "SplitV";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        int numSplits;
        INDArray splitDim = TFGraphMapper.getArrayFrom(TFGraphMapper.getNodeWithNameFromGraph(graph, nodeDef.getInput(0)), graph);
        if (splitDim != null) {
            this.splitDim = splitDim.getInt(0);
            this.addIArgument(splitDim.getInt(0));
        }
        this.numSplit = numSplits = (int)attributesForNode.get("num_split").getI();
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("numSplit", this.numSplit);
        ret.put("splitDim", this.splitDim);
        return ret;
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping splitDim = PropertyMapping.builder().tfInputPosition(-1).propertyNames(new String[]{"splitDim"}).build();
        PropertyMapping numSplit = PropertyMapping.builder().tfAttrName("num_split").propertyNames(new String[]{"numSplit"}).build();
        map.put("numSplit", numSplit);
        map.put("splitDim", splitDim);
        ret.put(this.tensorflowName(), map);
        return ret;
    }

    @Override
    public void configureWithSameDiff(SameDiff sameDiff) {
        super.configureWithSameDiff(sameDiff);
    }

    @Override
    public void configureFromArguments() {
        super.configureFromArguments();
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        if (properties.containsKey("splitDim")) {
            Integer splitDim = this.getIntValueFromProperty("splitDim", properties);
            this.splitDim = splitDim;
        }
        if (properties.containsKey("numSplit")) {
            Integer numSplit = this.getIntValueFromProperty("numSplit", properties);
            this.numSplit = numSplit;
        }
    }

    @Override
    public int getNumOutputs() {
        return this.numSplit;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        ArrayList<DataType> out = new ArrayList<DataType>(this.numSplit);
        for (int i = 0; i < this.numSplit; ++i) {
            out.add(dataTypes.get(0));
        }
        return out;
    }
}

