/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.layers.convolution;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import onnx.Onnx;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.enums.WeightsFormat;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.imports.converters.DifferentialFunctionClassHolder;
import org.nd4j.imports.descriptors.properties.AttributeAdapter;
import org.nd4j.imports.descriptors.properties.PropertyMapping;
import org.nd4j.imports.descriptors.properties.adapters.ConditionalFieldValueIntIndexArrayAdapter;
import org.nd4j.imports.descriptors.properties.adapters.NDArrayShapeAdapter;
import org.nd4j.imports.descriptors.properties.adapters.SizeThresholdIntArrayIntIndexAdapter;
import org.nd4j.imports.descriptors.properties.adapters.StringEqualsAdapter;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.layers.convolution.Conv2DDerivative;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.Conv2DConfig;
import org.nd4j.linalg.api.ops.impl.layers.convolution.config.PaddingMode;
import org.nd4j.linalg.util.LinAlgExceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Conv2D
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(Conv2D.class);
    protected Conv2DConfig config;
    private static final String INVALID_CONFIGURATION = "Invalid Conv2D configuration : sW = %s pH = %s dW = %s ";

    public Conv2D(@NonNull SameDiff sameDiff, @NonNull SDVariable input, @NonNull SDVariable weights, SDVariable bias, @NonNull Conv2DConfig conv2DConfig) {
        this(sameDiff, Conv2D.wrapFilterNull(input, weights, bias), conv2DConfig);
        if (sameDiff == null) {
            throw new NullPointerException("sameDiff is marked non-null but is null");
        }
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
        if (conv2DConfig == null) {
            throw new NullPointerException("conv2DConfig is marked non-null but is null");
        }
    }

    public Conv2D(SameDiff sameDiff, SDVariable[] inputFunctions, Conv2DConfig config) {
        super(sameDiff, inputFunctions);
        this.initConfig(config);
    }

    public Conv2D(INDArray[] inputs, INDArray[] outputs, Conv2DConfig config) {
        super(inputs, outputs);
        this.initConfig(config);
    }

    public Conv2D(@NonNull INDArray input, @NonNull INDArray weights, INDArray bias, INDArray output, @NonNull Conv2DConfig config) {
        this(Conv2D.wrapFilterNull(input, weights, bias), Conv2D.wrapOrNull(output), config);
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        if (weights == null) {
            throw new NullPointerException("weights is marked non-null but is null");
        }
        if (config == null) {
            throw new NullPointerException("config is marked non-null but is null");
        }
    }

    public Conv2D(INDArray layerInput, INDArray weights, INDArray bias, Conv2DConfig config) {
        this(layerInput, weights, bias, null, config);
    }

    protected void initConfig(Conv2DConfig config) {
        this.config = config;
        Preconditions.checkState((config.getSW() >= 1L && config.getPH() >= 0L && config.getDW() >= 1L ? 1 : 0) != 0, (String)INVALID_CONFIGURATION, (long)config.getSH(), (long)config.getPH(), (long)config.getDW());
        this.addArgs();
    }

    protected void addArgs() {
        if (this.config != null) {
            this.addIArgument(this.config.getKH(), this.config.getKW(), this.config.getSH(), this.config.getSW(), this.config.getPH(), this.config.getPW(), this.config.getDH(), this.config.getDW(), this.config.getPaddingMode().index, this.config.getDataFormat().equalsIgnoreCase("NCHW") ? 0L : 1L, this.config.getWeightsFormat().ordinal());
        }
    }

    @Override
    public void setPropertiesForFunction(Map<String, Object> properties) {
        if (this.config == null) {
            String paddingMode;
            Long kH;
            Long kW;
            Long pH;
            Long sH;
            Long dW;
            Long pW;
            Long sW;
            Conv2DConfig.Conv2DConfigBuilder builder = Conv2DConfig.builder();
            Long dH = this.getLongValueFromProperty("dH", properties);
            if (dH != null) {
                builder.dH(dH);
            }
            if ((sW = this.getLongValueFromProperty("sW", properties)) != null) {
                builder.sW(sW);
            }
            if ((pW = this.getLongValueFromProperty("pW", properties)) != null) {
                builder.pW(pW);
            }
            if ((dW = this.getLongValueFromProperty("dW", properties)) != null) {
                builder.dW(dW);
            }
            if ((sH = this.getLongValueFromProperty("sH", properties)) != null) {
                builder.sH(sH);
            }
            if ((pH = this.getLongValueFromProperty("pH", properties)) != null) {
                builder.pH(pH);
            }
            if ((kW = this.getLongValueFromProperty("kW", properties)) != null) {
                builder.kW(kW);
            }
            if ((kH = this.getLongValueFromProperty("kH", properties)) != null) {
                builder.kH(kH);
            }
            if ((paddingMode = this.getStringFromProperty("paddingMode", properties)) != null) {
                builder.paddingMode(PaddingMode.valueOf(paddingMode));
            }
            if (properties.containsKey("dataFormat")) {
                builder.dataFormat(properties.get("dataFormat").toString());
            }
            this.config = builder.build();
        }
    }

    @Override
    public void configureFromArguments() {
        if (this.config == null && this.iArguments.size() >= 10) {
            this.config = Conv2DConfig.builder().kH((Long)this.iArguments.get(0)).kW((Long)this.iArguments.get(1)).sH((Long)this.iArguments.get(2)).sW((Long)this.iArguments.get(3)).pH((Long)this.iArguments.get(4)).pW((Long)this.iArguments.get(5)).dH((Long)this.iArguments.get(6)).dW((Long)this.iArguments.get(7)).paddingMode(PaddingMode.fromNumber(((Long)this.iArguments.get(8)).intValue())).build();
        }
    }

    @Override
    public long[] iArgs() {
        if (this.iArguments.size() == 0) {
            this.addArgs();
        }
        return super.iArgs();
    }

    @Override
    public Object getValue(Field property) {
        if (this.config == null) {
            this.config = Conv2DConfig.builder().build();
        }
        return this.config.getValue(property);
    }

    @Override
    public Map<String, Object> propertiesForFunction() {
        if (this.config != null) {
            return this.config.toProperties();
        }
        return Collections.emptyMap();
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.addArgs();
    }

    @Override
    public boolean isConfigProperties() {
        return true;
    }

    @Override
    public String configFieldName() {
        return "config";
    }

    @Override
    public void initFromOnnx(Onnx.NodeProto node, SameDiff initWith, Map<String, Onnx.AttributeProto> attributesForNode, Onnx.GraphProto graph) {
    }

    @Override
    public Map<String, Map<String, AttributeAdapter>> attributeAdaptersForFunction() {
        HashMap<String, Map<String, AttributeAdapter>> ret = new HashMap<String, Map<String, AttributeAdapter>>();
        LinkedHashMap<String, AttributeAdapter> tfMappings = new LinkedHashMap<String, AttributeAdapter>();
        Map<String, Field> fields = DifferentialFunctionClassHolder.getInstance().getFieldsForFunction(this);
        tfMappings.put("kH", new NDArrayShapeAdapter(0));
        tfMappings.put("kW", new NDArrayShapeAdapter(1));
        tfMappings.put("sH", new ConditionalFieldValueIntIndexArrayAdapter("NCHW", 2, 1, fields.get("dataFormat")));
        tfMappings.put("sW", new ConditionalFieldValueIntIndexArrayAdapter("NCHW", 3, 2, fields.get("dataFormat")));
        tfMappings.put("dH", new ConditionalFieldValueIntIndexArrayAdapter("NCHW", 2, 1, fields.get("dataFormat")));
        tfMappings.put("dW", new ConditionalFieldValueIntIndexArrayAdapter("NCHW", 3, 2, fields.get("dataFormat")));
        tfMappings.put("isSameMode", new StringEqualsAdapter("SAME"));
        HashMap<String, AttributeAdapter> onnxMappings = new HashMap<String, AttributeAdapter>();
        onnxMappings.put("kH", new SizeThresholdIntArrayIntIndexAdapter(0, 2, 0));
        onnxMappings.put("kW", new SizeThresholdIntArrayIntIndexAdapter(1, 2, 0));
        onnxMappings.put("dH", new SizeThresholdIntArrayIntIndexAdapter(0, 2, 0));
        onnxMappings.put("dW", new SizeThresholdIntArrayIntIndexAdapter(1, 2, 0));
        onnxMappings.put("sH", new SizeThresholdIntArrayIntIndexAdapter(0, 2, 0));
        onnxMappings.put("sW", new SizeThresholdIntArrayIntIndexAdapter(1, 2, 0));
        onnxMappings.put("isSameMode", new StringEqualsAdapter("SAME"));
        ret.put(this.tensorflowName(), tfMappings);
        ret.put(this.onnxName(), onnxMappings);
        return ret;
    }

    @Override
    public Map<String, Map<String, PropertyMapping>> mappingsForFunction() {
        HashMap<String, Map<String, PropertyMapping>> ret = new HashMap<String, Map<String, PropertyMapping>>();
        HashMap<String, PropertyMapping> map = new HashMap<String, PropertyMapping>();
        PropertyMapping strideMapping = PropertyMapping.builder().tfAttrName("strides").onnxAttrName("strides").propertyNames(new String[]{"sW", "sH"}).build();
        PropertyMapping kernelMappingH = PropertyMapping.builder().propertyNames(new String[]{"kH"}).tfInputPosition(1).shapePosition(0).onnxAttrName("kernel_shape").build();
        PropertyMapping kernelMappingW = PropertyMapping.builder().propertyNames(new String[]{"kW"}).tfInputPosition(1).shapePosition(1).onnxAttrName("kernel_shape").build();
        PropertyMapping dilationMapping = PropertyMapping.builder().onnxAttrName("dilations").propertyNames(new String[]{"dW", "dH"}).tfAttrName("dilations").build();
        PropertyMapping dataFormat = PropertyMapping.builder().onnxAttrName("data_format").tfAttrName("data_format").propertyNames(new String[]{"dataFormat"}).build();
        PropertyMapping sameMode = PropertyMapping.builder().onnxAttrName("auto_pad").propertyNames(new String[]{"isSameMode"}).tfAttrName("padding").build();
        PropertyMapping paddingWidthHeight = PropertyMapping.builder().onnxAttrName("padding").propertyNames(new String[]{"pH", "pW"}).build();
        map.put("sW", strideMapping);
        map.put("sH", strideMapping);
        map.put("kH", kernelMappingH);
        map.put("kW", kernelMappingW);
        map.put("dW", dilationMapping);
        map.put("dH", dilationMapping);
        map.put("isSameMode", sameMode);
        map.put("pH", paddingWidthHeight);
        map.put("pW", paddingWidthHeight);
        map.put("dataFormat", dataFormat);
        try {
            ret.put(this.onnxName(), map);
        }
        catch (NoOpNameFoundException noOpNameFoundException) {
            // empty catch block
        }
        try {
            ret.put(this.tensorflowName(), map);
        }
        catch (NoOpNameFoundException noOpNameFoundException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public String opName() {
        return "conv2d";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> f1) {
        ArrayList<SDVariable> inputs = new ArrayList<SDVariable>(Arrays.asList(this.args()));
        inputs.add(f1.get(0));
        if (this.config == null && !this.iArguments.isEmpty()) {
            this.createConfigFromArguments();
        }
        Conv2DDerivative conv2DDerivative = Conv2DDerivative.derivativeBuilder().sameDiff(this.sameDiff).config(this.config).inputFunctions(inputs.toArray(new SDVariable[inputs.size()])).build();
        List<SDVariable> ret = Arrays.asList(conv2DDerivative.outputVariables());
        return ret;
    }

    private void createConfigFromArguments() {
        LinAlgExceptions.assertAllConfigured(this, 9);
        this.config = Conv2DConfig.builder().kH((Long)this.iArguments.get(0)).kW((Long)this.iArguments.get(1)).sH((Long)this.iArguments.get(2)).sW((Long)this.iArguments.get(3)).pH((Long)this.iArguments.get(4)).pW((Long)this.iArguments.get(5)).dH((Long)this.iArguments.get(6)).dW((Long)this.iArguments.get(7)).paddingMode(this.iArguments.size() < 9 ? PaddingMode.VALID : PaddingMode.fromNumber(((Long)this.iArguments.get(8)).intValue())).dataFormat(this.iArguments.size() < 10 ? "NCHW" : ((Long)this.iArguments.get(9) > 0L ? "NHWC" : "NCHW")).weightsFormat(this.iArguments.size() < 11 ? WeightsFormat.YXIO : WeightsFormat.values()[((Long)this.iArguments.get(10)).intValue()]).build();
    }

    @Override
    public String onnxName() {
        return "Conv";
    }

    @Override
    public String tensorflowName() {
        return "Conv2D";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"Conv2D"};
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        int n = this.args().length;
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == n ? 1 : 0) != 0, (String)"Expected %s input data types for %s, got %s", (Object)n, this.getClass(), inputDataTypes);
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public static Conv2DBuilder sameDiffBuilder() {
        return new Conv2DBuilder();
    }

    public Conv2DConfig getConfig() {
        return this.config;
    }

    public Conv2D() {
    }

    public static class Conv2DBuilder {
        private SameDiff sameDiff;
        private SDVariable[] inputFunctions;
        private Conv2DConfig config;

        Conv2DBuilder() {
        }

        public Conv2DBuilder sameDiff(SameDiff sameDiff) {
            this.sameDiff = sameDiff;
            return this;
        }

        public Conv2DBuilder inputFunctions(SDVariable[] inputFunctions) {
            this.inputFunctions = inputFunctions;
            return this;
        }

        public Conv2DBuilder config(Conv2DConfig config) {
            this.config = config;
            return this;
        }

        public Conv2D build() {
            return new Conv2D(this.sameDiff, this.inputFunctions, this.config);
        }

        public String toString() {
            return "Conv2D.Conv2DBuilder(sameDiff=" + this.sameDiff + ", inputFunctions=" + Arrays.deepToString(this.inputFunctions) + ", config=" + this.config + ")";
        }
    }
}

