/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.compat;

import java.util.Arrays;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.api.shape.LongShapeDescriptor;

public class CompatSparseToDense
extends DynamicCustomOp {
    public CompatSparseToDense() {
    }

    public CompatSparseToDense(INDArray indices, INDArray shape, INDArray values) {
        Preconditions.checkArgument((shape.isZ() && indices.isZ() ? 1 : 0) != 0, (String)"Shape & indices arrays must have one integer data types");
        this.inputArguments.add(indices);
        this.inputArguments.add(shape);
        this.inputArguments.add(values);
    }

    public CompatSparseToDense(SameDiff sd, SDVariable indices, SDVariable shape, SDVariable values) {
        super(sd, new SDVariable[]{indices, shape, values});
    }

    public CompatSparseToDense(SameDiff sd, SDVariable indices, SDVariable shape, SDVariable values, SDVariable defaultValue) {
        super(sd, new SDVariable[]{indices, shape, values, defaultValue});
    }

    public CompatSparseToDense(INDArray indices, INDArray shape, INDArray values, INDArray defaultValue) {
        super(new INDArray[]{indices, shape, values, defaultValue}, null);
    }

    @Override
    public List<LongShapeDescriptor> calculateOutputShape(OpContext oc) {
        return Arrays.asList(LongShapeDescriptor.fromShape(oc.getInputArrays().get(1).toLongVector(), oc.getInputArrays().get(0).dataType()));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        if (!this.dArguments.isEmpty()) {
            return Arrays.asList(dataTypes.get(0));
        }
        return Arrays.asList(dataTypes.get(0));
    }

    @Override
    public String opName() {
        return "compat_sparse_to_dense";
    }
}

