/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.nd4j.autodiff.functions.DifferentialFunction;
import org.nd4j.autodiff.samediff.config.SDValue;
import org.nd4j.autodiff.samediff.config.SDValueType;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.OpContext;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;

public class ExecutionResult {
    private Map<String, Optional<INDArray>> outputs;
    private Map<String, SDValue> valueOutputs;

    public static ExecutionResult createFrom(List<String> names, List<INDArray> input) {
        Preconditions.checkState((names.size() == input.size() ? 1 : 0) != 0, (String)"Inputs and names must be equal size!");
        LinkedHashMap<String, Optional<INDArray>> outputs = new LinkedHashMap<String, Optional<INDArray>>();
        for (int i = 0; i < input.size(); ++i) {
            outputs.put(names.get(i), input.get(i) == null ? Optional.empty() : Optional.of(input.get(i)));
        }
        return ExecutionResult.builder().outputs(outputs).build();
    }

    public static ExecutionResult createValue(String name, SDValue inputs) {
        return ExecutionResult.builder().valueOutputs(Collections.singletonMap(name, inputs)).build();
    }

    public static ExecutionResult createValue(String name, List inputs) {
        return ExecutionResult.builder().valueOutputs(Collections.singletonMap(name, SDValue.create(inputs))).build();
    }

    public static ExecutionResult createFrom(String name, INDArray input) {
        return ExecutionResult.createFrom(Arrays.asList(name), Arrays.asList(input));
    }

    public static ExecutionResult createFrom(DifferentialFunction func, OpContext opContext) {
        return ExecutionResult.createFrom(Arrays.asList(func.outputVariablesNames()), opContext.getOutputArrays().toArray(new INDArray[opContext.getOutputArrays().size()]));
    }

    public static ExecutionResult createFrom(List<String> names, INDArray[] input) {
        Preconditions.checkState((names.size() == input.length ? 1 : 0) != 0, (String)"Inputs and names must be equal size!");
        LinkedHashMap<String, Optional<INDArray>> outputs = new LinkedHashMap<String, Optional<INDArray>>();
        for (int i = 0; i < input.length; ++i) {
            outputs.put(names.get(i), Optional.ofNullable(input[i]));
        }
        return ExecutionResult.builder().outputs(outputs).build();
    }

    public INDArray[] outputsToArray(List<String> inputs) {
        if (this.valueOutputs != null) {
            INDArray[] ret = new INDArray[this.valueOutputs.size()];
            int count = 0;
            for (Map.Entry<String, SDValue> entry : this.valueOutputs.entrySet()) {
                if (entry.getValue() == null) continue;
                ret[count++] = entry.getValue().getTensorValue();
            }
            return ret;
        }
        if (this.outputs != null) {
            INDArray[] ret = new INDArray[inputs.size()];
            for (int i = 0; i < inputs.size(); ++i) {
                Optional<INDArray> get = this.outputs.get(inputs.get(i));
                try {
                    ret[i] = get.get();
                    continue;
                }
                catch (NullPointerException e) {
                    ret[i] = null;
                }
            }
            return ret;
        }
        throw new IllegalStateException("No outputs to be converted.");
    }

    public boolean hasValues() {
        return this.valueOutputs != null;
    }

    public boolean hasSingle() {
        return this.outputs != null;
    }

    public int numResults() {
        if (this.outputs != null && !this.outputs.isEmpty()) {
            return this.outputs.size();
        }
        if (this.valueOutputs != null && !this.valueOutputs.isEmpty()) {
            return this.valueOutputs.size();
        }
        return 0;
    }

    public boolean valueExistsAtIndex(int index) {
        SDValue value;
        if (this.outputs != null) {
            return this.resultAt(index) != null;
        }
        if (this.valueOutputs != null && (value = this.valueWithKey(this.valueAtIndex(index))) != null) {
            switch (value.getSdValueType()) {
                case TENSOR: {
                    return value.getTensorValue() != null;
                }
                case LIST: {
                    return value.getListValue() != null;
                }
            }
        }
        return false;
    }

    public boolean isNull() {
        return this.valueOutputs == null && this.outputs == null;
    }

    public INDArray resultOrValueAt(int index, boolean returnDummy) {
        if (this.hasValues()) {
            SDValue sdValue = this.valueWithKeyAtIndex(index, returnDummy);
            if (sdValue != null) {
                return sdValue.getTensorValue();
            }
            return null;
        }
        return this.resultAt(index);
    }

    private String valueAtIndex(int index) {
        Set<String> keys = this.valueOutputs != null ? this.valueOutputs.keySet() : this.outputs.keySet();
        int count = 0;
        for (String value : keys) {
            if (count == index) {
                return value;
            }
            ++count;
        }
        return null;
    }

    public SDValue valueWithKeyAtIndex(int index, boolean returnDummy) {
        if (this.valueOutputs == null) {
            return null;
        }
        String key = this.valueAtIndex(index);
        if (this.valueOutputs.containsKey(key)) {
            SDValue sdValue = this.valueOutputs.get(key);
            if (sdValue != null && sdValue.getSdValueType() == SDValueType.LIST && returnDummy) {
                return SDValue.create(Nd4j.empty(DataType.FLOAT));
            }
            return sdValue;
        }
        return this.valueOutputs.get(key);
    }

    public SDValue valueWithKey(String name) {
        if (this.valueOutputs == null) {
            return null;
        }
        return this.valueOutputs.get(name);
    }

    public INDArray resultAt(int index) {
        if (this.outputs == null) {
            return null;
        }
        String name = this.valueAtIndex(index);
        return this.outputs.get(name).get();
    }

    public static Map<String, INDArray> unpack(Map<String, Optional<INDArray>> result) {
        LinkedHashMap<String, INDArray> ret = new LinkedHashMap<String, INDArray>();
        for (Map.Entry<String, Optional<INDArray>> entry : result.entrySet()) {
            ret.put(entry.getKey(), entry.getValue().get());
        }
        return ret;
    }

    public static Map<String, Optional<INDArray>> pack(Map<String, INDArray> result) {
        LinkedHashMap<String, Optional<INDArray>> ret = new LinkedHashMap<String, Optional<INDArray>>();
        for (Map.Entry<String, INDArray> entry : result.entrySet()) {
            ret.put(entry.getKey(), Optional.ofNullable(entry.getValue().get(new INDArrayIndex[0])));
        }
        return ret;
    }

    ExecutionResult(Map<String, Optional<INDArray>> outputs, Map<String, SDValue> valueOutputs) {
        this.outputs = outputs;
        this.valueOutputs = valueOutputs;
    }

    public static ExecutionResultBuilder builder() {
        return new ExecutionResultBuilder();
    }

    public Map<String, Optional<INDArray>> getOutputs() {
        return this.outputs;
    }

    public Map<String, SDValue> getValueOutputs() {
        return this.valueOutputs;
    }

    public void setOutputs(Map<String, Optional<INDArray>> outputs) {
        this.outputs = outputs;
    }

    public void setValueOutputs(Map<String, SDValue> valueOutputs) {
        this.valueOutputs = valueOutputs;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExecutionResult)) {
            return false;
        }
        ExecutionResult other = (ExecutionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Optional<INDArray>> this$outputs = this.getOutputs();
        Map<String, Optional<INDArray>> other$outputs = other.getOutputs();
        if (this$outputs == null ? other$outputs != null : !((Object)this$outputs).equals(other$outputs)) {
            return false;
        }
        Map<String, SDValue> this$valueOutputs = this.getValueOutputs();
        Map<String, SDValue> other$valueOutputs = other.getValueOutputs();
        return !(this$valueOutputs == null ? other$valueOutputs != null : !((Object)this$valueOutputs).equals(other$valueOutputs));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExecutionResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Optional<INDArray>> $outputs = this.getOutputs();
        result = result * 59 + ($outputs == null ? 43 : ((Object)$outputs).hashCode());
        Map<String, SDValue> $valueOutputs = this.getValueOutputs();
        result = result * 59 + ($valueOutputs == null ? 43 : ((Object)$valueOutputs).hashCode());
        return result;
    }

    public String toString() {
        return "ExecutionResult(outputs=" + this.getOutputs() + ", valueOutputs=" + this.getValueOutputs() + ")";
    }

    public static class ExecutionResultBuilder {
        private Map<String, Optional<INDArray>> outputs;
        private Map<String, SDValue> valueOutputs;

        ExecutionResultBuilder() {
        }

        public ExecutionResultBuilder outputs(Map<String, Optional<INDArray>> outputs) {
            this.outputs = outputs;
            return this;
        }

        public ExecutionResultBuilder valueOutputs(Map<String, SDValue> valueOutputs) {
            this.valueOutputs = valueOutputs;
            return this;
        }

        public ExecutionResult build() {
            return new ExecutionResult(this.outputs, this.valueOutputs);
        }

        public String toString() {
            return "ExecutionResult.ExecutionResultBuilder(outputs=" + this.outputs + ", valueOutputs=" + this.valueOutputs + ")";
        }
    }
}

