/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.listeners.Listener;
import org.nd4j.autodiff.listeners.records.EvaluationRecord;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.evaluation.IEvaluation;
import org.nd4j.linalg.dataset.adapter.MultiDataSetIteratorAdapter;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;

public class EvaluationConfig {
    @NonNull
    private Map<String, List<IEvaluation>> evaluations = new HashMap<String, List<IEvaluation>>();
    @NonNull
    private Map<String, Integer> labelIndices = new HashMap<String, Integer>();
    private MultiDataSetIterator data;
    @NonNull
    private List<Listener> listeners = new ArrayList<Listener>();
    private boolean singleInput = false;
    private SameDiff sd;

    public EvaluationConfig(@NonNull SameDiff sd) {
        if (sd == null) {
            throw new NullPointerException("sd is marked non-null but is null");
        }
        this.sd = sd;
    }

    public EvaluationConfig evaluate(@NonNull String param, int labelIndex, IEvaluation ... evaluations) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        if (evaluations == null) {
            throw new NullPointerException("evaluations is marked non-null but is null");
        }
        return this.evaluate(param, evaluations).labelIndex(param, labelIndex);
    }

    public EvaluationConfig evaluate(@NonNull SDVariable variable, int labelIndex, IEvaluation ... evaluations) {
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        if (evaluations == null) {
            throw new NullPointerException("evaluations is marked non-null but is null");
        }
        return this.evaluate(variable.name(), labelIndex, evaluations);
    }

    public EvaluationConfig evaluate(@NonNull String param, IEvaluation ... evaluations) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        if (evaluations == null) {
            throw new NullPointerException("evaluations is marked non-null but is null");
        }
        if (this.evaluations.get(param) == null) {
            this.evaluations.put(param, new ArrayList());
        }
        this.evaluations.get(param).addAll(Arrays.asList(evaluations));
        return this;
    }

    public EvaluationConfig evaluate(@NonNull SDVariable variable, IEvaluation ... evaluations) {
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        if (evaluations == null) {
            throw new NullPointerException("evaluations is marked non-null but is null");
        }
        return this.evaluate(variable.name(), evaluations);
    }

    public EvaluationConfig labelIndex(@NonNull String param, int labelIndex) {
        if (param == null) {
            throw new NullPointerException("param is marked non-null but is null");
        }
        if (this.labelIndices.get(param) != null) {
            int existingIndex = this.labelIndices.get(param);
            Preconditions.checkArgument((existingIndex == labelIndex ? 1 : 0) != 0, (String)"Different label index already specified for param %s.  Already specified: %s, given: %s", (Object)param, (Object)existingIndex, (Object)labelIndex);
        }
        this.labelIndices.put(param, labelIndex);
        return this;
    }

    public EvaluationConfig labelIndex(@NonNull SDVariable variable, int labelIndex) {
        if (variable == null) {
            throw new NullPointerException("variable is marked non-null but is null");
        }
        return this.labelIndex(variable.name(), labelIndex);
    }

    public EvaluationConfig listeners(Listener ... listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners is marked non-null but is null");
        }
        this.listeners.addAll(Arrays.asList(listeners));
        return this;
    }

    public EvaluationConfig data(@NonNull MultiDataSetIterator data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = data;
        this.singleInput = false;
        return this;
    }

    public EvaluationConfig data(@NonNull DataSetIterator data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        this.data = new MultiDataSetIteratorAdapter(data);
        this.singleInput = true;
        return this;
    }

    private void validateConfig() {
        Preconditions.checkNotNull((Object)this.data, (String)"Must specify data.  It may not be null.");
        if (!this.singleInput) {
            for (String param : this.evaluations.keySet()) {
                Preconditions.checkState((boolean)this.labelIndices.containsKey(param), (String)"Using multiple input dataset iterator without specifying a label index for %s", (Object)param);
            }
        }
        for (String param : this.evaluations.keySet()) {
            Preconditions.checkState((boolean)this.sd.variableMap().containsKey(param), (String)"Parameter %s not present in this SameDiff graph", (Object)param);
        }
    }

    public EvaluationRecord exec() {
        this.validateConfig();
        if (this.singleInput) {
            for (String param : this.evaluations.keySet()) {
                this.labelIndices.put(param, 0);
            }
        }
        this.sd.evaluate(this.data, this.evaluations, this.labelIndices, this.listeners.toArray(new Listener[0]));
        return new EvaluationRecord(this.evaluations);
    }

    @NonNull
    public Map<String, List<IEvaluation>> getEvaluations() {
        return this.evaluations;
    }

    @NonNull
    public Map<String, Integer> getLabelIndices() {
        return this.labelIndices;
    }

    public MultiDataSetIterator getData() {
        return this.data;
    }

    @NonNull
    public List<Listener> getListeners() {
        return this.listeners;
    }

    public boolean isSingleInput() {
        return this.singleInput;
    }

    public SameDiff getSd() {
        return this.sd;
    }

    public void setEvaluations(@NonNull Map<String, List<IEvaluation>> evaluations) {
        if (evaluations == null) {
            throw new NullPointerException("evaluations is marked non-null but is null");
        }
        this.evaluations = evaluations;
    }

    public void setLabelIndices(@NonNull Map<String, Integer> labelIndices) {
        if (labelIndices == null) {
            throw new NullPointerException("labelIndices is marked non-null but is null");
        }
        this.labelIndices = labelIndices;
    }

    public void setData(MultiDataSetIterator data) {
        this.data = data;
    }

    public void setListeners(@NonNull List<Listener> listeners) {
        if (listeners == null) {
            throw new NullPointerException("listeners is marked non-null but is null");
        }
        this.listeners = listeners;
    }

    public void setSingleInput(boolean singleInput) {
        this.singleInput = singleInput;
    }
}

