/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff;

import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.linalg.exception.ND4JIllegalArgumentException;

public class SDIndex {
    private IndexType indexType = IndexType.ALL;
    private long pointIndex;
    private SDVariable pointVar;
    private boolean pointKeepDim;
    private Long intervalBegin = null;
    private Long intervalEnd = null;
    private SDVariable intervalInputBegin = null;
    private SDVariable intervalInputEnd = null;
    private SDVariable intervalStrideInput = null;
    private Long intervalStrides = 1L;
    private boolean inclusive = false;
    private SDVariable inclusiveInput = null;

    public static SDIndex all() {
        return new SDIndex();
    }

    public static SDIndex point(SDVariable i) {
        return SDIndex.point(i, false);
    }

    public static SDIndex point(long i) {
        SDIndex sdIndex = new SDIndex();
        sdIndex.indexType = IndexType.POINT;
        sdIndex.pointIndex = i;
        sdIndex.pointKeepDim = false;
        return sdIndex;
    }

    public static SDIndex point(SDVariable i, boolean keepDim) {
        SDIndex sdIndex = new SDIndex();
        sdIndex.indexType = IndexType.POINT_INPUT;
        sdIndex.pointVar = i;
        sdIndex.pointKeepDim = keepDim;
        return sdIndex;
    }

    public static SDIndex point(long i, boolean keepDim) {
        SDIndex sdIndex = new SDIndex();
        sdIndex.indexType = IndexType.POINT;
        sdIndex.pointIndex = i;
        sdIndex.pointKeepDim = keepDim;
        return sdIndex;
    }

    public static SDIndex interval(SDVariable begin, SDVariable end) {
        SDIndex sdIndex = new SDIndex();
        sdIndex.indexType = IndexType.INTERVAL_INPUT;
        sdIndex.intervalInputBegin = begin;
        sdIndex.intervalInputEnd = end;
        sdIndex.inclusiveInput = begin.getSameDiff().constant(0);
        return sdIndex;
    }

    public static SDIndex interval(Long begin, Long end) {
        return SDIndex.interval(begin, end, false);
    }

    public static SDIndex interval(Long begin, Long end, Boolean inclusive) {
        SDIndex sdIndex = new SDIndex();
        sdIndex.indexType = IndexType.INTERVAL;
        if (begin != null) {
            sdIndex.intervalBegin = (long)begin;
        }
        if (end != null) {
            sdIndex.intervalEnd = (long)end;
        }
        sdIndex.inclusive = inclusive != null ? inclusive : false;
        return sdIndex;
    }

    public static SDIndex interval(Integer begin, Integer end) {
        SDIndex sdIndex = new SDIndex();
        sdIndex.indexType = IndexType.INTERVAL;
        if (begin != null) {
            sdIndex.intervalBegin = begin.longValue();
        }
        if (end != null) {
            sdIndex.intervalEnd = end.longValue();
        }
        sdIndex.inclusive = false;
        return sdIndex;
    }

    public static SDIndex interval(Long begin, Long strides, Long end) {
        if (strides == 0L) {
            throw new ND4JIllegalArgumentException("Invalid index : strides can not be 0.");
        }
        SDIndex sdIndex = new SDIndex();
        sdIndex.indexType = IndexType.INTERVAL;
        sdIndex.intervalBegin = begin;
        sdIndex.intervalEnd = end;
        sdIndex.intervalStrides = strides;
        sdIndex.inclusive = false;
        return sdIndex;
    }

    public static SDIndex interval(Long begin, Long strides, Long end, Boolean inclusive) {
        if (strides == 0L) {
            throw new ND4JIllegalArgumentException("Invalid index : strides can not be 0.");
        }
        SDIndex sdIndex = new SDIndex();
        sdIndex.indexType = IndexType.INTERVAL;
        sdIndex.intervalBegin = begin;
        sdIndex.intervalEnd = end;
        sdIndex.intervalStrides = strides;
        sdIndex.inclusive = inclusive != null ? inclusive : false;
        return sdIndex;
    }

    public static SDIndex interval(Integer begin, Integer strides, Integer end) {
        return SDIndex.interval((Long)begin.longValue(), (Long)strides.longValue(), end.longValue());
    }

    public static SDIndex interval(SDVariable begin, SDVariable strides, SDVariable end) {
        return SDIndex.interval(begin, strides, end, begin.getSameDiff().constant(false));
    }

    public static SDIndex interval(SDVariable begin, SDVariable strides, SDVariable end, SDVariable inclusive) {
        SDIndex sdIndex = new SDIndex();
        sdIndex.indexType = IndexType.INTERVAL_INPUT;
        if (begin != null) {
            sdIndex.intervalInputBegin = begin;
        }
        if (end != null) {
            sdIndex.intervalInputEnd = end;
        }
        if (strides != null) {
            sdIndex.intervalStrideInput = strides;
        }
        sdIndex.inclusiveInput = inclusive != null ? inclusive : begin.getSameDiff().constant(false);
        return sdIndex;
    }

    public IndexType getIndexType() {
        return this.indexType;
    }

    public long getPointIndex() {
        return this.pointIndex;
    }

    public SDVariable getPointVar() {
        return this.pointVar;
    }

    public boolean isPointKeepDim() {
        return this.pointKeepDim;
    }

    public Long getIntervalBegin() {
        return this.intervalBegin;
    }

    public Long getIntervalEnd() {
        return this.intervalEnd;
    }

    public SDVariable getIntervalInputBegin() {
        return this.intervalInputBegin;
    }

    public SDVariable getIntervalInputEnd() {
        return this.intervalInputEnd;
    }

    public SDVariable getIntervalStrideInput() {
        return this.intervalStrideInput;
    }

    public Long getIntervalStrides() {
        return this.intervalStrides;
    }

    public boolean isInclusive() {
        return this.inclusive;
    }

    public SDVariable getInclusiveInput() {
        return this.inclusiveInput;
    }

    public static enum IndexType {
        ALL,
        POINT,
        INTERVAL,
        POINT_INPUT,
        INTERVAL_INPUT;

    }
}

