/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.primitives.AtomicDouble;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.blas.Blas;
import org.nd4j.linalg.api.blas.Lapack;
import org.nd4j.linalg.api.blas.Level1;
import org.nd4j.linalg.api.blas.Level2;
import org.nd4j.linalg.api.blas.Level3;
import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.memory.MemoryWorkspace;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.random.impl.Range;
import org.nd4j.linalg.api.rng.Random;
import org.nd4j.linalg.api.rng.distribution.Distribution;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.exception.ND4JArraySizeException;
import org.nd4j.linalg.factory.NDArrayFactory;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.indexing.INDArrayIndex;
import org.nd4j.linalg.indexing.NDArrayIndex;

public abstract class BaseNDArrayFactory
implements NDArrayFactory {
    protected char order;
    protected Blas blas;
    protected Level1 level1;
    protected Level2 level2;
    protected Level3 level3;
    protected Lapack lapack;

    public BaseNDArrayFactory() {
    }

    @Override
    public Lapack lapack() {
        if (this.lapack == null) {
            this.createLapack();
        }
        return this.lapack;
    }

    @Override
    public Blas blas() {
        if (this.blas == null) {
            this.createBlas();
        }
        return this.blas;
    }

    @Override
    public Level1 level1() {
        if (this.level1 == null) {
            this.createLevel1();
        }
        return this.level1;
    }

    @Override
    public Level2 level2() {
        if (this.level2 == null) {
            this.createLevel2();
        }
        return this.level2;
    }

    @Override
    public Level3 level3() {
        if (this.level3 == null) {
            this.createLevel3();
        }
        return this.level3;
    }

    protected BaseNDArrayFactory(DataType dtype, Character order) {
        if (Character.toLowerCase(order.charValue()) != 'c' && Character.toLowerCase(order.charValue()) != 'f') {
            throw new IllegalArgumentException("Order must either be c or f");
        }
        this.order = Character.toLowerCase(order.charValue());
    }

    protected BaseNDArrayFactory(DataType dtype, char order) {
        if (Character.toLowerCase(order) != 'c' && Character.toLowerCase(order) != 'f') {
            throw new IllegalArgumentException("Order must either be c or f");
        }
        this.order = Character.toLowerCase(order);
    }

    @Override
    public void setOrder(char order) {
        Preconditions.checkArgument((order == 'c' || order == 'f' ? 1 : 0) != 0, (String)"Order specified must be either c or f: got %s", (Object)String.valueOf(order));
        this.order = order;
    }

    @Override
    public INDArray rand(long[] shape, double min, double max, Random rng) {
        Nd4j.getRandom().setSeed(rng.getSeed());
        return Nd4j.getDistributions().createUniform(min, max).sample(shape);
    }

    @Override
    public INDArray rand(int[] shape, double min, double max, Random rng) {
        Nd4j.getRandom().setSeed(rng.getSeed());
        return Nd4j.getDistributions().createUniform(min, max).sample(shape);
    }

    @Override
    public INDArray rand(long rows, long columns, double min, double max, Random rng) {
        Nd4j.getRandom().setSeed(rng.getSeed());
        return this.rand(new long[]{rows, columns}, min, max, rng);
    }

    @Override
    public void setDType(DataType dtype) {
        assert (dtype == DataType.DOUBLE || dtype == DataType.FLOAT || dtype == DataType.INT) : "Invalid opType passed, must be float or double";
    }

    @Override
    public INDArray create(int[] shape, DataType dataType, MemoryWorkspace workspace) {
        return this.create(shape, Nd4j.createBuffer(shape, dataType));
    }

    @Override
    public char order() {
        return this.order;
    }

    @Override
    public DataType dtype() {
        return Nd4j.dataType();
    }

    @Override
    public INDArray create(int[] ints, int[] ints1, int[] stride, long offset) {
        return this.create(Nd4j.createBuffer(ints), ints1, stride, offset);
    }

    @Override
    public INDArray create(long rows, long columns, char ordering) {
        return this.create(new long[]{rows, columns}, ordering);
    }

    @Override
    public INDArray toFlattened(Collection<INDArray> matrices) {
        return this.toFlattened('c', matrices.toArray(new INDArray[matrices.size()]));
    }

    @Override
    public INDArray toFlattened(int length, Iterator<? extends INDArray> ... matrices) {
        ArrayList<INDArray> arr = new ArrayList<INDArray>();
        for (Iterator<? extends INDArray> arrs : matrices) {
            while (arrs.hasNext()) {
                arr.add(arrs.next());
            }
        }
        return this.toFlattened(arr);
    }

    @Override
    public INDArray bilinearProducts(INDArray curr, INDArray in) {
        Preconditions.checkArgument((curr.rank() == 3 ? 1 : 0) != 0, (String)"Argument 'curr' must be rank 3. Got input with rank: %s", (int)curr.rank());
        if (in.columns() != 1) {
            throw new AssertionError((Object)"Expected a column vector");
        }
        if ((long)in.rows() != curr.size(curr.shape().length - 1)) {
            throw new AssertionError((Object)"Number of rows in the input does not match number of columns in tensor");
        }
        if (curr.size(curr.shape().length - 2) != curr.size(curr.shape().length - 1)) {
            throw new AssertionError((Object)"Can only perform this operation on a SimpleTensor with square slices");
        }
        INDArray ret = Nd4j.create(curr.slices(), 1L);
        INDArray inT = in.transpose();
        int i = 0;
        while ((long)i < curr.slices()) {
            INDArray slice = curr.slice(i);
            INDArray inTTimesSlice = inT.mmul(slice);
            ret.putScalar((long)i, Nd4j.getBlasWrapper().dot(inTTimesSlice, in));
            ++i;
        }
        return ret;
    }

    @Override
    public INDArray toFlattened(INDArray ... matrices) {
        return this.toFlattened(Nd4j.order().charValue(), Arrays.asList(matrices));
    }

    @Override
    public INDArray toFlattened(char order, INDArray ... matrices) {
        return this.toFlattened(order, Arrays.asList(matrices));
    }

    @Override
    public INDArray eye(long n) {
        INDArray ret = Nd4j.create(n, n);
        int i = 0;
        while ((long)i < n) {
            ret.put(i, i, 1.0);
            ++i;
        }
        return ret.reshape(n, n);
    }

    @Override
    public void rot90(INDArray toRotate) {
        if (!toRotate.isMatrix()) {
            throw new IllegalArgumentException("Only rotating matrices");
        }
        INDArray start = toRotate.transpose();
        for (int i = 0; i < start.rows(); ++i) {
            start.putRow(i, this.reverse(start.getRow(i)));
        }
    }

    @Override
    public INDArray rot(INDArray reverse) {
        INDArray ret = Nd4j.create(reverse.shape());
        if (reverse.isVector()) {
            return this.reverse(reverse);
        }
        int i = 0;
        while ((long)i < reverse.slices()) {
            ret.putSlice(i, this.reverse(reverse.slice(i)));
            ++i;
        }
        return ret.reshape(reverse.shape());
    }

    @Override
    public INDArray reverse(INDArray reverse) {
        INDArray rev = reverse.reshape(-1L);
        INDArray ret = Nd4j.create(rev.shape());
        int count = 0;
        for (long i = rev.length() - 1L; i >= 0L; --i) {
            ret.putScalar((long)count++, rev.getFloat(i));
        }
        return ret.reshape(reverse.shape());
    }

    @Override
    public INDArray arange(double begin, double end, double step) {
        long length = (long)Math.floor((end - begin) / step);
        Range op = new Range(begin, end, step, DataType.FLOAT);
        INDArray out = Nd4j.create(op.calculateOutputShape().get(0));
        op.setOutputArgument(0, out);
        Nd4j.exec(op);
        return out;
    }

    @Override
    public void copy(INDArray a, INDArray b) {
        b.assign(a);
    }

    @Override
    public INDArray rand(int[] shape, float min, float max, Random rng) {
        if (shape.length == 1 && shape[0] == 0) {
            shape = new int[]{1, 1};
        }
        return Nd4j.getDistributions().createUniform(min, max).sample(shape);
    }

    @Override
    public INDArray rand(long[] shape, float min, float max, Random rng) {
        if (shape.length == 1 && shape[0] == 0L) {
            shape = new long[]{1L, 1L};
        }
        return Nd4j.getDistributions().createUniform(min, max).sample(shape);
    }

    @Override
    public INDArray rand(long rows, long columns, float min, float max, Random rng) {
        return this.rand(new long[]{rows, columns}, min, max, rng);
    }

    @Override
    public INDArray appendBias(INDArray ... vectors) {
        Preconditions.checkArgument((vectors != null && vectors.length > 0 ? 1 : 0) != 0, (String)"vectros must be not null and have at least one element");
        int size = 0;
        for (INDArray vector : vectors) {
            size += vector.rows();
            Preconditions.checkArgument((vectors[0].dataType() == vector.dataType() ? 1 : 0) != 0, (String)"appendBias: all arrays must have same type");
        }
        INDArray result = Nd4j.create(vectors[0].dataType(), size + 1, vectors[0].columns());
        int index = 0;
        for (INDArray vector : vectors) {
            INDArray put = this.toFlattened(vector, Nd4j.ones(vector.dataType(), 1L));
            result.put(new INDArrayIndex[]{NDArrayIndex.interval(index, index + vector.rows() + 1), NDArrayIndex.interval(0, vectors[0].columns())}, put);
            index += vector.rows();
        }
        return result;
    }

    @Override
    public INDArray rand(long rows, long columns, Random r) {
        return this.rand(new long[]{rows, columns}, r);
    }

    @Override
    public INDArray rand(long rows, long columns, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return this.rand(new long[]{rows, columns}, Nd4j.getRandom());
    }

    @Override
    public INDArray rand(long rows, long columns) {
        return this.rand(new long[]{rows, columns}, System.currentTimeMillis());
    }

    @Override
    public INDArray rand(char order, long rows, long columns) {
        Shape.assertValidOrder(order);
        return Nd4j.getRandom().nextDouble(order, new long[]{rows, columns});
    }

    @Override
    public INDArray randn(long rows, long columns, Random r) {
        return this.randn(new long[]{rows, columns}, r);
    }

    @Override
    public INDArray randn(long rows, long columns) {
        return this.randn(new long[]{rows, columns}, System.currentTimeMillis());
    }

    @Override
    public INDArray randn(char order, long rows, long columns) {
        Shape.assertValidOrder(order);
        return Nd4j.getRandom().nextGaussian(order, new long[]{rows, columns});
    }

    @Override
    public INDArray randn(long rows, long columns, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return this.randn(new long[]{rows, columns}, Nd4j.getRandom());
    }

    @Override
    public INDArray rand(int[] shape, Distribution r) {
        INDArray ret = r.sample(shape);
        return ret;
    }

    @Override
    public INDArray rand(int[] shape, Random r) {
        INDArray ret = r.nextDouble(shape);
        return ret;
    }

    @Override
    public INDArray rand(long[] shape, Random r) {
        INDArray ret = r.nextDouble(shape);
        return ret;
    }

    @Override
    public INDArray rand(int[] shape, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return this.rand(shape, Nd4j.getRandom());
    }

    @Override
    public INDArray rand(long[] shape, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return this.rand(shape, Nd4j.getRandom());
    }

    @Override
    public INDArray rand(int[] shape) {
        return this.rand(shape, System.currentTimeMillis());
    }

    @Override
    public INDArray rand(long[] shape) {
        return this.rand(shape, System.currentTimeMillis());
    }

    @Override
    public INDArray rand(char order, int[] shape) {
        Shape.assertValidOrder(order);
        return Nd4j.getRandom().nextDouble(order, shape);
    }

    @Override
    public INDArray rand(char order, long[] shape) {
        Shape.assertValidOrder(order);
        return Nd4j.getRandom().nextDouble(order, shape);
    }

    @Override
    public INDArray randn(int[] shape, Random r) {
        return r.nextGaussian(shape);
    }

    @Override
    public INDArray randn(long[] shape, Random r) {
        return r.nextGaussian(shape);
    }

    @Override
    public INDArray randn(char order, int[] shape) {
        Shape.assertValidOrder(order);
        return Nd4j.getRandom().nextGaussian(order, shape);
    }

    @Override
    public INDArray randn(char order, long[] shape) {
        Shape.assertValidOrder(order);
        return Nd4j.getRandom().nextGaussian(order, shape);
    }

    @Override
    public INDArray randn(int[] shape) {
        return this.randn(shape, System.currentTimeMillis());
    }

    @Override
    public INDArray randn(long[] shape) {
        return this.randn(shape, System.currentTimeMillis());
    }

    @Override
    public INDArray randn(int[] shape, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return this.randn(shape, Nd4j.getRandom());
    }

    @Override
    public INDArray randn(long[] shape, long seed) {
        Nd4j.getRandom().setSeed(seed);
        return this.randn(shape, Nd4j.getRandom());
    }

    @Override
    public INDArray create(double[] data) {
        return this.create(data, new int[]{1, data.length});
    }

    @Override
    public INDArray create(float[] data) {
        return this.create(data, new long[]{data.length});
    }

    @Override
    public INDArray create(long columns) {
        return this.create(new long[]{columns});
    }

    @Override
    public INDArray zeros(long rows, long columns) {
        return this.zeros(new long[]{rows, columns});
    }

    @Override
    public INDArray pullRows(INDArray source, int sourceDimension, int[] indexes, char order) {
        Shape.assertValidOrder(order);
        long vectorLength = source.shape()[sourceDimension];
        INDArray ret = Nd4j.createUninitialized(new long[]{indexes.length, vectorLength}, order);
        for (int cnt = 0; cnt < indexes.length; ++cnt) {
            ret.putRow(cnt, source.tensorAlongDimension(indexes[cnt], sourceDimension));
        }
        return ret;
    }

    @Override
    public INDArray pullRows(INDArray source, int sourceDimension, int[] indexes) {
        return this.pullRows(source, sourceDimension, indexes, Nd4j.order().charValue());
    }

    @Override
    public INDArray zeros(long columns) {
        return this.zeros(new long[]{columns});
    }

    @Override
    public INDArray valueArrayOf(int[] shape, double value) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        ret.assign(value);
        return ret;
    }

    @Override
    public INDArray valueArrayOf(long[] shape, double value) {
        INDArray ret = Nd4j.createUninitialized(shape, Nd4j.order().charValue());
        ret.assign(value);
        return ret;
    }

    @Override
    public INDArray create(int[] shape, int[] stride, long offset, char ordering) {
        Shape.assertValidOrder(ordering);
        long length = ArrayUtil.prodLong((int[])shape);
        if (length == 0L) {
            return this.scalar(0.0);
        }
        return this.create(Nd4j.createBuffer(length), shape, stride, offset, ordering);
    }

    @Override
    public INDArray valueArrayOf(long rows, long columns, double value) {
        INDArray create = this.createUninitialized(new long[]{rows, columns}, Nd4j.order().charValue());
        create.assign(value);
        return create;
    }

    @Override
    public INDArray ones(long rows, long columns) {
        return this.ones(new long[]{rows, columns});
    }

    @Override
    public INDArray ones(long columns) {
        return this.ones(new long[]{columns});
    }

    @Override
    public INDArray create(float[] data, int[] shape, char ordering) {
        Shape.assertValidOrder(ordering);
        long length = ArrayUtil.prodLong((int[])shape);
        if (length == 0L) {
            return this.scalar(0.0);
        }
        return this.create(Nd4j.createBuffer(data), shape, Nd4j.getStrides(shape, ordering), 0L, ordering);
    }

    @Override
    public INDArray concat(int dimension, INDArray ... toConcat) {
        if (toConcat.length == 1) {
            return toConcat[0];
        }
        int sumAlongDim = 0;
        boolean allC = toConcat[0].ordering() == 'c';
        long[] outputShape = ArrayUtil.copy((long[])toConcat[0].shape());
        outputShape[dimension] = sumAlongDim;
        for (int i = 0; i < toConcat.length; ++i) {
            sumAlongDim = (int)((long)sumAlongDim + toConcat[i].size(dimension));
            allC = allC && toConcat[i].ordering() == 'c';
            for (int j = 0; j < toConcat[i].rank(); ++j) {
                if (j == dimension || toConcat[i].size(j) == outputShape[j] || toConcat[i].isVector()) continue;
                throw new IllegalArgumentException("Illegal concatenation at array " + i + " and shape element " + j);
            }
        }
        long[] sortedStrides = Nd4j.getStrides(outputShape);
        INDArray ret = Nd4j.create(outputShape, sortedStrides);
        allC &= ret.ordering() == 'c';
        if (toConcat[0].isScalar()) {
            INDArray retLinear = ret.reshape(-1L);
            int i = 0;
            while ((long)i < retLinear.length()) {
                retLinear.putScalar((long)i, toConcat[i].getDouble(0L));
                ++i;
            }
            return ret;
        }
        if (dimension == 0 && allC) {
            int currBuffer = 0;
            int currBufferOffset = 0;
            int i = 0;
            while ((long)i < ret.length()) {
                ret.data().put((long)i, toConcat[currBuffer].data().getDouble(toConcat[currBuffer].offset() + (long)currBufferOffset++));
                if ((long)currBufferOffset >= toConcat[currBuffer].length()) {
                    ++currBuffer;
                    currBufferOffset = 0;
                }
                ++i;
            }
            return ret;
        }
        int arrOffset = 0;
        if (ret.tensorsAlongDimension(dimension) > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        INDArray[] retAlongDimensionArrays = new INDArray[(int)ret.tensorsAlongDimension(dimension)];
        for (int i = 0; i < retAlongDimensionArrays.length; ++i) {
            retAlongDimensionArrays[i] = ret.tensorAlongDimension(i, dimension);
        }
        for (INDArray arr : toConcat) {
            long arrTensorLength = -1L;
            if (arr.tensorsAlongDimension(dimension) != ret.tensorsAlongDimension(dimension)) {
                throw new IllegalStateException("Illegal concatenate. Tensors along dimension must be same length.");
            }
            int i = 0;
            while ((long)i < arr.tensorsAlongDimension(dimension)) {
                INDArray retLinear = retAlongDimensionArrays[i];
                INDArray arrTensor = arr.tensorAlongDimension(i, dimension);
                arrTensorLength = arrTensor.length();
                int j = 0;
                while ((long)j < arrTensor.length()) {
                    int idx = j + arrOffset;
                    retLinear.putScalar((long)idx, arrTensor.getDouble((long)j));
                    ++j;
                }
                ++i;
            }
            arrOffset = (int)((long)arrOffset + arrTensorLength);
        }
        return ret;
    }

    @Override
    public INDArray hstack(INDArray ... arrs) {
        if (arrs == null) {
            throw new NullPointerException("arrs is marked non-null but is null");
        }
        int firstRank = arrs[0].rank();
        Preconditions.checkState((firstRank > 0 && firstRank <= 2 ? 1 : 0) != 0, (String)"Only rank 1 and 2 arrays may be horizontally stacked; first input has rank %ndRank shape %nhShape", (Object)arrs[0], (Object)arrs[0]);
        for (int i = 1; i < arrs.length; ++i) {
            Preconditions.checkState((firstRank == arrs[i].rank() ? 1 : 0) != 0, (String)"Array ranks must be equal for horizontal stacking, arrs[0].rank=%s, arrs[%s].rank=%s", (int)arrs[0].rank(), (int)i, (int)arrs[i].rank());
        }
        if (firstRank == 1) {
            return Nd4j.concat(0, arrs);
        }
        return Nd4j.concat(1, arrs);
    }

    @Override
    public INDArray vstack(INDArray ... arrs) {
        return Nd4j.concat(0, arrs);
    }

    @Override
    public INDArray zeros(int[] shape) {
        INDArray ret = this.create(shape);
        return ret;
    }

    @Override
    public INDArray zeros(long[] shape) {
        INDArray ret = this.create(shape);
        return ret;
    }

    @Override
    public INDArray ones(int[] shape) {
        INDArray ret = this.createUninitialized(shape, Nd4j.order().charValue());
        ret.assign(1);
        return ret;
    }

    @Override
    public INDArray ones(long[] shape) {
        INDArray ret = this.createUninitialized(shape, Nd4j.order().charValue());
        ret.assign(1);
        return ret;
    }

    @Override
    public INDArray create(float[] data, long rows, long columns, int[] stride, long offset) {
        return this.create(data, new long[]{rows, columns}, ArrayUtil.toLongArray((int[])stride), offset);
    }

    @Override
    public abstract INDArray create(float[] var1, int[] var2, int[] var3, long var4);

    @Override
    public INDArray create(double[] data, int[] shape) {
        return this.create(data, shape, Nd4j.getStrides(shape), 0L);
    }

    @Override
    public INDArray create(float[] data, int[] shape) {
        return this.create(data, shape, Nd4j.getStrides(shape), 0L);
    }

    @Override
    public INDArray create(float[] data, long[] shape) {
        return this.create(data, shape, Nd4j.getStrides(shape), 0L);
    }

    @Override
    public INDArray create(double[] data, long[] shape) {
        return this.create(data, shape, Nd4j.getStrides(shape), 0L);
    }

    @Override
    public INDArray create(double[] data, long rows, long columns, int[] stride, long offset) {
        return this.create(data, new long[]{rows, columns}, ArrayUtil.toLongArray((int[])stride), offset);
    }

    @Override
    public abstract INDArray create(double[] var1, int[] var2, int[] var3, long var4);

    @Override
    public abstract INDArray create(List<INDArray> var1, int[] var2);

    @Override
    public INDArray create(long rows, long columns, int[] stride, long offset) {
        throw new UnsupportedOperationException();
    }

    @Override
    public INDArray create(int[] shape, int[] stride, long offset) {
        DataBuffer buffer = Nd4j.createBuffer(ArrayUtil.prodLong((int[])shape));
        return this.create(buffer, shape, stride, offset);
    }

    @Override
    public INDArray create(long[] shape, long[] stride, long offset) {
        DataBuffer buffer = Nd4j.createBuffer(ArrayUtil.prodLong((long[])shape));
        return this.create(buffer, shape, stride, offset);
    }

    @Override
    public INDArray create(long rows, long columns, int[] stride) {
        return this.create(new long[]{rows, columns}, ArrayUtil.toLongArray((int[])stride));
    }

    @Override
    public INDArray create(long[] shape, long[] stride) {
        return this.create(shape, stride, 0L, Nd4j.order().charValue());
    }

    @Override
    public INDArray create(long[] shape, long[] stride, long offset, char ordering) {
        Shape.assertValidOrder(ordering);
        return this.create(Nd4j.createBuffer(ArrayUtil.prodLong((long[])shape)), shape, stride, offset, ordering);
    }

    @Override
    public INDArray create(int[] shape, int[] stride) {
        return this.create(shape, stride, 0L);
    }

    @Override
    public INDArray create(long rows, long columns) {
        return this.create(new long[]{rows, columns});
    }

    @Override
    public INDArray create(long[] shape) {
        return this.create(shape, Nd4j.getStrides(shape), 0L);
    }

    @Override
    public INDArray create(int[] shape) {
        return this.create(shape, Nd4j.getStrides(shape), 0L);
    }

    @Override
    public INDArray scalar(float value, long offset) {
        return this.create(new float[]{value}, new int[0], new int[0], offset);
    }

    @Override
    public INDArray scalar(double value, long offset) {
        return this.create(new double[]{value}, new int[0], new int[0], offset);
    }

    @Override
    public INDArray scalar(int value, long offset) {
        return this.create(new int[]{value}, new long[0], new long[0], DataType.INT, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    @Override
    public INDArray scalar(Number value) {
        MemoryWorkspace ws = Nd4j.getMemoryManager().getCurrentWorkspace();
        if (value instanceof Double || value instanceof AtomicDouble) {
            return this.scalar(value.doubleValue());
        }
        if (value instanceof Float) {
            return this.scalar(value.floatValue());
        }
        if (value instanceof Long || value instanceof AtomicLong) {
            return this.create(new long[]{value.longValue()}, new long[0], new long[0], DataType.LONG, ws);
        }
        if (value instanceof Integer || value instanceof AtomicInteger) {
            return this.create(new int[]{value.intValue()}, new long[0], new long[0], DataType.INT, ws);
        }
        if (value instanceof Short) {
            return this.create(new short[]{value.shortValue()}, new long[0], new long[0], DataType.SHORT, ws);
        }
        if (value instanceof Byte) {
            return this.create(new byte[]{value.byteValue()}, new long[0], new long[0], DataType.BYTE, ws);
        }
        throw new UnsupportedOperationException("Unsupported data type: [" + value.getClass().getSimpleName() + "]");
    }

    @Override
    public INDArray scalar(double value) {
        return this.create(new double[]{value}, new long[0], new long[0], DataType.DOUBLE, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    @Override
    public INDArray scalar(float value) {
        return this.create(new float[]{value}, new long[0], new long[0], DataType.FLOAT, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    @Override
    public INDArray create(float[] data, int[] shape, long offset) {
        return this.create(Nd4j.createBuffer(data), shape, offset);
    }

    @Override
    public abstract INDArray create(float[] var1, long[] var2, long[] var3, char var4, DataType var5, MemoryWorkspace var6);

    @Override
    public INDArray create(float[] data, char order) {
        long[] shape = new long[]{data.length};
        long[] stride = Nd4j.getStrides(shape, order);
        return this.create(data, shape, stride, order, DataType.FLOAT);
    }

    @Override
    public INDArray create(float[] data, int[] shape, int[] stride, char order, long offset) {
        return this.create(Nd4j.createBuffer(data), shape, stride, order, offset);
    }

    @Override
    public INDArray create(double[] data, char order) {
        Shape.assertValidOrder(order);
        return this.create(data, new long[]{data.length}, new long[]{1L}, DataType.DOUBLE, Nd4j.getMemoryManager().getCurrentWorkspace());
    }

    @Override
    public INDArray create(double[] data, int[] shape, int[] stride, char order, long offset) {
        return this.create(Nd4j.createBuffer(data), shape, stride, order, offset);
    }

    @Override
    public INDArray create(DataBuffer buffer, int[] shape, int[] stride, char order, long offset) {
        Shape.assertValidOrder(order);
        return this.create(buffer, shape, stride, offset, order);
    }

    @Override
    public INDArray create(int[] data, int[] shape, int[] stride, char order, long offset) {
        Shape.assertValidOrder(order);
        return this.create(Nd4j.createBuffer(data), shape, stride, order, offset);
    }
}

