/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.performance.primitives;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lombok.NonNull;
import org.nd4j.linalg.api.memory.MemcpyDirection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AveragingTransactionsHolder {
    private static final Logger log = LoggerFactory.getLogger(AveragingTransactionsHolder.class);
    private final List<List<Long>> storage = new ArrayList<List<Long>>(MemcpyDirection.values().length);
    private final List<ReentrantReadWriteLock> locks = new ArrayList<ReentrantReadWriteLock>(MemcpyDirection.values().length);

    public AveragingTransactionsHolder() {
        this.init();
    }

    protected void init() {
        for (MemcpyDirection v : MemcpyDirection.values()) {
            int o = v.ordinal();
            this.storage.add(o, new ArrayList());
            this.locks.add(o, new ReentrantReadWriteLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        for (MemcpyDirection v : MemcpyDirection.values()) {
            int o = v.ordinal();
            try {
                this.locks.get(o).writeLock().lock();
                this.storage.get(o).clear();
            }
            finally {
                this.locks.get(o).writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValue(@NonNull MemcpyDirection direction, Long value) {
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        int o = direction.ordinal();
        try {
            this.locks.get(o).writeLock().lock();
            this.storage.get(o).add(value);
        }
        finally {
            this.locks.get(o).writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getAverageValue(@NonNull MemcpyDirection direction) {
        if (direction == null) {
            throw new NullPointerException("direction is marked non-null but is null");
        }
        int o = direction.ordinal();
        try {
            Long r = 0L;
            this.locks.get(o).readLock().lock();
            List<Long> list = this.storage.get(o);
            if (list.isEmpty()) {
                Long l = 0L;
                return l;
            }
            for (Long v : list) {
                r = r + v;
            }
            Long l = r / (long)list.size();
            return l;
        }
        finally {
            this.locks.get(o).readLock().unlock();
        }
    }
}

