/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class UniqueWithCounts
extends DynamicCustomOp {
    private static final Logger log = LoggerFactory.getLogger(UniqueWithCounts.class);
    public static final DataType DEFAULT_IDX_DTYPE = DataType.INT;
    private DataType idxDataType;

    public UniqueWithCounts() {
    }

    public UniqueWithCounts(SameDiff sd, SDVariable in) {
        super(sd, new SDVariable[]{in}, false);
    }

    @Override
    public String opName() {
        return "unique_with_counts";
    }

    @Override
    public String[] tensorflowNames() {
        return new String[]{"UniqueWithCounts", "UniqueWithCountsV2"};
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> i_v) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public int numOutputArguments() {
        return 3;
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        this.idxDataType = TFGraphMapper.convertType(nodeDef.getAttrOrThrow("out_idx").getType());
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() >= 1 ? 1 : 0) != 0, (String)"Expected exactly 1 or more input datatypes for %s, got %s", this.getClass(), dataTypes);
        if (dataTypes.size() > 1) {
            log.warn("Using returning first data type of type " + (Object)((Object)dataTypes.get(0)) + " for input");
        }
        DataType d = this.idxDataType == null ? DEFAULT_IDX_DTYPE : this.idxDataType;
        return Arrays.asList(dataTypes.get(0), d, d);
    }
}

