/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.transforms.custom;

import java.util.Collections;
import java.util.List;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.transforms.custom.StandardizeBp;

public class Standardize
extends DynamicCustomOp {
    public Standardize(SameDiff sameDiff, SDVariable i_v, int ... dimensions) {
        super(null, sameDiff, new SDVariable[]{i_v}, false);
        this.setDimensions(dimensions);
    }

    public Standardize(INDArray input, int ... dimensions) {
        this(input, null, dimensions);
    }

    public Standardize(INDArray input, INDArray result, int ... dimensions) {
        super("standardize", new INDArray[]{input}, Standardize.wrapOrNull(result));
        this.setDimensions(dimensions);
    }

    public Standardize() {
    }

    @Override
    public void setDimensions(int[] dimensions) {
        Preconditions.checkArgument((dimensions != null ? 1 : 0) != 0, (String)"Standardize: You have to provide dimensions");
        Preconditions.checkArgument((dimensions.length > 0 ? 1 : 0) != 0, (String)"Standardize: You have to provide dimensions");
        this.dimensions = dimensions;
        this.addIArgument(dimensions);
    }

    @Override
    public String opName() {
        return "standardize";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        return new StandardizeBp(this.sameDiff, this.arg(0), grad.get(0), this.dimensions).outputs();
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 input datatype for %s, got %s", this.getClass(), dataTypes);
        Preconditions.checkState((boolean)dataTypes.get(0).isFPType(), (String)"Input must be a floating point type, got %s", (Object)((Object)dataTypes.get(0)));
        return Collections.singletonList(dataTypes.get(0));
    }
}

