/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.scatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.NoOpNameFoundException;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class ScatterUpdate
extends DynamicCustomOp {
    public ScatterUpdate(SameDiff sameDiff, SDVariable ref, SDVariable indices, SDVariable updates) {
        super(null, sameDiff, new SDVariable[]{ref, indices, updates}, false);
    }

    public ScatterUpdate() {
    }

    public ScatterUpdate(INDArray ref, INDArray indices, INDArray update) {
        super(new INDArray[]{ref, indices, update}, null);
    }

    @Override
    public String opName() {
        return "scatter_update";
    }

    @Override
    public String onnxName() {
        throw new NoOpNameFoundException("No onnx op opName found for " + this.opName());
    }

    @Override
    public String tensorflowName() {
        return "ScatterUpdate";
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        if (nodeDef.containsAttr("use_locking")) {
            if (nodeDef.getAttrOrThrow("use_locking").getB()) {
                this.bArguments.add(true);
            } else {
                this.bArguments.add(false);
            }
        } else {
            this.bArguments.add(false);
        }
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> gradOut) {
        SDVariable indices = this.arg(1);
        SDVariable updates = this.arg(2);
        ArrayList<SDVariable> ret = new ArrayList<SDVariable>(3);
        SDVariable zerosUpdate = this.sameDiff.zerosLike(updates);
        SDVariable gradRef = this.sameDiff.scatterMul(gradOut.get(0), indices, zerosUpdate);
        ret.add(gradRef);
        ret.add(this.sameDiff.zerosLike(this.arg(1)));
        SDVariable gather = this.sameDiff.gather(gradOut.get(0), indices, 0);
        ret.add(gather);
        return ret;
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> inputDataTypes) {
        Preconditions.checkState((inputDataTypes != null && inputDataTypes.size() == 3 ? 1 : 0) != 0, (String)"Expected exactly 3 input datatypes for %s, got %s", this.getClass(), inputDataTypes);
        Preconditions.checkState((inputDataTypes.get(0) == inputDataTypes.get(2) ? 1 : 0) != 0, (String)"Reference (input 0) and updates (input 2) must have exactly same data types, got %s and %s", (Object)((Object)inputDataTypes.get(0)), (Object)((Object)inputDataTypes.get(2)));
        return Collections.singletonList(inputDataTypes.get(0));
    }

    public static enum UpdateOp {
        ADD,
        SUBTRACT,
        MULTIPLY,
        DIVIDE,
        REVERSE_SUBTRACT,
        REVERSE_DIVIDE,
        ASSIGN;

    }
}

