/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.ops.impl.reduce;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.common.base.Preconditions;
import org.nd4j.imports.graphmapper.tf.TFGraphMapper;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.DynamicCustomOp;
import org.nd4j.linalg.api.ops.impl.reduce.bp.MeanBp;
import org.nd4j.linalg.api.ops.impl.reduce.bp.VarianceBp;
import org.nd4j.linalg.factory.Nd4j;
import org.tensorflow.framework.AttrValue;
import org.tensorflow.framework.GraphDef;
import org.tensorflow.framework.NodeDef;

public class Moments
extends DynamicCustomOp {
    private int[] axes;

    public Moments(@NonNull INDArray input, int ... axes) {
        super(new INDArray[]{input}, null);
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.axes = axes;
        this.addArgs();
    }

    public Moments(SameDiff sameDiff, SDVariable input) {
        this(sameDiff, input, null);
    }

    public Moments(SameDiff sameDiff, SDVariable input, int[] axes) {
        super(null, sameDiff, new SDVariable[]{input}, false);
        this.axes = axes;
        this.addArgs();
    }

    public Moments(INDArray in, INDArray outMean, INDArray outStd, int ... axes) {
        super(null, new INDArray[]{in}, new INDArray[]{outMean, outStd}, null, axes);
    }

    private void addArgs() {
        if (this.axes != null) {
            for (int axis : this.axes) {
                this.addIArgument(axis);
            }
        }
    }

    @Override
    public void initFromTensorFlow(NodeDef nodeDef, SameDiff initWith, Map<String, AttrValue> attributesForNode, GraphDef graph) {
        TFGraphMapper.initFunctionFromProperties(nodeDef.getOp(), this, attributesForNode, nodeDef, graph);
        this.addArgs();
    }

    @Override
    public String opName() {
        return "moments";
    }

    @Override
    public List<SDVariable> doDiff(List<SDVariable> grad) {
        SDVariable dLdMean = grad.get(0);
        SDVariable dLdVar = grad.get(1);
        SDVariable meanBp = new MeanBp(this.sameDiff, this.arg(), dLdMean, false, this.axes).outputVariable();
        SDVariable varBp = new VarianceBp(this.sameDiff, this.arg(), dLdVar, false, false, this.axes).outputVariable();
        return Collections.singletonList(meanBp.add(varBp));
    }

    @Override
    public List<DataType> calculateOutputDataTypes(List<DataType> dataTypes) {
        Preconditions.checkState((dataTypes != null && dataTypes.size() == 1 ? 1 : 0) != 0, (String)"Expected 1 datatype for %s, got %s", this.getClass(), dataTypes);
        if (dataTypes.get(0).isFPType()) {
            return Arrays.asList(dataTypes.get(0), dataTypes.get(0));
        }
        return Arrays.asList(Nd4j.defaultFloatingPointType(), Nd4j.defaultFloatingPointType());
    }

    public Moments() {
    }
}

