/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas.impl;

import org.nd4j.linalg.api.blas.Level2;
import org.nd4j.linalg.api.blas.impl.BaseLevel;
import org.nd4j.linalg.api.blas.params.GemvParameters;
import org.nd4j.linalg.api.blas.params.MMulTranspose;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.executioner.DefaultOpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpExecutioner;
import org.nd4j.linalg.api.ops.executioner.OpExecutionerUtil;
import org.nd4j.linalg.api.ops.impl.reduce.Mmul;
import org.nd4j.linalg.exception.ND4JArraySizeException;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.profiler.OpProfiler;

public abstract class BaseLevel2
extends BaseLevel
implements Level2 {
    @Override
    public void gemv(char order, char transA, double alpha, INDArray A, INDArray X, double beta, INDArray Y) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X, Y);
        }
        GemvParameters parameters = new GemvParameters(A, X, Y);
        Nd4j.exec(new Mmul(A, X, Y, alpha, beta, MMulTranspose.builder().transposeA(false).build()));
        OpExecutionerUtil.checkForAny(Y);
    }

    @Override
    public void gbmv(char order, char TransA, int KL, int KU, double alpha, INDArray A, INDArray X, double beta, INDArray Y) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X, Y);
        }
        if (A.data().dataType() == DataType.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataType.DOUBLE, A, X, Y);
            if (A.rows() > Integer.MAX_VALUE || A.columns() > Integer.MAX_VALUE || A.size(0) > Integer.MAX_VALUE) {
                throw new ND4JArraySizeException();
            }
            this.dgbmv(order, TransA, A.rows(), A.columns(), KL, KU, alpha, A, (int)A.size(0), X, X.stride(-1), beta, Y, Y.stride(-1));
        } else {
            DefaultOpExecutioner.validateDataType(DataType.FLOAT, A, X, Y);
            this.sgbmv(order, TransA, A.rows(), A.columns(), KL, KU, (float)alpha, A, (int)A.size(0), X, X.stride(-1), (float)beta, Y, Y.stride(-1));
        }
        OpExecutionerUtil.checkForAny(Y);
    }

    @Override
    public void ger(char order, double alpha, INDArray X, INDArray Y, INDArray A) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X, Y);
        }
        if (X.data().dataType() == DataType.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataType.DOUBLE, A, X, Y);
            if (A.rows() > Integer.MAX_VALUE || A.columns() > Integer.MAX_VALUE || A.size(0) > Integer.MAX_VALUE) {
                throw new ND4JArraySizeException();
            }
            this.dger(order, A.rows(), A.columns(), alpha, X, X.stride(-1), Y, Y.stride(-1), A, (int)A.size(0));
        } else {
            DefaultOpExecutioner.validateDataType(DataType.FLOAT, A, X, Y);
            this.sger(order, A.rows(), A.columns(), (float)alpha, X, X.stride(-1), Y, Y.stride(-1), A, (int)A.size(0));
        }
        OpExecutionerUtil.checkForAny(A);
    }

    @Override
    public void sbmv(char order, char Uplo, double alpha, INDArray A, INDArray X, double beta, INDArray Y) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X, Y);
        }
        if (X.length() > Integer.MAX_VALUE || A.columns() > Integer.MAX_VALUE || A.size(0) > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        if (X.data().dataType() == DataType.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataType.DOUBLE, A, X, Y);
            this.dsbmv(order, Uplo, (int)X.length(), A.columns(), alpha, A, (int)A.size(0), X, X.stride(-1), beta, Y, Y.stride(-1));
        } else {
            DefaultOpExecutioner.validateDataType(DataType.FLOAT, A, X, Y);
            this.ssbmv(order, Uplo, (int)X.length(), A.columns(), (float)alpha, A, (int)A.size(0), X, X.stride(-1), (float)beta, Y, Y.stride(-1));
        }
        OpExecutionerUtil.checkForAny(Y);
    }

    @Override
    public void spmv(char order, char Uplo, double alpha, INDArray Ap, INDArray X, double beta, INDArray Y) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, Ap, X, Y);
        }
        if (X.length() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        if (Ap.data().dataType() == DataType.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataType.DOUBLE, X, Y);
            this.dspmv(order, Uplo, (int)X.length(), alpha, Ap, X, Ap.stride(-1), beta, Y, Y.stride(-1));
        } else {
            DefaultOpExecutioner.validateDataType(DataType.FLOAT, X, Y);
            this.sspmv(order, Uplo, (int)X.length(), (float)alpha, Ap, X, Ap.stride(-1), (float)beta, Y, Y.stride(-1));
        }
        OpExecutionerUtil.checkForAny(Y);
    }

    @Override
    public void spr(char order, char Uplo, double alpha, INDArray X, INDArray Ap) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, Ap, X);
        }
        if (X.length() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        if (X.data().dataType() == DataType.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataType.DOUBLE, X, new INDArray[0]);
            this.dspr(order, Uplo, (int)X.length(), alpha, X, X.stride(-1), Ap);
        } else {
            DefaultOpExecutioner.validateDataType(DataType.FLOAT, X, new INDArray[0]);
            this.sspr(order, Uplo, (int)X.length(), (float)alpha, X, X.stride(-1), Ap);
        }
        OpExecutionerUtil.checkForAny(Ap);
    }

    @Override
    public void spr2(char order, char Uplo, double alpha, INDArray X, INDArray Y, INDArray A) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X, Y);
        }
        if (X.length() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        if (X.data().dataType() == DataType.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataType.DOUBLE, A, X, Y);
            this.dspr2(order, Uplo, (int)X.length(), alpha, X, X.stride(-1), Y, Y.stride(-1), A);
        } else {
            DefaultOpExecutioner.validateDataType(DataType.FLOAT, A, X, Y);
            this.sspr2(order, Uplo, (int)X.length(), (float)alpha, X, X.stride(-1), Y, Y.stride(-1), A);
        }
        OpExecutionerUtil.checkForAny(A);
    }

    @Override
    public void symv(char order, char Uplo, double alpha, INDArray A, INDArray X, double beta, INDArray Y) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X, Y);
        }
        if (X.length() > Integer.MAX_VALUE || A.size(0) > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        if (X.data().dataType() == DataType.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataType.DOUBLE, A, X, Y);
            this.dsymv(order, Uplo, (int)X.length(), alpha, A, (int)A.size(0), X, X.stride(-1), beta, Y, Y.stride(-1));
        } else {
            DefaultOpExecutioner.validateDataType(DataType.FLOAT, A, X, Y);
            this.ssymv(order, Uplo, (int)X.length(), (float)alpha, A, (int)A.size(0), X, X.stride(-1), (float)beta, Y, Y.stride(-1));
        }
        OpExecutionerUtil.checkForAny(Y);
    }

    @Override
    public void syr(char order, char Uplo, int N, double alpha, INDArray X, INDArray A) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X);
        }
        if (X.length() > Integer.MAX_VALUE || A.size(0) > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        if (X.data().dataType() == DataType.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataType.DOUBLE, A, X);
            this.dsyr(order, Uplo, (int)X.length(), alpha, X, X.stride(-1), A, (int)A.size(0));
        } else {
            DefaultOpExecutioner.validateDataType(DataType.FLOAT, A, X);
            this.ssyr(order, Uplo, (int)X.length(), (float)alpha, X, X.stride(-1), A, (int)A.size(0));
        }
        OpExecutionerUtil.checkForAny(A);
    }

    @Override
    public void syr2(char order, char Uplo, double alpha, INDArray X, INDArray Y, INDArray A) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X, Y);
        }
        if (X.length() > Integer.MAX_VALUE || A.size(0) > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        if (X.data().dataType() == DataType.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataType.DOUBLE, A, X, Y);
            this.dsyr2(order, Uplo, (int)X.length(), alpha, X, X.stride(-1), Y, Y.stride(-1), A, (int)A.size(0));
        } else {
            DefaultOpExecutioner.validateDataType(DataType.FLOAT, A, X, Y);
            this.ssyr2(order, Uplo, (int)X.length(), (float)alpha, X, X.stride(-1), Y, Y.stride(-1), A, (int)A.size(0));
        }
        OpExecutionerUtil.checkForAny(A);
    }

    @Override
    public void tbmv(char order, char Uplo, char TransA, char Diag2, INDArray A, INDArray X) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X);
        }
        if (X.length() > Integer.MAX_VALUE || A.columns() > Integer.MAX_VALUE || A.size(0) > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        if (X.data().dataType() == DataType.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataType.DOUBLE, A, X);
            this.dtbmv(order, Uplo, TransA, Diag2, (int)X.length(), A.columns(), A, (int)A.size(0), X, X.stride(-1));
        } else {
            DefaultOpExecutioner.validateDataType(DataType.FLOAT, A, X);
            this.stbmv(order, Uplo, TransA, Diag2, (int)X.length(), A.columns(), A, (int)A.size(0), X, X.stride(-1));
        }
    }

    @Override
    public void tbsv(char order, char Uplo, char TransA, char Diag2, INDArray A, INDArray X) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X);
        }
        if (X.length() > Integer.MAX_VALUE || A.columns() > Integer.MAX_VALUE || A.size(0) > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        if (X.data().dataType() == DataType.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataType.DOUBLE, A, X);
            this.dtbsv(order, Uplo, TransA, Diag2, (int)X.length(), A.columns(), A, (int)A.size(0), X, X.stride(-1));
        } else {
            DefaultOpExecutioner.validateDataType(DataType.FLOAT, A, X);
            this.stbsv(order, Uplo, TransA, Diag2, (int)X.length(), A.columns(), A, (int)A.size(0), X, X.stride(-1));
        }
    }

    @Override
    public void tpmv(char order, char Uplo, char TransA, char Diag2, INDArray Ap, INDArray X) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, Ap, X);
        }
        if (Ap.length() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        if (X.data().dataType() == DataType.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataType.DOUBLE, X, new INDArray[0]);
            this.dtpmv(order, Uplo, TransA, Diag2, (int)Ap.length(), Ap, X, X.stride(-1));
        } else {
            DefaultOpExecutioner.validateDataType(DataType.FLOAT, X, new INDArray[0]);
            this.stpmv(order, Uplo, TransA, Diag2, (int)Ap.length(), Ap, X, X.stride(-1));
        }
        OpExecutionerUtil.checkForAny(X);
    }

    @Override
    public void tpsv(char order, char Uplo, char TransA, char Diag2, INDArray Ap, INDArray X) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, Ap, X);
        }
        if (X.length() > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        if (X.data().dataType() == DataType.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataType.DOUBLE, X, Ap);
            this.dtpsv(order, Uplo, TransA, Diag2, (int)X.length(), Ap, X, X.stride(-1));
        } else {
            DefaultOpExecutioner.validateDataType(DataType.FLOAT, Ap, X);
            this.stpsv(order, Uplo, TransA, Diag2, (int)X.length(), Ap, X, X.stride(-1));
        }
        OpExecutionerUtil.checkForAny(X);
    }

    @Override
    public void trmv(char order, char Uplo, char TransA, char Diag2, INDArray A, INDArray X) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X);
        }
        if (X.length() > Integer.MAX_VALUE || A.size(0) > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        if (A.data().dataType() == DataType.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataType.DOUBLE, A, X);
            this.dtrmv(order, Uplo, TransA, Diag2, (int)X.length(), A, (int)A.size(0), X, X.stride(-1));
        } else {
            DefaultOpExecutioner.validateDataType(DataType.FLOAT, A, X);
            this.strmv(order, Uplo, TransA, Diag2, (int)X.length(), A, (int)A.size(0), X, X.stride(-1));
        }
        OpExecutionerUtil.checkForAny(X);
    }

    @Override
    public void trsv(char order, char Uplo, char TransA, char Diag2, INDArray A, INDArray X) {
        if (Nd4j.getExecutioner().getProfilingMode() == OpExecutioner.ProfilingMode.ALL) {
            OpProfiler.getInstance().processBlasCall(false, A, X);
        }
        if (A.length() > Integer.MAX_VALUE || A.size(0) > Integer.MAX_VALUE) {
            throw new ND4JArraySizeException();
        }
        if (X.data().dataType() == DataType.DOUBLE) {
            DefaultOpExecutioner.validateDataType(DataType.DOUBLE, A, X);
            this.dtrsv(order, Uplo, TransA, Diag2, (int)A.length(), A, (int)A.size(0), X, X.stride(-1));
        } else {
            DefaultOpExecutioner.validateDataType(DataType.FLOAT, A, X);
            this.strsv(order, Uplo, TransA, Diag2, (int)A.length(), A, (int)A.size(0), X, X.stride(-1));
        }
        OpExecutionerUtil.checkForAny(X);
    }

    protected abstract void sgemv(char var1, char var2, int var3, int var4, float var5, INDArray var6, int var7, INDArray var8, int var9, float var10, INDArray var11, int var12);

    protected abstract void sgbmv(char var1, char var2, int var3, int var4, int var5, int var6, float var7, INDArray var8, int var9, INDArray var10, int var11, float var12, INDArray var13, int var14);

    protected abstract void strmv(char var1, char var2, char var3, char var4, int var5, INDArray var6, int var7, INDArray var8, int var9);

    protected abstract void stbmv(char var1, char var2, char var3, char var4, int var5, int var6, INDArray var7, int var8, INDArray var9, int var10);

    protected abstract void stpmv(char var1, char var2, char var3, char var4, int var5, INDArray var6, INDArray var7, int var8);

    protected abstract void strsv(char var1, char var2, char var3, char var4, int var5, INDArray var6, int var7, INDArray var8, int var9);

    protected abstract void stbsv(char var1, char var2, char var3, char var4, int var5, int var6, INDArray var7, int var8, INDArray var9, int var10);

    protected abstract void stpsv(char var1, char var2, char var3, char var4, int var5, INDArray var6, INDArray var7, int var8);

    protected abstract void dgemv(char var1, char var2, int var3, int var4, double var5, INDArray var7, int var8, INDArray var9, int var10, double var11, INDArray var13, int var14);

    protected abstract void dgbmv(char var1, char var2, int var3, int var4, int var5, int var6, double var7, INDArray var9, int var10, INDArray var11, int var12, double var13, INDArray var15, int var16);

    protected abstract void dtrmv(char var1, char var2, char var3, char var4, int var5, INDArray var6, int var7, INDArray var8, int var9);

    protected abstract void dtbmv(char var1, char var2, char var3, char var4, int var5, int var6, INDArray var7, int var8, INDArray var9, int var10);

    protected abstract void dtpmv(char var1, char var2, char var3, char var4, int var5, INDArray var6, INDArray var7, int var8);

    protected abstract void dtrsv(char var1, char var2, char var3, char var4, int var5, INDArray var6, int var7, INDArray var8, int var9);

    protected abstract void dtbsv(char var1, char var2, char var3, char var4, int var5, int var6, INDArray var7, int var8, INDArray var9, int var10);

    protected abstract void dtpsv(char var1, char var2, char var3, char var4, int var5, INDArray var6, INDArray var7, int var8);

    protected abstract void ssymv(char var1, char var2, int var3, float var4, INDArray var5, int var6, INDArray var7, int var8, float var9, INDArray var10, int var11);

    protected abstract void ssbmv(char var1, char var2, int var3, int var4, float var5, INDArray var6, int var7, INDArray var8, int var9, float var10, INDArray var11, int var12);

    protected abstract void sspmv(char var1, char var2, int var3, float var4, INDArray var5, INDArray var6, int var7, float var8, INDArray var9, int var10);

    protected abstract void sger(char var1, int var2, int var3, float var4, INDArray var5, int var6, INDArray var7, int var8, INDArray var9, int var10);

    protected abstract void ssyr(char var1, char var2, int var3, float var4, INDArray var5, int var6, INDArray var7, int var8);

    protected abstract void sspr(char var1, char var2, int var3, float var4, INDArray var5, int var6, INDArray var7);

    protected abstract void ssyr2(char var1, char var2, int var3, float var4, INDArray var5, int var6, INDArray var7, int var8, INDArray var9, int var10);

    protected abstract void sspr2(char var1, char var2, int var3, float var4, INDArray var5, int var6, INDArray var7, int var8, INDArray var9);

    protected abstract void dsymv(char var1, char var2, int var3, double var4, INDArray var6, int var7, INDArray var8, int var9, double var10, INDArray var12, int var13);

    protected abstract void dsbmv(char var1, char var2, int var3, int var4, double var5, INDArray var7, int var8, INDArray var9, int var10, double var11, INDArray var13, int var14);

    protected abstract void dspmv(char var1, char var2, int var3, double var4, INDArray var6, INDArray var7, int var8, double var9, INDArray var11, int var12);

    protected abstract void dger(char var1, int var2, int var3, double var4, INDArray var6, int var7, INDArray var8, int var9, INDArray var10, int var11);

    protected abstract void dsyr(char var1, char var2, int var3, double var4, INDArray var6, int var7, INDArray var8, int var9);

    protected abstract void dspr(char var1, char var2, int var3, double var4, INDArray var6, int var7, INDArray var8);

    protected abstract void dsyr2(char var1, char var2, int var3, double var4, INDArray var6, int var7, INDArray var8, int var9, INDArray var10, int var11);

    protected abstract void dspr2(char var1, char var2, int var3, double var4, INDArray var6, int var7, INDArray var8, int var9, INDArray var10);
}

