/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.execution.input;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.NonNull;
import org.nd4j.common.primitives.Pair;
import org.nd4j.linalg.api.ndarray.INDArray;

public class Operands {
    private Map<NodeDescriptor, INDArray> map = new LinkedHashMap<NodeDescriptor, INDArray>();

    public Operands addArgument(@NonNull String id, @NonNull INDArray array) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        this.map.put(NodeDescriptor.builder().name(id).build(), array);
        return this;
    }

    public Operands addArgument(int id, @NonNull INDArray array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        this.map.put(NodeDescriptor.builder().id(id).build(), array);
        return this;
    }

    public Operands addArgument(int id, int index, @NonNull INDArray array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        this.map.put(NodeDescriptor.builder().id(id).index(index).build(), array);
        return this;
    }

    public Operands addArgument(String name, int id, int index, @NonNull INDArray array) {
        if (array == null) {
            throw new NullPointerException("array is marked non-null but is null");
        }
        this.map.put(NodeDescriptor.builder().name(name).id(id).index(index).build(), array);
        return this;
    }

    public INDArray getById(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.map.get(NodeDescriptor.builder().name(name).build());
    }

    public INDArray getById(int id) {
        return this.map.get(NodeDescriptor.builder().id(id).build());
    }

    public INDArray getById(int id, int index) {
        return this.map.get(NodeDescriptor.builder().id(id).index(index).build());
    }

    public INDArray[] asArray() {
        Collection<INDArray> val = this.map.values();
        INDArray[] res = new INDArray[val.size()];
        int cnt = 0;
        for (INDArray v : val) {
            res[cnt++] = v;
        }
        return res;
    }

    public Collection<Pair<NodeDescriptor, INDArray>> asCollection() {
        HashSet<Pair<NodeDescriptor, INDArray>> c = new HashSet<Pair<NodeDescriptor, INDArray>>();
        for (NodeDescriptor k : this.map.keySet()) {
            c.add((Pair<NodeDescriptor, INDArray>)Pair.makePair((Object)k, (Object)this.map.get(k)));
        }
        return c;
    }

    public int size() {
        return this.map.size();
    }

    public static class NodeDescriptor {
        private String name;
        private int id;
        private int index;

        public static NodeDescriptorBuilder builder() {
            return new NodeDescriptorBuilder();
        }

        public NodeDescriptor() {
        }

        public NodeDescriptor(String name, int id, int index) {
            this.name = name;
            this.id = id;
            this.index = index;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public int getIndex() {
            return this.index;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setId(int id) {
            this.id = id;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NodeDescriptor)) {
                return false;
            }
            NodeDescriptor other = (NodeDescriptor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getId() != other.getId()) {
                return false;
            }
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NodeDescriptor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getId();
            result = result * 59 + this.getIndex();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "Operands.NodeDescriptor(name=" + this.getName() + ", id=" + this.getId() + ", index=" + this.getIndex() + ")";
        }

        public static class NodeDescriptorBuilder {
            private String name;
            private int id;
            private int index;

            NodeDescriptorBuilder() {
            }

            public NodeDescriptorBuilder name(String name) {
                this.name = name;
                return this;
            }

            public NodeDescriptorBuilder id(int id) {
                this.id = id;
                return this;
            }

            public NodeDescriptorBuilder index(int index) {
                this.index = index;
                return this;
            }

            public NodeDescriptor build() {
                return new NodeDescriptor(this.name, this.id, this.index);
            }

            public String toString() {
                return "Operands.NodeDescriptor.NodeDescriptorBuilder(name=" + this.name + ", id=" + this.id + ", index=" + this.index + ")";
            }
        }
    }
}

