/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.profiler.data.primitives;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.nd4j.linalg.profiler.data.primitives.StackDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StackNode
implements Comparable<StackNode> {
    private static final Logger log = LoggerFactory.getLogger(StackNode.class);
    private final String nodeURI;
    protected Map<String, StackNode> entries = new HashMap<String, StackNode>();
    protected AtomicLong counter = new AtomicLong(0L);

    public StackNode(@NonNull String uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        this.nodeURI = uri;
    }

    public Collection<StackNode> getNodes() {
        return this.entries.values();
    }

    public void traverse(int ownLevel, boolean displayCounts) {
        StringBuilder builder = new StringBuilder();
        for (int x = 0; x < ownLevel; ++x) {
            builder.append("   ");
        }
        builder.append("").append(this.nodeURI);
        if (displayCounts) {
            builder.append("  ").append(this.counter.get()).append(" us");
        }
        System.out.println(builder.toString());
        for (StackNode node : this.entries.values()) {
            node.traverse(ownLevel + 1, displayCounts);
        }
    }

    public void consume(@NonNull StackDescriptor descriptor, int lastLevel) {
        if (descriptor == null) {
            throw new NullPointerException("descriptor is marked non-null but is null");
        }
        this.consume(descriptor, lastLevel, 1L);
    }

    public void consume(@NonNull StackDescriptor descriptor, int lastLevel, long delta) {
        if (descriptor == null) {
            throw new NullPointerException("descriptor is marked non-null but is null");
        }
        boolean gotEntry = false;
        for (int e = 0; e < descriptor.size(); ++e) {
            String entryName = descriptor.getElementName(e);
            if (!gotEntry) {
                if (!entryName.equalsIgnoreCase(this.nodeURI) || e < lastLevel) continue;
                gotEntry = true;
                this.counter.addAndGet(delta);
                continue;
            }
            if (!this.entries.containsKey(entryName)) {
                this.entries.put(entryName, new StackNode(entryName));
            }
            this.entries.get(entryName).consume(descriptor, e);
            break;
        }
    }

    @Override
    public int compareTo(StackNode o) {
        return Long.compare(o.counter.get(), this.counter.get());
    }
}

