/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.learning.regularization;

import lombok.NonNull;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.api.ops.impl.transforms.pairwise.arithmetic.Axpy;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.linalg.learning.regularization.Regularization;
import org.nd4j.linalg.ops.transforms.Transforms;
import org.nd4j.linalg.schedule.FixedSchedule;
import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class L1Regularization
implements Regularization {
    protected final ISchedule l1;

    public L1Regularization(double l1) {
        this(new FixedSchedule(l1));
    }

    public L1Regularization(@JsonProperty(value="l1") @NonNull ISchedule l1) {
        if (l1 == null) {
            throw new NullPointerException("l1 is marked non-null but is null");
        }
        this.l1 = l1;
    }

    @Override
    public Regularization.ApplyStep applyStep() {
        return Regularization.ApplyStep.BEFORE_UPDATER;
    }

    @Override
    public void apply(INDArray param, INDArray gradView, double lr, int iteration, int epoch) {
        double coeff = this.l1.valueAt(iteration, epoch);
        INDArray sign = Transforms.sign(param, true);
        Nd4j.exec(new Axpy(sign, gradView, gradView, coeff));
    }

    @Override
    public double score(INDArray param, int iteration, int epoch) {
        return this.l1.valueAt(iteration, epoch) * param.norm1Number().doubleValue();
    }

    @Override
    public Regularization clone() {
        return new L1Regularization(this.l1.clone());
    }

    public ISchedule getL1() {
        return this.l1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof L1Regularization)) {
            return false;
        }
        L1Regularization other = (L1Regularization)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ISchedule this$l1 = this.getL1();
        ISchedule other$l1 = other.getL1();
        return !(this$l1 == null ? other$l1 != null : !this$l1.equals(other$l1));
    }

    protected boolean canEqual(Object other) {
        return other instanceof L1Regularization;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ISchedule $l1 = this.getL1();
        result = result * 59 + ($l1 == null ? 43 : $l1.hashCode());
        return result;
    }

    public String toString() {
        return "L1Regularization(l1=" + this.getL1() + ")";
    }
}

