/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.dataset.api.preprocessor;

import org.nd4j.common.base.Preconditions;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.DataSetPreProcessor;

public class PermuteDataSetPreProcessor
implements DataSetPreProcessor {
    private final PermutationTypes permutationType;
    private final int[] rearrange;

    public PermuteDataSetPreProcessor(PermutationTypes permutationType) {
        Preconditions.checkArgument((permutationType != PermutationTypes.Custom ? 1 : 0) != 0, (String)"Use the ctor PermuteDataSetPreProcessor(int... rearrange) for custom permutations.");
        this.permutationType = permutationType;
        this.rearrange = null;
    }

    public PermuteDataSetPreProcessor(int ... rearrange) {
        this.permutationType = PermutationTypes.Custom;
        this.rearrange = rearrange;
    }

    @Override
    public void preProcess(DataSet dataSet) {
        INDArray output;
        Preconditions.checkNotNull((Object)dataSet, (String)"Encountered null dataSet");
        if (dataSet.isEmpty()) {
            return;
        }
        INDArray input = dataSet.getFeatures();
        switch (this.permutationType) {
            case NCHWtoNHWC: {
                output = input.permute(0, 2, 3, 1);
                break;
            }
            case NHWCtoNCHW: {
                output = input.permute(0, 3, 1, 2);
                break;
            }
            case Custom: {
                output = input.permute(this.rearrange);
                break;
            }
            default: {
                output = input;
            }
        }
        dataSet.setFeatures(output);
    }

    public static enum PermutationTypes {
        NCHWtoNHWC,
        NHWCtoNCHW,
        Custom;

    }
}

