/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.shape.options;

import lombok.NonNull;
import org.nd4j.linalg.api.shape.Shape;
import org.nd4j.linalg.api.shape.options.ArrayType;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.linalg.exception.ND4JUnknownDataTypeException;
import org.tensorflow.framework.DataType;

public class ArrayOptionsHelper {
    public static final long ATYPE_SPARSE_BIT = 2L;
    public static final long ATYPE_COMPRESSED_BIT = 4L;
    public static final long ATYPE_EMPTY_BIT = 8L;
    public static final long DTYPE_COMPRESSED_BIT = 4L;
    public static final long DTYPE_BFLOAT16_BIT = 2048L;
    public static final long DTYPE_HALF_BIT = 4096L;
    public static final long DTYPE_FLOAT_BIT = 8192L;
    public static final long DTYPE_DOUBLE_BIT = 16384L;
    public static final long DTYPE_INT_BIT = 131072L;
    public static final long DTYPE_LONG_BIT = 262144L;
    public static final long DTYPE_BOOL_BIT = 524288L;
    public static final long DTYPE_BYTE_BIT = 32768L;
    public static final long DTYPE_SHORT_BIT = 65536L;
    public static final long DTYPE_UTF8_BIT = 0x100000L;
    public static final long DTYPE_UNSIGNED_BIT = 0x800000L;
    public static final long HAS_PADDED_BUFFER = 0x2000000L;

    public static boolean hasBitSet(long[] shapeInfo, long bit) {
        long opt = Shape.options(shapeInfo);
        return ArrayOptionsHelper.hasBitSet(opt, bit);
    }

    public static long setOptionBit(long extras, long bit) {
        return extras | bit;
    }

    public static void setOptionBit(long[] storage, ArrayType type) {
        int length = Shape.shapeInfoLength(storage);
        storage[length - 3] = ArrayOptionsHelper.setOptionBit(storage[length - 3], type);
    }

    public static boolean hasBitSet(long storage, long bit) {
        return (storage & bit) == bit;
    }

    public static ArrayType arrayType(long[] shapeInfo) {
        long opt = Shape.options(shapeInfo);
        if (ArrayOptionsHelper.hasBitSet(opt, 2L)) {
            return ArrayType.SPARSE;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 4L)) {
            return ArrayType.COMPRESSED;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 8L)) {
            return ArrayType.EMPTY;
        }
        return ArrayType.DENSE;
    }

    public static org.nd4j.linalg.api.buffer.DataType dataType(long opt) {
        if (ArrayOptionsHelper.hasBitSet(opt, 4L)) {
            return org.nd4j.linalg.api.buffer.DataType.COMPRESSED;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 4096L)) {
            return org.nd4j.linalg.api.buffer.DataType.HALF;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 2048L)) {
            return org.nd4j.linalg.api.buffer.DataType.BFLOAT16;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 8192L)) {
            return org.nd4j.linalg.api.buffer.DataType.FLOAT;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 16384L)) {
            return org.nd4j.linalg.api.buffer.DataType.DOUBLE;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 131072L)) {
            return ArrayOptionsHelper.hasBitSet(opt, 0x800000L) ? org.nd4j.linalg.api.buffer.DataType.UINT32 : org.nd4j.linalg.api.buffer.DataType.INT;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 262144L)) {
            return ArrayOptionsHelper.hasBitSet(opt, 0x800000L) ? org.nd4j.linalg.api.buffer.DataType.UINT64 : org.nd4j.linalg.api.buffer.DataType.LONG;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 524288L)) {
            return org.nd4j.linalg.api.buffer.DataType.BOOL;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 32768L)) {
            return ArrayOptionsHelper.hasBitSet(opt, 0x800000L) ? org.nd4j.linalg.api.buffer.DataType.UBYTE : org.nd4j.linalg.api.buffer.DataType.BYTE;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 65536L)) {
            return ArrayOptionsHelper.hasBitSet(opt, 0x800000L) ? org.nd4j.linalg.api.buffer.DataType.UINT16 : org.nd4j.linalg.api.buffer.DataType.SHORT;
        }
        if (ArrayOptionsHelper.hasBitSet(opt, 0x100000L)) {
            return org.nd4j.linalg.api.buffer.DataType.UTF8;
        }
        throw new ND4JUnknownDataTypeException("Unknown extras set: [" + opt + "]");
    }

    public static org.nd4j.linalg.api.buffer.DataType dataType(long[] shapeInfo) {
        long opt = Shape.options(shapeInfo);
        return ArrayOptionsHelper.dataType(opt);
    }

    public static long setOptionBit(long storage, org.nd4j.linalg.api.buffer.DataType type) {
        long bit = 0L;
        switch (type) {
            case HALF: {
                bit = 4096L;
                break;
            }
            case BFLOAT16: {
                bit = 2048L;
                break;
            }
            case FLOAT: {
                bit = 8192L;
                break;
            }
            case DOUBLE: {
                bit = 16384L;
                break;
            }
            case UINT32: {
                storage |= 0x800000L;
            }
            case INT: {
                bit = 131072L;
                break;
            }
            case UINT64: {
                storage |= 0x800000L;
            }
            case LONG: {
                bit = 262144L;
                break;
            }
            case BOOL: {
                bit = 524288L;
                break;
            }
            case UBYTE: {
                storage |= 0x800000L;
            }
            case BYTE: {
                bit = 32768L;
                break;
            }
            case UINT16: {
                storage |= 0x800000L;
            }
            case SHORT: {
                bit = 65536L;
                break;
            }
            case UTF8: {
                bit = 0x100000L;
                break;
            }
            case COMPRESSED: {
                bit = 4L;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return storage |= bit;
    }

    public static long setOptionBit(long storage, ArrayType type) {
        long bit = 0L;
        switch (type) {
            case SPARSE: {
                bit = 2L;
                break;
            }
            case COMPRESSED: {
                bit = 4L;
                break;
            }
            case EMPTY: {
                bit = 8L;
                break;
            }
            default: {
                return storage;
            }
        }
        return storage |= bit;
    }

    public static org.nd4j.linalg.api.buffer.DataType convertToDataType(DataType dataType) {
        switch (dataType) {
            case DT_UINT16: {
                return org.nd4j.linalg.api.buffer.DataType.UINT16;
            }
            case DT_UINT32: {
                return org.nd4j.linalg.api.buffer.DataType.UINT32;
            }
            case DT_UINT64: {
                return org.nd4j.linalg.api.buffer.DataType.UINT64;
            }
            case DT_BOOL: {
                return org.nd4j.linalg.api.buffer.DataType.BOOL;
            }
            case DT_BFLOAT16: {
                return org.nd4j.linalg.api.buffer.DataType.BFLOAT16;
            }
            case DT_FLOAT: {
                return org.nd4j.linalg.api.buffer.DataType.FLOAT;
            }
            case DT_INT32: {
                return org.nd4j.linalg.api.buffer.DataType.INT;
            }
            case DT_INT64: {
                return org.nd4j.linalg.api.buffer.DataType.LONG;
            }
            case DT_INT8: {
                return org.nd4j.linalg.api.buffer.DataType.BYTE;
            }
            case DT_INT16: {
                return org.nd4j.linalg.api.buffer.DataType.SHORT;
            }
            case DT_DOUBLE: {
                return org.nd4j.linalg.api.buffer.DataType.DOUBLE;
            }
            case DT_UINT8: {
                return org.nd4j.linalg.api.buffer.DataType.UBYTE;
            }
            case DT_HALF: {
                return org.nd4j.linalg.api.buffer.DataType.HALF;
            }
            case DT_STRING: {
                return org.nd4j.linalg.api.buffer.DataType.UTF8;
            }
        }
        throw new UnsupportedOperationException("Unknown TF data type: [" + dataType.name() + "]");
    }

    public static org.nd4j.linalg.api.buffer.DataType dataType(@NonNull String dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        switch (dataType) {
            case "uint64": {
                return org.nd4j.linalg.api.buffer.DataType.UINT64;
            }
            case "uint32": {
                return org.nd4j.linalg.api.buffer.DataType.UINT32;
            }
            case "uint16": {
                return org.nd4j.linalg.api.buffer.DataType.UINT16;
            }
            case "int64": {
                return org.nd4j.linalg.api.buffer.DataType.LONG;
            }
            case "int32": {
                return org.nd4j.linalg.api.buffer.DataType.INT;
            }
            case "int16": {
                return org.nd4j.linalg.api.buffer.DataType.SHORT;
            }
            case "int8": {
                return org.nd4j.linalg.api.buffer.DataType.BYTE;
            }
            case "bool": {
                return org.nd4j.linalg.api.buffer.DataType.BOOL;
            }
            case "resource": 
            case "float32": {
                return org.nd4j.linalg.api.buffer.DataType.FLOAT;
            }
            case "float64": 
            case "double": {
                return org.nd4j.linalg.api.buffer.DataType.DOUBLE;
            }
            case "string": {
                return org.nd4j.linalg.api.buffer.DataType.UTF8;
            }
            case "uint8": 
            case "ubyte": {
                return org.nd4j.linalg.api.buffer.DataType.UBYTE;
            }
            case "bfloat16": {
                return org.nd4j.linalg.api.buffer.DataType.BFLOAT16;
            }
            case "float16": {
                return org.nd4j.linalg.api.buffer.DataType.HALF;
            }
        }
        throw new ND4JIllegalStateException("Unknown data type used: [" + dataType + "]");
    }
}

