/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.shape;

import java.util.Arrays;
import lombok.NonNull;
import org.nd4j.common.util.ArrayUtil;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.shape.ShapeDescriptor;
import org.nd4j.linalg.api.shape.options.ArrayOptionsHelper;
import org.nd4j.linalg.api.shape.options.ArrayType;
import org.nd4j.linalg.factory.Nd4j;

public class LongShapeDescriptor {
    private char order;
    private long offset;
    private long ews;
    private long hashShape = 0L;
    private long hashStride = 0L;
    private long[] shape;
    private long[] stride;
    private long extras;

    public LongShapeDescriptor(long[] shape, long[] stride, long offset, long ews, char order, long extras) {
        this.shape = Arrays.copyOf(shape, shape.length);
        this.stride = Arrays.copyOf(stride, stride.length);
        this.offset = offset;
        this.ews = ews;
        this.order = order;
        this.extras = extras;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LongShapeDescriptor that = (LongShapeDescriptor)o;
        if (this.extras != that.extras) {
            return false;
        }
        if (this.order != that.order) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        if (this.ews != that.ews) {
            return false;
        }
        if (!Arrays.equals(this.shape, that.shape)) {
            return false;
        }
        return Arrays.equals(this.stride, that.stride);
    }

    public int rank() {
        return this.shape == null ? 0 : this.shape.length;
    }

    public DataType dataType() {
        return ArrayOptionsHelper.dataType(this.extras);
    }

    public int hashCode() {
        int result = this.order;
        result = 31 * result + this.longHashCode(this.offset);
        result = 31 * result + this.longHashCode(this.ews);
        result = 31 * result + this.longHashCode(this.extras);
        result = 31 * result + Arrays.hashCode(this.shape);
        result = 31 * result + Arrays.hashCode(this.stride);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.shape.length).append(",").append(Arrays.toString(this.shape)).append(",").append(Arrays.toString(this.stride)).append(",").append(this.extras).append(",").append(this.ews).append(",").append(this.order);
        String result = builder.toString().replaceAll("\\]", "").replaceAll("\\[", "");
        result = "[" + result + "]";
        return result;
    }

    private int longHashCode(long v) {
        return (int)(v ^ v >>> 32);
    }

    public static LongShapeDescriptor fromShapeDescriptor(@NonNull ShapeDescriptor descriptor) {
        if (descriptor == null) {
            throw new NullPointerException("descriptor is marked non-null but is null");
        }
        return new LongShapeDescriptor(ArrayUtil.toLongArray((int[])descriptor.getShape()), ArrayUtil.toLongArray((int[])descriptor.getStride()), descriptor.getOffset(), descriptor.getEws(), descriptor.getOrder(), descriptor.getExtras());
    }

    public static LongShapeDescriptor fromShape(int[] shape, @NonNull DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        return LongShapeDescriptor.fromShape(ArrayUtil.toLongArray((int[])shape), dataType);
    }

    public static LongShapeDescriptor fromShape(long[] shape, @NonNull DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        return LongShapeDescriptor.fromShape(shape, Nd4j.getStrides(shape, Nd4j.order().charValue()), 1L, Nd4j.order().charValue(), dataType, false);
    }

    public static LongShapeDescriptor empty(@NonNull DataType dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        long[] l = new long[]{};
        return LongShapeDescriptor.fromShape(l, l, 1L, 'c', dataType, true);
    }

    public static LongShapeDescriptor fromShape(@NonNull long[] shape, @NonNull long[] strides, long ews, char order, @NonNull DataType dataType, boolean empty) {
        if (shape == null) {
            throw new NullPointerException("shape is marked non-null but is null");
        }
        if (strides == null) {
            throw new NullPointerException("strides is marked non-null but is null");
        }
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        long extras = 0L;
        extras = ArrayOptionsHelper.setOptionBit(extras, dataType);
        if (empty) {
            extras = ArrayOptionsHelper.setOptionBit(extras, ArrayType.EMPTY);
        }
        return new LongShapeDescriptor(shape, strides, 0L, ews, order, extras);
    }

    public static LongShapeDescriptor fromShape(long[] shape, long extras) {
        return new LongShapeDescriptor(shape, Nd4j.getStrides(shape, Nd4j.order().charValue()), 0L, 1L, Nd4j.order().charValue(), extras);
    }

    public LongShapeDescriptor asDataType(DataType dataType) {
        long extras = 0L;
        extras = ArrayOptionsHelper.setOptionBit(extras, dataType);
        if (this.isEmpty()) {
            extras = ArrayOptionsHelper.setOptionBit(extras, ArrayType.EMPTY);
        }
        return new LongShapeDescriptor(this.shape, this.stride, this.offset, this.ews, this.order, extras);
    }

    public boolean isEmpty() {
        return ArrayOptionsHelper.hasBitSet(this.extras, 8L);
    }

    public char getOrder() {
        return this.order;
    }

    public long[] getShape() {
        return this.shape;
    }

    public long[] getStride() {
        return this.stride;
    }

    public long getExtras() {
        return this.extras;
    }

    public void setExtras(long extras) {
        this.extras = extras;
    }
}

